#include <gtk/gtk.h>

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "ppaSetBase.h"
#define MAXPATHLEN 256

#ifndef XTERM
#define XTERM "/usr/bin/X11/xterm"
#endif
#ifndef PAGER
#define PAGER "/usr/bin/less"
#endif


/* GUI elements */
GtkWidget *mainWindow;
GtkWidget *mainVbox;
 GtkWidget *buttonsHbox;
  GtkWidget *okButton;
  GtkWidget *onceButton;
  GtkWidget *cancelButton;
  GtkWidget *removeButton;
  GtkWidget *toDefButton;
  GtkWidget *helpButton;
 GtkWidget *mainNotebook;

  GtkWidget *basicTable;
   GtkWidget *typeFrame;
    GtkWidget *typeVbox;
//    GSList *typeGSList;
    GtkWidget *t710RButton;
    GtkWidget *t712RButton;
    GtkWidget *t720RButton;
    GtkWidget *t722RButton;
    GtkWidget *t820RButton;
    GtkWidget *t1000RButton;
   GtkWidget *colorFrame;
    GtkWidget *colorVbox;
//    GSList *colorGSList;
    GtkWidget *colorRButton;
    GtkWidget *gsRButton;
    GtkWidget *bwRButton;
   GtkWidget *ditherFrame;
    GtkWidget *ditherVbox;
//    GSList *ditherGSList;
    GtkWidget *fsRButton;
    GtkWidget *fastRButton;
   GtkWidget *modeFrame;
    GtkWidget *modeVbox;
//    GSList *modeGSList;
    GtkWidget *ecoRButton;
    GtkWidget *normalRButton;
    GtkWidget *photoRButton;
   GtkWidget *basicLabel;

  GtkWidget *paperHbox;
   GtkWidget *sizeFrame;
    GtkWidget *sizeVbox;
//    GSList *sizeGSList;
    GtkWidget *a4RButton;
    GtkWidget *a3RButton;
    GtkWidget *legalRButton;
    GtkWidget *letterRButton;
   GtkWidget *xyFrame;
    GtkWidget *xyTable;
    // X and Y Offset (xo, yo).
    GtkWidget *xoLabel;
    GtkWidget *xoEntry;
    GtkWidget *yoLabel;
    GtkWidget *yoEntry;
    // Top, Bottom, Left and Right Margins (tm, bm, lm, rm).
    GtkWidget *tmLabel;
    GtkWidget *tmEntry;
    GtkWidget *bmLabel;
    GtkWidget *bmEntry;
    GtkWidget *lmLabel;
    GtkWidget *lmEntry;
    GtkWidget *rmLabel;
    GtkWidget *rmEntry;
   GtkWidget *paperLabel;

  GtkWidget *advancedHbox;
   GtkWidget *fineFrame;
    GtkWidget *fineTable;
    GtkWidget *uniRButton;
    GtkWidget *biRButton;
    GtkWidget *bwsLabel;
    GtkWidget *bwsEntry;
    GtkWidget *csLabel;
    GtkWidget *csEntry;
    GtkWidget *xocLabel;
    GtkWidget *xocEntry;
    GtkWidget *yocLabel;
    GtkWidget *yocEntry;
    GtkWidget *blackLabel;
    GtkWidget *blackEntry;
   GtkWidget *gammaFrame;
    GtkWidget *gammaTable;
    GtkWidget *defaultRButton;
    GtkWidget *noneRButton;
    GtkWidget *enhRButton;
    GtkWidget *redeLabel;
    GtkWidget *redeEntry;
    GtkWidget *greeneLabel;
    GtkWidget *greeneEntry;
    GtkWidget *blueeLabel;
    GtkWidget *blueeEntry;
    GtkWidget *indexRButton;
    GtkWidget *rediLabel;
    GtkWidget *rediEntry;
    GtkWidget *greeniLabel;
    GtkWidget *greeniEntry;
    GtkWidget *blueiLabel;
    GtkWidget *blueiEntry;
    GtkWidget *fileRButton;
    GtkWidget *fileLabel;
    GtkWidget *fileEntry;
   GtkWidget *advancedLabel;
  GtkWidget *servicesVbox;
   GtkWidget *testButton;
   GtkWidget *pnm2ppaButton;
   GtkWidget *calButton;
   GtkWidget *gammaRefButton;
   GtkWidget *gammaNoButton;
   GtkWidget *cleanButton;
   GtkWidget *servicesLabel;

// The structure that stores configuration info
ppaSet_t settings;

/* Helping functions. They act just like atoi and atof, but when "" is given...
   they return d in that cases */
int atoi2(char *s, int d){
  if (s[0] == 0){
    return d;
  } else {
    return atoi(s);
  }
}
double atof2(char *s, double d){
  if (s[0] == 0){
    return d;
  } else {
    return atof(s);
  }
}

int showHelp(){
  char helpPath[MAXPATHLEN];
  int pid;
  int status;
  strcpy(helpPath, BASEDIR);
  strcat(helpPath, "/HELP");
  pid = fork();
  if (pid == -1){
    perror("gPpaSet");
    return -1;
  } else if (pid == 0) { // child
    if (execl(XTERM, XTERM, "-e", PAGER, helpPath, NULL) == -1){
      perror("gPpaSet");
      exit(1);
    }
    exit(0);
  } else { // parent
    /*
      // wait for the children to exit
      waitpid(pid, &status, 0);
      if (WIFEXITED(status)){
      // Do nothing, process was successfully executed
      } else {
      fprintf(stderr, "ppaSetBase: error in child process\n");
      return -1;
      }
    */
  }
  return 0;
}

/* Functions movid information from GUI to structure and viceversa */
void settings2gui(){
  char tmp[MAXPATHLEN];
  if (settings.type == TYPE_HP710){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(t710RButton), TRUE);
  } else if (settings.type == TYPE_HP712){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(t712RButton), TRUE);
  } else if (settings.type == TYPE_HP720){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(t720RButton), TRUE);
  } else if (settings.type == TYPE_HP722){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(t722RButton), TRUE);
  } else if (settings.type == TYPE_HP820){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(t820RButton), TRUE);
  } else if (settings.type == TYPE_HP1000){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(t1000RButton), TRUE);
  }
  if (settings.color == COLOR_COLOR ) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(colorRButton), TRUE);
  } else if (settings.color == COLOR_GREYSCALE ) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gsRButton), TRUE);
  } else if (settings.color == COLOR_BLACKWHITE ) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bwRButton), TRUE);
  }
  if (settings.dither == DITHER_FS){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fsRButton), TRUE);
  } else if (settings.dither == DITHER_FAST){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fastRButton), TRUE);
  }
  if (settings.mode == MODE_ECO){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ecoRButton), TRUE);
  } else if (settings.mode == MODE_NORMAL){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(normalRButton), TRUE);
  } else if (settings.mode == MODE_PHOTO){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(photoRButton), TRUE);
  }
  if (settings.paper == PAPER_A4){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(a4RButton), TRUE);
  } else if (settings.paper == PAPER_A3){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(a3RButton), TRUE);
  } else if (settings.paper == PAPER_LEGAL){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(legalRButton), TRUE);
  } else if (settings.paper == PAPER_LETTER){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(letterRButton), TRUE);
  }
  snprintf(tmp, MAXPATHLEN, "%i", settings.xOffset);
  gtk_entry_set_text(GTK_ENTRY(xoEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.yOffset);
  gtk_entry_set_text(GTK_ENTRY(yoEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.topMargin);
  gtk_entry_set_text(GTK_ENTRY(tmEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.bottomMargin);
  gtk_entry_set_text(GTK_ENTRY(bmEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.leftMargin);
  gtk_entry_set_text(GTK_ENTRY(lmEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.rightMargin);
  gtk_entry_set_text(GTK_ENTRY(rmEntry), (gchar*)tmp);
  if (settings.biUni == BIUNI_BI){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(biRButton), TRUE);
  } else if (settings.biUni == BIUNI_UNI){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(uniRButton), TRUE);
  }
  snprintf(tmp, MAXPATHLEN, "%i", settings.bwShearing);
  gtk_entry_set_text(GTK_ENTRY(bwsEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.colorShearing);
  gtk_entry_set_text(GTK_ENTRY(csEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.xOffsetColor);
  gtk_entry_set_text(GTK_ENTRY(xocEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.yOffsetColor);
  gtk_entry_set_text(GTK_ENTRY(yocEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.blackness);
  gtk_entry_set_text(GTK_ENTRY(blackEntry), (gchar*)tmp);
  if (settings.gammaMode == GAMMA_DEFAULT){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(defaultRButton), TRUE);
  } else if (settings.gammaMode == GAMMA_NONE){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(noneRButton), TRUE);
  } else if (settings.gammaMode == GAMMA_ENH){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enhRButton), TRUE);
  } else if (settings.gammaMode == GAMMA_INDEX){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(indexRButton), TRUE);
  } else if (settings.gammaMode == GAMMA_FILE){
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fileRButton), TRUE);
  }
  snprintf(tmp, MAXPATHLEN, "%f", settings.gammaEnhR);
  gtk_entry_set_text(GTK_ENTRY(redeEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%f", settings.gammaEnhG);
  gtk_entry_set_text(GTK_ENTRY(greeneEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%f", settings.gammaEnhB);
  gtk_entry_set_text(GTK_ENTRY(blueeEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.gammaIndexR);
  gtk_entry_set_text(GTK_ENTRY(rediEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.gammaIndexG);
  gtk_entry_set_text(GTK_ENTRY(greeniEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%i", settings.gammaIndexB);
  gtk_entry_set_text(GTK_ENTRY(blueiEntry), (gchar*)tmp);
  snprintf(tmp, MAXPATHLEN, "%s", settings.gammaFile);
  gtk_entry_set_text(GTK_ENTRY(fileEntry), (gchar*)tmp);
}

void gui2settings(){
  char tmp[MAXPATHLEN];
  /* Let's set 'settings' to defaults, so an unset value doesn't hurst us */
  getSystemDefaults(&settings);
  /* Now let's fill it with info from the GUI */
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(t710RButton))) {
    settings.type = TYPE_HP710;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(t712RButton))) {
    settings.type = TYPE_HP712;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(t720RButton))) {
    settings.type = TYPE_HP720;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(t722RButton))) {
    settings.type = TYPE_HP722;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(t820RButton))) {
    settings.type = TYPE_HP820;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(t1000RButton))) {
    settings.type = TYPE_HP1000;
  }
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(colorRButton))) {
    settings.color = COLOR_COLOR;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gsRButton))) {
    settings.color = COLOR_GREYSCALE;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bwRButton))) {
    settings.color = COLOR_BLACKWHITE;
  }
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fsRButton))) {
    settings.dither = DITHER_FS;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fastRButton))) {
    settings.dither = DITHER_FAST;
  }
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ecoRButton))) {
    settings.mode = MODE_ECO;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(normalRButton))) {
    settings.mode = MODE_NORMAL;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(photoRButton))) {
    settings.mode = MODE_PHOTO;
  }
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(a4RButton))) {
    settings.paper = PAPER_A4;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(a3RButton))) {
    settings.paper = PAPER_A3;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(legalRButton))) {
    settings.paper = PAPER_LEGAL;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(letterRButton))) {
    settings.paper = PAPER_LETTER;
  }
  settings.xOffset = atoi2(gtk_entry_get_text(GTK_ENTRY(xoEntry)), 0);
  settings.yOffset = atoi2(gtk_entry_get_text(GTK_ENTRY(yoEntry)), 0);
  settings.topMargin = atoi2(gtk_entry_get_text(GTK_ENTRY(tmEntry)), 100);
  settings.bottomMargin = atoi2(gtk_entry_get_text(GTK_ENTRY(bmEntry)), 100);
  settings.leftMargin = atoi2(gtk_entry_get_text(GTK_ENTRY(lmEntry)), 100);
  settings.rightMargin = atoi2(gtk_entry_get_text(GTK_ENTRY(rmEntry)), 150);
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(uniRButton))) {
    settings.biUni = BIUNI_UNI;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(biRButton))) {
    settings.biUni = BIUNI_BI;
  }
  settings.bwShearing = atoi2(gtk_entry_get_text(GTK_ENTRY(bwsEntry)), 0);
  settings.colorShearing = atoi2(gtk_entry_get_text(GTK_ENTRY(csEntry)), 0);
  settings.xOffsetColor = atoi2(gtk_entry_get_text(GTK_ENTRY(xocEntry)), 0);
  settings.yOffsetColor = atoi2(gtk_entry_get_text(GTK_ENTRY(yocEntry)), 0);
  settings.blackness = atoi2(gtk_entry_get_text(GTK_ENTRY(blackEntry)), 2);
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(defaultRButton))) {
    settings.gammaMode = GAMMA_DEFAULT;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(noneRButton))) {
    settings.gammaMode = GAMMA_NONE;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(enhRButton))) {
    settings.gammaMode = GAMMA_ENH;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(indexRButton))) {
    settings.gammaMode = GAMMA_INDEX;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fileRButton))) {
    settings.gammaMode = GAMMA_FILE;
  }
  settings.gammaEnhR = atof2(gtk_entry_get_text(GTK_ENTRY(redeEntry)), 0);
  settings.gammaEnhG = atof2(gtk_entry_get_text(GTK_ENTRY(greeneEntry)), 0);
  settings.gammaEnhB = atof2(gtk_entry_get_text(GTK_ENTRY(blueeEntry)), 0);
  settings.gammaIndexR = atoi2(gtk_entry_get_text(GTK_ENTRY(rediEntry)), 1);
  settings.gammaIndexG = atoi2(gtk_entry_get_text(GTK_ENTRY(greeniEntry)), 1);
  settings.gammaIndexB = atoi2(gtk_entry_get_text(GTK_ENTRY(blueiEntry)), 1);
  if (*gtk_entry_get_text(GTK_ENTRY(fileEntry)) == 0){
    strncpy(settings.gammaFile, "/etc/pnm2ppa.gamma", MAXPATHLEN);
  } else {
    strncpy(settings.gammaFile, gtk_entry_get_text(GTK_ENTRY(fileEntry)), MAXPATHLEN);
  }
}

/* Callbacks */
gint mainWindowDelete(GtkWidget *widget, GdkEvent *event, gpointer data ) {
  /* Change TRUE to FALSE and the main window will be destroyed with
   * a "delete_event". */
  return(FALSE);
}
void mainWindowDestroy(GtkWidget *widget, gpointer data) {
  gtk_main_quit();
}

void actionOk(GtkWidget *widget, gpointer data){
  gui2settings();
  if (createPpaSetRC(settings) == -1){
    fprintf(stderr, "gPpaSet: couldn't create .ppaSetRC* files at HOME\n");
  }
  gtk_main_quit();
}
void actionOnce(GtkWidget *widget, gpointer data){
  gui2settings();
  if (createPpaSet1RC(settings) == -1) {
    fprintf(stderr, "gPpaSet: couldn't create .ppaSet1RC* files at HOME\n");
  }
}
void actionToDef(GtkWidget *widget, gpointer data){
  getSystemDefaults(&settings);
  settings2gui();
}
void actionRemove(GtkWidget *widget, gpointer data){
  removePpaSetRC();
  gtk_main_quit();
}
void actionHelp(GtkWidget *widget, gpointer data){
  if (showHelp() == -1){
    fprintf(stderr, "gPpaSet: error showing help\n");
  }
}
void actionTest(GtkWidget *widget, gpointer data){
  gui2settings();
  if (printTestPage(settings) == -1){
    fprintf(stderr, "gPpaSet: error printing test page\n");
  }
}
void actionPnm2ppa(GtkWidget *widget, gpointer data){
  gui2settings();
  if (createPnm2ppa_conf(settings) == 1){
    fprintf(stderr, "gPpaSet: error creating /tmp/pnm2ppa.conf\n");
  }
}
void actionCal(GtkWidget *widget, gpointer data){
  gui2settings();
  if (printCalibrationPages(settings) == -1){
    fprintf(stderr, "gPpaSet: error printing calibration pages\n");
  }
  
}
void actionGammaRef(GtkWidget *widget, gpointer data){
  if (createGammaRef() == -1){
    fprintf(stderr, "gPpaSet: error creating gamma reference file\n");
  }
}
void actionGammaNo(GtkWidget *widget, gpointer data){
  gui2settings();
  if (printNoGamma(settings) == -1){
    fprintf(stderr, "gPpaSet: error printing non-gamma-corrected page\n");
  }
}
void actionClean(GtkWidget *widget, gpointer data){
  gui2settings();
  if (cleanHeads(settings) == -1){
    fprintf(stderr, "gPpaSet: error cleaning cartridge heads\n");
  }
}

/* Helping functions */
int makeGUI(){
  mainWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_container_set_border_width (GTK_CONTAINER (mainWindow), 10);
    mainVbox = gtk_vbox_new(FALSE,10);
      mainNotebook = gtk_notebook_new();
        // Basic tab
        basicTable = gtk_table_new(2,2,FALSE);
          typeFrame = gtk_frame_new("Type of printer");
	    typeVbox = gtk_vbox_new(FALSE,0);
 	      t710RButton = gtk_radio_button_new_with_label(NULL, "HP 710");
	        gtk_widget_show(t710RButton);
	        gtk_box_pack_start(GTK_BOX(typeVbox), t710RButton, FALSE, FALSE, 0);
	      t712RButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(t710RButton)),
			     "HP 712");
	        gtk_widget_show(t712RButton);
	        gtk_box_pack_start(GTK_BOX(typeVbox), t712RButton, FALSE, FALSE, 0);
	      t720RButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(t712RButton)),
			     "HP 720");
	        gtk_widget_show(t720RButton);
	        gtk_box_pack_start(GTK_BOX(typeVbox), t720RButton, FALSE, FALSE, 0);
	      t722RButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(t720RButton)),
			     "HP 722");
	        gtk_widget_show(t722RButton);
	        gtk_box_pack_start(GTK_BOX(typeVbox), t722RButton, FALSE, FALSE, 0);
	      t820RButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(t722RButton)),
			     "HP 820");
	        gtk_widget_show(t820RButton);
	        gtk_box_pack_start(GTK_BOX(typeVbox), t820RButton, FALSE, FALSE, 0);
	      t1000RButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(t820RButton)),
			     "HP 1000");
	        gtk_widget_show(t1000RButton);
	        gtk_box_pack_start(GTK_BOX(typeVbox), t1000RButton, FALSE, FALSE, 0);
	      gtk_widget_show(typeVbox);
	      gtk_container_add(GTK_CONTAINER(typeFrame),typeVbox);
	    gtk_widget_show(typeFrame);
	    gtk_table_attach_defaults(GTK_TABLE(basicTable), typeFrame, 0, 1, 0, 1);	
          colorFrame = gtk_frame_new("Color mode");
	    colorVbox = gtk_vbox_new(FALSE,0);
 	      colorRButton = gtk_radio_button_new_with_label(NULL, "Full color");
	        gtk_widget_show(colorRButton);
	        gtk_box_pack_start(GTK_BOX(colorVbox), colorRButton, FALSE, FALSE, 0);
	      gsRButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(colorRButton)),
			     "Greyscale");
	        gtk_widget_show(gsRButton);
	        gtk_box_pack_start(GTK_BOX(colorVbox), gsRButton, FALSE, FALSE, 0);
	      bwRButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(gsRButton)),
			     "Black & white");
	        gtk_widget_show(bwRButton);
	        gtk_box_pack_start(GTK_BOX(colorVbox), bwRButton, FALSE, FALSE, 0);
	      gtk_widget_show(colorVbox);
	      gtk_container_add(GTK_CONTAINER(colorFrame),colorVbox);
	    gtk_widget_show(colorFrame);
	    gtk_table_attach_defaults(GTK_TABLE(basicTable), colorFrame, 0, 1, 1, 2);	
	  ditherFrame = gtk_frame_new("Dithering mode");
	    ditherVbox = gtk_vbox_new(FALSE,0);
 	      fsRButton = gtk_radio_button_new_with_label(NULL, "Floyd-Steinberg dithering");
	        gtk_widget_show(fsRButton);
	        gtk_box_pack_start(GTK_BOX(ditherVbox), fsRButton, FALSE, FALSE, 0);
	      fastRButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(fsRButton)),
			     "Fast dithering");
	        gtk_widget_show(fastRButton);
	        gtk_box_pack_start(GTK_BOX(ditherVbox), fastRButton, FALSE, FALSE, 0);
	      gtk_widget_show(ditherVbox);
	      gtk_container_add(GTK_CONTAINER(ditherFrame),ditherVbox);
	    gtk_widget_show(ditherFrame);
	    gtk_table_attach_defaults(GTK_TABLE(basicTable), ditherFrame, 1, 2, 0, 1);	
          modeFrame = gtk_frame_new("Quality mode");
	    modeVbox = gtk_vbox_new(FALSE,0);
 	      ecoRButton = gtk_radio_button_new_with_label(NULL, "Economic mode");
	        gtk_widget_show(ecoRButton);
	        gtk_box_pack_start(GTK_BOX(modeVbox), ecoRButton, FALSE, FALSE, 0);
	      normalRButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(ecoRButton)),
			     "Normal mode");
	        gtk_widget_show(normalRButton);
	        gtk_box_pack_start(GTK_BOX(modeVbox), normalRButton, FALSE, FALSE, 0);
	      photoRButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(normalRButton)),
			     "Photo mode");
	        gtk_widget_show(photoRButton);
	        gtk_box_pack_start(GTK_BOX(modeVbox), photoRButton, FALSE, FALSE, 0);
	      gtk_widget_show(modeVbox);
	      gtk_container_add(GTK_CONTAINER(modeFrame),modeVbox);
	    gtk_widget_show(modeFrame);
	    gtk_table_attach_defaults(GTK_TABLE(basicTable), modeFrame, 1, 2, 1, 2);	
	  gtk_widget_show(basicTable);
	  basicLabel = gtk_label_new("Basic");
	    gtk_widget_show(basicLabel);
	  gtk_notebook_append_page(GTK_NOTEBOOK(mainNotebook), basicTable, basicLabel);
	// Paper tab
	paperHbox = gtk_hbox_new(FALSE,10);
	  sizeFrame = gtk_frame_new("Size");
	    sizeVbox = gtk_vbox_new(FALSE,0);
	      a4RButton = gtk_radio_button_new_with_label(NULL, "DIN A4");
	        gtk_widget_show(a4RButton);
	        gtk_box_pack_start(GTK_BOX(sizeVbox), a4RButton, FALSE, FALSE, 0);
	      a3RButton = gtk_radio_button_new_with_label(
	             gtk_radio_button_group(GTK_RADIO_BUTTON(a4RButton)),
	    	     "DIN A3");
	        gtk_widget_show(a3RButton);
                gtk_box_pack_start(GTK_BOX(sizeVbox), a3RButton, FALSE, FALSE, 0);
	      legalRButton = gtk_radio_button_new_with_label(
   	        gtk_radio_button_group(GTK_RADIO_BUTTON(a3RButton)),
	    	     "US legal");
	             gtk_widget_show(legalRButton);
	        gtk_box_pack_start(GTK_BOX(sizeVbox), legalRButton, FALSE, FALSE, 0);
	      letterRButton = gtk_radio_button_new_with_label(
	             gtk_radio_button_group(GTK_RADIO_BUTTON(legalRButton)),
	    	     "US letter");
	        gtk_widget_show(letterRButton);
	        gtk_box_pack_start(GTK_BOX(sizeVbox), letterRButton, FALSE, FALSE, 0);
	      gtk_widget_show(sizeVbox);
	      gtk_container_add(GTK_CONTAINER(sizeFrame),sizeVbox);
	    gtk_widget_show(sizeFrame);
	    gtk_box_pack_start(GTK_BOX(paperHbox), sizeFrame, FALSE, FALSE, 0);
	  xyFrame = gtk_frame_new("Offsets and margins");
	    xyTable = gtk_table_new(6,2,FALSE);
	      xoLabel = gtk_label_new("X offset:");
	        gtk_widget_show(xoLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), xoLabel, 0, 1, 0, 1);
	      xoEntry = gtk_entry_new();
	    	gtk_widget_show(xoEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), xoEntry, 1, 2, 0, 1);
	      yoLabel = gtk_label_new("Y offset:");
	    	gtk_widget_show(yoLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), yoLabel, 0, 1, 1, 2);
	      yoEntry = gtk_entry_new();
	    	gtk_widget_show(yoEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), yoEntry, 1, 2, 1, 2);
	      tmLabel = gtk_label_new("Top margin:");
	    	gtk_widget_show(tmLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), tmLabel, 0, 1, 2, 3);
	      tmEntry = gtk_entry_new();
	    	gtk_widget_show(tmEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), tmEntry, 1, 2, 2, 3);
	      bmLabel = gtk_label_new("Bottom margin");
	    	gtk_widget_show(bmLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), bmLabel, 0, 1, 3, 4);
	      bmEntry = gtk_entry_new();
	    	gtk_widget_show(bmEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), bmEntry, 1, 2, 3, 4);
	      lmLabel = gtk_label_new("Left margin:");
	    	gtk_widget_show(lmLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), lmLabel, 0, 1, 4, 5);
	      lmEntry = gtk_entry_new();
	    	gtk_widget_show(lmEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), lmEntry, 1, 2, 4, 5);
	      rmLabel = gtk_label_new("Right margin");
	    	gtk_widget_show(rmLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), rmLabel, 0, 1, 5, 6);
	      rmEntry = gtk_entry_new();
	    	gtk_widget_show(rmEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(xyTable), rmEntry, 1, 2, 5, 6);
	      gtk_widget_show(xyTable);
	      gtk_container_add(GTK_CONTAINER(xyFrame),xyTable);
	    gtk_widget_show(xyFrame);
	    gtk_box_pack_start(GTK_BOX(paperHbox), xyFrame, FALSE, FALSE, 0);
	  gtk_widget_show(paperHbox);
	  paperLabel = gtk_label_new("Paper options");
	    gtk_widget_show(paperLabel);
	  gtk_notebook_append_page(GTK_NOTEBOOK(mainNotebook), paperHbox, paperLabel);
	// Advanced tab
	advancedHbox = gtk_hbox_new(FALSE,10);
	  fineFrame = gtk_frame_new("Fine tunning");
	    fineTable = gtk_table_new(7,2,FALSE);
 	      uniRButton = gtk_radio_button_new_with_label(NULL, "Unidirectional printing");
	        gtk_widget_show(uniRButton);
		gtk_table_attach_defaults(GTK_TABLE(fineTable), uniRButton, 0, 2, 0, 1);
	      biRButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(uniRButton)),
			     "Bidirectional printing");
	        gtk_widget_show(biRButton);
		gtk_table_attach_defaults(GTK_TABLE(fineTable), biRButton, 0, 2, 1, 2);
	      bwsLabel = gtk_label_new(" - B&W shearing:");
	    	gtk_widget_show(bwsLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(fineTable), bwsLabel, 0, 1, 2, 3);
	      bwsEntry = gtk_entry_new();
	    	gtk_widget_show(bwsEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(fineTable), bwsEntry, 1, 2, 2, 3);
	      csLabel = gtk_label_new(" - Color shearing:");
	    	gtk_widget_show(csLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(fineTable), csLabel, 0, 1, 3, 4);
	      csEntry = gtk_entry_new();
	    	gtk_widget_show(csEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(fineTable), csEntry, 1, 2, 3, 4);
	      xocLabel = gtk_label_new("X color offset:");
	    	gtk_widget_show(xocLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(fineTable), xocLabel, 0, 1, 4, 5);
	      xocEntry = gtk_entry_new();
	    	gtk_widget_show(xocEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(fineTable), xocEntry, 1, 2, 4, 5);
	      yocLabel = gtk_label_new("Y color offset:");
	    	gtk_widget_show(yocLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(fineTable), yocLabel, 0, 1, 5, 6);
	      yocEntry = gtk_entry_new();
	    	gtk_widget_show(yocEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(fineTable), yocEntry, 1, 2, 5, 6);
	      blackLabel = gtk_label_new("Blackness (0-4):");
	    	gtk_widget_show(blackLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(fineTable), blackLabel, 0, 1, 6, 7);
	      blackEntry = gtk_entry_new();
	    	gtk_widget_show(blackEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(fineTable), blackEntry, 1, 2, 6, 7);
	      gtk_widget_show(fineTable);
	      gtk_container_add(GTK_CONTAINER(fineFrame), fineTable);
	    gtk_widget_show(fineFrame);
	    gtk_box_pack_start(GTK_BOX(advancedHbox), fineFrame, FALSE, FALSE, 0);
	  gammaFrame = gtk_frame_new("Gamma correction");
	    gammaTable = gtk_table_new(12,2,FALSE);
 	      defaultRButton = gtk_radio_button_new_with_label(NULL, "System defaults");
	        gtk_widget_show(defaultRButton);
		gtk_table_attach_defaults(GTK_TABLE(gammaTable), defaultRButton, 0, 2, 0, 1);
	      noneRButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(defaultRButton)),
			     "None");
	        gtk_widget_show(noneRButton);
		gtk_table_attach_defaults(GTK_TABLE(gammaTable), noneRButton, 0, 2, 1, 2);
	      enhRButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(noneRButton)),
			     "RGB correction (enhancements)");
	        gtk_widget_show(enhRButton);
		gtk_table_attach_defaults(GTK_TABLE(gammaTable), enhRButton, 0, 2, 2, 3);
	      redeLabel = gtk_label_new(" - Red:");
	    	gtk_widget_show(redeLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), redeLabel, 0, 1, 3 , 4);
	      redeEntry = gtk_entry_new();
	    	gtk_widget_show(redeEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), redeEntry, 1, 2, 3, 4);
	      greeneLabel = gtk_label_new(" - Green:");
	    	gtk_widget_show(greeneLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), greeneLabel, 0, 1, 4, 5);
	      greeneEntry = gtk_entry_new();
	    	gtk_widget_show(greeneEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), greeneEntry, 1, 2, 4, 5);
	      blueeLabel = gtk_label_new(" - Blue:");
	    	gtk_widget_show(blueeLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), blueeLabel, 0, 1, 5, 6);
	      blueeEntry = gtk_entry_new();
	    	gtk_widget_show(blueeEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), blueeEntry, 1, 2, 5, 6);
	      indexRButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(enhRButton)),
			     "RGB correction (indexes)");
	        gtk_widget_show(indexRButton);
		gtk_table_attach_defaults(GTK_TABLE(gammaTable), indexRButton, 0, 2, 6, 7);
	      rediLabel = gtk_label_new(" - Red:");
	    	gtk_widget_show(rediLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), rediLabel, 0, 1, 7, 8);
	      rediEntry = gtk_entry_new();
	    	gtk_widget_show(rediEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), rediEntry, 1, 2, 7, 8);
	      greeniLabel = gtk_label_new(" - Green:");
	    	gtk_widget_show(greeniLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), greeniLabel, 0, 1, 8, 9);
	      greeniEntry = gtk_entry_new();
	    	gtk_widget_show(greeniEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), greeniEntry, 1, 2, 8, 9);
	      blueiLabel = gtk_label_new(" - Blue:");
	    	gtk_widget_show(blueiLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), blueiLabel, 0, 1, 9, 10);
	      blueiEntry = gtk_entry_new();
	    	gtk_widget_show(blueiEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), blueiEntry, 1, 2, 9, 10);
	      fileRButton = gtk_radio_button_new_with_label(
			     gtk_radio_button_group(GTK_RADIO_BUTTON(indexRButton)),
			     "RGB correction (file)");
	        gtk_widget_show(fileRButton);
		gtk_table_attach_defaults(GTK_TABLE(gammaTable), fileRButton, 0, 2, 10, 11);
	      fileLabel = gtk_label_new(" - File:");
	    	gtk_widget_show(fileLabel);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), fileLabel, 0, 1, 11, 12);
	      fileEntry = gtk_entry_new();
	    	gtk_widget_show(fileEntry);
	    	gtk_table_attach_defaults(GTK_TABLE(gammaTable), fileEntry, 1, 2, 11, 12);
	      gtk_widget_show(gammaTable);
	      gtk_container_add(GTK_CONTAINER(gammaFrame), gammaTable);
	    gtk_widget_show(gammaFrame);
	    gtk_box_pack_start(GTK_BOX(advancedHbox), gammaFrame, FALSE, FALSE, 0);
	  gtk_widget_show(advancedHbox);
	  advancedLabel = gtk_label_new("Advanced");
	    gtk_widget_show(advancedLabel);
	  gtk_notebook_append_page(GTK_NOTEBOOK(mainNotebook), advancedHbox, advancedLabel);
	// Services tab
	servicesVbox = gtk_vbox_new(FALSE,10);
	  testButton = gtk_button_new_with_label("Print a test page");
	    gtk_widget_show(testButton);
	    gtk_box_pack_start(GTK_BOX(servicesVbox), testButton, TRUE, FALSE, 0);
	  pnm2ppaButton = gtk_button_new_with_label("Create /tmp/pnm2ppa.conf file");
	    gtk_widget_show(pnm2ppaButton);
	    gtk_box_pack_start(GTK_BOX(servicesVbox), pnm2ppaButton, TRUE, FALSE, 0);
	  calButton = gtk_button_new_with_label("Print calibration pages");
	    gtk_widget_show(calButton);
	    gtk_box_pack_start(GTK_BOX(servicesVbox), calButton, TRUE, FALSE, 0);
	  gammaRefButton = gtk_button_new_with_label("Create gamma reference (/tmp/gamma.ppm)");
	    gtk_widget_show(gammaRefButton);
	    gtk_box_pack_start(GTK_BOX(servicesVbox), gammaRefButton, TRUE, FALSE, 0);
	  gammaNoButton = gtk_button_new_with_label("Print a non-gamma-corrected page");
	    gtk_widget_show(gammaNoButton);
	    gtk_box_pack_start(GTK_BOX(servicesVbox), gammaNoButton, TRUE, FALSE, 0);
	  cleanButton = gtk_button_new_with_label("Clean printer cartridges");
	    gtk_widget_show(cleanButton);
	    gtk_box_pack_start(GTK_BOX(servicesVbox), cleanButton, TRUE, FALSE, 0);
	  gtk_widget_show(servicesVbox);
	  servicesLabel = gtk_label_new("Services");
	    gtk_widget_show(servicesLabel); 
	  gtk_notebook_append_page(GTK_NOTEBOOK(mainNotebook), servicesVbox, servicesLabel);
	gtk_widget_show(mainNotebook);
        gtk_box_pack_start(GTK_BOX(mainVbox), mainNotebook, FALSE, FALSE, 0);
      buttonsHbox = gtk_hbox_new(FALSE,0);
        okButton = gtk_button_new_with_label("Ok");
    	  gtk_widget_show(okButton);
          gtk_box_pack_start(GTK_BOX(buttonsHbox), okButton, TRUE, TRUE, 10);
        onceButton = gtk_button_new_with_label("Aply once");
    	  gtk_widget_show(onceButton);
          gtk_box_pack_start(GTK_BOX(buttonsHbox), onceButton, TRUE, TRUE, 10);
        cancelButton = gtk_button_new_with_label("Cancel");
    	  gtk_widget_show(cancelButton);
          gtk_box_pack_start(GTK_BOX(buttonsHbox), cancelButton, TRUE, TRUE, 10);
        toDefButton = gtk_button_new_with_label("System defaults");
    	  gtk_widget_show(toDefButton);
          gtk_box_pack_start(GTK_BOX(buttonsHbox), toDefButton, TRUE, TRUE, 10);
        removeButton = gtk_button_new_with_label("Remove");
    	  gtk_widget_show(removeButton);
          gtk_box_pack_start(GTK_BOX(buttonsHbox), removeButton, TRUE, TRUE, 10);
        helpButton = gtk_button_new_with_label("Help");
    	  gtk_widget_show(helpButton);
          gtk_box_pack_start(GTK_BOX(buttonsHbox), helpButton, TRUE, TRUE, 10);
        gtk_widget_show(buttonsHbox);
        gtk_box_pack_start(GTK_BOX(mainVbox), buttonsHbox, FALSE, FALSE, 0);
      gtk_widget_show(mainVbox);
      gtk_container_add(GTK_CONTAINER (mainWindow), mainVbox);
    gtk_widget_show(mainWindow);

  return (doConnections());
}

int doConnections(){
  /* Exit app when closing the main window */
  gtk_signal_connect(GTK_OBJECT (mainWindow), "delete_event", GTK_SIGNAL_FUNC(mainWindowDelete), NULL);
  gtk_signal_connect(GTK_OBJECT (mainWindow), "destroy", GTK_SIGNAL_FUNC(mainWindowDestroy), NULL);
  /* Exit app when clicking Cancel */
  gtk_signal_connect(GTK_OBJECT (cancelButton), "clicked", GTK_SIGNAL_FUNC(mainWindowDestroy), NULL);
  gtk_signal_connect(GTK_OBJECT(okButton), "clicked", GTK_SIGNAL_FUNC(actionOk), NULL);
  gtk_signal_connect(GTK_OBJECT(onceButton), "clicked", GTK_SIGNAL_FUNC(actionOnce), NULL);
  gtk_signal_connect(GTK_OBJECT(toDefButton), "clicked", GTK_SIGNAL_FUNC(actionToDef), NULL);
  gtk_signal_connect(GTK_OBJECT(removeButton), "clicked", GTK_SIGNAL_FUNC(actionRemove), NULL);
  gtk_signal_connect(GTK_OBJECT(helpButton), "clicked", GTK_SIGNAL_FUNC(actionHelp), NULL);

  gtk_signal_connect(GTK_OBJECT(testButton), "clicked", GTK_SIGNAL_FUNC(actionTest), NULL);
  gtk_signal_connect(GTK_OBJECT(pnm2ppaButton), "clicked", GTK_SIGNAL_FUNC(actionPnm2ppa), NULL);
  gtk_signal_connect(GTK_OBJECT(calButton), "clicked", GTK_SIGNAL_FUNC(actionCal), NULL);
  gtk_signal_connect(GTK_OBJECT(gammaRefButton), "clicked", GTK_SIGNAL_FUNC(actionGammaRef), NULL);
  gtk_signal_connect(GTK_OBJECT(gammaNoButton), "clicked", GTK_SIGNAL_FUNC(actionGammaNo), NULL);
  gtk_signal_connect(GTK_OBJECT(cleanButton), "clicked", GTK_SIGNAL_FUNC(actionClean), NULL);

  //  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  //			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
  //			     GTK_OBJECT (window));
  
  return 0;
}

int main(int argc, char *argv[]) {
  int confReaded = 0;
  gtk_init(&argc, &argv);

  confReaded = getPpaSetRC(&settings);
  if (confReaded == 1) {
    // Files doesn't exists, so read system defaults
    if (getSystemDefaults(&settings) == -1){
      fprintf(stderr, "Couldn't read system default configuration\n");
      exit(-1);
    }
  } else if (confReaded == 0) {
    // Sucesfully readed.
    // Do nothing
  } else {
    // Error
    fprintf(stderr, "Couldn't read config files in HOME\n");
    exit(-1);
  }

  if (makeGUI() == -1){
    exit(-1);
  }

  settings2gui();
  
  gtk_main();
  return(0);
}
