#ifndef _PPASETBASE_H_
#define _PPASETBASE_H_

// The default paths, if not given
#ifndef BASEDIR
#define BASEDIR "/usr/local/ppaSet"
#endif
#ifndef TEST
#define TEST "/usr/local/ppaSet/test"
#endif
#ifndef CALIBRATION
#define CALIBRATION "/usr/local/ppaSet/calibration"
#endif
#ifndef GAMMAREF
#define GAMMAREF "/usr/local/ppaSet/gammaRef"
#endif
#ifndef NOGAMMA
#define NOGAMMA "/usr/local/ppaSet/noGamma"
#endif
#ifndef CLEAN
#define CLEAN "/usr/local/ppaSet/cleanHeads"
#endif
#ifndef LPR
#define LPR "/usr/bin/lpr"
#endif

#define MAXPATHLEN 256

// The name of the printer in /etc/printcap
// "ppa" is OK for the default installation
#define PPAPRINTER "ppa"
// This value must be larger than length_of_the_later plus 2
#define PPAPRINTERLEN 10


#define TYPE_NONE 0
#define TYPE_HP710 1
#define TYPE_HP712 2
#define TYPE_HP720 3
#define TYPE_HP722 4
#define TYPE_HP820 5
#define TYPE_HP1000 6

#define COLOR_NONE 0
#define COLOR_COLOR 1
#define COLOR_GREYSCALE 2
#define COLOR_BLACKWHITE 3

#define DITHER_NONE 0
#define DITHER_FS 1
#define DITHER_FAST 2

#define MODE_NONE 0
#define MODE_ECO 1
#define MODE_NORMAL 2
#define MODE_PHOTO 3

#define PAPER_NONE 0
#define PAPER_A4 1
#define PAPER_A3 2
#define PAPER_LEGAL 3
#define PAPER_LETTER 4

#define BIUNI_NONE 0
#define BIUNI_BI 1
#define BIUNI_UNI 2

#define GAMMA_DEFAULT 0
#define GAMMA_NONE 1
#define GAMMA_ENH 2
#define GAMMA_INDEX 3
#define GAMMA_FILE 4
#define GAMMA_FILE_PATH_LEN 256
#define GAMMA_CAL 5

typedef struct {
  char type;
  char color;
  char dither;
  char mode;

  char paper;
  int xOffset;
  int yOffset;
  int topMargin;
  int bottomMargin;
  int leftMargin;
  int rightMargin;

  char biUni;
  int bwShearing;
  int colorShearing;
  int xOffsetColor;
  int yOffsetColor;
  int blackness;
  char gammaMode;
  double gammaEnhR;
  double gammaEnhG;
  double gammaEnhB;
  int gammaIndexR;
  int gammaIndexG;
  int gammaIndexB;
  char gammaFile[GAMMA_FILE_PATH_LEN];
} ppaSet_t;

/*************************************************/
/* Functions to read/create configuration  files */
/*************************************************/

// Reads system default configuration, and stores it in the structure.
// It uses hard-coded info, then /etc/pnm2ppa.conf
// Returns 0 on sucess, -1 on error.
int getSystemDefaults(ppaSet_t *settings);

// Reads ~/.ppaSetRC and ~/ppaSetRC.conf if exist, and updates information in "settings"
// Returns 0 on sucess, -1 on error, 1 if the file doesn't exists.
int getPpaSetRC(ppaSet_t *settings);

// Creates ~/.ppaSetRC and ~/ppaSetRC.conf with the given information
// Returns 0 on sucess, -1 on error.
int createPpaSetRC(ppaSet_t settings);

// Creates ~/.ppaSet1RC and ~/ppaSetRC1.conf with the given information
// Returns 0 on sucess, -1 on error.
int createPpaSet1RC(ppaSet_t settings);

// Removes ~/.ppaSetRC, ~/.ppaSetRC.conf, ~/.ppaSet1RC and ~/.ppaSet1RC.conf
// if exist.
// Returns 0 on success, -1 on error.
int removePpaSetRC();

/********************************************/
/* Services associated to pnm2ppa software: */
/********************************************/

// Creates a pnm2ppa.conf file, suitable for being used as system wide configuration
// Returns 0 on success, -1 on error.
int createPnm2ppa_conf(ppaSet_t settings);

// Creates a /tmp/gamma.ppm gamma reference file, to be used in gamma calibration
// Returns 0 on success, -1 on error.
int createGammRef();

// Prints a non-gamma-corrected image, to be used in the gamma calibration.
// Returns 0 on success, -1 on error.
int printNoGamma(ppaSet_t settings);

// Prints a test page, using the given settings
// Returns 0 on success, -1 on error
int printTestPage(ppaSet_t settings);

// Prints calibration pages, using the given settings
// Returns 0 on success, -1 on error
int printCalibrationPages(ppaSet_t settings);

// Cleans printer head... as much as possible.
// Returns 0 on success, -1 on error
int cleanHeads(ppaSet_t settings);


#endif // _PPASETBASE_H_
