/* 
   pstoeditexe.cpp : This file is part of pstoedit
   main program for Windows 9X/NT. Just calls the pstoedit.dll
 
   Copyright (C) 1999 Wolfgang Glunz, wglunz@geocities.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
// #include <iostream.h>  // use stdio to be plain C compatible
#include <windows.h>

#include "pstoedll.h" 

int write_callback_test (void * cb_data, const char* text,unsigned long length)
/* Returns number of characters successfully written  */
{
	fwrite(text, 1, length, stdout);
	return length;
}

int main(int argc,char* argv[]) {
	char myname[2000];
	void * handle = 0;
	myname[0] = '\0';
	GetModuleFileName(0,myname,sizeof(myname));
	{
		const int len = strlen(myname);
		if (len < 0) {
			fprintf(stderr, "could not find path to myself");
			return 1;
		}
		myname[len-3] = 'D';
		myname[len-2] = 'L';
		myname[len-1] = 'L';
	}

	handle = LoadLibrary(myname);
	if (handle) {
		{void * fptr0 = GetProcAddress(handle, "pstoedit_checkversion");
		if (fptr0) {
			pstoedit_checkversion_func * pstoedit_checkversion = (pstoedit_checkversion_func *) fptr0;
			int result = pstoedit_checkversion(pstoeditdllversion);
			if (!result) {
				fprintf(stderr,"wrong version of pstoedit.dll found\n");
				return 1;
			}
		} else {
			fprintf(stderr, "could not find pstoedit_checkversion in %s",myname);
			return 1;
		}}

		
		{void * fptr0 = GetProcAddress(handle, "setPstoeditOutputFunction");
		if (fptr0) {
			setPstoeditOutputFunction_func * setPstoeditOutputFunction = (setPstoeditOutputFunction_func *) fptr0;
			setPstoeditOutputFunction(0, // no Call Back Data ptr
					write_callback_test);
		} else {
			fprintf(stderr, "could not find setPstoeditOutputFunction in %s",myname);
			return 1;
		}}
#if NOTNEEDEDINMAIN
		{void * fptr1 = GetProcAddress(handle, "getPstoeditDriverInfo_plainC");
		if (fptr1) {
			getPstoeditDriverInfo_plainC_func * getPstoeditDriverInfo_plainC = (getPstoeditDriverInfo_plainC_func *) fptr1;
			struct DriverDescription_S * dd = getPstoeditDriverInfo_plainC();
			struct DriverDescription_S * ddi = dd;
#define DUMPLIST
#ifdef DUMPLIST
			while(ddi && (ddi->symbolicname) ) {
				fprintf(stdout, "%s : %s : %s\n",
					ddi->symbolicname,
					ddi->explanation,
					ddi->suffix);
				ddi++;
			}
#endif
			//free(dd);
			{void * fptr0 = GetProcAddress(handle, "clearPstoeditDriverInfo_plainC");
			if (fptr0) {
				clearPstoeditDriverInfo_plainC_func * clearPstoeditDriverInfo_plainC = (clearPstoeditDriverInfo_plainC_func *) fptr0;
				clearPstoeditDriverInfo_plainC(dd);
			} else {
				fprintf(stderr, "could not find clearPstoeditDriverInfo_plainC in %s",myname);
				return 1;
			}}
		} else {
			fprintf(stderr,"could not find getPstoeditDriverInfo_plainC in %s",myname);
			return 1;
		}}
#endif

		{void * fptr2 = GetProcAddress(handle, "pstoedit_plainC");
		if (fptr2) {
			pstoedit_plainC_func * pstoedit_plainC = (pstoedit_plainC_func *) fptr2;
// #define JUSTFORUSAGEDEMO
#ifdef JUSTFORUSAGEDEMO
			const char * testargv[] = {"pstoedit", "-help" };
			const int testargc = 2;
 			pstoedit_plainC(testargc,testargv,"asdadsa.dll");
#else
			pstoedit_plainC(argc,argv,0);
#endif
		} else {
			fprintf(stderr,"could not find pstoedit_plainC in %s",myname );
			return 1;
		}}
		
		FreeLibrary(handle);
	} else {
		fprintf(stderr,"could not open %s",myname );
		return 1;
	}
	return 0;
}
 