#!/bin/sh
#
# ptetex -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

. ./common.sh

if env | grep "^TEX" | grep -v "^TEXMFMAIN=" | grep -v "^TEXDOCVIEW"; then
    echo ""
    echo "Those variables may make unexpected effect. Please unset."
    echo ""
    exit 1
fi

for f in "$HOME/texmf" "$HOME/.texmf-var" "$HOME/.texmf-config"; do
    if test -d "$f"; then
	echo ""
	echo "Personal texmf tree '$f' may make unexpected effect."
	echo "Please rename."
	echo ""
	exit 1
    fi
done

MKTEMP=`mktemp ptetextmp.XXXXXX`
if test $? -ne 0; then
    echo ""
    echo "We need 'mktemp' command when we apply security/tetex-3.0-badscript.patch in 2extract-src.sh."
    echo ""
    exit 1
fi
$RM $MKTEMP

uname -a
cat <<EOF

JAPANESE="$JAPANESE"
KANJI_CODE="$KANJI_CODE"

TMP_PREFIX="$TMP_PREFIX"
PREFIX="$PREFIX"

MAKE="$MAKE"
PATCH="$PATCH"
MD5="$MD5"
NKFJIS="$NKFJIS"

TEXSRC_EXTRACTED="$TEXSRC_EXTRACTED"
TEXMFDIST="$TEXMFDIST"
SYSTEM_FREETYPE2="$SYSTEM_FREETYPE2"

CONF_OPTION="$CONF_OPTION"
MAKE_OPTION="$MAKE_OPTION"

PATH="$PATH"
EOF

echo "-------------------------------------------------------------------------"

test "$MD5" != "none" && necessity_command $MD5
necessity_command ed
necessity_command sed -e s/a/b/g $0
necessity_command egrep '^E?OF$' $0
necessity_command gzip -h
necessity_command unzip -h
necessity_command perl -v

perl -e 'print "\xa4\xa2\xa5\xa2\xb0\xa1"' > nkfjis-check
nkfjis nkfjis-check
md5check <<EOF || exit 1
68630308fe925f9c84b134c42fb0d080  nkfjis-check
EOF
$RM nkfjis-check

if test "$1" != "notetex"; then
    if test ! -f $SRC_DIR/tetex-src-$TETEX_VER.tar.gz \
	 -o ! -f $SRC_DIR/tetex-texmf-$TEXMF_VER.tar.gz; then
	CTAN=http://www.ring.gr.jp/pub/text/CTAN/systems/unix/teTeX/3.0/distrib
	cat <<-EOF

	Please get "tetex-src-$TETEX_VER.tar.gz" and
	           "tetex-texmf-$TEXMF_VER.tar.gz" by following commands.
	cd $SRC_DIR
	wget $CTAN/tetex-src-$TETEX_VER.tar.gz
	wget $CTAN/tetex-texmf-$TEXMF_VER.tar.gz

	EOF
	exit 1
    fi
    if test -z "$TEXSRC_EXTRACTED"; then md5check <<-EOF || exit
	944a4641e79e61043fdaf8f38ecbb4b3  $SRC_DIR/tetex-src-$TETEX_VER.tar.gz
	EOF
    fi
    if test -z "$TEXMFDIST"; then md5check <<-EOF || exit
	ed9d30d9162d16ac8d5065cde6e0f6fa  $SRC_DIR/tetex-texmf-$TEXMF_VER.tar.gz
	EOF
    fi
fi
md5check <<EOF || exit
41786c08288b04000ef5274735fdfaa6  archive/tetex-3.0-libkanji-0.84.patch
86aed5bc9333e1afe1e7948991452640  archive/ptex-src-3.1.10-utf8.patch
81ae0946d3015e946ec8ee4f6c630d41  archive/mendexk2.6d-utf8.patch
5a74547c99fa93fd6bf0dc2012ed0d8b  archive/jmpost-0.04b-utf8.patch
55e138de6bc458ae2572dbd51c5bf508  archive/dvipdfmx-20050831-leak.patch
7b0be8ab8f5e896e2345a8a1a820ba89  archive/dvipdfmx-20050831-p.patch
23659eff85cc515666f528f16e1a0876  archive/dvipdfmx-20050831.tar.gz
92f5fcdf523381c6e30288d0e2c487ab  archive/dvipdfmx-contrib-latex.tar.gz
8233b3c090a670c9fe92fbeb6fb45519  archive/dvipsk-5.95b-p1.7a.tar.gz
93456db388c322cf79643c2d154cb646  archive/freetype-2.1.10.tar.gz
7d688306677b99ec34cf68ef93562381  archive/jcode.pl
12fc14c4ed0530eab018c867b383eedb  archive/jis.tar.gz
c82f9dbbe660149fc737e4f8dfb5095a  archive/jmpost-0.04b.tar.gz
a96792cb86d818ce3c88f84fc471d601  archive/mendexk2.6d.tar.gz
10a3a0bb382d9edf834177d0c03101f5  archive/morisawa.tar.gz
e1a6831d17cf0f615029c6717a557081  archive/patch-ebb-artbox.diff
263407fe38f2ab8e0ad83ee343071c46  archive/platex209.tar.gz
9738f48ec9d6b603b4b6550ba480876d  archive/ptex-src-3.1.10-Beta3.tar.gz
1350dfb1780f5ea8e122bdbc5eaf3c0b  archive/ptex-texmf-2.4.tar.gz
0827b7c13924311c029bbf2a1fded7ac  archive/tetex-3.0-dcb314.patch
0a0ae03d463d30c88d42b1e6985de90a  archive/tetex-3.0-dvipdfm.patch
c88f4c99f3e984c0d3ff540373f2e359  archive/tetex-3.0-magstep.patch
3a68bc5a68db27ff8a66026804855540  archive/tetex-3.0-makej.patch
010ae209d2a5fcac800c99d6f46c9102  archive/tetex-3.0-marvosym-rightarrow.patch
e69659fcf06be4f1f7b2e6c7aa863f94  archive/tetex-src-3.0-omegaware.patch
9eb419b166952d26d48afe382c727cac  archive/updmap-3.0-4.diff
2a79fd972752055f6a1e5a4c24db4a5f  archive/updmap-ExtendSlant.patch
aa5acc8f579394fecf68d6ef9d3f556e  archive/updmap-nostop.patch
71be8be4d9060810380df1c0227a5559  archive/xdvik-tetex-3.0-20061107.diff.gz
35260e1a2815f4ce42631ddc25b07644  archive/xdvik-tetex-3.0-22.84.10.diff.gz
3f73b6d1c55f49f135c8eb57d465d214  babel/babeltest.tex
38d4aefc987b08b829a3af6298774016  babel/japanese-jis.tar.gz
57c1942af01504cff64f7c6b10b4b844  babel/ptetex-babel.tar.gz
344d1f8ff9938282be58e243a5c6700f  cmap/Adobe-Japan1-UCS2
124d33b6c57ffabb96225c410fde70fb  cmap/H
e707ebfb356e4eda5e37a6a6159c6480  cmap/UniCNS-UTF16-H
b18aef107407bde72d9044eaa9f01a07  cmap/UniCNS-UTF16-V
3f833ab691eaf42bf03878d92d576f81  cmap/UniGB-UTF16-H
26daee24a68378b4d54ceef2b04bd1a0  cmap/UniGB-UTF16-V
7ce67e3ef8afc574f0350a5a7de31d76  cmap/UniJIS-UTF16-H
6d313c09922369a0098ed865735b381f  cmap/UniJIS-UTF16-V
fc4c85803cc4bf73f3bed51e3c0b33f2  cmap/UniKS-UTF16-H
9c7616f643b7f9d5e0fea989d7057865  cmap/UniKS-UTF16-V
c917e6a527ba7704c3e11545dab330ca  cmap/V
55daff53c4e52be78025dcd0785bcfc3  macro/burasage.lzh
40f757c7c16bce50915893170ed9b916  macro/eclepsf.sty
601835d441df357d28f93c4d4534dbe0  macro/epsbox.sty
529d0b4598f81c14ec4cf39a6365b654  macro/jsclasses-061106.zip
4c6224bbdc50345999714c32958eb186  macro/otfstable-speedup.patch
94bf85c5c3ed4c0db5895de1e63a9201  macro/otfstable.zip
50382fd31d95532cbc3d6803bc882578  macro/powerdot.tar.gz
4acbd7a7aea2000b4a5c7048f06041cc  macro/prosper-1.00.4.tar.gz
b5978c8956885bed02211d32f680be2c  macro/tategumi.tar.gz
c9dd89924d2041ff5c64f853736713ef  macro/tateyoko.tar.gz
f8a3ac31b14e6ae9484fe874e2d7c2a6  macro/utfsrc-speedup.patch
95d9440a5d62c8ccf09d55713019033c  macro/utfsrc.zip
beeee2eddd35c5c70a0c60ac4a046a68  macro/xkeyval.tar.gz
caab6b09d2d79aeb3d70383dc6059dcf  security/tetex-2.0.2-dvipdfm-security.patch
aaa40a494cb30778f56f3b5c6590477e  security/tetex-3.0-CVE-2005-3193.patch
25cf7d7cb3728e1cc4a98eaae0b4be96  security/tetex-3.0-badscript.patch
EOF
echo ""
