#!/bin/sh
#
# ptetex -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

. ./common.sh

install="prefix=$TMP_PREFIX texmf=$TEXMF datadir=$TMP_DATADIR install"

unset TEXINPUTS
unset HOME
##
## To set enviroment variable, edit "../my_option".
##

date
if test "$JAPANESE" != "without"; then
## freetype for xdvi-jp
if test "$SYSTEM_FREETYPE2" = "no"; then
    echo "[--freetype--] configure"
    cd $SRC/freetype || exit
    GNUMAKE=$MAKE ./configure || exit
    echo "[--freetype--] make"
    $MAKE || exit

    for f in $SRC/texk/*xdvik/configure; do
	perlprint \
	"s@freetype-config --ftversion@echo 2.1.10@g;
	 s@freetype-config --cflags@echo -I../../freetype/include@g;
	 s@freetype-config --libs@sh ../../freetype/builds/unix/freetype-config --libs | sed -e 's|-lfreetype|../../freetype/objs/.libs/libfreetype.a|'@" \
	     $f
    done
fi
fi # "$JAPANESE" != "without"

echo "[--tetex--] configure"
cd $SRC || exit
./configure --prefix=$PREFIX --datadir=$DATADIR \
    --disable-multiplatform --enable-kanji=$KANJI_CODE \
    $CONF_OPTION || exit
echo "[--tetex--] make"
$MAKE $MAKE_OPTION || exit
echo "[--tetex--] make install"
$MAKE $MAKE_OPTION $install || exit


if test "$JAPANESE" != "without"; then
$MKDIR $TEXMF/xdvi || exit
cat <<EOF > $TEXMF/xdvi/vfontmap || exit
%
% vfontmap -- Do NOT edit this file BY HAND!!
%
% An effective file is
% "$DATADIR/texmf-var/fonts/map/xdvi/updmap/vfontmap"
% which is generated by 'updmap-sys'.
%
% Use "updmap-sys --setoption xdviRml mincho-font"
% and "updmap-sys --setoption xdviGbm gothic-font".
%
EOF


echo "[--dvipdfmx--] configure"
cd $SRC/texk/dvipdfmx || exit
./configure --with-kpathsea=$TMP_PREFIX \
    --prefix=$PREFIX --datadir=$DATADIR || exit
echo "[--dvipdfmx--] make"
$MAKE $MAKE_OPTION || exit
echo "[--dvipdfmx--] install"
$MAKE $MAKE_OPTION $install || exit

$MKDIR $TEXMF/fonts/cmap || exit
$RM    $TEXMF/fonts/cmap/dvipdfm/CMap || exit
$MKDIR $TEXMF/fonts/map/dvipdfm || exit
mv $TEXMF/dvipdfm/CMap $TEXMF/fonts/cmap/dvipdfm || exit
mv $TEXMF/dvipdfm/config/glyphlist.txt $TEXMF/fonts/map/dvipdfm || exit
fi # "$JAPANESE" != "without"

## disable mktexlsr (texhash)
#echo "% disable ls-R" > $TEXMF/ls-R

strip $TMP_PREFIX/bin/* $TMP_PREFIX/lib/libkpathsea.* 2> /dev/null
$MKTEXLSR || exit
$UPDMAP 2> /dev/null || exit
date

cat <<EOF
------------------------------
'ptetex3' binary was installed temporary.
(You should need extra macros and settings of Japanese fonts
 via 'make macro' and 'make font'.)
A WIZARD of UNIX can use the temporary TeX system by following setting.
In most case 'make install' is recommended.

(for sh/bash user)
export            PATH=$TMP_PREFIX/bin:\$PATH
export LD_LIBRARY_PATH=$TMP_PREFIX/lib:\$LD_LIBRARY_PATH
export       TEXMFMAIN=$TMP_PREFIX/share/texmf

(for csh/tcsh user)
setenv            PATH $TMP_PREFIX/bin:\$PATH
setenv LD_LIBRARY_PATH $TMP_PREFIX/lib:\$LD_LIBRARY_PATH
setenv       TEXMFMAIN $TMP_PREFIX/share/texmf
------------------------------

EOF
