#!/bin/sh
#
# ptetex -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#
# pTeX ˳ƸΥϥեեɤ߹ޤ
# Babel ޥѥåȻȤ褦ˤޤ
#
# http://www2.tba.t-com.ne.jp/ing/gcinst3g3sj.txt
# ƤƧޤάƼ¹ԤƤޤ
# Ĥޤꡢʤ٤ teTeX-3.0 °ΥեѤ
# $TEXMF-dist/ ʲΥե򥹥ץȤѴϡ
# Ʊ̾Υե $TEXMF/ ʲˤĤꡢ
# ʤ٤ language.dat ѹʤ褦ˤƤޤ

. ./common.sh

test -f $TEXMF/ptex/platex/config/hyphen.cfg && \
     mv $TEXMF/ptex/platex/config/hyphen.cfg \
        $TEXMF/ptex/platex/config/hyphen.cfg.ptex

### extra files (shhyphl.tex, elhyphen, teubner, etc.)
tarx babel/ptetex-babel.tar.gz $TEXMF

### (1) bug fix of Babel
## usorbian
distcp $TEXMF tex/generic/babel usorbian.ldf
perlprint 's/^(\\addto\\extrasusorbian\{\\babel\@savevariable\{\\lccode`\\\^\^Y\}%)$/%\1/g;
 s/^(  \\lccode\`\\\^\^Y\`\\\^\^Y})$/%\1/g' \
       $TEXMF/tex/generic/babel/usorbian.ldf

## icelandic
distcp $TEXMF tex/generic/babel icelandic.ldf
perlprint 's/(decimalsep|thousandsep)/ice$1/g' \
       $TEXMF/tex/generic/babel/icelandic.ldf

## welsh
distcp $TEXMF tex/generic/config language.dat
echo "welsh		cyhyph.tex" >> $TEXMF/tex/generic/config/language.dat

if test "$JAPANESE" != "without"; then
### (2) change encoding (to coexist with Japanese EUC, SJIS)
## ukrainian as OT2 encoding
perlprint 's/^(ukrainian\s+ukrhyph.tex)/%! \1/g;
           s/^%! (ukrainian\s+ukrhyph.ot2)/\1/g' \
       $TEXMF/tex/generic/config/language.dat
distcp $TEXMF tex/generic/ukrhyph ukrhyph.tex
perlprint 's/(\\patterns\{ c8h d8j k8h l8j n8j s8h s8h8c8h t8s x8q y8a y8u z8h \})/%\1/g' \
       $TEXMF/tex/generic/ukrhyph/ukrhyph.tex

## russian as OT2 encoding
distcp $TEXMF tex/generic/ruhyphen ruhyphen.tex
perlprint 's/^(\\def\\Encoding\{t2a\})/%\1/g;
           s/%(\\def\\Encoding\{ot2\})/\1/g' \
       $TEXMF/tex/generic/ruhyphen/ruhyphen.tex
distcp $TEXMF tex/generic/ruhyphen koi2ot2.tex
perlprint 's/^%(\\patterns)/\1/g' \
       $TEXMF/tex/generic/ruhyphen/koi2ot2.tex
distcp $TEXMF tex/generic/ruhyphen ruhyphal.tex
perlprint 's/^(2\xcb1\xc82)$/%\1/g;
           s/^(\xd31\xc82)$/%\1/g;
           s/^(4\xd41\xd32)$/%\1/g;
           s/^(2\xdb1\xde)$/%\1/g;
           s/^(\xd9\xd52)$/%\1/g' \
       $TEXMF/tex/generic/ruhyphen/ruhyphal.tex

## serbian as T1 encoding
perlprint 's/srhyphc.tex.*/shhyphl.tex/g' \
       $TEXMF/tex/generic/config/language.dat

### (3) convert 8bit character into ^^?? form
eightbit2hex $TEXMF tex/generic/hyphen   gahyph.tex
eightbit2hex $TEXMF tex/generic/hyphen   huhyphn.tex
eightbit2hex $TEXMF tex/generic/hyphen   trhyph.tex
eightbit2hex $TEXMF tex/generic/ukrhyph  ukrhypmp.tex
eightbit2hex $TEXMF tex/generic/bghyph   bghyphsi.tex
eightbit2hex $TEXMF tex/generic/hyphen   srhyphc.tex
eightbit2hex $TEXMF tex/generic/ruhyphen ruhyphen.tex
eightbit2hex $TEXMF tex/generic/ruhyphen catkoi.tex
eightbit2hex $TEXMF tex/generic/ruhyphen koi2ot2.tex
eightbit2hex $TEXMF tex/generic/ruhyphen ruhyphal.tex
eightbit2hex $TEXMF tex/generic/ruhyphen cyryoal.tex
eightbit2hex $TEXMF tex/generic/babel    icelandic.ldf

### japanese style
tarx babel/japanese-jis.tar.gz $TEXMF/ptex/generic/babel/japanese
(cd $TEXMF/ptex/generic/babel/japanese
platex japanese.ins
$RM japanese.log langxmpl.dat readme.tex sample.tex
)
fi # "$JAPANESE" != "without"

## update fmt
$MKTEXLSR || exit
fmtutil-sys --byfmt latex       || exit
if test "$JAPANESE" != "without"; then
fmtutil-sys --byfmt platex-euc  || exit
fmtutil-sys --byfmt platex-sjis || exit
fi # "$JAPANESE" != "without"

## post
cd $TEXMF || exit
chmod -R og-w .
echo ""
