#!/bin/sh
#
# ptetex -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

. ./common.sh

test -z "$DVIPS"  && DVIPS=dvips
test -z "$DVIPDF" && DVIPDF=dvipdfm
test -z "$XDVI"   && XDVI="xdvi -debug 8"
test -z "$PSPDF"  && PSPDF="ps2pdf -dNOKANJI"
if test "$JAPANESE" = "traditional"; then
    test -z "$PDVIPS"  && PDVIPS="dvips -noomega"
    test -z "$PDVIPDF" && PDVIPDF=dvipdfmx
    test -z "$PXDVI"   && PXDVI="xdvi -debug 8"
elif test "$JAPANESE" = "international"; then
    test -z "$PDVIPS"  && PDVIPS=pdvips
    test -z "$PDVIPDF" && PDVIPDF=dvipdfmx
    test -z "$PXDVI"   && PXDVI="pxdvi -debug 8"
fi

## usage: catexit hoge.log
catexit() {
    cat $1
    exit 1
}

## usage: ex command args....
ex() {
    if $@ 2> /dev/null; then return; fi
    echo "$@"
    $@
    exit 1
}

## check for shared library
#ldd $1/bin/latex  | grep kpath
#ldd $1/bin/platex | grep kpath

$MKDIR ptetex-test-$$
cd ptetex-test-$$

# [$TEXMF/tex/latex/base/testpage.tex]
echo "-----------------------------"
echo "[latex] test"
latex testpage.tex <<EOF > /dev/null || catexit testpage.log
a4paper
y
EOF

ex $DVIPS  testpage.dvi
ex $DVIPDF testpage.dvi > /dev/null
ex $XDVI   testpage.dvi


test "$JAPANESE" = "without" && exit 0
# [$TEXMF/ptex/platex/jsclasses/jsclasses.dtx]
echo "-----------------------------"
echo "[platex yoko] test"
platex jsclasses.dtx < /dev/null > /dev/null || catexit jsclasses.log
platex jsclasses.dtx < /dev/null > /dev/null || catexit jsclasses.log

ex $PDVIPS  jsclasses.dvi
ex $PDVIPDF jsclasses.dvi
ex $PXDVI   jsclasses.dvi

# [$TEXMF/ptex/platex209/sample.tex]
echo "-----------------------------"
echo "[platex tate] test"
platex209 sample.tex < /dev/null > /dev/null || catexit sample.log

ex $PDVIPS  sample.dvi
ex $PDVIPDF sample.dvi
ex $PXDVI   sample.dvi

# [$TEXMF/packages/utfsrc/test/utfsmpl.tex]
if test -f $TEXMF/packages/utfsrc/test/utfsmpl.tex; then
echo "-----------------------------"
echo "[UTF package] test"
platex $TEXMF/packages/utfsrc/test/utfsmpl.tex < /dev/null > /dev/null \
    || catexit utfsmpl.log

ex $PDVIPDF -o utfsmpl-dvipdfmx.pdf utfsmpl.dvi
ex $PDVIPS  utfsmpl.dvi
ex $PSPDF   utfsmpl.ps utfsmpl-ps2pdf.pdf
ex $PXDVI   utfsmpl.dvi
fi

# [$TEXMF/packages/otfstable/test/otftest.tex]
if test -f $TEXMF/packages/otfstable/test/otftest.tex; then
echo "-----------------------------"
echo "[OTF package] test"
tarx ../macro/tategumi.tar.gz . # for furikana.sty
$RM index.html burasage.sty furiknkt.sty j-uline.sty jundline.sty kochu.sty kyakuchu.sty sfkanbun.sty shiika.sty tkokugo.sty tnamisen.sty tochu.sty tsayusen.sty tundline.sty warichu.sty
platex $TEXMF/packages/otfstable/test/otftest.tex < /dev/null > /dev/null \
    || catexit otftest.log

ex $PDVIPDF -o otftest-dvipdfmx.pdf otftest.dvi
ex $PDVIPS  otftest.dvi
ex $PSPDF   otftest.ps otftest-ps2pdf.pdf
ex $PXDVI   otftest.dvi
fi

# [babel/babeltest.tex]
if kpsewhich -progname=platex japanese.sty > /dev/null; then
echo "-----------------------------"
echo "[Babel + ptex] test"
platex ../babel/babeltest.tex < /dev/null > /dev/null || catexit babeltest.log

ex $PDVIPS  babeltest.dvi
ex $PDVIPDF babeltest.dvi
ex $PXDVI   babeltest.dvi
fi

# -dNOKANJI check for dvipdfmx
echo "-----------------------------"
echo "[-dNOKANJI] test"
cat <<EOF > dNOKANJI.tex
\documentclass[43pt]{jsarticle}
\setlength{\headsep}{-3em}
\usepackage{graphicx}
\begin{document}
\noindent {\tiny If char and EPS looks similar, OK.}

\noindent
Char: {\Huge ѤԤ} \newline
\raisebox{3em}{EPS:~}
\includegraphics[clip,width=0.7\textwidth]{`pwd`/dNOKANJI.eps}
\end{document}
EOF

cat <<EOF > dNOKANJI.eps
%!PS-Adobe-2.0
%%BoundingBox: 20 100 330 308
%%BeginProlog
/OurCharSet findfont 12 scalefont setfont
(a) stringwidth pop /mp_a_x exch def
%%EndProlog
save
gsave
560 11 mp_a_x mul div 306 18 div scale
4 7 translate 552 560 div 16 36 div scale
/Ryumin-Light-H findfont 14 scalefont setfont
0 13 moveto <2451> show
2 mp_a_x mul 13 moveto <2454> show
4 mp_a_x mul 13 moveto <2457> show
0 0 moveto <245a> show
2 mp_a_x mul 0 moveto <245d> show
4 mp_a_x mul 0 moveto <396c> show
grestore
restore
showpage
EOF

nkfjis dNOKANJI.tex
platex dNOKANJI.tex < /dev/null > /dev/null || catexit dNOKANJI.log
ex $PDVIPS  dNOKANJI.dvi
ex $PDVIPDF dNOKANJI.dvi
if test `wc -c < dNOKANJI.pdf` -gt 10000; then
    cat <<EOF
Warning: 'gs' seem to embed Japanese fonts in spite of '-dNOKANJI' option.
Check gs options in $TEXMF/dvipdfm/config/dvipdfmx.cfg.
We may need some additional patches for ghostscript.
EOF
fi
