#!/bin/sh
#
# ptetex -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

. ./common.sh

## arg check
if test -z "$1"; then
cat <<EOF
usage : $0 {install,refresh,uninstall,distclean}
ex.:    $0 install refresh
EOF
exit 1
fi

remove() {
    echo -n "Removing '$1' ok? (yes/no) "
    read REPLY
    case $REPLY in
	y*) rm -rf "$1";;
    esac
}


while [ -n "$1" ]; do
    case "$1" in
	distclean) remove "$TMP_PREFIX";;
	uninstall) remove "$PREFIX";;
	install) echo "copying files ..."
$MKDIR $PREFIX $DATADIR
(cd $TMP_PREFIX; tar cf - bin lib include man info) | (cd $PREFIX; tar xf -)
(cd $TMP_PREFIX/share; tar cf - .) | (cd $DATADIR; tar xf -)
test "$UID" = 0 && chown -R 0:0 $PREFIX $DATADIR
cat <<EOF
------------------------------
'ptetex3' was installed successfully.

for sh/bash user
export PATH=$PREFIX/bin:\$PATH

for csh/tcsh user
setenv PATH $PREFIX/bin:\$PATH

To uninstall
make uninstall
(or 'rm -rf $PREFIX')
------------------------------
EOF
;;
	refresh) echo "finishing ..."
PATH=$PREFIX/bin:$PATH
TEXMF=$DATADIR/texmf
TEXMFMAIN=$TEXMF
LD_LIBRARY_PATH=$PREFIX/lib:$LD_LIBRARY_PATH
export PATH LD_LIBRARY_PATH TEXMFMAIN

$MKTEXLSR 2> /dev/null || exit
$UPDMAP   2> /dev/null || exit
fmtutil-sys --all > /dev/null || exit
# You can check if "$TMP_PREFIX" is not included in files under $PREFIX.
# grep $TMP_PREFIX -l -r $PREFIX || true
;;
	*) echo "Unknown option $1";;
    esac
    shift
done
