#!/usr/bin/perl -w

while (<>) {
    s/(Name:) ptetex3/$1 tetex/;
    $version = $2 if s/(Version:) (.*)/$1 3.0/;
    s/(Release:) .*/$1 $version/;
    s/^Source1:/Source0:/ unless s/^Source0:/Source1:/;
    s/%{name}-%{version}\.tar\.gz/ptetex3-%{release}.tar.gz/;
    s/(Provides:) tetex = 3.0\s+/$1 /;
    s/(%setup -q)/$1 -n tetex-src-3.0 -a 1\nmv ptetex3-* ptetex3\ncd ptetex3/;
    s/build\/tetex-src-3.0/../;
    s/^(cp -a) (build)/$1 ptetex3\/$2/;
    print;
    print "TEXSRC_EXTRACTED=%{_builddir}\n" if /^DATADIR/;
    print "cd ptetex3\n" if /^%build/;
    if (/%description/) {
	<>;
	print "TeTeX is an implementation of TeX for Linux or UNIX systems.\n";
    }
    print <<'EOF' if /^EOF/;
# ommit file check
perl -pi -e "s|(\./1check-archive\.sh)|\1 notetex|g" Makefile
EOF
}
