# for SUSE Linux 10.1
%define fontsjp IPAGothic IPAMincho

%define exec_texhash [ -x %{_bindir}/texconfig-sys ] && PATH=%{_bindir}:$PATH %{_bindir}/texconfig-sys rehash 2>/dev/null
%define exec_updmap  [ -x %{_bindir}/updmap-sys ]    && PATH=%{_bindir}:$PATH %{_bindir}/updmap-sys --nostop 2>/dev/null
%define exec_fmtutil [ -x %{_bindir}/fmtutil-sys ]   && PATH=%{_bindir}:$PATH %{_bindir}/fmtutil-sys --all >/dev/null
%define vartexfonts %{_var}/lib/texmf

Summary: TeX distribution teTeX with Japanese patch collection 'ptetex'
Name: ptetex3
Version: 20061111
Release: 1
Source0: http://tutimura.ath.cx/~nob/tex/ptetex/ptetex3/%{name}-%{version}.tar.gz
Source1: http://www.ring.gr.jp/pub/text/CTAN/systems/unix/teTeX/3.0/distrib/tetex-src-3.0.tar.gz
Source2: http://www.ring.gr.jp/pub/text/CTAN/systems/unix/teTeX/3.0/distrib/tetex-texmf-3.0po.tar.gz
URL: http://www.nn.iij4u.or.jp/~tutimura/tex/ptetex.html
License: distributable
Buildroot: %{_tmppath}/%{name}-%{version}-root
Group: Productivity/Publishing/TeX/Base
PreReq:        ed mktemp
BuildRequires: ed mktemp
PreReq:        ghostscript-cjk %{fontsjp}
BuildRequires: ghostscript-cjk %{fontsjp}
BuildRequires: rpm build
BuildRequires: cpp gzip bzip2 tar patch file nkf
BuildRequires: binutils coreutils findutils diffutils
BuildRequires: gcc gcc-c++ libgcc >= 4.0.2
BuildRequires: glibc glibc-devel glibc-locale >= 2.3.5
BuildRequires: make libstdc++ libstdc++-devel
BuildRequires: bison flex libtool automake autoconf
BuildRequires: zlib-devel libpng-devel ncurses-devel
BuildRequires: xorg-x11 xorg-x11-devel xorg-x11-libs
BuildRequires: openmotif openmotif-libs openmotif-devel
#http://ftp.opensuse.org/pub/opensuse/distribution/SL-10.1/inst-source/suse/i586/openmotif-devel-2.2.4-21.i586.rpm
#http://ftp.opensuse.org/pub/opensuse/distribution/SL-10.1/inst-source/suse/x86_64/openmotif-devel-2.2.4-21.x86_64.rpm
BuildRequires: freetype2 freetype2-devel >= 2.1.10
Provides:  tetex = 3.0 te_cont te_kpath te_latex te_mpost te_omega
Provides:  te_ptex jsclasses
Conflicts: te_ams te_dvilj te_eplai te_web
Conflicts: cjk-latex latex-ucs musictex
#PreReq:        tetex-texmf
#BuildRequires: tetex-texmf

%description
'ptetex' is Japanes patch collection for teTeX.

%prep
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%setup -q
cat <<EOF > my_option
KANJI_CODE=EUC
#KANJI_CODE=UTF8
export CFLAGS="$RPM_OPT_FLAGS"
SRC_DIR=%{_sourcedir}
TMP_PREFIX=`pwd`/build
PREFIX=%{_prefix}
DATADIR=%{_datadir}
#TEXMFDIST=%{_datadir}/texmf-dist
make_option vartexfonts=%{vartexfonts}

conf_option --without-dviljk
conf_option --without-info
conf_option --without-texi2html
conf_option --without-texinfo

conf_option --with-system-zlib
conf_option --with-system-pnglib
conf_option --with-system-gd
conf_option --with-system-ncurses
conf_option --with-system-t1lib
conf_option --enable-shared
conf_option --enable-kanji-iconv
EOF
# remove useless entry in 7font-search.sh
perl -ni -e 'print unless /^X11TTF / or /^Acrobat/' 7font-search.sh
# extract files
unset TEXINPUTS HOME
make check x
# modify input method for xdvi
perl -pi -e 's/(\*inputMethod: kinput2)/! \1/' \
    build/tetex-src-3.0/texk/xdvik/texmf/XDvi
# avoid dependency on perl-Tk
rm -rf teTeX/share/texmf-dist/scripts/context/perl

%build
unset TEXINPUTS HOME
make c macro otf babel fonty

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_prefix}
mkdir -p $RPM_BUILD_ROOT%{vartexfonts}
cp -a build/bin     $RPM_BUILD_ROOT%{_bindir}
cp -a build/share   $RPM_BUILD_ROOT%{_datadir}
cp -a build/include $RPM_BUILD_ROOT%{_includedir}
cp -a build/lib     $RPM_BUILD_ROOT%{_libdir}
cp -a build/man     $RPM_BUILD_ROOT%{_mandir}
cp -a build/info    $RPM_BUILD_ROOT%{_infodir}

rm -r	$RPM_BUILD_ROOT%{_datadir}/texmf/web2c/texmf.cnf.* \
	$RPM_BUILD_ROOT%{_datadir}/texmf/web2c/fmtutil.cnf.* \
	$RPM_BUILD_ROOT%{_infodir}/dir

### Files list
find $RPM_BUILD_ROOT -type f -or -type l | \
    sed -e "s|$RPM_BUILD_ROOT||g" \
	-e "s|.*\.cnf$|%config(noreplace) &|" \
	-e "s|.*\.cfg$|%config(noreplace) &|" \
	-e "s|.*/ls-R$|%ghost &|" \
	-e "s|.*/texmf-var/.*\.log$|%ghost &|" \
	-e "s|.*/texmf-var/.*map$|%ghost &|" \
	-e "s|.*/texmf-var/.*\.fmt$|%verify(not size md5 mtime) &|" \
	-e "s|.*/texmf-var/.*\.mem$|%verify(not size md5 mtime) &|" \
	-e "s|.*/texmf-var/.*\.base$|%verify(not size md5 mtime) &|" \
	-e "s|.*/man/man.*|&*|" \
	-e "s|.*/info/.*|&*|" \
						> filelist.full
find $RPM_BUILD_ROOT%{_datadir}/texmf* -type d | \
    sed -e "s|^$RPM_BUILD_ROOT|%dir |" \
	-e "s|$|/|"				>> filelist.full
echo "%dir %{_includedir}/kpathsea"		>> filelist.full

## check if 'jmpost.mem' exist
grep '/jmpost.mem' filelist.full > /dev/null

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT


%preun
rm -rf %{vartexfonts}/*
exit 0

%post
/sbin/ldconfig
%{exec_texhash}
%{exec_updmap}
exit 0

%postun
/sbin/ldconfig
exit 0


%files -f filelist.full
%defattr(-,root,root)
%attr(1777,root,root) %dir %{vartexfonts}


%changelog
* Tue Nov  7 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added 'unset TEXINPUTS HOME' before 'make'.

* Mon Oct 16 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- updated "my_option".
- use %{vartexfonts}.

* Tue Sep  5 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- use %{_mandir} and %{_infodir}, etc.
- remove useless files. (%{_infodir}/dir, texmf.cnf.*, fmtutil.cnf.*)
- added check existence of 'jmpost.mem'.

* Sun Sep  3 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added %{exec_fmtutil} macro.

* Tue Aug 15 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- use conf_option and make_option.

* Mon Mar 20 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added %verify() attribute to *.fmt and *.mem and *.base.

* Mon Dec  5 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- automatic yes in make font (target "fonty").

* Sat Dec  3 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- enhanced %exec_texhash macro (check if the command exist).

* Tue Aug 30 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added 'babel' target for make.

* Thu Jun 16 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- 1st release.
