#
# DO NOT MODIFY!!!!
# This file is automatically generated by racc 1.4.5
# from racc grammer file "grammar.ra".
#

require 'racc/parser'


require 'puppet'
require 'puppet/util/loadedfile'
require 'puppet/parser/lexer'
require 'puppet/parser/ast'
#require 'puppet/parser/interpreter'

module Puppet
    class ParseError < Puppet::Error; end

    class ImportError < Racc::ParseError; end
end

Puppet[:typecheck] = true
Puppet[:paramcheck] = true


module Puppet

  module Parser

    class Parser < Racc::Parser

module_eval <<'..end grammar.ra modeval..id8685abbbb8', 'grammar.ra', 614
require 'puppet/parser/functions'

attr_reader :file, :interp
attr_accessor :files

# Add context to a message; useful for error messages and such.
def addcontext(message, obj = nil)
    obj ||= @lexer

    message += " on line %s" % obj.line
    if file = obj.file
        message += " in file %s" % file
    end

    return message
end

# Create an AST array out of all of the args
def aryfy(*args)
    if args[0].instance_of?(AST::ASTArray)
        result = args.shift
        args.each { |arg|
            result.push arg
        }
    else
        result = ast AST::ASTArray, :children => args
    end

    return result
end

# Create an AST object, and automatically add the file and line information if
# available.
def ast(klass, hash = nil)
    hash ||= {}
    unless hash.include?(:line)
        hash[:line] = @lexer.line
    end

    unless hash.include?(:file)
        if file = @lexer.file
            hash[:file] = file
        end
    end

    return klass.new(hash)
end

# Raise a Parse error.
def error(message)
    if brace = @lexer.expected
        message += "; expected '%s'"
    end
    except = Puppet::ParseError.new(message)
    except.line = @lexer.line
    if @lexer.file
        except.file = @lexer.file
    end

    raise except
end

def file=(file)
    unless FileTest.exists?(file)
        unless file =~ /\.pp$/
            file = file + ".pp"
        end
        unless FileTest.exists?(file)
            raise Puppet::Error, "Could not find file %s" % file
        end
    end
    if @files.detect { |f| f.file == file }
        raise Puppet::ImportError.new("Import loop detected")
    else
        @files << Puppet::Util::LoadedFile.new(file)
        @lexer.file = file
    end
end

# Import our files.
def import(file)
    if Puppet[:ignoreimport]
        return AST::ASTArray.new(:children => [])
    end
    # use a path relative to the file doing the importing
    if @lexer.file
        dir = @lexer.file.sub(%r{[^/]+$},'').sub(/\/$/, '')
    else
        dir = "."
    end
    if dir == ""
        dir = "."
    end
    result = ast AST::ASTArray

    # We can't interpolate at this point since we don't have any
    # scopes set up. Warn the user if they use a variable reference
    pat = file
    if pat.index("$")
        Puppet.warning(
           "The import of #{pat} contains a variable reference;" +
           " variables are not interpolated for imports " +
           "in file #{@lexer.file} at line #{@lexer.line}"
        )
    end
    files = Puppet::Module::find_manifests(pat, dir)
    if files.size == 0
        raise Puppet::ImportError.new("No file(s) found for import " +
                                      "of '#{pat}'")
    end

    files.collect { |file|
        parser = Puppet::Parser::Parser.new(interp)
        parser.files = self.files
        Puppet.debug("importing '%s'" % file)

        unless file =~ /^#{File::SEPARATOR}/
            file = File.join(dir, file)
        end
        begin
            parser.file = file
        rescue Puppet::ImportError
            Puppet.warning(
                "Importing %s would result in an import loop" %
                    File.join(dir, file)
            )
            next
        end

        # This will normally add code to the 'main' class.
        parser.parse
    }
end

def initialize(interpreter)
    @interp = interpreter
    initvars()
end

# Initialize or reset all of our variables.
def initvars
    @lexer = Puppet::Parser::Lexer.new()
    @files = []
end

# The fully qualifed name, with the full namespace.
def classname(name)
    [@lexer.namespace, name].join("::").sub(/^::/, '')
end

def on_error(token,value,stack)
    #on '%s' at '%s' in\n'%s'" % [token,value,stack]
    #error = "line %s: parse error after '%s'" %
    #    [@lexer.line,@lexer.last]
    error = "Syntax error at '%s'" % [value]

    if brace = @lexer.expected
        error += "; expected '%s'" % brace
    end

    except = Puppet::ParseError.new(error)
    except.line = @lexer.line
    if @lexer.file
        except.file = @lexer.file
    end

    raise except
end

# how should I do error handling here?
def parse(string = nil)
    if string
        self.string = string
    end
    begin
        main = yyparse(@lexer,:scan)
    rescue Racc::ParseError => except
        error = Puppet::ParseError.new(except)
        error.line = @lexer.line
        error.file = @lexer.file
        error.set_backtrace except.backtrace
        raise error
    rescue Puppet::ParseError => except
        except.line ||= @lexer.line
        except.file ||= @lexer.file
        raise except
    rescue Puppet::Error => except
        # and this is a framework error
        except.line ||= @lexer.line
        except.file ||= @lexer.file
        raise except
    rescue Puppet::DevError => except
        except.line ||= @lexer.line
        except.file ||= @lexer.file
        raise except
    rescue => except
        error = Puppet::DevError.new(except.message)
        error.line = @lexer.line
        error.file = @lexer.file
        error.set_backtrace except.backtrace
        raise error
    end
    if main
        # Store the results as the top-level class.
        interp.newclass("", :code => main)
        return main
    end
ensure
    @lexer.clear
end

# See if any of the files have changed.
def reparse?
    if file = @files.detect { |file| file.changed?  }
        return file.stamp
    else
        return false
    end
end

def string=(string)
    @lexer.string = string
end

# Make emacs happy
# Local Variables:
# mode: ruby
# End:

# $Id: parser.rb 2599 2007-06-18 06:26:01Z luke $

..end grammar.ra modeval..id8685abbbb8

##### racc 1.4.5 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 1, 52, :_reduce_1,
 1, 52, :_reduce_none,
 1, 53, :_reduce_none,
 2, 53, :_reduce_4,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 4, 63, :_reduce_17,
 3, 63, :_reduce_18,
 2, 63, :_reduce_19,
 1, 68, :_reduce_none,
 1, 68, :_reduce_none,
 1, 69, :_reduce_none,
 3, 69, :_reduce_23,
 1, 71, :_reduce_none,
 1, 71, :_reduce_none,
 1, 71, :_reduce_none,
 1, 71, :_reduce_none,
 1, 71, :_reduce_none,
 1, 71, :_reduce_none,
 1, 71, :_reduce_none,
 1, 71, :_reduce_31,
 1, 70, :_reduce_none,
 3, 70, :_reduce_33,
 5, 56, :_reduce_34,
 5, 56, :_reduce_35,
 5, 56, :_reduce_36,
 5, 67, :_reduce_37,
 2, 57, :_reduce_38,
 1, 85, :_reduce_39,
 2, 85, :_reduce_40,
 2, 58, :_reduce_41,
 1, 86, :_reduce_none,
 1, 86, :_reduce_none,
 3, 87, :_reduce_44,
 3, 87, :_reduce_45,
 1, 88, :_reduce_none,
 1, 88, :_reduce_none,
 3, 88, :_reduce_48,
 1, 89, :_reduce_none,
 3, 89, :_reduce_50,
 1, 90, :_reduce_none,
 1, 90, :_reduce_none,
 3, 91, :_reduce_53,
 3, 91, :_reduce_54,
 1, 92, :_reduce_none,
 1, 92, :_reduce_none,
 4, 94, :_reduce_57,
 1, 81, :_reduce_none,
 3, 81, :_reduce_59,
 0, 82, :_reduce_none,
 1, 82, :_reduce_none,
 1, 96, :_reduce_62,
 1, 72, :_reduce_63,
 1, 74, :_reduce_64,
 1, 95, :_reduce_none,
 1, 95, :_reduce_none,
 1, 95, :_reduce_none,
 1, 95, :_reduce_none,
 1, 95, :_reduce_none,
 1, 95, :_reduce_none,
 3, 59, :_reduce_71,
 0, 83, :_reduce_72,
 1, 83, :_reduce_73,
 3, 83, :_reduce_74,
 3, 99, :_reduce_75,
 1, 100, :_reduce_none,
 3, 100, :_reduce_77,
 1, 93, :_reduce_none,
 1, 93, :_reduce_none,
 1, 93, :_reduce_none,
 1, 93, :_reduce_none,
 1, 93, :_reduce_none,
 1, 93, :_reduce_none,
 1, 98, :_reduce_none,
 1, 98, :_reduce_none,
 1, 98, :_reduce_none,
 1, 98, :_reduce_none,
 1, 98, :_reduce_none,
 1, 98, :_reduce_none,
 1, 98, :_reduce_none,
 1, 98, :_reduce_none,
 1, 98, :_reduce_none,
 1, 98, :_reduce_none,
 4, 76, :_reduce_94,
 3, 76, :_reduce_95,
 1, 78, :_reduce_96,
 1, 78, :_reduce_97,
 1, 75, :_reduce_98,
 4, 79, :_reduce_99,
 4, 79, :_reduce_100,
 6, 61, :_reduce_101,
 0, 103, :_reduce_none,
 4, 103, :_reduce_103,
 1, 102, :_reduce_none,
 5, 60, :_reduce_105,
 1, 104, :_reduce_none,
 2, 104, :_reduce_107,
 5, 105, :_reduce_108,
 4, 105, :_reduce_109,
 1, 106, :_reduce_none,
 3, 106, :_reduce_111,
 3, 77, :_reduce_112,
 1, 108, :_reduce_none,
 4, 108, :_reduce_114,
 1, 110, :_reduce_none,
 3, 110, :_reduce_116,
 3, 109, :_reduce_117,
 1, 107, :_reduce_none,
 1, 107, :_reduce_none,
 1, 107, :_reduce_none,
 1, 107, :_reduce_none,
 1, 107, :_reduce_none,
 1, 107, :_reduce_none,
 1, 107, :_reduce_none,
 1, 107, :_reduce_125,
 1, 111, :_reduce_126,
 3, 111, :_reduce_127,
 2, 62, :_reduce_128,
 6, 64, :_reduce_129,
 5, 64, :_reduce_130,
 6, 65, :_reduce_131,
 5, 65, :_reduce_132,
 6, 66, :_reduce_133,
 5, 66, :_reduce_134,
 1, 80, :_reduce_none,
 1, 80, :_reduce_none,
 1, 114, :_reduce_none,
 3, 114, :_reduce_138,
 1, 116, :_reduce_none,
 1, 116, :_reduce_none,
 1, 116, :_reduce_none,
 0, 54, :_reduce_142,
 0, 117, :_reduce_143,
 1, 112, :_reduce_none,
 3, 112, :_reduce_145,
 3, 112, :_reduce_146,
 1, 118, :_reduce_none,
 3, 118, :_reduce_148,
 3, 119, :_reduce_149,
 1, 119, :_reduce_150,
 3, 119, :_reduce_151,
 1, 119, :_reduce_152,
 1, 115, :_reduce_none,
 2, 115, :_reduce_154,
 1, 113, :_reduce_none,
 2, 113, :_reduce_156,
 1, 120, :_reduce_none,
 1, 120, :_reduce_none,
 1, 73, :_reduce_159,
 3, 97, :_reduce_160,
 2, 97, :_reduce_161,
 1, 101, :_reduce_none,
 1, 101, :_reduce_none,
 0, 84, :_reduce_none,
 1, 84, :_reduce_165 ]

racc_reduce_n = 166

racc_shift_n = 267

racc_action_table = [
    69,    50,    53,    86,   201,    89,    69,    50,    53,    36,
    36,   203,   191,   104,    47,   152,   113,   192,    92,    36,
   202,   163,    59,    34,    69,    50,    53,  -124,   124,    90,
     4,    42,   199,   200,   124,    52,   108,    42,   101,    61,
    59,    52,    55,    38,    38,    61,    40,    40,    57,    69,
    50,    53,   234,    38,    57,    42,    40,   225,    81,    52,
    55,   168,    82,    61,   224,    59,   231,    69,    50,    53,
   127,   138,    57,    69,    50,    53,  -119,   199,   200,   230,
    42,   167,    42,    59,    52,    55,  -121,   143,    61,    59,
  -118,    47,    50,    53,   138,  -135,   204,    57,    42,   161,
   199,   200,    52,    55,    42,    42,    61,    59,    52,    55,
   143,    44,    61,   138,   191,    57,    69,    50,    53,   192,
   138,    57,    42,   129,    42,  -120,    52,    55,    34,   143,
    61,    42,    59,   188,    45,     4,   143,    34,   154,    57,
    69,    50,    53,    34,     4,  -121,   149,    42,   154,   180,
     4,    52,    55,   181,   182,    61,    59,   196,    69,    50,
    53,    50,    53,  -118,    57,    69,    50,    53,    50,    53,
  -122,    42,   181,   249,   113,    52,    55,   159,  -120,    61,
  -123,    59,  -119,    69,    50,    53,   208,    99,    57,    42,
   125,   212,  -121,    52,   164,   214,    42,    61,    99,    59,
    52,    55,    50,    53,    61,   124,    57,    69,    50,    53,
    47,    81,   216,    57,    42,    81,   219,   113,    52,    55,
  -118,  -119,    61,    59,   123,    69,    50,    53,   156,   122,
   227,    57,    42,    50,    53,   228,    52,   164,    42,   229,
    61,    59,    52,    55,    50,    53,    61,  -123,   113,    57,
  -120,    50,    53,   154,   152,    57,    42,   151,    99,   113,
    52,    55,    95,    42,    61,   162,   113,    52,   164,    50,
    53,    61,   173,    57,    42,    50,    53,   154,    52,   164,
    57,    42,    61,   130,   113,    52,   164,   135,   252,    61,
   113,    57,   253,    50,    53,   134,    87,    82,    57,    42,
   133,    99,  -120,    52,   164,    42,  -118,    61,   113,    52,
   164,    50,    53,    61,  -121,   223,    57,    50,    53,  -119,
  -123,    41,    57,    42,   260,  -165,   113,    52,   164,   261,
    35,    61,    59,    50,    53,    50,    53,   119,  -122,    32,
    57,    42,   226,   nil,   nil,    52,   164,    42,    59,    61,
   113,    52,    55,   169,   nil,    61,   nil,   nil,    57,    45,
   nil,   nil,   nil,    42,    57,    42,   nil,    52,    55,    52,
   164,    61,   266,    61,   nil,    45,   nil,    45,   nil,   nil,
    57,   nil,    57,    19,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   232,   nil,    16,   nil,    21,    25,   nil,     1,     5,
   nil,    10,    19,    14,   nil,    18,   nil,    27,   nil,   nil,
     4,   nil,    16,   nil,    21,    25,   221,     1,     5,   nil,
    10,   nil,    14,   nil,    18,   nil,    27,    19,   nil,     4,
   nil,   nil,   nil,   nil,   nil,   244,   nil,    16,   nil,    21,
    25,   nil,     1,     5,   nil,    10,    19,    14,   nil,    18,
   nil,    27,   nil,   nil,     4,   nil,    16,   nil,    21,    25,
   258,     1,     5,   nil,    10,   nil,    14,   nil,    18,   nil,
    27,    19,   nil,     4,   nil,   nil,   nil,   nil,   nil,   245,
   nil,    16,   nil,    21,    25,   nil,     1,     5,   nil,    10,
    19,    14,   nil,    18,   nil,    27,   nil,   nil,     4,   nil,
    16,   nil,    21,    25,   262,     1,     5,   nil,    10,   nil,
    14,   nil,    18,   nil,    27,    19,   nil,     4,   nil,   nil,
   nil,   nil,   nil,   265,   nil,    16,   nil,    21,    25,   nil,
     1,     5,   nil,    10,    19,    14,   nil,    18,   nil,    27,
   nil,   nil,     4,   nil,    16,   nil,    21,    25,   205,     1,
     5,   nil,    10,   nil,    14,   nil,    18,   nil,    27,    19,
   nil,     4,   nil,   nil,   nil,   nil,   nil,   210,   nil,    16,
   nil,    21,    25,   nil,     1,     5,   nil,    10,    19,    14,
   nil,    18,   nil,    27,   nil,   nil,     4,   nil,    16,   nil,
    21,    25,   nil,     1,     5,   nil,    10,    19,    14,   nil,
    18,   nil,    27,   nil,   nil,     4,   nil,    16,   nil,    21,
    25,   nil,     1,     5,   nil,    10,    19,    14,   nil,    18,
   nil,    27,   nil,   nil,     4,   nil,    16,   nil,    21,    25,
   nil,     1,     5,   nil,    10,    19,    14,   nil,    18,   nil,
    27,   nil,   nil,     4,   nil,    16,   nil,    21,    25,   nil,
     1,     5,   nil,    10,    19,    14,   nil,    18,   nil,    27,
   nil,   nil,     4,   nil,    16,   nil,    21,    25,   nil,     1,
     5,   nil,    10,   nil,    14,   nil,    18,   nil,    27,   nil,
   nil,     4 ]

racc_action_check = [
    41,    41,    41,    22,   139,    26,    47,    47,    47,   104,
    10,   142,   135,    37,    55,   108,    41,   135,    27,   101,
   142,   121,    47,    22,    81,    81,    81,    74,   108,    26,
    22,    41,   139,   139,    55,    41,    41,    47,    37,    41,
    81,    47,    47,   104,    10,    47,   104,    10,    41,   179,
   179,   179,   197,   101,    47,    81,   101,   186,    19,    81,
    81,   123,    19,    81,   186,   179,   194,    69,    69,    69,
    69,    89,    81,    32,    32,    32,   115,   197,   197,   194,
   179,   123,    89,    69,   179,   179,    73,    89,   179,    32,
    72,    14,    14,    14,   138,    14,   147,   179,    69,   114,
   147,   147,    69,    69,    32,   138,    69,    14,    32,    32,
   138,    14,    32,   198,   231,    69,    16,    16,    16,   231,
    90,    32,    14,    71,   198,    68,    14,    14,    25,   198,
    14,    90,    16,   131,    14,    25,    90,     5,   132,    14,
    18,    18,    18,    95,     5,   112,    95,    16,   111,   126,
    95,    16,    16,   126,   126,    16,    18,   136,   159,   159,
   159,    21,    21,   109,    16,   228,   228,   228,   133,   133,
    66,    18,   217,   217,   159,    18,    18,   107,   106,    18,
    65,   228,    64,   152,   152,   152,   153,   154,    18,   159,
    63,   158,    60,   159,   159,   160,   228,   159,   161,   152,
   228,   228,   225,   225,   228,   164,   159,   219,   219,   219,
   167,   168,   170,   228,   152,    59,   176,   225,   152,   152,
    58,    75,   152,   219,    54,   227,   227,   227,   102,    51,
   191,   152,   225,   130,   130,   192,   225,   225,   219,   193,
   225,   227,   219,   219,   173,   173,   219,    77,   130,   225,
    46,   247,   247,   100,    99,   219,   227,    96,    35,   173,
   227,   227,    33,   130,   227,   120,   247,   130,   130,   125,
   125,   130,   125,   227,   173,   203,   203,   215,   173,   173,
   130,   247,   173,    80,   125,   247,   247,    88,   221,   247,
   203,   173,   224,   202,   202,    87,    24,    86,   247,   125,
    83,    82,   237,   125,   125,   203,   239,   125,   202,   203,
   203,   184,   184,   203,   240,   184,   125,    44,    44,   241,
   242,    11,   203,   202,   248,   249,   184,   202,   202,   252,
     8,   202,    44,   124,   124,   122,   122,    44,    79,     1,
   202,   184,   189,   nil,   nil,   184,   184,    44,   124,   184,
   122,    44,    44,   124,   nil,    44,   nil,   nil,   184,    44,
   nil,   nil,   nil,   124,    44,   122,   nil,   124,   124,   122,
   122,   124,   264,   122,   nil,   124,   nil,   122,   nil,   nil,
   124,   nil,   122,   264,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   196,   nil,   264,   nil,   264,   264,   nil,   264,   264,
   nil,   264,   196,   264,   nil,   264,   nil,   264,   nil,   nil,
   264,   nil,   196,   nil,   196,   196,   183,   196,   196,   nil,
   196,   nil,   196,   nil,   196,   nil,   196,   183,   nil,   196,
   nil,   nil,   nil,   nil,   nil,   206,   nil,   183,   nil,   183,
   183,   nil,   183,   183,   nil,   183,   206,   183,   nil,   183,
   nil,   183,   nil,   nil,   183,   nil,   206,   nil,   206,   206,
   233,   206,   206,   nil,   206,   nil,   206,   nil,   206,   nil,
   206,   233,   nil,   206,   nil,   nil,   nil,   nil,   nil,   211,
   nil,   233,   nil,   233,   233,   nil,   233,   233,   nil,   233,
   211,   233,   nil,   233,   nil,   233,   nil,   nil,   233,   nil,
   211,   nil,   211,   211,   253,   211,   211,   nil,   211,   nil,
   211,   nil,   211,   nil,   211,   253,   nil,   211,   nil,   nil,
   nil,   nil,   nil,   263,   nil,   253,   nil,   253,   253,   nil,
   253,   253,   nil,   253,   263,   253,   nil,   253,   nil,   253,
   nil,   nil,   253,   nil,   263,   nil,   263,   263,   151,   263,
   263,   nil,   263,   nil,   263,   nil,   263,   nil,   263,   151,
   nil,   263,   nil,   nil,   nil,   nil,   nil,   156,   nil,   151,
   nil,   151,   151,   nil,   151,   151,   nil,   151,   156,   151,
   nil,   151,   nil,   151,   nil,   nil,   151,   nil,   156,   nil,
   156,   156,   nil,   156,   156,   nil,   156,   261,   156,   nil,
   156,   nil,   156,   nil,   nil,   156,   nil,   261,   nil,   261,
   261,   nil,   261,   261,   nil,   261,    29,   261,   nil,   261,
   nil,   261,   nil,   nil,   261,   nil,    29,   nil,    29,    29,
   nil,    29,    29,   nil,    29,   129,    29,   nil,    29,   nil,
    29,   nil,   nil,    29,   nil,   129,   nil,   129,   129,   nil,
   129,   129,   nil,   129,     0,   129,   nil,   129,   nil,   129,
   nil,   nil,   129,   nil,     0,   nil,     0,     0,   nil,     0,
     0,   nil,     0,   nil,     0,   nil,     0,   nil,     0,   nil,
   nil,     0 ]

racc_action_pointer = [
   636,   326,   nil,   nil,   nil,    99,   nil,   nil,   324,   nil,
     6,   315,   nil,   nil,    89,   nil,   114,   nil,   138,    56,
   nil,   158,   -15,   nil,   296,    90,   -14,   -24,   nil,   598,
   nil,   nil,    71,   227,   nil,   220,   nil,     3,   nil,   nil,
   nil,    -2,   nil,   nil,   314,   nil,   229,     4,   nil,   nil,
   nil,   219,   nil,   nil,   214,    12,   nil,   nil,   199,   213,
   171,   nil,   nil,   169,   161,   159,   149,   nil,   104,    65,
   nil,   117,    69,    65,     6,   200,   nil,   226,   nil,   317,
   277,    22,   263,   290,   nil,   nil,   291,   295,   265,    49,
    98,   nil,   nil,   nil,   nil,   105,   251,   nil,   nil,   245,
   243,    15,   222,   nil,     5,   nil,   157,   138,     6,   142,
   nil,   138,   124,   nil,    82,    55,   nil,   nil,   nil,   nil,
   242,    16,   332,    43,   330,   266,   144,   nil,   nil,   617,
   230,   128,   128,   165,   nil,   -21,   151,   nil,    72,   -16,
   nil,   nil,    -4,   nil,   nil,   nil,   nil,    52,   nil,   nil,
   nil,   541,   181,   179,   149,   nil,   560,   nil,   184,   156,
   188,   160,   nil,   nil,   183,   nil,   nil,   208,   209,   nil,
   189,   nil,   nil,   241,   nil,   nil,   207,   nil,   nil,    47,
   nil,   nil,   nil,   409,   308,   nil,    47,   nil,   nil,   335,
   nil,   217,   222,   216,    56,   nil,   384,    29,    91,   nil,
   nil,   nil,   290,   272,   nil,   nil,   428,   nil,   nil,   nil,
   nil,   472,   nil,   nil,   nil,   267,   nil,   163,   nil,   205,
   nil,   259,   nil,   nil,   286,   199,   nil,   223,   163,   nil,
   nil,    81,   nil,   453,   nil,   nil,   nil,   281,   nil,   285,
   293,   298,   299,   nil,   nil,   nil,   nil,   248,   317,   318,
   nil,   nil,   323,   497,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   579,   nil,   516,   365,   nil,   nil ]

racc_action_default = [
  -142,  -166,   -15,    -3,  -136,  -166,   -16,    -5,  -166,    -6,
  -166,  -166,    -7,    -8,   -43,    -9,  -166,   -10,  -166,   -42,
   -11,  -166,  -166,   -12,  -166,  -166,  -166,   -39,   -13,    -1,
   -14,    -2,  -166,  -142,  -135,   -72,  -140,  -142,  -139,  -137,
  -141,   -72,  -159,   -29,  -166,   -31,   -30,  -166,   -32,   -19,
   -96,   -20,   -98,   -97,   -21,   -63,   -22,   -62,   -24,   -64,
   -25,  -125,  -124,  -166,   -26,   -27,   -28,   -88,   -84,  -166,
   -91,  -166,   -85,   -89,   -93,   -86,   -90,   -87,  -104,   -92,
  -166,  -166,   -72,  -128,  -126,   -38,  -166,  -166,  -142,  -142,
  -142,   -41,   -40,    -4,   -71,  -166,  -166,  -155,   -73,  -166,
  -164,  -166,  -166,  -153,  -166,   -68,   -65,   -60,   -63,   -66,
   -58,  -164,   -69,   -64,  -166,   -67,  -123,   -70,  -122,   -18,
  -166,  -166,  -166,  -166,  -166,  -166,  -166,  -161,   -76,  -166,
  -166,  -166,  -164,  -166,   267,  -143,  -166,  -144,  -142,  -166,
   -47,   -49,  -166,   -63,   -56,   -55,   -46,  -166,  -157,  -158,
  -156,  -166,  -166,  -166,  -165,  -154,  -166,  -138,  -166,   -61,
  -166,   -72,   -17,   -99,   -63,   -23,   -33,  -166,  -166,   -95,
  -166,  -120,  -118,  -166,  -121,  -119,  -166,  -112,  -113,  -166,
  -160,  -162,  -163,  -166,  -166,  -106,  -166,  -110,  -100,  -166,
  -127,  -152,  -150,  -166,  -166,  -147,  -166,  -166,  -166,   -52,
   -51,   -45,  -166,  -166,   -44,  -132,  -166,   -75,   -37,   -74,
  -134,  -166,   -34,   -59,   -35,  -164,   -94,  -164,  -115,  -166,
   -77,  -102,  -107,  -105,  -166,  -166,   -36,  -166,  -166,  -145,
  -146,  -166,  -130,  -166,   -50,   -48,   -82,   -78,   -53,   -79,
   -83,   -80,   -81,   -54,  -131,  -133,   -57,  -166,  -166,  -163,
  -117,  -101,  -166,  -166,  -111,  -151,  -149,  -148,  -129,  -116,
  -114,  -166,  -109,  -166,  -166,  -108,  -103 ]

racc_goto_table = [
    29,    93,   100,   110,    46,   178,   195,    39,   111,    43,
   176,    84,   179,   117,    66,   187,    49,    33,   153,   185,
    24,   139,   147,   238,   243,   209,   126,   235,    71,   160,
    65,   106,   251,   184,    46,    91,   105,    88,   158,    43,
   177,   118,   107,   217,    66,    83,   120,   136,    96,   132,
   189,    37,   102,   218,    64,   165,    31,   116,   176,   193,
    65,    60,   194,    85,   150,   nil,   nil,   nil,   nil,   187,
   197,   nil,   nil,   222,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   115,   nil,   nil,    64,   nil,   nil,   nil,   112,    97,
   nil,    60,   nil,   103,   nil,   nil,   nil,   nil,   155,   nil,
   nil,   157,   257,   247,   nil,   nil,   nil,   148,   nil,   nil,
   254,   nil,    46,   nil,    46,   171,   nil,    43,   nil,    43,
   171,   213,    66,   190,    66,   118,   170,   259,   215,   183,
   118,   117,   176,   246,   nil,   248,   145,   145,    65,   nil,
    65,   116,   nil,   nil,   137,   nil,   116,   nil,   nil,   106,
   nil,   206,   nil,   nil,   105,    93,   211,   nil,   nil,   118,
   nil,   nil,    64,   171,    64,   175,   nil,   nil,   nil,    60,
   175,    60,   174,   118,   171,   116,   nil,   174,    93,   nil,
    58,   nil,   nil,    93,   118,   145,   nil,   nil,   nil,   116,
   nil,   nil,   237,   237,   nil,   nil,   233,   236,   236,   115,
   116,   nil,   118,   118,   nil,    93,   112,   109,   nil,   nil,
    58,   nil,   nil,   175,   nil,   171,   nil,   nil,   242,   242,
   174,   nil,   nil,   nil,   175,   118,   nil,   nil,   nil,   nil,
   nil,   174,   nil,   nil,   nil,    93,    93,   171,   nil,   nil,
   nil,   116,   241,   241,    48,   145,    70,   118,    70,   240,
   240,   nil,    78,   263,    80,   144,   144,   nil,   nil,   nil,
   nil,   264,    70,   116,   nil,   175,   nil,   nil,    94,    74,
   nil,    74,   174,   nil,    48,   nil,   nil,    70,   nil,   nil,
   nil,   nil,   nil,   121,   nil,    74,   nil,   175,    58,   nil,
    58,   172,   nil,   nil,   174,   nil,   172,   nil,   nil,    70,
    74,   nil,   nil,   nil,   144,   128,   nil,   nil,   nil,   nil,
   nil,    70,   nil,   nil,   nil,   nil,   nil,   131,   nil,   nil,
   nil,   nil,    74,   nil,   nil,   109,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    74,   nil,   nil,   nil,   nil,   172,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   172,   nil,   nil,   166,    48,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   144,   nil,   nil,   nil,   239,   239,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,    70,   nil,   nil,   nil,   nil,   nil,   207,   nil,
   nil,   172,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,    74,   nil,   nil,   nil,    70,
   nil,   nil,   nil,   172,   nil,   220,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,    74,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    70,
   nil,   nil,   nil,   nil,   nil,   250,   nil,    70,    70,   nil,
   nil,   nil,   nil,   255,   256,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,    74,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
    74,    74 ]

racc_goto_check = [
     2,     4,    32,    43,    27,    58,    68,    65,    32,    26,
    56,    27,    50,    46,    25,    56,    17,    29,    33,    54,
     1,    37,    37,    42,    42,    48,    49,    38,    51,    33,
    24,    27,    52,    53,    27,    36,    26,    29,    31,    26,
    57,    25,    30,    59,    25,    60,    17,    61,    62,    32,
    33,    63,    64,    58,    23,    20,     3,    24,    56,    66,
    24,    22,    67,     5,    69,   nil,   nil,   nil,   nil,    56,
    37,   nil,   nil,    54,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,    23,   nil,   nil,    23,   nil,   nil,   nil,    22,     3,
   nil,    22,   nil,     3,   nil,   nil,   nil,   nil,    65,   nil,
   nil,    65,    68,    50,   nil,   nil,   nil,    29,   nil,   nil,
    56,   nil,    27,   nil,    27,    27,   nil,    26,   nil,    26,
    27,    43,    25,    27,    25,    25,    17,    58,    32,     2,
    25,    46,    56,    33,   nil,    33,    22,    22,    24,   nil,
    24,    24,   nil,   nil,     3,   nil,    24,   nil,   nil,    27,
   nil,     2,   nil,   nil,    26,     4,     2,   nil,   nil,    25,
   nil,   nil,    23,    27,    23,    23,   nil,   nil,   nil,    22,
    23,    22,    22,    25,    27,    24,   nil,    22,     4,   nil,
    21,   nil,   nil,     4,    25,    22,   nil,   nil,   nil,    24,
   nil,   nil,    27,    27,   nil,   nil,     2,    26,    26,    23,
    24,   nil,    25,    25,   nil,     4,    22,    21,   nil,   nil,
    21,   nil,   nil,    23,   nil,    27,   nil,   nil,    24,    24,
    22,   nil,   nil,   nil,    23,    25,   nil,   nil,   nil,   nil,
   nil,    22,   nil,   nil,   nil,     4,     4,    27,   nil,   nil,
   nil,    24,    23,    23,    28,    22,    28,    25,    28,    22,
    22,   nil,    47,     2,    47,    21,    21,   nil,   nil,   nil,
   nil,     2,    28,    24,   nil,    23,   nil,   nil,    47,    45,
   nil,    45,    22,   nil,    28,   nil,   nil,    28,   nil,   nil,
   nil,   nil,   nil,    47,   nil,    45,   nil,    23,    21,   nil,
    21,    21,   nil,   nil,    22,   nil,    21,   nil,   nil,    28,
    45,   nil,   nil,   nil,    21,    47,   nil,   nil,   nil,   nil,
   nil,    28,   nil,   nil,   nil,   nil,   nil,    47,   nil,   nil,
   nil,   nil,    45,   nil,   nil,    21,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    45,   nil,   nil,   nil,   nil,    21,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
    21,   nil,   nil,    28,    28,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    21,   nil,   nil,   nil,    21,    21,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,    28,   nil,   nil,   nil,   nil,   nil,    47,   nil,
   nil,    21,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,    45,   nil,   nil,   nil,    28,
   nil,   nil,   nil,    21,   nil,    47,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,    45,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    28,
   nil,   nil,   nil,   nil,   nil,    47,   nil,    28,    28,   nil,
   nil,   nil,   nil,    47,    47,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,    45,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
    45,    45 ]

racc_goto_pointer = [
   nil,    20,     0,    56,   -28,    41,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,     2,   nil,   nil,
   -67,   166,    47,    40,    16,     0,    -5,   -10,   230,    12,
     1,   -69,   -33,   -82,   nil,   nil,     9,   -68,  -171,   nil,
   nil,   nil,  -179,   -38,   nil,   253,   -28,   236,  -129,   -43,
  -114,    12,  -189,   -97,  -111,   nil,  -115,   -85,  -120,  -130,
    24,   -41,    15,    41,    15,    -3,   -76,   -73,  -129,   -31 ]

racc_goto_default = [
   nil,   nil,   nil,   146,     3,     7,     9,    12,    13,    15,
    17,    20,    23,    28,    30,     2,     6,   nil,    51,    54,
    56,    72,    73,    75,    77,    79,    67,    68,     8,    11,
   nil,   nil,   nil,   nil,    22,    26,   nil,   nil,   140,   198,
   141,   142,   nil,   nil,   114,    62,    76,   nil,    98,   nil,
   nil,   nil,   nil,   nil,   nil,   186,    63,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :LBRACK => 2,
 :DQTEXT => 3,
 :SQTEXT => 4,
 :RBRACK => 5,
 :LBRACE => 6,
 :RBRACE => 7,
 :SYMBOL => 8,
 :FARROW => 9,
 :COMMA => 10,
 :TRUE => 11,
 :FALSE => 12,
 :EQUALS => 13,
 :LESSEQUAL => 14,
 :NOTEQUAL => 15,
 :DOT => 16,
 :COLON => 17,
 :TYPE => 18,
 :LLCOLLECT => 19,
 :RRCOLLECT => 20,
 :QMARK => 21,
 :LPAREN => 22,
 :RPAREN => 23,
 :ISEQUAL => 24,
 :GREATEREQUAL => 25,
 :GREATERTHAN => 26,
 :LESSTHAN => 27,
 :IF => 28,
 :ELSE => 29,
 :IMPORT => 30,
 :DEFINE => 31,
 :ELSIF => 32,
 :VARIABLE => 33,
 :CLASS => 34,
 :INHERITS => 35,
 :NODE => 36,
 :BOOLEAN => 37,
 :NAME => 38,
 :SEMIC => 39,
 :CASE => 40,
 :DEFAULT => 41,
 :AT => 42,
 :LCOLLECT => 43,
 :RCOLLECT => 44,
 :CLASSNAME => 45,
 :CLASSREF => 46,
 :NOT => 47,
 :OR => 48,
 :AND => 49,
 :UNDEF => 50 }

racc_use_result_var = true

racc_nt_base = 51

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_token_to_s_table = [
'$end',
'error',
'LBRACK',
'DQTEXT',
'SQTEXT',
'RBRACK',
'LBRACE',
'RBRACE',
'SYMBOL',
'FARROW',
'COMMA',
'TRUE',
'FALSE',
'EQUALS',
'LESSEQUAL',
'NOTEQUAL',
'DOT',
'COLON',
'TYPE',
'LLCOLLECT',
'RRCOLLECT',
'QMARK',
'LPAREN',
'RPAREN',
'ISEQUAL',
'GREATEREQUAL',
'GREATERTHAN',
'LESSTHAN',
'IF',
'ELSE',
'IMPORT',
'DEFINE',
'ELSIF',
'VARIABLE',
'CLASS',
'INHERITS',
'NODE',
'BOOLEAN',
'NAME',
'SEMIC',
'CASE',
'DEFAULT',
'AT',
'LCOLLECT',
'RCOLLECT',
'CLASSNAME',
'CLASSREF',
'NOT',
'OR',
'AND',
'UNDEF',
'$start',
'program',
'statements',
'nil',
'statement',
'resource',
'virtualresource',
'collection',
'assignment',
'casestatement',
'ifstatement',
'import',
'fstatement',
'definition',
'hostclass',
'nodedef',
'resourceoverride',
'funcvalues',
'namestrings',
'resourcerefs',
'namestring',
'name',
'variable',
'type',
'boolean',
'funcrvalue',
'selector',
'quotedtext',
'resourceref',
'classname',
'resourceinstances',
'endsemi',
'params',
'endcomma',
'at',
'collectname',
'collectrhand',
'collstatements',
'collstatement',
'colljoin',
'collexpr',
'colllval',
'simplervalue',
'resourceinst',
'resourcename',
'undef',
'array',
'rvalue',
'param',
'rvalues',
'comma',
'iftest',
'else',
'caseopts',
'caseopt',
'casevalues',
'selectlhand',
'svalues',
'selectval',
'sintvalues',
'qtexts',
'argumentlist',
'classparent',
'hostnames',
'nodeparent',
'hostname',
'nothing',
'arguments',
'argument',
'classnameordefault']

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

module_eval <<'.,.,', 'grammar.ra', 30
  def _reduce_1( val, _values, result )
    if val[0]
        # Make sure we always return an array.
        if val[0].is_a?(AST::ASTArray)
            if val[0].children.empty?
                result = nil
            else
                result = val[0]
            end
        else
            result = aryfy(val[0])
        end
    else
        result = nil
    end
   result
  end
.,.,

 # reduce 2 omitted

 # reduce 3 omitted

module_eval <<'.,.,', 'grammar.ra', 46
  def _reduce_4( val, _values, result )
    if val[0] and val[1]
        if val[0].instance_of?(AST::ASTArray)
            val[0].push(val[1])
            result = val[0]
        else
            result = ast AST::ASTArray, :children => [val[0],val[1]]
        end
    elsif obj = (val[0] || val[1])
        result = obj
    else result = nil
    end
   result
  end
.,.,

 # reduce 5 omitted

 # reduce 6 omitted

 # reduce 7 omitted

 # reduce 8 omitted

 # reduce 9 omitted

 # reduce 10 omitted

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

 # reduce 15 omitted

 # reduce 16 omitted

module_eval <<'.,.,', 'grammar.ra', 68
  def _reduce_17( val, _values, result )
    args = aryfy(val[2])
    result = ast AST::Function,
        :name => val[0],
        :arguments => args,
        :ftype => :statement
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 74
  def _reduce_18( val, _values, result )
    result = ast AST::Function,
        :name => val[0],
        :arguments => AST::ASTArray.new({}),
        :ftype => :statement
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 81
  def _reduce_19( val, _values, result )
    args = aryfy(val[1])
    result = ast AST::Function,
        :name => val[0],
        :arguments => args,
        :ftype => :statement
   result
  end
.,.,

 # reduce 20 omitted

 # reduce 21 omitted

 # reduce 22 omitted

module_eval <<'.,.,', 'grammar.ra', 91
  def _reduce_23( val, _values, result )
    result = aryfy(val[0], val[2])
    result.line = @lexer.line
    result.file = @lexer.file
   result
  end
.,.,

 # reduce 24 omitted

 # reduce 25 omitted

 # reduce 26 omitted

 # reduce 27 omitted

 # reduce 28 omitted

 # reduce 29 omitted

 # reduce 30 omitted

module_eval <<'.,.,', 'grammar.ra', 104
  def _reduce_31( val, _values, result )
                    result = ast AST::Name, :value => val[0]
   result
  end
.,.,

 # reduce 32 omitted

module_eval <<'.,.,', 'grammar.ra', 115
  def _reduce_33( val, _values, result )
    unless val[0].is_a?(AST::ASTArray)
        val[0] = aryfy(val[0])
    end

    val[0].push(val[2])

    result = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 136
  def _reduce_34( val, _values, result )
    array = val[2]
    if array.instance_of?(AST::ResourceInst)
        array = [array]
    end
    result = ast AST::ASTArray

    # this iterates across each specified resourceinstance
    array.each { |instance|
        unless instance.instance_of?(AST::ResourceInst)
            raise Puppet::Dev, "Got something that isn't an instance"
        end
        # now, i need to somehow differentiate between those things with
        # arrays in their names, and normal things
        result.push ast(AST::ResourceDef,
            :type => val[0],
            :title => instance[0],
            :params => instance[1])
    }
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 139
  def _reduce_35( val, _values, result )
    # This is a deprecated syntax.
    error "All resource specifications require names"
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 142
  def _reduce_36( val, _values, result )
    # a defaults setting for a type
    result = ast(AST::ResourceDefaults, :type => val[0], :params => val[2])
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 147
  def _reduce_37( val, _values, result )
    result = ast AST::ResourceOverride, :object => val[0], :params => val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 174
  def _reduce_38( val, _values, result )
    type = val[0]

    if type == :exported and ! Puppet[:storeconfigs]
        error "You cannot collect without storeconfigs being set"
    end

    if val[1].is_a? AST::ResourceDefaults
        error "Defaults are not virtualizable"
    end

    method = type.to_s + "="

    # Just mark our resources as exported and pass them through.
    if val[1].instance_of?(AST::ASTArray)
        val[1].each do |obj|
            obj.send(method, true)
        end
    else
        val[1].send(method, true)
    end

    result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 175
  def _reduce_39( val, _values, result )
 result = :virtual
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 176
  def _reduce_40( val, _values, result )
 result = :exported
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 199
  def _reduce_41( val, _values, result )
    if val[0] =~ /^[a-z]/
        Puppet.warning addcontext("Collection names must now be capitalized")
    end
    type = val[0].downcase
    args = {:type => type}

    if val[1].is_a?(AST::CollExpr)
        args[:query] = val[1]
        args[:query].type = type
        args[:form] = args[:query].form
    else
        args[:form] = val[1]
    end
    if args[:form] == :exported and ! Puppet[:storeconfigs]
        error "You cannot collect exported resources without storeconfigs being set"
    end
    result = ast AST::Collection, args
   result
  end
.,.,

 # reduce 42 omitted

 # reduce 43 omitted

module_eval <<'.,.,', 'grammar.ra', 210
  def _reduce_44( val, _values, result )
    if val[1]
        result = val[1]
        result.form = :virtual
    else
        result = :virtual
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 218
  def _reduce_45( val, _values, result )
    if val[1]
        result = val[1]
        result.form = :exported
    else
        result = :exported
    end
   result
  end
.,.,

 # reduce 46 omitted

 # reduce 47 omitted

module_eval <<'.,.,', 'grammar.ra', 226
  def _reduce_48( val, _values, result )
    result = ast AST::CollExpr, :test1 => val[0], :oper => val[1], :test2 => val[2]
   result
  end
.,.,

 # reduce 49 omitted

module_eval <<'.,.,', 'grammar.ra', 232
  def _reduce_50( val, _values, result )
    result = val[1]
    result.parens = true
   result
  end
.,.,

 # reduce 51 omitted

 # reduce 52 omitted

module_eval <<'.,.,', 'grammar.ra', 240
  def _reduce_53( val, _values, result )
    result = ast AST::CollExpr, :test1 => val[0], :oper => val[1], :test2 => val[2]
    #result = ast AST::CollExpr
    #result.push *val
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 245
  def _reduce_54( val, _values, result )
    result = ast AST::CollExpr, :test1 => val[0], :oper => val[1], :test2 => val[2]
    #result = ast AST::CollExpr
    #result.push *val
   result
  end
.,.,

 # reduce 55 omitted

 # reduce 56 omitted

module_eval <<'.,.,', 'grammar.ra', 252
  def _reduce_57( val, _values, result )
    result = ast AST::ResourceInst, :children => [val[0],val[2]]
   result
  end
.,.,

 # reduce 58 omitted

module_eval <<'.,.,', 'grammar.ra', 262
  def _reduce_59( val, _values, result )
    if val[0].instance_of?(AST::ResourceInst)
        result = ast AST::ASTArray, :children => [val[0],val[2]]
    else
        val[0].push val[2]
        result = val[0]
    end
   result
  end
.,.,

 # reduce 60 omitted

 # reduce 61 omitted

module_eval <<'.,.,', 'grammar.ra', 269
  def _reduce_62( val, _values, result )
    result = ast AST::Undef, :value => :undef
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 273
  def _reduce_63( val, _values, result )
    result = ast AST::Name, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 277
  def _reduce_64( val, _values, result )
    result = ast AST::Type, :value => val[0]
   result
  end
.,.,

 # reduce 65 omitted

 # reduce 66 omitted

 # reduce 67 omitted

 # reduce 68 omitted

 # reduce 69 omitted

 # reduce 70 omitted

module_eval <<'.,.,', 'grammar.ra', 293
  def _reduce_71( val, _values, result )
    if val[0] =~ /::/
        raise Puppet::ParseError, "Cannot assign to variables in other namespaces"
    end
    # this is distinct from referencing a variable
    variable = ast AST::Name, :value => val[0]
    result = ast AST::VarDef, :name => variable, :value => val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 298
  def _reduce_72( val, _values, result )
    result = ast AST::ASTArray
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 298
  def _reduce_73( val, _values, result )
 result = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 307
  def _reduce_74( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[2])
        result = val[0]
    else
        result = ast AST::ASTArray, :children => [val[0],val[2]]
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 311
  def _reduce_75( val, _values, result )
    result = ast AST::ResourceParam, :param => val[0], :value => val[2]
   result
  end
.,.,

 # reduce 76 omitted

module_eval <<'.,.,', 'grammar.ra', 320
  def _reduce_77( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        result = val[0].push(val[2])
    else
        result = ast AST::ASTArray, :children => [val[0],val[2]]
    end
   result
  end
.,.,

 # reduce 78 omitted

 # reduce 79 omitted

 # reduce 80 omitted

 # reduce 81 omitted

 # reduce 82 omitted

 # reduce 83 omitted

 # reduce 84 omitted

 # reduce 85 omitted

 # reduce 86 omitted

 # reduce 87 omitted

 # reduce 88 omitted

 # reduce 89 omitted

 # reduce 90 omitted

 # reduce 91 omitted

 # reduce 92 omitted

 # reduce 93 omitted

module_eval <<'.,.,', 'grammar.ra', 347
  def _reduce_94( val, _values, result )
    args = aryfy(val[2])
    result = ast AST::Function,
        :name => val[0],
        :arguments => args,
        :ftype => :rvalue
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 352
  def _reduce_95( val, _values, result )
    result = ast AST::Function,
        :name => val[0],
        :arguments => AST::ASTArray.new({}),
        :ftype => :rvalue
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 356
  def _reduce_96( val, _values, result )
    result = ast AST::String, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 358
  def _reduce_97( val, _values, result )
    result = ast AST::FlatString, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 362
  def _reduce_98( val, _values, result )
    result = ast AST::Boolean, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 367
  def _reduce_99( val, _values, result )
    Puppet.warning addcontext("Deprecation notice:  Resource references should now be capitalized")
    result = ast AST::ResourceRef, :type => val[0], :title => val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 369
  def _reduce_100( val, _values, result )
    result = ast AST::ResourceRef, :type => val[0], :title => val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 382
  def _reduce_101( val, _values, result )
    args = {
        :test => val[1],
        :statements => val[3]
    }

    if val[5]
        args[:else] = val[5]
    end

    result = ast AST::IfStatement, args
   result
  end
.,.,

 # reduce 102 omitted

module_eval <<'.,.,', 'grammar.ra', 387
  def _reduce_103( val, _values, result )
    result = ast AST::Else, :statements => val[2]
   result
  end
.,.,

 # reduce 104 omitted

module_eval <<'.,.,', 'grammar.ra', 399
  def _reduce_105( val, _values, result )
    options = val[3]
    unless options.instance_of?(AST::ASTArray)
        options = ast AST::ASTArray, :children => [val[3]]
    end
    result = ast AST::CaseStatement, :test => val[1], :options => options
   result
  end
.,.,

 # reduce 106 omitted

module_eval <<'.,.,', 'grammar.ra', 409
  def _reduce_107( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push val[1]
        result = val[0]
    else
        result = ast AST::ASTArray, :children => [val[0], val[1]]
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 413
  def _reduce_108( val, _values, result )
    result = ast AST::CaseOpt, :value => val[0], :statements => val[3]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 418
  def _reduce_109( val, _values, result )
    result = ast(AST::CaseOpt,
        :value => val[0],
        :statements => ast(AST::ASTArray)
    )
   result
  end
.,.,

 # reduce 110 omitted

module_eval <<'.,.,', 'grammar.ra', 428
  def _reduce_111( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[2])
        result = val[0]
    else
        result = ast AST::ASTArray, :children => [val[0],val[2]]
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 432
  def _reduce_112( val, _values, result )
    result = ast AST::Selector, :param => val[0], :values => val[2]
   result
  end
.,.,

 # reduce 113 omitted

module_eval <<'.,.,', 'grammar.ra', 434
  def _reduce_114( val, _values, result )
 result = val[1]
   result
  end
.,.,

 # reduce 115 omitted

module_eval <<'.,.,', 'grammar.ra', 445
  def _reduce_116( val, _values, result )
    if val[0].instance_of?(AST::ASTArray)
        val[0].push(val[2])
        result = val[0]
    else
        result = ast AST::ASTArray, :children => [val[0],val[2]]
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 449
  def _reduce_117( val, _values, result )
    result = ast AST::ResourceParam, :param => val[0], :value => val[2]
   result
  end
.,.,

 # reduce 118 omitted

 # reduce 119 omitted

 # reduce 120 omitted

 # reduce 121 omitted

 # reduce 122 omitted

 # reduce 123 omitted

 # reduce 124 omitted

module_eval <<'.,.,', 'grammar.ra', 460
  def _reduce_125( val, _values, result )
    result = ast AST::Default, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 462
  def _reduce_126( val, _values, result )
 result = [val[0].value]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 466
  def _reduce_127( val, _values, result )
    results = val[0] << val[2].value
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 474
  def _reduce_128( val, _values, result )
    val[1].each do |file|
        import(file)
    end

    result = AST::ASTArray.new(:children => [])
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 484
  def _reduce_129( val, _values, result )
    interp.newdefine classname(val[1]), :arguments => val[2], :code => val[4]
    @lexer.indefine = false
    result = nil

#}           | DEFINE NAME argumentlist parent LBRACE RBRACE {
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 488
  def _reduce_130( val, _values, result )
    interp.newdefine classname(val[1]), :arguments => val[2]
    @lexer.indefine = false
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 496
  def _reduce_131( val, _values, result )
    # Our class gets defined in the parent namespace, not our own.
    @lexer.namepop
    interp.newclass classname(val[1]), :code => val[4], :parent => val[2]
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 501
  def _reduce_132( val, _values, result )
    # Our class gets defined in the parent namespace, not our own.
    @lexer.namepop
    interp.newclass classname(val[1]), :parent => val[2]
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 506
  def _reduce_133( val, _values, result )
    interp.newnode val[1], :parent => val[2], :code => val[4]
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 509
  def _reduce_134( val, _values, result )
    interp.newnode val[1], :parent => val[2]
    result = nil
   result
  end
.,.,

 # reduce 135 omitted

 # reduce 136 omitted

 # reduce 137 omitted

module_eval <<'.,.,', 'grammar.ra', 521
  def _reduce_138( val, _values, result )
    result = val[0]
    result = [result] unless result.is_a?(Array)
    result << val[2]
   result
  end
.,.,

 # reduce 139 omitted

 # reduce 140 omitted

 # reduce 141 omitted

module_eval <<'.,.,', 'grammar.ra', 529
  def _reduce_142( val, _values, result )
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 533
  def _reduce_143( val, _values, result )
    result = ast AST::ASTArray, :children => []
   result
  end
.,.,

 # reduce 144 omitted

module_eval <<'.,.,', 'grammar.ra', 538
  def _reduce_145( val, _values, result )
    result = nil
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 542
  def _reduce_146( val, _values, result )
    result = val[1]
    result = [result] unless result[0].is_a?(Array)
   result
  end
.,.,

 # reduce 147 omitted

module_eval <<'.,.,', 'grammar.ra', 549
  def _reduce_148( val, _values, result )
    result = val[0]
    result = [result] unless result[0].is_a?(Array)
    result << val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 554
  def _reduce_149( val, _values, result )
    Puppet.warning addcontext("Deprecation notice: must now include '$' in prototype")
    result = [val[0], val[2]]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 558
  def _reduce_150( val, _values, result )
    Puppet.warning addcontext("Deprecation notice: must now include '$' in prototype")
    result = [val[0]]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 560
  def _reduce_151( val, _values, result )
    result = [val[0], val[2]]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 562
  def _reduce_152( val, _values, result )
    result = [val[0]]
   result
  end
.,.,

 # reduce 153 omitted

module_eval <<'.,.,', 'grammar.ra', 567
  def _reduce_154( val, _values, result )
    result = val[1]
   result
  end
.,.,

 # reduce 155 omitted

module_eval <<'.,.,', 'grammar.ra', 572
  def _reduce_156( val, _values, result )
    result = val[1]
   result
  end
.,.,

 # reduce 157 omitted

 # reduce 158 omitted

module_eval <<'.,.,', 'grammar.ra', 578
  def _reduce_159( val, _values, result )
    result = ast AST::Variable, :value => val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 586
  def _reduce_160( val, _values, result )
    if val[1].instance_of?(AST::ASTArray)
        result = val[1]
    else
        result = ast AST::ASTArray, :children => [val[1]]
    end
   result
  end
.,.,

module_eval <<'.,.,', 'grammar.ra', 588
  def _reduce_161( val, _values, result )
    result = ast AST::ASTArray
   result
  end
.,.,

 # reduce 162 omitted

 # reduce 163 omitted

 # reduce 164 omitted

module_eval <<'.,.,', 'grammar.ra', 593
  def _reduce_165( val, _values, result )
 result = nil
   result
  end
.,.,

 def _reduce_none( val, _values, result )
  result
 end

    end   # class Parser

  end   # module Parser

end   # module Puppet
