/****************************************************************************
** Execute class
**
** Created: Tue Jan 26 12:09:08 2003
**      by: Varol Okan using kate editor
**
** This class provide a GUI to the man pages.
**
****************************************************************************/

#ifndef MENUSLIDE_H
#define MENUSLIDE_H

#include <qimage.h>
#include <qpixmap.h>
#include <qvaluelist.h>

#include "../interface.h"

#include "uimenuslide.h"

namespace Plugin
{

class MenuSlide : public uiDialogMenuSlide
{
  Q_OBJECT

  class ImageContainer {
  public:
    ImageContainer ( QString & );
    QString qsFileName;
    QString qsBaseName;
    QImage  thumbnail;
  };

public:
           MenuSlide  ( QWidget *p=NULL, const char *n=NULL, bool m=FALSE, WFlags f=0 );
  virtual ~MenuSlide  ( );
  
  virtual void  initMe  ( QObject * );
  
  virtual void accept   ( );

protected:
  virtual void doEmit ( Interface::enResponseType, QString &, QString & ) {}; // pass to the parent class ...
  QString getMenuXml       ( );
  QString buildAnimation   ( int );
  QString buildImageObject ( ImageContainer *, int );
  
  float getImageDuration   ( );

protected slots:
  virtual void polish           ( );
  virtual void slotUp           ( );
  virtual void slotDown         ( );
  virtual void slotDelete       ( );
  virtual void slotHelp         ( );
  virtual void slotAddImages    ( );
  virtual void slotPreview      ( );
  virtual void slotBackground   ( );
  virtual void slotToggledID    ( bool );
  virtual void slotToggledTD    ( bool );
  virtual void slotImageChanged ( QListBoxItem * );

protected:
  void timerEvent ( QTimerEvent * );

private:  // private member functions.
  void loadBackgroundImage ( );
  void createAnimationData ( bool );
  void animate             ( );
  void animate             ( unsigned long );

private:
  int m_iMaxWidth;
  int m_iMaxHeight;
  int m_iConcurrentImages;
  QString testMenu ( );
  QValueList<ImageContainer *> m_listImages;

  int m_iAnimationTimerID;
  unsigned long m_iCurrentFrame;
  unsigned long m_iTotalFrames;
  float m_fTotalDuration;
  float m_fImageDuration;
  QPixmap m_backgroundPixmap;
};

class MenuSlideInterface : public Interface, public MenuSlide
{
public:
  MenuSlideInterface    ( );
  virtual ~MenuSlideInterface   ( ) { };
  virtual void  initMe  ( QObject *pObject ) { MenuSlide::initMe ( pObject ); };
  virtual float version ( ) { return 0.1f; };
  virtual void  doEmit  ( enResponseType, QString &, QString & );
};

}; // end of namespace Plugins
#endif // DIALOGMAN_H
