dnl AM_PATH_RAST([MAJOR], [MINOR], [TEENY])
dnl Adds support for Rast
AC_DEFUN([AM_PATH_RAST],
[
  rast_major="$1"
  rast_minor="$2"
  rast_patch="$3"
  rast_version="$1.$2.$3"

  AC_ARG_WITH(rast-config,
  AC_HELP_STRING([--with-rast-config=PATH],[path to rast-config]),
  [
      AC_MSG_RESULT([using $withval for rast-config])
      RAST_CONFIG="$withval"
  ], [
      AC_PATH_PROG(RAST_CONFIG, rast-config, no)
  ])
  if test "$RAST_CONFIG" = "no"; then
      AC_MSG_ERROR([rast-config is required])
  fi

  AC_MSG_CHECKING([RAST version])    
  RAST_VERSION="`$RAST_CONFIG --version`"
  if test $? -ne 0; then
    AC_MSG_ERROR([rast-config --version failed])
  fi
  changequote(<<, >>)
  RAST_MAJOR=`expr "$RAST_VERSION" : '\(.*\)\..*\..*'`
  RAST_MINOR=`expr "$RAST_VERSION" : '.*\.\(.*\)\..*'`
  RAST_PATCH=`expr "$RAST_VERSION" : '.*\..*\.\(.*\)'`
  changequote([, ])
  if expr "$RAST_MAJOR" '<' "$rast_major" > /dev/null; then
    AC_MSG_ERROR([$rast_version is required])
  fi
  if expr "$RAST_MAJOR" '=' "$rast_major" > /dev/null; then
    if expr "$RAST_MINOR" '<' "$rast_minor" > /dev/null; then
      AC_MSG_ERROR([$rast_version is required])
    fi
    if expr "$RAST_MINOR" '=' "$rast_minor" > /dev/null; then
      if expr "$RAST_PATCH" '<' "$rast_patch" > /dev/null; then
        AC_MSG_ERROR([$rast_version is required])
      fi
    fi
  fi
  AC_MSG_RESULT([$RAST_VERSION])

  RAST_CPPFLAGS="$CPPFLAGS `$RAST_CONFIG --cppflags`"
  RAST_CFLAGS="$CFLAGS `$RAST_CONFIG --cflags`"
  RAST_LDFLAGS="$LDFLAGS `$RAST_CONFIG --ldflags`"

  RAST_INCLUDES="`$RAST_CONFIG --includes`"
  RAST_LIBS_LD="`$RAST_CONFIG --libs-ld`"
  RAST_LIBS_LIBTOOL="`$RAST_CONFIG --libs-libtool`"

  AC_SUBST(RAST_INCLUDES)
  AC_SUBST(RAST_LIBS_LD)
  AC_SUBST(RAST_LIBS_LIBTOOL)
])
