# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require File.join(File.dirname(__FILE__), "read-buckets-to-file")

class ApplicationPostScript
  SUPPORTED_VERSION = 1
  MIME_TYPE = "application/postscript"
  ENCODINGS = []

  include ReadBucketsToFile

  private

  def process_file(filter, mime_type, path)
    db_encoding = filter.db_encoding

    buffer = ""
    File.open(path) do |f|
      f.gets  # skip %!PS-Adobe-

      while (line = f.gets)
        if /^%%/.match(line)
          buffer.concat(line)
        else
          break
        end
      end
    end

    buffer.each_line do |line|
      if (match_data = /^%%([^:]*): (.*)$/i.match(line))
        property_encoding =
          Rast::EncodingConverter.guess(match_data[1],
                                        Rast::JAPANESE_ENCODINGS)
        property_value =
          Rast::EncodingConverter.convert_encoding(property_encoding,
                                                   db_encoding,
                                                   match_data[2])
        filter.set_property(match_data[1].downcase, property_value)
        if match_data[1] == "For"
          filter.set_property("author", property_value)
        end
      end
    end

    page = ""
    IO.popen("ps2text #{path}") do |io|
      while line = io.gets
        if /\f/.match(line)
          next_brigade = Rast::Brigade.new
          next_brigade.insert_tail(Rast::TransientBucket.new(page))
          filter.pass(next_brigade, "text/plain")
          page = ""
        else
          page.concat(line)
        end
      end
    end

    next_brigade = Rast::Brigade.new
    if !page.empty?
      next_brigade.insert_tail(Rast::TransientBucket.new(page))
    end
    next_brigade.insert_tail(Rast::EOSBucket.new)
    filter.pass(next_brigade, "text/plain")
  end
end
