# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"

require "rast_test"
require "rast/filter"

module Rast
  module Filter
    load_mime_filter("excel.rb")
    load_mime_filter("html.rb")

    class ApplicationExcelTest < Test::Unit::TestCase
      def test_invoke
        invoke_test_simple
        invoke_test_error
      end

      def invoke_test_simple
        excel_filter = SpoofFilter.new("UTF-8")
        brigade = Brigade.new

        path = File.join(MakeVariable::TOP_SRCDIR, "tests", "data",
                         "filter", "ja", "excel.xls")
        file = File.open(path)
        bucket = FileBucket.new(file)
        brigade.insert_tail(bucket)
        brigade.insert_tail(EOSBucket.new)
        filter_module = ApplicationExcel.new
        filter_module.invoke(excel_filter, brigade, "application/vnd.ms-excel")

        assert_equal("text/html", excel_filter.passed[0].mime_type)
        assert_equal(1, excel_filter.passed.length)
        assert_equal("著者", excel_filter.properties["author"])
        assert_equal("タイトル", excel_filter.properties["title"])
        assert_equal(2, excel_filter.properties.length)

        html_filter = SpoofFilter.new("UTF-8")
        filter_module = TextHtml.new
        filter_module.invoke(html_filter, excel_filter.passed[0].brigade,
                             excel_filter.passed[0].mime_type)

        buf = ""
        html_filter.passed[0].brigade.each do |bucket|
          buf.concat(bucket.read)
        end

        assert_match(/^\s*Microsoft Excel テスト\s*$/m, buf)
        assert_match(/^\s*これはMS Excelファイルです\s*$/m, buf)
        assert_match(/^\s*A-1項目\s*$/m, buf)
        assert_match(/^\s*B-1項目\s*$/m, buf)
        assert_match(/^\s*A-2項目\s*$/m, buf)
        assert_match(/^\s*B-1項目\s*$/m, buf)
        assert_equal("text/plain", html_filter.passed[0].mime_type)
        assert_equal(1, html_filter.passed.length)
      end

      def invoke_test_error
        filter = SpoofFilter.new("UTF-8")
        brigade = Brigade.new
        brigade.insert_tail(TransientBucket.new("invalid type file"))
        brigade.insert_tail(EOSBucket.new)
        filter_module = ApplicationExcel.new
        assert_raise(RastError) do
          filter_module.invoke(filter, brigade,
                               "application/vnd.ms-excel")
        end
      end
    end
  end
end
