#
# Copyright 2007 Fedora Unity
#
# Jonathan Steffan <jon a fedoraunity.org>
# Jeroen van Meeuwen <kanarip a fedoraunity.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 only
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


##
##
## NOTICE: This file is currently not used.
##
##

import os
import sys
import gtk
import gtk.glade
import gobject
import gtk.gdk as gdk

from ConfigParser import SafeConfigParser

# Import constants
from revisor.constants import *

# Translation
from rhpl.translate import _, N_, getDefaultLangs
import rhpl.translate as translate

class RepositoryConfiguration:
    def __init__(self, gui):
        self.gui = gui
        self.base = gui.base
        self.log = gui.log
        self.cfg = gui.cfg
        self.frame_xml = gui.frame_xml

        self.select_model = self.gui.frame_xml.get_widget("revisor_config_select_model")

        gui.add_buttons()

        self.connect_button_signals()

        self.restore_options()

        self.header_image = gui.base_screen_xml.get_widget("header_image")
        self.header_image.set_from_file(PIXMAPS_FILES + "header_yum.png")

    # widgets:
    # repo_treeview - repository selection box (treeview)
    # revisor_config_select_model - model selection
    def connect_button_signals(self):
        sigs = { "on_button_back_clicked": self.button_back_clicked,
                 "on_button_forward_clicked": self.button_forward_clicked,
                 "on_button_cancel_clicked": self.gui.button_cancel_clicked }

        self.gui.base_buttons_xml.signal_autoconnect(sigs)

        sigs = { "on_button_revisor_config_apply_model_clicked": self.revisor_config_apply_model_clicked,
                 "on_button_revisor_config_refresh_clicked": self.revisor_config_refresh_clicked }

        self.gui.frame_xml.signal_autoconnect(sigs)

    def revisor_config_refresh_clicked(self, button):
        widget_rc = self.gui.frame_xml.get_widget("revisor_config")
        widget_cbox_parent = self.gui.frame_xml.get_widget("revisor_config_table")

        models = self.revisor_config_sections(widget_rc.get_text())

        if models:
            self.select_model.hide()
            self.select_model.destroy()
            self.select_model = gtk.combo_box_new_text()

            i=0
            for model in models:
                self.select_model.append_text(model)
                if model == self.cfg.revisor_model:
                    self.select_model.set_active(i)
                i += 1

            if not self.select_model.get_active() >= 0:
                self.select_model.set_active(0)

            widget_cbox_parent.attach(self.select_model,1,2,1,2,yoptions=gtk.EXPAND)
            self.select_model.show()
            self.cfg.set_revisor_config(widget_rc.get_text())

            self.cfg.override_defaults()

            model_selected = self.select_model.get_active_text()

            self.repo_treeview = self.gui.frame_xml.get_widget("repo_treeview")
            if not model_selected == "" and not model_selected == None:
                if self.revisor_config_has_option(self.cfg.revisor_config,model_selected,"main") and self.revisor_config_has_option(self.cfg.revisor_config,model_selected,"pungi"):
                    self.cfg.set_revisor_model(model_selected)
                    self.cfg.set_main_conf(self.revisor_parser.get(model_selected,"main"))
                    self.cfg.set_pungi_conf(self.revisor_parser.get(model_selected,"pungi"))
                    try:
                        self.repo_treeview.remove_column(self.repo_column_select)
                        self.repo_treeview.remove_column(self.repo_column_name)
                        self.repo_treeview.remove_column(self.repo_column_desc)
                    except:
#                        print >> sys.stdout, "No columns yet ;-)"
                        pass

                    self.load_repositories(self.cfg)
        else:
            self.log.error(widget_rc.get_text() + " is not a valid Revisor configuration file")

    def revisor_config_apply_model_clicked(self, button):
        model_selected = self.select_model.get_active_text()

        self.repo_treeview = self.gui.frame_xml.get_widget("repo_treeview")
        if not model_selected == "" and not model_selected == None:
            if self.revisor_config_has_option(self.cfg.revisor_config,model_selected,"main") and self.revisor_config_has_option(self.cfg.revisor_config,model_selected,"pungi"):
                self.cfg.set_revisor_model(model_selected)
                self.cfg.set_main_conf(self.revisor_parser.get(model_selected,"main"))
                self.cfg.set_pungi_conf(self.revisor_parser.get(model_selected,"pungi"))
                try:
                    self.repo_treeview.remove_column(self.repo_column_select)
                    self.repo_treeview.remove_column(self.repo_column_name)
                    self.repo_treeview.remove_column(self.repo_column_desc)
                except:
                    pass
#                    print >> sys.stdout, "No columns yet ;-)"

                self.load_repositories(self.cfg)
            else:
                self.log.error("The configured model does not have the mandatory 'mainconf' and 'pungiconf' configured.")
        else:
            self.log.error("Invalid model. Please choose a valid model.")

    def button_back_clicked(self, button):
        self.store_options()
        self.gui.outer_frame.hide()
        self.gui.outer_frame.destroy()
        self.gui.displaySelectMedia()

    def button_forward_clicked(self, button):
        if not self.check_options():
            pass
        else:
            self.store_options()
            self.gui.outer_frame.hide()
            self.gui.outer_frame.destroy()
            self.gui.displayLoadKickstart()

    def load_repositories(self):
        repo_parser = SafeConfigParser()
        self.repo_parser = repo_parser
        # FIXME (try except os.access)
        repo_parser.read(self.cfg.main_conf)
        # widget - repo_treeview
        self.repoStore = gtk.ListStore(gobject.TYPE_BOOLEAN,
                                      gobject.TYPE_STRING,
                                      gobject.TYPE_STRING)

        self.repo_column_select = gtk.TreeViewColumn(None, None)
        cbr = gtk.CellRendererToggle()
        self.repo_column_select.pack_start(cbr, False)
        self.repo_column_select.add_attribute(cbr, 'active', 0)
        cbr.connect("toggled", self._repoToggled)
        self.repo_treeview.append_column(self.repo_column_select)

        self.repo_column_name = gtk.TreeViewColumn(None, None)
        txtr = gtk.CellRendererText()
        self.repo_column_name.pack_start(txtr, False)
        self.repo_column_name.add_attribute(txtr, 'markup', 1)
        self.repo_treeview.append_column(self.repo_column_name)

        self.repo_column_desc = gtk.TreeViewColumn(None, None)
        txtr = gtk.CellRendererText()
        self.repo_column_desc.pack_start(txtr, False)
        self.repo_column_desc.add_attribute(txtr, 'markup', 2)
        self.repo_treeview.append_column(self.repo_column_desc)

        self.repoStore.set_sort_column_id(1, gtk.SORT_ASCENDING)

        self.cfg.override_defaults()

        for repo in repo_parser._sections:
            if not repo == "main":
                # Remove all disabled repos
                if not self.cfg.repos_enablesource and repo.find("source") >= 0:
#                    print >> sys.stdout, "Found source in repo " + repo + " but source repos are disabled"
                    continue
#                else:
#                    print >> sys.stdout, "Source repos are disabled but luckily " + repo + " doesn't have source"
                if not self.cfg.repos_enabledebuginfo and repo.find("debuginfo") >= 0:
#                    print >> sys.stdout, "Found debuginfo in repo " + repo + " but debuginfo repos are disabled"
                    continue
#                else:
#                    print >> sys.stdout, "Debuginfo repos are disabled but luckily " + repo + " doesn't have debuginfo"
                if not self.cfg.repos_enabletesting and repo.find("testing") >= 0:
#                    print >> sys.stdout, "Found testing in repo " + repo + " but testing repos are disabled"
                    continue
#                else:
#                    print >> sys.stdout, "Testing repos are disabled but luckily " + repo + " doesn't have testing"
                if not self.cfg.repos_enabledevelopment and repo.find("development") >= 0:
#                    print >> sys.stdout, "Found development in repo " + repo + " but development repos are disabled"
                    continue
#                else:
#                    print >> sys.stdout, "Development repos are disabled but luckily " + repo + " doesn't have development"

                if self.repo_parser.get(repo,"enabled") == "1":
                    repo_enabled = True
                else:
                    repo_enabled = False
                if repo in self.cfg.repos and self.cfg.repos[repo]:
                    repo_enabled = True
                elif repo in self.cfg.repos and not self.cfg.repos[repo]:
                    repo_enabled = False

                self.repoStore.append([repo_enabled,repo,"<i>" + self.repo_parser.get(repo,"name") + "</i>"])
                self.cfg.set_repo_enabled(repo,repo_enabled)

        self.repo_treeview.set_model(self.repoStore)

    def _repoToggled(self, widget, path):
        i = self.repoStore.get_iter(path)
        repo_toggled = self.repoStore.get_value(i, 1)
        if self.repoStore.get_value(i, 0):
            self.repoStore.set_value(i, 0, False)
            self.cfg.set_repo_enabled(repo_toggled, False)
            status = "disabled"
        else:
            self.repoStore.set_value(i, 0, True)
            self.cfg.set_repo_enabled(repo_toggled, True)
            status = "enabled"

#        print >> sys.stdout, repo_toggled + " is now " + status

    def check_options(self):
        widget_rc = self.gui.frame_xml.get_widget("revisor_config")
        config = widget_rc.get_text()

        try:
            fp = open(config)
            fp.close()
        except:
            self.log.error("File " + config + " is not accessible.")
            return False

        if self.revisor_config_has_option(config,self.select_model.get_active_text(),"main") and self.revisor_config_has_option(config,self.select_model.get_active_text(),"pungi"):
            try:
                fp_main = open(self.revisor_parser.get(self.select_model.get_active_text(),"main"))
                fp_main.close()
            except:
                self.log.error("The 'main' option configuration directive has a non-accessible file: " + self.revisor_parser.get(self.select_model.get_active_text(),"main"))
                return False
            try:
                fp_pungi = open(self.revisor_parser.get(self.select_model.get_active_text(),"pungi"))
                fp_pungi.close()
            except:
                self.log.error("The 'pungi' option configuration directive has a non-accessible file: " + self.revisor_parser.get(self.select_model.get_active_text(),"pungi"))
                return False
            self.cfg.set_revisor_config(config)

            one_repo_set = False
            for repo in self.cfg.repos:
                if self.cfg.repos[repo]:
                    one_repo_set = True

            base_repo_set = False
            if "core" in self.cfg.repos and self.cfg.repos["core"]:
                base_repo_set = True
            elif "base" in self.cfg.repos and self.cfg.repos["base"]:
                base_repo_set = True
            elif "development" in self.cfg.repos and self.cfg.repos["development"]:
                base_repo_set = True

            if not one_repo_set or not base_repo_set:
                self.log.error("You have not selected any mandatory repository. Please select one of 'core', 'base' or 'development'")
                return False

            return True
        else:
            self.log.error("Configuration file '" + config + "', section '" + self.select_model.get_active_text() + "' does not have the mandatory 'main' and 'pungi' options")
            return False

    def restore_options(self):
        widget_rc = self.gui.frame_xml.get_widget("revisor_config")

        widget_rc.set_text(self.cfg.revisor_config)

        self.load_models()

        self.load_selected_model()

    def load_selected_model(self):
        widget_cbox_parent = self.gui.frame_xml.get_widget("revisor_config_table")
        self.repo_treeview = self.gui.frame_xml.get_widget("repo_treeview")

        if not self.cfg.revisor_model == "" and not self.cfg.revisor_model == None:
            if self.revisor_config_has_option(self.cfg.revisor_config,self.cfg.revisor_model,"main") and self.revisor_config_has_option(self.cfg.revisor_config,self.cfg.revisor_model,"pungi"):
                self.cfg.set_main_conf(self.revisor_parser.get(self.cfg.revisor_model,"main"))
                self.cfg.set_pungi_conf(self.revisor_parser.get(self.cfg.revisor_model,"pungi"))
                try:
                    self.repo_treeview.remove_column(self.repo_column_select)
                    self.repo_treeview.remove_column(self.repo_column_name)
                    self.repo_treeview.remove_column(self.repo_column_desc)
                except:
                    pass
#                    print >> sys.stdout, "No columns yet ;-)"

                self.load_repositories(self.cfg)

        widget_cbox_parent.attach(self.select_model,1,2,1,2,yoptions=gtk.EXPAND)
        self.select_model.show()

    def load_models(self):
        widget_cbox_parent = self.gui.frame_xml.get_widget("revisor_config_table")
        self.select_model.hide()
        self.select_model.destroy()

        models = self.revisor_config_sections(self.cfg.revisor_config)
        self.select_model = gtk.combo_box_new_text()

        i=0
        for model in models:
            self.select_model.append_text(model)
            if model == self.cfg.revisor_model:
                self.select_model.set_active(i)
            i += 1

        if not self.select_model.get_active() >= 0:
            self.select_model.set_active(0)

        self.cfg.set_revisor_model(self.select_model.get_active_text())

    def store_options(self):
        widget_rc = self.gui.frame_xml.get_widget("revisor_config")

        self.cfg.set_revisor_config(widget_rc.get_text())
        self.cfg.set_revisor_model(self.select_model.get_active_text())
#FIXME
# Do the repoStore

    def revisor_config_sections(self, config):
        parser = SafeConfigParser()
        # FIXME (try except os.access)
        try:
            parser.read(config)
            parser_sections = parser._sections.keys()
            parser_sections.sort()
#            print >> sys.stdout, parser_sections
            return parser_sections

        except:
            return False

    def revisor_config_has_option(self, config, section, option):
        self.revisor_parser = SafeConfigParser()
        # FIXME (try except os.access)
        self.revisor_parser.read(config)
        if self.revisor_parser.has_option(section,option):
            return True
        else:
            return False

