/* # skkinput (Simple Kana-Kanji Input)
 * OffWinP.h --- Off The Spot Window Style
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef OffWinP_h
#define OffWinP_h

#include "commondef.h"
#include "buffers.h"
#include "skkbuf.h"
#include "skkkey.h"
#include "OffWin.h"
#include "HistMgr.h"
#include "FontMgr.h"
#include "attrs.h"
#include <X11/CoreP.h>

typedef struct {
	Pixel		puppixel ;	/* foreground pixel */
	/* fontset ̾ʸ󡣤Ĥ convert  fontset á
	 * ळȤˤʤ롣 */
	String	fontset_string ;
	String	minibuf_fontset_string ;
	/* ѤƤեȡΤʤ */
	struct skkinputManagedFont	*fontset[ NUMBER_OF_CHARSET ] ;
	struct skkinputManagedFont	*minibuf_fontset[ NUMBER_OF_CHARSET ] ;
	/* ̤褹ΤѤ GC */
	GC		gc, rgc ;
	GC		minibuf_gc, minibuf_rgc ;
	/* եȤξȴФƤΤϤɤΤǡ*/
	int		font_height, font_ascent ;
	int		mfont_height, mfont_ascent ;
	/* 礭ʸȤϡʸ礭ˤ碌
	 * 뤬줬̵äˤɤ٤ˤΤꡣ */
	int		cursor_width ;
	/* minibuffer β*/
	Dimension	minibuf_width ;
	/* ȿžɽ뤫ݤ */
	Boolean	reverse_video ;
	/* kterm ʤɤΥեȤΥѹˤߥ˥ХåեΥեȥ *
	 * ⽤뤫ݤ*/
	Boolean	change_minibuffer_font ;
	Boolean	overthespotLikeInput ;
	Colormap	colormap ;
	Pixel		foreground, background ;
	Pixel		oforeground, obackground ;
	Boolean	clearMinibuffer ;
	Boolean	south_cursor ;
	
	Window	client_window ;
	/* եäƤ륦ɥ*/
	Window	focus_window ;
	/* ˥ޥ뤬ȥեƤȽǤ뺬 *
	 * Ȥʤ륦ɥ*/
	Window	input_focus_window ;
	Window	probe_window ;
	/* ƥȤɽϤ٤(եɥǤ *
	 * а֤Ǥ롣*/
	Position	spot_x, spot_y ;
	/* Ѵ饤Ȥɽΰ衣*/
	XRectangle	client_area ;
	/* Ѵ饤ȤΥơꥢΰ衣*/
	XRectangle	status_area ;
	/* Ѵ饤ȤΥ롼ȥɥǤа֡ĤȤȤˤ *
	 * Ƥ*/
	Position	focus_offset_x, focus_offset_y ;
	Position	client_x, client_y ;
	unsigned long attribute_mask ;
	int		conversion_set_focus, conversion_unset_focus ;

	/* ʸ(Хåե)ɽΤ˻Ȥ Window*/
	Window	canvas_win ;
	int		canvas_probe ;
	
	/* ߤδϥ⡼ɤɽ륦ɥ*/
	Window	modeshell_win ;
	int		modeshell_probe ;
	int		modeshell_width, modeshell_height ;
	int		modeshell_border_width ;
	unsigned long	prevModeStatus ;
	
	Widget	minibuffer_popup, minibuffer_canvas ;
	int		minibuffer_probe ;
	Boolean	m_fInputFocus ;
	
	/* ɽ֡νɬפݤ*/
	int		iposflag ;
	/* եäƤ뤫ɤ*/
	int		is_focus ;

	/* 饤ȤƤѿ*/
	struct ConvAttrsMesg *camsg ;

	/* Callback Ĥʤ˰դġ*/
	XtCallbackList endcallback ;	/* Widget ˲ѡ*/
	XtCallbackList fixcallback ;	/* ѴʸΤѡ*/
	XtCallbackList keybackcallback ;	/* 򲡤᤹Τѡ*/
	XtCallbackList			m_lstTextCallback ;

	/* μϤ˻Ȥѿ(ݥ)*/
	HistoryListNode *historyAttribute ;

	/* skkinput  buffer */
	struct skkinputBuffer	buffer ;
} OffthespotWinPart ;

typedef struct _OffthespotWinRec {
	CorePart 		core ;
	OffthespotWinPart	offthespotWin ;
} OffthespotWinRec ;

/* New fields for the My widget class record */
typedef struct {
	int dummy ;
} OffthespotWinClassPart ;

typedef struct _OffthespotWinClassRec {
	CoreClassPart			core_class ;
	OffthespotWinClassPart	offthespotWin_class ;
} OffthespotWinClassRec ;

extern OffthespotWinClassRec	offthespotWinClassRec ;

#endif
