/* # skkinput (Simple Kana-Kanji Input)
 * maketable.c --- Create kana-kanji table for skkinput
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>

struct roma_kana_table {
  unsigned char *prefix ;
  unsigned char *kana ;
  unsigned char *katakana ;
} ;

/* ޻ʤѴơ֥֣ */
static struct roma_kana_table skk_roma_kana_a[] = {
  { "",   "",   ""   },
  { "b" , "",   ""   },  { "by", "Ӥ", "ӥ" },
  { "ch", "", "" },  { "cy", "", "" }, 
  { "d",  "",   ""   },  { "dh", "Ǥ", "ǥ" },
  { "dy", "¤", "¥" },
  { "f",  "դ", "ե" },  { "fy", "դ", "ե" },
  { "g",  "",   ""   },  { "gy", "", "" },
  { "h",  "",   ""   },  { "hy", "Ҥ", "ҥ" },
  { "j",  "", "" },  { "jy", "", "" },
  { "k",  "",   ""   },  { "ky", "", "" },
  { "m",  "",   ""   },  { "my", "ߤ", "ߥ" },
  { "n",  "",   ""   },  { "ny", "ˤ", "˥" },
  { "p",  "",   ""   },  { "py", "Ԥ", "ԥ" },
  { "r",  "",   ""   },  { "ry", "", "" },
  { "s",  "",   ""   },  { "sh", "", "" },
  { "sy", "", "" }, 
  { "t",  "",   ""   },  { "th", "Ƥ", "ƥ" },
  { "ty", "", "" },
  { "v",  "", "" },{ "w",  "",   "" },
  { "x",  "",   ""   },  { "xk", "",   "" },
  { "xw", "",   ""   },  { "xy", "",   "" },
  { "y",  "",   ""   },
  { "z",  "",   ""   },  { "zy", "", "" },
  { NULL, NULL,     NULL }
} ;

/* ޻ʤѴơ֥֣ */
static struct roma_kana_table skk_roma_kana_i[] = {
  { "",   "",     ""   },
  { "b",  "",     ""   }, {"by", "Ӥ", "ӥ"},
  { "ch", "",     ""   }, {"cy", "", ""},
  { "d",  "",     ""   }, {"dh", "Ǥ", "ǥ"},
  { "dy", "¤",   "¥" },
  { "f",  "դ",   "ե" }, {"fy", "դ", "ե"},
  { "g",  "",     ""   }, {"gy", "", ""},
  { "h",  "",     ""   }, {"hy", "Ҥ", "ҥ"},
  { "j",  "",     ""   }, {"jy", "", ""},
  { "k",  "",     ""   }, {"ky", "", ""},
  { "m",  "",     ""   }, {"my", "ߤ", "ߥ"},
  { "n",  "",     ""   }, {"ny", "ˤ", "˥"},
  { "p",  "",     ""   }, {"py", "Ԥ", "ԥ"},
  { "r",  "",     ""   }, {"ry", "ꤣ", "ꥣ"},
  { "s",  "",     ""   }, {"sh", "",   ""},
  { "sy", "",   "" },
  { "t",  "",     ""   }, {"th", "Ƥ", "ƥ"},
  { "ty", "",   "" },
  { "v",  "", "" }, {"w",  "", ""},
  { "x",  "",     ""   }, {"xw", "",   ""},
  { "z",  "",     ""   }, {"zy", "", ""},
  { NULL, NULL,     NULL   }
} ;

/* ޻ʤѴơ֥֣ */
static struct roma_kana_table skk_roma_kana_u[] = {
  { "",   "",   ""   },
  { "b",  "",   ""   }, { "by", "Ӥ", "ӥ" },
  { "ch", "", "" }, { "cy", "", "" },
  { "d",  "",   ""   }, { "dh", "Ǥ", "ǥ" },
  { "dy", "¤", "¥" },
  { "f",  "",   ""   }, { "fy", "դ", "ե" },
  { "g",  "",   ""   }, { "gy", "", "" },
  { "h",  "",   ""   }, { "hy", "Ҥ", "ҥ" },
  { "j",  "", "" }, { "jy", "", "" },
  { "k",  "",   ""   }, { "ky", "", "" },
  { "m",  "",   ""   }, { "my", "ߤ", "ߥ" },
  { "n",  "",   ""   }, { "ny", "ˤ", "˥" },
  { "p",  "",   ""   }, { "py", "Ԥ", "ԥ" },
  { "r",  "",   ""   }, { "ry", "", "" },
  { "s",  "",   ""   }, { "sh", "", "" },
  { "sy", "", "" },
  { "t",  "",   ""   }, { "th", "Ƥ", "ƥ" },
  { "ts", "",   ""   }, { "ty", "", "" },
  { "v",  "", ""   }, { "w",  "",   ""   },
  { "x",  "",   ""   }, { "xt", "",   ""   },
  { "xts","",   ""   }, { "xy", "",   ""   },
  { "y",  "",   ""   },
  { "z",  "",   ""   }, { "zy", "", "" },
  { NULL, NULL,     NULL }
} ;

/* ޻ʤѴơ֥֣ */
static struct roma_kana_table skk_roma_kana_e[] = {
  { "",   "",     ""   },
  { "b",  "",     ""   }, { "by", "Ӥ", "ӥ" },
  { "ch", "",   "" }, { "cy", "", "" },
  { "d",  "",     ""   }, { "dh", "Ǥ", "ǥ" },
  { "dy", "¤",   "¥" },
  { "f",  "դ",   "ե" }, { "fy", "դ", "ե" },
  { "g",  "",     ""   }, { "gy", "", "" },
  { "h",  "",     ""   }, { "hy", "Ҥ", "ҥ" },
  { "j",  "",   "" }, { "jy", "", "" },
  { "k",  "",     ""   }, { "ky", "", "" },
  { "m",  "",     ""   }, { "my", "ߤ", "ߥ" },
  { "n",  "",     ""   }, { "ny", "ˤ", "˥" },
  { "p",  "",     ""   }, { "py", "Ԥ", "ԥ" },
  { "r",  "",     ""   }, { "ry", "ꤧ", "ꥧ" },
  { "s",  "",     ""   }, { "sh", "", "" },
  { "sy", "",   "" },
  { "t",  "",     ""   }, { "th", "Ƥ", "ƥ" },
  { "ty", "",   "" },
  { "v",  "", "" }, { "w",  "", "" },
  { "x",  "",     ""   }, { "xk", "",   ""   },
  { "xw", "",     ""   },
  { "y",  "",   "" },
  { "z",  "",     ""   }, { "zy", "", "" },
  { NULL, NULL,     NULL   }
} ;

/* ޻ʤѴơ֥֣ */
static struct roma_kana_table skk_roma_kana_o[] = {
  { "",   "",     ""   },
  { "b",  "",     ""   }, { "by", "Ӥ", "ӥ" },
  { "ch", "",   "" }, { "cy", "", "" },
  { "d",  "",     ""   }, { "dh", "Ǥ", "ǥ" },
  { "dy", "¤",   "¥" },
  { "f",  "դ",   "ե" }, { "fy", "դ", "ե" },
  { "g",  "",     ""   }, { "gy", "", "" },
  { "h",  "",     ""   }, { "hy", "Ҥ", "ҥ" },
  { "j",  "",   "" }, { "jy", "", "" },
  { "k",  "",     ""   }, { "ky", "", "" },
  { "m",  "",     ""   }, { "my", "ߤ", "ߥ" },
  { "n",  "",     ""   }, { "ny", "ˤ", "˥" },
  { "p",  "",     ""   }, { "py", "Ԥ", "ԥ" },
  { "r",  "",     ""   }, { "ry", "", "" },
  { "s",  "",     ""   }, { "sh", "", "" },
  { "sy", "",   "" },
  { "t",  "",     ""   }, { "th", "Ƥ", "ƥ" },
  { "ty", "",   "" },
  { "v",  "", "" }, { "w",  "",   ""   },
  { "x",  "",     ""   }, { "xy", "",   ""   },
  { "y",  "",     ""   },
  { "z",  "",     ""   }, { "zy", "", "" },
  { NULL, NULL,     NULL   }
} ;

void print_string( unsigned char *string )
{
  int chara, length ;

  printf( "{\n" ) ;
  length = 0 ;

  while( *string != '\0' ){
    if( *string & 0x80 ){
      chara = ( ( *string ) << 8 ) | *( string + 1 ) ;
      printf( "\t{ CHARSET_JISX0208_1983, 0x%04x }, \n", chara & 0x7F7F ) ;
      string ++ ;
      string ++ ;
    } else {
      chara = *string ;
      printf( "\t{ CHARSET_ASCII, '%c' }, \n", chara ) ;
      string ++ ;
    }
    length ++ ;
  }
  while( length < 4 ){
    printf( "\t{ CHARSET_ASCII, '\\0' }, \n" ) ;
    length ++ ;
  }
  printf( "},\n" ) ;
  return ;
}

void maketable( struct roma_kana_table *table )
{
  struct roma_kana_table *ptr = table ;
  while( ptr->prefix != NULL ){
    printf( "{\n" ) ;
    print_string( ptr->prefix ) ;
    print_string( ptr->kana ) ;
    print_string( ptr->katakana ) ;
    printf( "},\n" ) ;
    ptr ++ ;
  }
  /* üʸ*/
  printf( "{\n" ) ;
  print_string( "" ) ;
  print_string( "" ) ;
  print_string( "" ) ;
  printf( "},\n" ) ;
  return ;
}

int main( void )
{
  printf( "static struct roma_kana_table skk_roma_kana_a[] = {\n" ) ;
  maketable( skk_roma_kana_a ) ;
  printf( "} ;\n" ) ;
  printf( "static struct roma_kana_table skk_roma_kana_i[] = {\n" ) ;
  maketable( skk_roma_kana_i ) ;
  printf( "} ;\n" ) ;
  printf( "static struct roma_kana_table skk_roma_kana_u[] = {\n" ) ;
  maketable( skk_roma_kana_u ) ;
  printf( "} ;\n" ) ;
  printf( "static struct roma_kana_table skk_roma_kana_e[] = {\n" ) ;
  maketable( skk_roma_kana_e ) ;
  printf( "} ;\n" ) ;
  printf( "static struct roma_kana_table skk_roma_kana_o[] = {\n" ) ;
  maketable( skk_roma_kana_o ) ;
  printf( "} ;\n" ) ;
  return 0 ;
}
