= Mailbox Classes

== class TMail::MhMailbox

j
MH Υ᡼ܥåä륯饹
e
The class to handle MH mailboxes.
.

=== Class Methods

: new(dirname) -> TMail::MhMailbox
    dirname: String

j
    MhMailbox ֥Ȥޤ
    dirname  MH ᡼ܥåȤƻȤǥ쥯ȥ̾Ǥ
    Ǥ˺ߤǤʤФޤ
e
    creates new MhMailbox object.
    DIRNAME must be valid MH mailbox directory.
.

=== Instance Methods

: each_port {|port| .... }
: each {|port| .... }
    port: TMail::FilePort

j
    ᡼ܥåΥ᡼ФƸŤ᡼뤫֤˷֤ޤ
e
    iterates for each mail in the mailbox,
    in assendant order (older mail first).
.

: reverse_each_port {|port| .... }
: reverse_each {|port| .... }
    port: TMail::FilePort

j
    ǥ쥯ȥΥ᡼Фƿ᡼뤫֤˷֤ޤ
e
    iterates for each mail in the mailbox,
    in descendant order (newer mail first).
.

: last_atime -> Time
: last_atime=(time)
    time: Time

j
    Ǹ each_new_port/each_port/reverse_each_port ƤӽФ֡
e
    The time which last each_new_port/each_port/reverse_each_port is called.
.

: each_new_port(time = last_atime()) {|port| .... }
    time: Time
    port: TMail::FilePort

j
    ᡼ΤߤФƤ꤫ޤ
     time Ϳ줿ȤϤλʹߤ˹줿᡼Ȥߤʤޤ
    Ϳʤä each_mail, reverse_each_mail, each_new_port θ
    줿᡼Ȥߤʤޤ
e
    iterates for each mails in mailbox, which are newer than TIME.
.

: new_port -> TMail::FilePort
j
    ᡼бե
    б TMail::Port ֥Ȥ֤
e
    creates a new file in the mailbox and returns its port.
.

: close
j
    ʤˤ⤷ޤ
e
    does nothing.
.

== class TMail::UNIXMbox

j
UNIX mbox 򰷤饹ߤμǤϡ MH Ѵ
Ū close ƤӽФ GC Υߥ󥰤ǥե˽ᤷޤ
e
The class to handle UNIX mbox.
Current implementation creates temporary MH mbox.
.

=== Class Methods

: new(filename) -> TMail::UNIXMbox
    filename: String

j
     TMail::UNIXMbox ֥Ȥޤ
    filename  UNIX mbox ե̾Ǥ
e
    creates new TMail::UNIMbox object.
    FILENAME must be valid UNIX mbox file name.
.

=== Instance Methods

: each_port {|port| .... }
: each {|port| .... }
    port: TMail::FilePort

j
    ᡼ܥåΥ᡼ФƸŤ᡼뤫֤˷֤ޤ
e
    iterates for each mail in the mailbox,
    in assendant order (older mail first).
.

: reverse_each_port {|port| ... }
: reverse_each {|port| ... }
    port: TMail::FilePort

j
    ǥ쥯ȥΥ᡼Фƿ᡼뤫֤˷֤ޤ
e
    iterates for each mail in the mailbox,
    in descendant order (newer mail first).
.

: each_new_port(time = @last_loaded_time) {|port| .... }
    time: Time
    port: TMail::FilePort

j
    ᡼ΤߤФƤ꤫ޤ
     time Ϳ줿ȤϤλʹߤ˹줿᡼Ȥߤʤޤ
    Ϳʤä each_mail, reverse_each_mail, each_new_port θ
    줿᡼Ȥߤʤޤ
e
    iterates for each mails in mailbox, which are newer than TIME.
    @last_loaded_time is updated when each_new_port/each_port is
    called.
.

: new_port -> TMail::FilePort
j
    ᡼бե
    б TMail::Port ֥Ȥ֤
e
    creates a new file in the mailbox and returns its port.
.

: close
j
    Ū˥᡼ܥåᤷޤʸ塢Υ֥Ȥ
    Фƥ᡼᥽åɤƤӽФ㳰ˤʤޤ
e
    forces an UNIXMbox to write back mails to real mbox file.
    Once this method is called, any method calls causes to raise
    IOError exception.
.

== class TMail::Maildir

j
qmail Ѥ᡼ܥå maildir ä륯饹
e
The class to handle "maildir" mailbox.
.

=== Class Methods

: new(dirname) -> TMail::Maildir
    dirname: String

j
     TMail::Maildir ֥Ȥޤ
    dirname  maildir ᡼ܥåȤƻȤǥ쥯ȥ̾Ǥ
    ǥ쥯ȥϤǤ˺ߤǤʤФޤ
e
    creates new TMail::Maildir object.
    DIRNAME must be valid maildir.
.

=== Instance Methods

: each_port {|port| .... }
: each {|port| .... }
    port: TMail::FilePort

j
    ᡼ܥåΥ᡼ФƸŤ᡼뤫֤˷֤ޤ
e
    iterates for each mail in the mailbox,
    in assendant order (older mail first).
.

: reverse_each_port {|port| .... }
: reverse_each {|port| .... }
    port: TMail::FilePort

j
    ǥ쥯ȥΥ᡼Фƿ᡼뤫֤˷֤ޤ
e
    iterates for each mail in the mailbox,
    in descendant order (newer mail first).
.

: each_new_port {|port| .... }
    port: TMail::FilePort

j
    MAILDIR/new Υ᡼Фơcur ˰ưΤ˷֤ޤ
e
    iterates for each mails in MAILDIR/new.
.

: new_port -> TMail::FilePort
j
    ᡼бե
    б Port ֥Ȥ֤
e
    creates a new file in the mailbox and returns its port.
.
