#!/bin/sh
#
# This script starts xcircuit under the Tcl interpreter,
# reading commands from a special .wishrc script which
# launches magic and retains the Tcl interactive interpreter.
#

TKCON=true

for i in $@ ; do
   case $i in
      -noc*) TKCON=;;
   esac
done

loclibdir=${XCIRCUIT_LIB_DIR:=LIBDIR}
export XCIRCUIT_LIB_DIR

if [ $TKCON ]; then

   if [ ! -f ${loclibdir}/CONSOLE ]; then
      loclibdir=${loclibdir}/tcl
   fi

   exec ${loclibdir}/CONSOLE \
	-`eval' "source ${loclibdir}/CONSOLE_SCRIPT" \
        -slave "package require Tk; set argc $#; set argv [list $*]; \
        source ${loclibdir}/WRAPPER_INIT"
else

#
# Run the stand-in for wish (xcircexec), which acts exactly like "wish"
# except that it replaces ~/.wishrc with xcircuit.tcl.  This executable is
# *only* needed when running without the console; the console itself is
# capable of sourcing the startup script.
#
   exec ${loclibdir}/xcircexec -- $@

fi
