/*
 * Copyright 2004-2006 Luc Verhaegen.
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_PANEL_H_
#define _VIA_PANEL_H_ 1

/*
 *
 * Panel
 *
 */

/* For ViaPanelOutputPrivate->BusWidth */
#define	VIA_DI_12BIT  0x00
#define	VIA_DI_24BIT  0x01

/* For ViaPanelOutputPrivate->Size, as used by the scratch register. */
#define VIA_PANEL6X4         0
#define VIA_PANEL8X6         1
#define VIA_PANEL10X7        2
#define VIA_PANEL12X7        3
#define VIA_PANEL12X10       4
#define VIA_PANEL14X10       5
#define VIA_PANEL16X12       6
#define VIA_PANEL_INVALID  255

/*
 * Since mode->PrivFlags is overwritten to support the antique Tseng
 * this is the only way to flag a selfdefined mode as such.
 */
struct ViaModePriv {
    char   id[12]; /* "Unichrome" */
};

static struct ViaModePriv ViaPanelPrivate = {
    { 'U', 'n', 'i', 'c', 'h', 'r', 'o', 'm', 'e', 0, 0, 0 },
};

#define MODEPREFIX(name) NULL, NULL, name, 0,M_T_DEFAULT
#define MODESUFFIX       0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE,\
	sizeof(struct ViaModePriv),(void *)&ViaPanelPrivate,0,0.0,0.0

static DisplayModeRec ViaPanelModes[] = {
    /* 320x200 */
    /* 320x240 */
    /* 400x300 */
    /* 512x384 */
    /* 640x400 */
    { MODEPREFIX("640x480"),    25312,  640,  656,  752,  800, 0,  480,  489,  491,  525, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX },
    { MODEPREFIX("800x600"),    39822,  800,  840,  968, 1056, 0,  600,  600,  604,  628, 0, V_PHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1024x768"),   65028, 1024, 1048, 1184, 1344, 0,  768,  770,  776,  806, 0, V_NHSYNC | V_NVSYNC, MODESUFFIX },
    { MODEPREFIX("1280x768"),   81135, 1280, 1328, 1440, 1688, 0,  768,  770,  776,  802, 0, V_PHSYNC | V_NVSYNC, MODESUFFIX },
    { MODEPREFIX("1280x960"),  108280, 1280, 1376, 1488, 1800, 0,  960,  960,  963, 1000, 0, V_PHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1280x1024"), 108280, 1280, 1328, 1440, 1688, 0, 1024, 1024, 1027, 1066, 0, V_PHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1400x1050"), 122726, 1400, 1488, 1640, 1880, 0, 1050, 1050, 1053, 1087, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1600x1200"), 161793, 1600, 1664, 1856, 2160, 0, 1200, 1200, 1203, 1250, 0, V_PHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX(NULL), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, MODESUFFIX },
};

#define  VIA_PANEL_REG_COUNT_MAIN     29
#define  VIA_PANEL_REG_COUNT_PRIMARY  18
#define  VIA_PANEL_COUNT               7
#define  VIA_PANEL_COUNT_MAIN         12
#define  VIA_PANEL_COUNT_PRIMARY       3

struct ViaPanelPatchMain {
    int     HDisplay;
    int     VDisplay;
    int     PLLSecondary;
    int     PLLPrimary;
    Bool    Scaled;
    CARD8   data[VIA_PANEL_REG_COUNT_MAIN];
};

struct ViaPanelPatchPrimary {
    int     HDisplay;
    int     VDisplay;
    CARD8   offset[VIA_PANEL_REG_COUNT_PRIMARY];
    CARD8   data[VIA_PANEL_REG_COUNT_PRIMARY];
    int     numEntry;
};

typedef struct _VIALCDMODETABLE {
    int                          X;
    int                          Y;
    int                          PLL;
    CARD8                        data[VIA_PANEL_REG_COUNT_MAIN];
    struct ViaPanelPatchMain     CenterMain[VIA_PANEL_COUNT_MAIN];
    struct ViaPanelPatchMain     ExpandMain[VIA_PANEL_COUNT_MAIN];
    struct ViaPanelPatchPrimary  CenterPrimary[VIA_PANEL_COUNT_PRIMARY];
    struct ViaPanelPatchPrimary  ExpandPrimary[VIA_PANEL_COUNT_PRIMARY];
} VIALCDModeTableRec, *VIALCDModePtr;

static const VIALCDModeTableRec lcdTable[] = {
    { 640, 480, 25056,
      { 0x1F, 0x7F, 0x7F, 0x1F, 0x9A, 0x23, 0x87, 0xE7, 0x0C, 0xDF, 0xDF, 0x0C, 0x11, 0x0A, 0xE1, 0x23,
        0xA0, 0x50,    0,
        0x5F, 0x63, 0x0B, 0xDF, 0x12, 0xDF, 0x0C, 0x12, 0xE2, 0x14 },
      {
          {  320,  200,  25312,  25312, FALSE,
             { 0x0B, 0x3F, 0xDF, 0x7F, 0x51, 0x13, 0xE7, 0x47, 0x0C, 0xC7, 0x53, 0x80, 0x09, 0x02, 0x55, 0x37,
               0x50, 0x50, 0x00,
               0x5F, 0x63, 0x0B, 0xC7, 0x02, 0xC7, 0x0C, 0x02, 0x56, 0x18 } },
          {  320,  240,  25312,  25312, FALSE,
             { 0x0B, 0x3F, 0xDF, 0x7F, 0x51, 0x13, 0xE7, 0x47, 0x0C, 0xEF, 0x67, 0x94, 0x09, 0x02, 0x69, 0x2B,
               0x50, 0x50, 0x00,
               0x5F, 0x63, 0x0B, 0xEF, 0x02, 0xEF, 0x0C, 0x02, 0x6A, 0x1C } },
          {  400,  300,  25312,  25312, FALSE,
             { 0x5F, 0x8F, 0x07, 0xA7, 0x92, 0x13, 0x0F, 0x6F, 0x0C, 0x2B, 0x85, 0xB2, 0x09, 0x0A, 0x87, 0x29,
               0x64, 0x50, 0x00,
               0x5F, 0x63, 0x0B, 0x2B, 0x12, 0x2B, 0x0C, 0x12, 0x88, 0x1A } },
          {  512,  384,  25312,  25312, FALSE,
             { 0x00, 0xFF, 0x3F, 0xDF, 0x92, 0x13, 0x47, 0xA7, 0x0C, 0x7F, 0xAF, 0xDC, 0x09, 0x0A, 0xB1, 0x34,
               0x80, 0x50, 0x00,
               0x5F, 0x63, 0x0B, 0x7F, 0x12, 0x7F, 0x0C, 0x12, 0xB2, 0x14 } },
          {  640,  400,  25056,  25056, FALSE,
             { 0xB7, 0x7F, 0x7F, 0x1F, 0x9A, 0x23, 0x87, 0xE7, 0x0C, 0x8F, 0xB7, 0xE4, 0x09, 0x0A, 0xB9, 0x3B,
               0xA0, 0x50, 0x00,
               0x5F, 0x63, 0x0B, 0x8F, 0x12, 0x8F, 0x0C, 0x12, 0xBA, 0x1C } },
      }, {
          {  320,  200,  25312,  25312, FALSE,
             { 0x0B, 0x3F, 0xDF, 0x7F, 0x51, 0x13, 0xE7, 0x47, 0x0C, 0xC7, 0x53, 0x80, 0x09, 0x02, 0x55, 0x37,
               0x50, 0x50, 0x00,
               0x5F, 0x63, 0x0B, 0xC7, 0x02, 0xC7, 0x0C, 0x02, 0x56, 0x18 } },
          {  320,  240,  25312,  25312, FALSE,
             { 0x0B, 0x3F, 0xDF, 0x7F, 0x51, 0x13, 0xE7, 0x47, 0x0C, 0xEF, 0x67, 0x94, 0x09, 0x02, 0x69, 0x2B,
               0x50, 0x50, 0x00,
               0x5F, 0x63, 0x0B, 0xEF, 0x02, 0xEF, 0x0C, 0x02, 0x6A, 0x1C } },
          {  400,  300,  25312,  25312, FALSE,
             { 0x5F, 0x8F, 0x07, 0xA7, 0x92, 0x13, 0x0F, 0x6F, 0x0C, 0x2B, 0x85, 0xB2, 0x09, 0x0A, 0x87, 0x29,
               0x64, 0x50, 0x00,
               0x5F, 0x63, 0x0B, 0x2B, 0x12, 0x2B, 0x0C, 0x12, 0x88, 0x1A } },
          {  512,  384,  25312,  25312, FALSE,
             { 0x00, 0xFF, 0x3F, 0xDF, 0x92, 0x13, 0x47, 0xA7, 0x0C, 0x7F, 0xAF, 0xDC, 0x09, 0x0A, 0xB1, 0x34,
               0x80, 0x50, 0x00,
               0x5F, 0x63, 0x0B, 0x7F, 0x12, 0x7F, 0x0C, 0x12, 0xB2, 0x14 } },
          {  640,  400,  25056,  25056, FALSE,
             { 0xB7, 0x7F, 0x7F, 0x1F, 0x9A, 0x23, 0x87, 0xE7, 0x0C, 0x8F, 0xB7, 0xE4, 0x09, 0x0A, 0xB9, 0x3B,
               0xA0, 0x50, 0x00,
               0x5F, 0x63, 0x0B, 0x8F, 0x12, 0x8F, 0x0C, 0x12, 0xBA, 0x1C } },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x3D, 0x89, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x3D, 0x89, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x3D, 0x89, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x3D, 0x89, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      },
    },
    { 800, 600, 39971,
      { 0x1F, 0x1F, 0x1F, 0x1F, 0xE3, 0x34, 0x47, 0xC7, 0x73, 0x57, 0x57, 0x73, 0x52, 0x12, 0x58, 0x5C,
        0xC8, 0x6E,    0,
        0x7F, 0x83, 0x72, 0x57, 0x22, 0x57, 0x73, 0x22, 0x59, 0x2D },
      {
          {  320,  200,  39822,  39822, FALSE,
             { 0x83, 0x3F, 0x2F, 0x2F, 0xE3, 0x14, 0x57, 0xD7, 0x73, 0xC7, 0x8F, 0xAB, 0x09, 0x02, 0x90, 0x34,
               0x50, 0x6E, 0x00,
               0x7F, 0x83, 0x72, 0xC7, 0x02, 0xC7, 0x73, 0x02, 0x91, 0x15 } },
          {  320,  240,  39822,  39822, FALSE,
             { 0x83, 0x3F, 0x2F, 0x2F, 0xE3, 0x14, 0x57, 0xD7, 0x73, 0xEF, 0xA3, 0xBF, 0x09, 0x02, 0xA4, 0x28,
               0x50, 0x6E, 0x00,
               0x7F, 0x83, 0x72, 0xEF, 0x02, 0xEF, 0x73, 0x02, 0xA5, 0x19 } },
          {  400,  300,  39822,  39822, FALSE,
             { 0x6E, 0x8F, 0x57, 0x57, 0xE3, 0x14, 0x7F, 0xFF, 0x73, 0x2B, 0xC1, 0xDD, 0x09, 0x12, 0xC2, 0x26,
               0x64, 0x6E, 0x00,
               0x7F, 0x83, 0x72, 0x2B, 0x22, 0x2B, 0x73, 0x22, 0xC3, 0x17 } },
          {  512,  384,  39822,  39822, FALSE,
             { 0x6E, 0xFF, 0x8F, 0x8F, 0xE3, 0x14, 0xB7, 0x37, 0x73, 0x7F, 0xEB, 0x07, 0x51, 0x12, 0xEC, 0x30,
               0x80, 0x6E, 0x00,
               0x7F, 0x83, 0x72, 0x7F, 0x22, 0x7F, 0x73, 0x22, 0xED, 0x11 } },
          {  640,  400,  39971,  39971, FALSE,
             { 0xF3, 0x1F, 0x1F, 0x1F, 0xE3, 0x34, 0x47, 0xC7, 0x73, 0x8F, 0xF3, 0x0F, 0x51, 0x12, 0xF4, 0x38,
               0xC8, 0x6E, 0x00,
               0x7F, 0x83, 0x72, 0x8F, 0x22, 0x8F, 0x73, 0x22, 0xF5, 0x19 } },
          {  640,  480,  39971,  39971, FALSE,
             { 0x83, 0x7F, 0xCF, 0xCF, 0x9A, 0x24, 0xF7, 0x77, 0x73, 0xDF, 0x1B, 0x37, 0x52, 0x0A, 0x1C, 0x40,
               0xA0, 0x6E, 0x00,
               0x7F, 0x83, 0x72, 0xDF, 0x12, 0xDF, 0x73, 0x12, 0x1D, 0x21 } },
      }, {
          {  320,  200,  39822,  15085, TRUE,
             { 0x47, 0x1F, 0x1F, 0x1F, 0xE3, 0x34, 0x47, 0xC7, 0x73, 0x57, 0x57, 0x73, 0x52, 0x12, 0x58, 0x5C,
               0x50, 0x5A, 0x00,
               0x2D, 0x31, 0x72, 0x57, 0x22, 0x57, 0x73, 0x22, 0x59, 0x2D } },
          {  320,  240,  39822,  15085, TRUE,
             { 0x47, 0x1F, 0x1F, 0x1F, 0xE3, 0x34, 0x47, 0xC7, 0x73, 0x57, 0x57, 0x73, 0x52, 0x12, 0x58, 0x5C,
               0x50, 0x55, 0x00,
               0x2D, 0x31, 0x72, 0x57, 0x22, 0x57, 0x73, 0x22, 0x59, 0x2D } },
          {  400,  300,  39822,  19985, TRUE,
             { 0x47, 0x1F, 0x1F, 0x1B, 0xE3, 0x34, 0x47, 0xC7, 0x73, 0x57, 0x57, 0x73, 0x52, 0x12, 0x58, 0x5C,
               0x64, 0x5A, 0x00,
               0x3D, 0x41, 0x72, 0x57, 0x22, 0x57, 0x73, 0x22, 0x59, 0x2D } },
          {  512,  384,  39822,  24340, TRUE,
             { 0x47, 0x1F, 0x1F, 0x23, 0xE3, 0x34, 0x47, 0xC7, 0x73, 0x57, 0x57, 0x73, 0x52, 0x12, 0x58, 0x5C,
               0x80, 0x61, 0x00,
               0x4C, 0x50, 0x72, 0x57, 0x22, 0x57, 0x73, 0x22, 0x59, 0x2D } },
          {  640,  400,  39971,  30426, TRUE,
             { 0x1F, 0x1F, 0x1F, 0x1F, 0xE3, 0x34, 0x47, 0xC7, 0x73, 0x57, 0x57, 0x73, 0x52, 0x12, 0x58, 0x5C,
               0xC8, 0x6E, 0x00,
               0x7F, 0x83, 0x72, 0x57, 0x22, 0x57, 0x73, 0x22, 0x59, 0x2D } },
          {  640,  480,  39971,  30426, TRUE,
             { 0x34, 0x1F, 0x1F, 0x1A, 0xE3, 0x34, 0x47, 0xC7, 0x73, 0x57, 0x57, 0x73, 0x52, 0x12, 0x58, 0x5C,
               0xA0, 0x6E, 0x00,
               0x5F, 0x63, 0x72, 0x57, 0x22, 0x57, 0x73, 0x22, 0x59, 0x2D } },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x4B, 0x9B, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x4B, 0x9B, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x2A, 0x90, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x2A, 0x90, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      }
    },
    { 1024, 768, 65028,
      { 0x3F, 0xFF, 0xFF, 0x3F, 0x2B, 0x35, 0x17, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0x9A, 0x13,    0, 0x62,
        0, 0x96, 0x04,
        0xA3, 0xA7, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 },
      {
          {  320,  200,  65028,  65028, FALSE,
             { 0x24, 0x3F, 0x9F, 0xDF, 0x9A, 0x15, 0xB7, 0x3F, 0x25, 0xC7, 0xE3, 0x09, 0x51, 0x03, 0xE6, 0x2C,
               0x50, 0x96, 0x04,
               0xA3, 0xA7, 0x24, 0xC7, 0x03, 0xC7, 0x25, 0x03, 0xE7, 0x1D } },
          {  320,  240,  65028,  65028, FALSE,
             { 0x24, 0x3F, 0x9F, 0xDF, 0x9A, 0x15, 0xB7, 0x3F, 0x25, 0xEF, 0xF7, 0x1D, 0x51, 0x03, 0xFA, 0x20,
               0x50, 0x96, 0x04,
               0xA3, 0xA7, 0x24, 0xEF, 0x03, 0xEF, 0x25, 0x03, 0xFB, 0x11 } },
          {  400,  300,  65028,  65028, FALSE,
             { 0x96, 0x8F, 0xC7, 0x07, 0xA2, 0x15, 0xDF, 0x67, 0x25, 0x2B, 0x15, 0x3B, 0x9A, 0x13, 0x18, 0x5E,
               0x64, 0x96, 0x04,
               0xA3, 0xA7, 0x24, 0x2B, 0x23, 0x2B, 0x25, 0x23, 0x19, 0x2F } },
          {  512,  384,  65028,  65028, FALSE,
             { 0x96, 0xFF, 0xFF, 0x3F, 0xE2, 0x15, 0x17, 0x9F, 0x25, 0x7F, 0x3F, 0x65, 0x9A, 0x13, 0x42, 0x48,
               0x80, 0x96, 0x04,
               0xA3, 0xA7, 0x24, 0x7F, 0x23, 0x7F, 0x25, 0x23, 0x43, 0x29 } },
          {  640,  400,  65028,  65028, FALSE,
             { 0x8F, 0xFF, 0xFF, 0x3F, 0x2B, 0x35, 0x17, 0x9F, 0x25, 0x8F, 0x47, 0x6D, 0x9A, 0x13, 0x4A, 0x50,
               0x00, 0x96, 0x04,
               0xA3, 0xA7, 0x24, 0x8F, 0x23, 0x8F, 0x25, 0x23, 0x4B, 0x21 } },
          {  640,  480,  65028,  65028, FALSE,
             { 0xDF, 0x7F, 0x3F, 0x7F, 0xE3, 0x25, 0x57, 0xDF, 0x25, 0xDF, 0x6F, 0x95, 0x52, 0x0B, 0x72, 0x58,
               0xA0, 0x96, 0x00,
               0xA3, 0xA7, 0x24, 0xDF, 0x13, 0xDF, 0x25, 0x13, 0x73, 0x29 } },
          {  800,  600,  65028,  65028, FALSE,
             { 0x00, 0x1F, 0x8F, 0xCF, 0xE3, 0x35, 0xA7, 0x2F, 0x25, 0x57, 0xAB, 0xD1, 0x12, 0x13, 0xAE, 0x54,
               0xC8, 0x96, 0x00,
               0xA3, 0xA7, 0x24, 0x57, 0x23, 0x57, 0x25, 0x23, 0xAF, 0x25 } },
      }, {
          {  320,  200,  65028,  18971, TRUE,
             { 0x17, 0xFF, 0xFF, 0x3F, 0x2B, 0x35, 0x17, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0x9A, 0x13, 0x00, 0x62,
               0x50, 0x78, 0x04,
               0x2C, 0x30, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  320,  240,  65028,  18971, TRUE,
             { 0x17, 0xFF, 0xFF, 0x3F, 0x2B, 0x35, 0x17, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0x9A, 0x13, 0x00, 0x62,
               0x50, 0x7C, 0x04,
               0x2C, 0x30, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  400,  300,  65028,  25504, TRUE,
             { 0x17, 0xFF, 0xFF, 0x41, 0x2B, 0x35, 0x17, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0x9A, 0x13, 0x00, 0x62,
               0x64, 0x73, 0x04,
               0x3D, 0x41, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  512,  384,  65028,  31768, TRUE,
             { 0x17, 0xFF, 0xFF, 0x3E, 0x2B, 0x35, 0x17, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0x9A, 0x13, 0x00, 0x62,
               0x80, 0x8E, 0x04,
               0x4D, 0x51, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  640,  400,  65028,  38863, TRUE,
             { 0x3F, 0xFF, 0xFF, 0x3F, 0x2B, 0x35, 0x17, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0x9A, 0x13, 0x00, 0x62,
               0x00, 0x96, 0x04,
               0xA3, 0xA7, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  640,  480,  65028,  38863, TRUE,
             { 0x9F, 0xFF, 0xFF, 0x47, 0x2B, 0x35, 0x17, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0x9A, 0x13, 0x00, 0x62,
               0xA0, 0x8C, 0x00,
               0x60, 0x64, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  800,  600,  65028,  51008, TRUE,
             { 0x9F, 0xFF, 0xFF, 0x37, 0x2B, 0x35, 0x17, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0x9A, 0x13, 0x00, 0x62,
               0xC8, 0x8C, 0x00,
               0x7E, 0x82, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x57, 0x88, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x57, 0x88, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
       }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x2A, 0x90, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x2A, 0x90, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
       }
    },
    { 1280, 768, 81613,
      { 0x97, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0xDA, 0x13, 0x02, 0x68,
        0x40, 0xBE, 0x04,
        0xCE, 0xD2, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 },
      {
          {  320,  200,  81613,  81613, FALSE,
             { 0x24, 0x3F, 0x1F, 0xB7, 0xE3, 0x16, 0x4F, 0xBF, 0x25, 0xC7, 0xE3, 0x09, 0x51, 0x03, 0xE6, 0x2C,
               0x50, 0xBE, 0x04,
               0xCE, 0xD2, 0x24, 0xC7, 0x03, 0xC7, 0x25, 0x03, 0xE7, 0x1D } },
          {  320,  240,  81613,  81613, FALSE,
             { 0x24, 0x3F, 0x1F, 0xB7, 0xE3, 0x16, 0x4F, 0xBF, 0x25, 0xEF, 0xF7, 0x1D, 0x51, 0x03, 0xFA, 0x20,
               0x50, 0xBE, 0x04,
               0xCE, 0xD2, 0x24, 0xEF, 0x03, 0xEF, 0x25, 0x03, 0xFB, 0x11 } },
          {  400,  300,  81613,  81613, FALSE,
             { 0xBE, 0x8F, 0x47, 0xDF, 0xE3, 0x16, 0x77, 0xE7, 0x25, 0x2B, 0x15, 0x3B, 0x52, 0x13, 0x18, 0x5E,
               0x64, 0xBE, 0x04,
               0xCE, 0xD2, 0x24, 0x2B, 0x23, 0x2B, 0x25, 0x23, 0x19, 0x39 } },
          {  512,  384,  81613,  81613, FALSE,
             { 0x48, 0xFF, 0x7F, 0x17, 0x74, 0x16, 0x1F, 0x1F, 0x25, 0x7F, 0x3F, 0x65, 0xDA, 0x13, 0x42, 0x48,
               0x80, 0xBE, 0x04,
               0xCE, 0xD2, 0x24, 0x7F, 0x23, 0x7F, 0x25, 0x23, 0x43, 0x39 } },
          {  640,  400,  81613,  81613, FALSE,
             { 0x8F, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x25, 0x8F, 0x47, 0x6D, 0xDA, 0x13, 0x4A, 0x50,
               0x40, 0xBE, 0x04,
               0xCE, 0xD2, 0x24, 0x8F, 0x23, 0x8F, 0x25, 0x23, 0x4B, 0x21 } },
          {  640,  480,  81613,  81613, FALSE,
             { 0xDF, 0x7F, 0xBF, 0x57, 0xEB, 0x26, 0xEF, 0x5F, 0x25, 0xDF, 0x6F, 0x95, 0x12, 0x0B, 0x72, 0x58,
               0xA0, 0xBE, 0x00,
               0xCE, 0xD2, 0x24, 0xDF, 0x13, 0xDF, 0x25, 0x13, 0x73, 0x29 } },
          {  800,  600,  81613,  81613, FALSE,
             { 0xCE, 0x1F, 0x0F, 0xA7, 0x2C, 0x36, 0x3F, 0xAF, 0x25, 0x57, 0xAB, 0xD1, 0x92, 0x13, 0xAE, 0x54,
               0xC8, 0xBE, 0x00,
               0xCE, 0xD2, 0x24, 0x57, 0x23, 0x57, 0x25, 0x23, 0xAF, 0x25 } },
          { 1024,  768,  81613,  81613, FALSE,
            { 0x1F, 0xFF, 0x7F, 0x17, 0x34, 0x36, 0xAF, 0x1F, 0x25, 0xFF, 0xFF, 0x25, 0xDA, 0x13, 0x02, 0x68,
              0x00, 0xBE, 0x04,
              0xCE, 0xD2, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
      }, {
          {  320,  200,  81613,  19329, TRUE,
             { 0x74, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0xDA, 0x13, 0x02, 0x68,
               0x50, 0x8C, 0x04,
               0x2D, 0x31, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  320,  240,  81613,  19329, TRUE,
             { 0x74, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0xDA, 0x13, 0x02, 0x68,
               0x50, 0x8C, 0x04,
               0x2D, 0x31, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  400,  300,  81613,  25504, TRUE,
             { 0x2F, 0xFF, 0xFF, 0x99, 0x74, 0x46, 0x2F, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0xDA, 0x13, 0x02, 0x68,
               0x64, 0xB0, 0x04,
               0x3D, 0x41, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  512,  384,  81613,  31704, TRUE,
             { 0x97, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0xDA, 0x13, 0x02, 0x68,
               0x80, 0xBE, 0x04,
               0x4D, 0x51, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  640,  400,  81613,  38659, TRUE,
             { 0x97, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0xDA, 0x13, 0x02, 0x68,
               0x40, 0xBE, 0x04,
               0xCE, 0xD2, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  640,  480,  81613,  38659, TRUE,
             { 0x9F, 0xFF, 0xFF, 0xA9, 0x74, 0x46, 0x2F, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0xDA, 0x13, 0x02, 0x68,
               0xA0, 0xB8, 0x00,
               0x60, 0x64, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          {  800,  600,  81613,  51008, TRUE,
             { 0x9F, 0xFF, 0xFF, 0xBF, 0x74, 0x46, 0x2F, 0x9F, 0x25, 0xFF, 0xFF, 0x25, 0xDA, 0x13, 0x02, 0x68,
               0xC8, 0xBB, 0x00,
               0x82, 0x86, 0x24, 0xFF, 0x23, 0xFF, 0x25, 0x23, 0x03, 0x39 } },
          { 1024,  768,  81613,  64431, TRUE,
            { 0xA4, 0xFF, 0xFF, 0x87, 0x74, 0x46, 0x2F, 0x9F, 0x25, 0x00, 0x00, 0x00, 0xC3, 0x1B, 0x02, 0x68,
              0x00, 0xBE, 0x04,
              0xA0, 0xA4, 0x24, 0x00, 0x33, 0x00, 0x25, 0x33, 0x03, 0x39 } },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x6A, 0x98, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x6A, 0x98, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x2A, 0x90, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x2A, 0x90, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      }
    },
    { 1280, 1024, 108281,
      { 0x97, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0xFF, 0x29, 0xE3, 0x1C,    0, 0x83,
        0x40, 0xBE, 0x04,
        0xCE, 0xD2, 0x28, 0xFF, 0x34, 0xFF, 0x29, 0x34, 0x01, 0x44 },
      {
          {  320,  200, 108281, 108281, FALSE,
             { 0x28, 0x3F, 0x1F, 0xB7, 0xE3, 0x16, 0x4F, 0xBF, 0x29, 0xC7, 0x63, 0x8D, 0x52, 0x04, 0x64, 0x47,
               0x50, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0xC7, 0x04, 0xC7, 0x29, 0x04, 0x65, 0x28 } },
          {  320,  240, 108281, 108281, FALSE,
             { 0x28, 0x3F, 0x1F, 0xB7, 0xE3, 0x16, 0x4F, 0xBF, 0x29, 0xEF, 0x77, 0xA1, 0x52, 0x04, 0x78, 0x5B,
               0x50, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0xEF, 0x04, 0xEF, 0x29, 0x04, 0x79, 0x2C } },
          {  400,  300, 108281, 108281, FALSE,
             { 0x04, 0x8F, 0x47, 0xDF, 0xE3, 0x16, 0x77, 0xE7, 0x29, 0x2B, 0x95, 0xBF, 0x52, 0x1C, 0x96, 0x59,
               0x64, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0x2B, 0x34, 0x2B, 0x29, 0x34, 0x97, 0x2A } },
          {  512,  384, 108281, 108281, FALSE,
             { 0x80, 0xFF, 0x7F, 0x17, 0x74, 0x16, 0xAF, 0x1F, 0x29, 0x7F, 0xBF, 0xE9, 0x12, 0x1C, 0xC0, 0x43,
               0x80, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0x7F, 0x34, 0x7F, 0x29, 0x34, 0xC1, 0x44 } },
          {  640,  400, 108281, 108281, FALSE,
             { 0xC7, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0x8F, 0xC7, 0xF1, 0x12, 0x1C, 0xC8, 0x4B,
               0x40, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0x8F, 0x34, 0x8F, 0x29, 0x34, 0xC9, 0x2C } },
          {  640,  480, 108281, 108281, FALSE,
             { 0xDF, 0x7F, 0xBF, 0x57, 0xEB, 0x26, 0xEF, 0x5F, 0x29, 0xDF, 0xEF, 0x19, 0x1A, 0x0C, 0xF0, 0x53,
               0xA0, 0xBE, 0x00,
               0xCE, 0xD2, 0x28, 0xDF, 0x14, 0xDF, 0x29, 0x14, 0xF1, 0x24 } },
          {  800,  600, 108281, 108281, FALSE,
             { 0x57, 0x1F, 0x0F, 0xA7, 0x2C, 0x36, 0x3F, 0xAF, 0x29, 0x57, 0x2B, 0x55, 0x9B, 0x14, 0x2C, 0x6F,
               0xC8, 0xBE, 0x00,
               0xCE, 0xD2, 0x28, 0x57, 0x24, 0x57, 0x29, 0x24, 0x2D, 0x30 } },
          { 1024,  768, 108281, 108281, FALSE,
            { 0xBE, 0xFF, 0x7F, 0x17, 0x34, 0x36, 0xAF, 0x1F, 0x29, 0xFF, 0x7F, 0xA9, 0xDB, 0x14, 0x80, 0x63,
              0x00, 0xBE, 0x04,
              0xCE, 0xD2, 0x28, 0xFF, 0x24, 0xFF, 0x29, 0x24, 0x81, 0x34 } },
          { 1280,  768, 108281, 108281, FALSE,
            { 0x7F, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0x7F, 0xA9, 0xDB, 0x14, 0x80, 0x63,
              0x40, 0xBE, 0x04,
              0xCE, 0xD2, 0x28, 0xFF, 0x24, 0xFF, 0x29, 0x24, 0x81, 0x34 } },
          { 1280,  960, 108281, 108281, FALSE,
            { 0xBF, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xBF, 0xDF, 0x09, 0xE3, 0x1C, 0xE0, 0x63,
              0x40, 0xBE, 0x04,
              0xCE, 0xD2, 0x28, 0xBF, 0x34, 0xBF, 0x29, 0x34, 0xE1, 0x34 } },
      }, {
          {  320,  200, 108281,  25568, TRUE,
             { 0x74, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0xFF, 0x29, 0xE3, 0x1C, 0x00, 0x83,
               0x50, 0x82, 0x04,
               0x2D, 0x31, 0x28, 0xFF, 0x34, 0xFF, 0x29, 0x34, 0x01, 0x44 } },
          {  320,  240, 108281,  25568, TRUE,
             { 0x74, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0xFF, 0x29, 0xE3, 0x1C, 0x00, 0x83,
               0x50, 0x82, 0x04,
               0x2D, 0x31, 0x28, 0xFF, 0x34, 0xFF, 0x29, 0x34, 0x01, 0x44 } },
          {  400,  300, 108281,  33749, TRUE,
             { 0x97, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0xFF, 0x29, 0xE3, 0x1C, 0x00, 0x83,
               0x64, 0xBE, 0x04,
               0x3D, 0x41, 0x28, 0xFF, 0x34, 0xFF, 0x29, 0x34, 0x01, 0x44 } },
          {  512,  384, 108281,  41931, TRUE,
             { 0x97, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0xFF, 0x29, 0xE3, 0x1C, 0x00, 0x83,
               0x80, 0xBE, 0x04,
               0x4D, 0x51, 0x28, 0xFF, 0x34, 0xFF, 0x29, 0x34, 0x01, 0x44 } },
          {  640,  400, 108281,  51136, TRUE,
             { 0x97, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0xFF, 0x29, 0xE3, 0x1C, 0x00, 0x83,
               0x40, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0xFF, 0x34, 0xFF, 0x29, 0x34, 0x01, 0x44 } },
          {  640,  480, 108281,  51136, TRUE,
             { 0x9F, 0xFF, 0xFF, 0x9D, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0xFF, 0x29, 0xE3, 0x1C, 0x00, 0x83,
               0xA0, 0xAA, 0x00,
               0x5F, 0x63, 0x28, 0xFF, 0x34, 0xFF, 0x29, 0x34, 0x01, 0x44 } },
          {  800,  600, 108281,  67499, TRUE,
             { 0x2F, 0xFF, 0xFF, 0x9D, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0xFF, 0x29, 0xE3, 0x1C, 0x00, 0x83,
               0xC8, 0xBE, 0x00,
               0x7F, 0x83, 0x28, 0xFF, 0x34, 0xFF, 0x29, 0x34, 0x01, 0x44 } },
          { 1024,  768, 108281,  85909, TRUE,
            { 0x46, 0xFF, 0xFF, 0x9D, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0xFF, 0x29, 0xE3, 0x1C, 0x00, 0x83,
              0x00, 0xBE, 0x04,
              0xA3, 0xA7, 0x28, 0xFF, 0x34, 0xFF, 0x29, 0x34, 0x01, 0x44 } },
          { 1280,  768, 108281, 108281, FALSE,
            { 0x7F, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xFF, 0x7F, 0xA9, 0xDB, 0x14, 0x80, 0x63,
              0x40, 0xBE, 0x04,
              0xCE, 0xD2, 0x28, 0xFF, 0x24, 0xFF, 0x29, 0x24, 0x81, 0x34 } },
          { 1280,  960, 108281, 108281, FALSE,
            { 0xBF, 0xFF, 0xFF, 0x97, 0x74, 0x46, 0x2F, 0x9F, 0x29, 0xBF, 0xDF, 0x09, 0xE3, 0x1C, 0xE0, 0x63,
              0x40, 0xBE, 0x04,
              0xCE, 0xD2, 0x28, 0xBF, 0x34, 0xBF, 0x29, 0x34, 0xE1, 0x34 } },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x6A, 0x98, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x6A, 0x98, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x2A, 0x90, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x2A, 0x90, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      }
    },
    { 1400, 1050, 108281,
      { 0x97, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
        0x5E, 0xBE, 0x04,
        0xCE, 0xD2, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E },
      {
          {  320,  200, 108281, 108281, FALSE,
             { 0x28, 0x3F, 0x5B, 0x7B, 0xE3, 0x16, 0x8B, 0xFB, 0x29, 0xC7, 0x70, 0x80, 0x52, 0x04, 0x71, 0x54,
               0x50, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0xC7, 0x04, 0xC7, 0x29, 0x04, 0x72, 0x25 } },
          {  320,  240, 108281, 108281, FALSE,
             { 0x28, 0x3F, 0x5B, 0x7B, 0xE3, 0x16, 0x8B, 0xFB, 0x29, 0xEF, 0x84, 0x94, 0x52, 0x04, 0x85, 0x48,
               0x50, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0xEF, 0x04, 0xEF, 0x29, 0x04, 0x86, 0x29 } },
          {  400,  300, 108281, 108281, FALSE,
             { 0x04, 0x8F, 0x83, 0xA3, 0xE3, 0x16, 0xB3, 0x23, 0x29, 0x2B, 0xA2, 0xB2, 0x12, 0x24, 0xA3, 0x46,
               0x64, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0x2B, 0x44, 0x2B, 0x29, 0x44, 0xA4, 0x27 } },
          {  512,  384, 108281, 108281, FALSE,
             { 0xBE, 0xFF, 0xBB, 0xDB, 0xE3, 0x16, 0xEB, 0x5B, 0x29, 0x7F, 0xCC, 0xDC, 0x12, 0x24, 0xCD, 0x50,
               0x80, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0x7F, 0x44, 0x7F, 0x29, 0x44, 0xCE, 0x4E } },
          {  640,  400, 108281, 108281, FALSE,
             { 0xD4, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x8F, 0xD4, 0xE4, 0x92, 0x24, 0xD5, 0x58,
               0x5E, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0x8F, 0x44, 0x8F, 0x29, 0x44, 0xD6, 0x29 } },
          {  640,  480, 108281, 108281, FALSE,
             { 0xDF, 0x7F, 0xFB, 0x1B, 0x2B, 0x26, 0x2B, 0x9B, 0x29, 0xDF, 0xFC, 0x0C, 0x9A, 0x0C, 0xFD, 0x40,
               0xA0, 0xBE, 0x00,
               0xCE, 0xD2, 0x28, 0xDF, 0x14, 0xDF, 0x29, 0x14, 0xFE, 0x21 } },
          {  800,  600, 108281, 108281, FALSE,
             { 0x24, 0x1F, 0x4B, 0x6B, 0x2C, 0x36, 0x7B, 0xEB, 0x29, 0x57, 0x38, 0x48, 0x9B, 0x14, 0x39, 0x7C,
               0xC8, 0xBE, 0x00,
               0xCE, 0xD2, 0x28, 0x57, 0x24, 0x57, 0x29, 0x24, 0x3A, 0x3D } },
          { 1024,  768, 108281, 108281, FALSE,
            { 0x28, 0xFF, 0xBB, 0xDB, 0x2C, 0x36, 0xEB, 0x5B, 0x29, 0xFF, 0x8C, 0x9C, 0xDB, 0x14, 0x8D, 0x70,
              0x00, 0xBE, 0x04,
              0xCE, 0xD2, 0x28, 0xFF, 0x24, 0xFF, 0x29, 0x24, 0x8E, 0x31 } },
          { 1280,  768, 108281, 108281, FALSE,
            { 0x8C, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x8C, 0x9C, 0xDB, 0x14, 0x8D, 0x70,
              0x5E, 0xBE, 0x04,
              0xCE, 0xD2, 0x28, 0x19, 0x24, 0x19, 0x29, 0x24, 0x8E, 0x31 } },
          { 1280,  960, 108281, 108281, FALSE,
            { 0xEC, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0xBF, 0xEC, 0xFC, 0xDB, 0x24, 0xED, 0x70,
              0x5E, 0xBE, 0x04,
              0xCE, 0xD2, 0x28, 0xBF, 0x44, 0xBF, 0x29, 0x44, 0xEE, 0x31 } },
          { 1280, 1024, 108281, 108281, FALSE,
            { 0xD2, 0xFF, 0x3B, 0x5B, 0x75, 0x46, 0x6B, 0xDB, 0x29, 0xFF, 0x0C, 0x1C, 0xE4, 0x1C, 0x0D, 0x90,
              0x40, 0xBE, 0x04,
              0xCE, 0xD2, 0x28, 0xFF, 0x34, 0xFF, 0x29, 0x34, 0x0E, 0x41 } },
      }, {
          {  320,  200, 108281,  25568, TRUE,
             { 0x75, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
               0x50, 0x8C, 0x04,
               0x2D, 0x31, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
          {  320,  240, 108281,  25568, TRUE,
             { 0x75, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
               0x50, 0x8C, 0x04,
               0x2D, 0x31, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
          {  400,  300, 108281,  33749, TRUE,
             { 0x75, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
               0x64, 0xAA, 0x04,
               0x3D, 0x41, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
          {  512,  384, 108281,  41931, TRUE,
             { 0x75, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
               0x80, 0xAA, 0x04,
               0x4D, 0x51, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
          {  640,  400, 108281,  51136, TRUE,
             { 0x97, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
               0x5E, 0xBE, 0x04,
               0xCE, 0xD2, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
          {  640,  480, 108281,  51136, TRUE,
             { 0xA7, 0x77, 0x77, 0x9D, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
               0xA0, 0xBE, 0x00,
               0x5F, 0x63, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
          {  800,  600, 108281,  67499, TRUE,
             { 0xA7, 0x77, 0x77, 0x9D, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
               0xC8, 0xBE, 0x00,
               0x7F, 0x83, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
          { 1024,  768, 108281,  85909, TRUE,
            { 0xA7, 0x77, 0x77, 0x9D, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
              0x00, 0xC3, 0x04,
              0xA3, 0xA7, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
          { 1280,  768, 108281, 108281, TRUE,
            { 0x77, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
              0x5E, 0xCA, 0x04,
              0xCE, 0xD2, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
          { 1280,  960, 108281, 108281, TRUE,
            { 0x77, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
              0x5E, 0xCA, 0x04,
              0xCE, 0xD2, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
          { 1280, 1024, 108281, 108281, TRUE,
            { 0x77, 0x77, 0x77, 0x97, 0x75, 0x56, 0xA7, 0x17, 0x29, 0x19, 0x19, 0x29, 0xA4, 0x24, 0x1A, 0x9D,
              0x40, 0xC9, 0x04,
              0xCE, 0xD2, 0x28, 0x19, 0x44, 0x19, 0x29, 0x44, 0x1B, 0x4E } },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x71, 0x9F, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x71, 0x9F, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      }, {
          { 320, 200,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x6C, 0x2D, 0x27, 0x27, 0x91, 0x2A, 0x90, 0xDE, 0x10, 0x40, 0xC9, 0xEC, 0xC7, 0xC7, 0xDF, 0x06,    0, 0x31 },
            18 },
          { 320, 240,
            { 0x11,    0, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x09, 0x10, 0x11, 0x12, 0x15, 0x16, 0x33, 0x35, 0x36 },
            { 0x07, 0x2D, 0x27, 0x27, 0x91, 0x2A, 0x90, 0x05, 0x11, 0x40, 0xF5, 0x87, 0xEF, 0xEF, 0x06, 0x06,    0, 0x31 },
            18 },
       }
    },
    { 1600, 1200, 161795,
      { 0x6F, 0x3F, 0x3F,    0, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
        0x90, 0xFA, 0x04,
        0x09, 0x0D, 0xE0, 0xAF, 0x4C, 0xAF, 0xE1, 0x44, 0xB1, 0x44 },
      {
          {  320,  200, 161795, 161795, FALSE,
             { 0xE0, 0x3F, 0xBF, 0xEF, 0xEB, 0x18, 0xFF, 0xBF, 0xE1, 0xC7, 0xBB, 0xED, 0x12, 0x04, 0xBC, 0x5F,
               0x50, 0xFA, 0x04,
               0x09, 0x0D, 0xE0, 0xC7, 0x0C, 0xC7, 0xE1, 0x04, 0xBD, 0x20 } },
          {  320,  240, 161795, 161795, FALSE,
             { 0xE0, 0x3F, 0xBF, 0xEF, 0xEB, 0x18, 0xFF, 0xBF, 0xE1, 0xEF, 0xCF, 0x01, 0x1A, 0x04, 0xD0, 0x53,
               0x50, 0xFA, 0x04,
               0x09, 0x0D, 0xE0, 0xEF, 0x0C, 0xEF, 0xE1, 0x04, 0xD1, 0x24 } },
          {  400,  300, 161795, 161795, FALSE,
             { 0x09, 0x8F, 0xE7, 0x17, 0x33, 0x18, 0x27, 0xE7, 0xE1, 0x2B, 0xED, 0x1F, 0x9A, 0x0C, 0xEE, 0x51,
               0x64, 0xFA, 0x04,
               0x09, 0x0D, 0xE0, 0x2B, 0x4C, 0x2B, 0xE1, 0x44, 0xEF, 0x22 } },
          {  512,  384, 161795, 161795, FALSE,
             { 0x80, 0xFF, 0x1F, 0x4F, 0x86, 0x18, 0x5F, 0x1F, 0xE1, 0x7F, 0x17, 0x49, 0xE4, 0x24, 0x18, 0x7B,
               0x80, 0xFA, 0x04,
               0x09, 0x0D, 0xE0, 0x7F, 0x4C, 0x7F, 0xE1, 0x44, 0x19, 0x3C } },
          {  640,  400, 161795, 161795, FALSE,
             { 0x8F, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0x8F, 0x1F, 0x51, 0xE4, 0x24, 0x20, 0x63,
               0x90, 0xFA, 0x04,
               0x09, 0x0D, 0xE0, 0x8F, 0x4C, 0x8F, 0xE1, 0x44, 0x21, 0x34 } },
          {  640,  480, 161795, 161795, FALSE,
             { 0xDF, 0x7F, 0x5F, 0x8F, 0x34, 0x28, 0x9F, 0x5F, 0xE1, 0xDF, 0x47, 0x79, 0xDB, 0x0C, 0x48, 0x6B,
               0xA0, 0xFA, 0x00,
               0x09, 0x0D, 0xE0, 0xDF, 0x1C, 0xDF, 0xE1, 0x14, 0x49, 0x3C } },
          {  800,  600, 161795, 161795, FALSE,
             { 0x57, 0x1F, 0xAF, 0xDF, 0x34, 0x38, 0xEF, 0xAF, 0xE1, 0x57, 0x83, 0xB5, 0xDB, 0x14, 0x84, 0x67,
               0xC8, 0xFA, 0x00,
               0x09, 0x0D, 0xE0, 0x57, 0x2C, 0x57, 0xE1, 0x24, 0x85, 0x38 } },
          { 1024,  768, 161795, 161795, FALSE,
            { 0xE0, 0xFF, 0x1F, 0x4F, 0x7D, 0x38, 0x5F, 0x1F, 0xE1, 0xFF, 0xD7, 0x09, 0xA3, 0x14, 0xD8, 0x7B,
              0x00, 0xFA, 0x04,
              0x09, 0x0D, 0xE0, 0xFF, 0x2C, 0xFF, 0xE1, 0x24, 0xD9, 0x3C } },
          { 1280,  768, 161795, 161795, FALSE,
            { 0xD7, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xD7, 0x09, 0xA3, 0x14, 0xD8, 0x7B,
              0x90, 0xFA, 0x04,
              0x09, 0x0D, 0xE0, 0xAF, 0x2C, 0xAF, 0xE1, 0x24, 0xD9, 0x3C } },
          { 1280,  960, 161795, 161795, FALSE,
            { 0x3F, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xBF, 0x37, 0x69, 0xE4, 0x24, 0x38, 0x93,
              0x90, 0xFA, 0x04,
              0x09, 0x0D, 0xE0, 0xBF, 0x4C, 0xBF, 0xE1, 0x44, 0x39, 0x44 } },
          { 1280, 1024, 161795, 161795, FALSE,
            { 0xE0, 0xFF, 0x9F, 0xCF, 0x7D, 0x48, 0xDF, 0x9F, 0xE1, 0xFF, 0x57, 0x89, 0xA4, 0x1C, 0x58, 0x9B,
              0x40, 0xFA, 0x04,
              0x09, 0x0D, 0xE0, 0xFF, 0x3C, 0xFF, 0xE1, 0x34, 0x59, 0x4C } },
          { 1400, 1050, 161795, 161795, FALSE,
            { 0x04, 0x77, 0xDB, 0xFF, 0xBD, 0x58, 0x1B, 0xDB, 0xE1, 0x19, 0x64, 0x96, 0xA4, 0x24, 0x65, 0x88,
              0x5E, 0xFA, 0x04,
              0x09, 0x0D, 0xE0, 0x19, 0x4C, 0x19, 0xE1, 0x44, 0x66, 0x49 } },
      }, {
          {  320,  200, 161795,  31193, TRUE,
             { 0x68, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
               0x50, 0xC8, 0x04,
               0x2F, 0x33, 0xE0, 0xAF, 0x4C, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          {  320,  240, 161795,  31193, TRUE,
             { 0x68, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
               0x50, 0xC8, 0x04,
               0x2F, 0x33, 0xE0, 0xAF, 0x4C, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          {  400,  300, 161795,  39732, TRUE,
             { 0x68, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
               0x64, 0xBE, 0x04,
               0x3D, 0x41, 0xE0, 0xAF, 0x4C, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          {  512,  384, 161795,  49090, TRUE,
             { 0x68, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
               0x80, 0xC8, 0x04,
               0x4D, 0x51, 0xE0, 0xAF, 0x4C, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          {  640,  400, 161795,  56825, TRUE,
             { 0x6F, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
               0x90, 0xFA, 0x04,
               0x09, 0x0D, 0xE0, 0xAF, 0x4C, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          {  640,  480, 161795,  56825, TRUE,
             { 0x3F, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
               0xA0, 0xD8, 0x00,
               0x5A, 0x5E, 0xE0, 0xAF, 0x44, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          {  800,  600, 161795,  79465, TRUE,
             { 0x3F, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
               0xC8, 0xE1, 0x00,
               0x7F, 0x83, 0xE0, 0xAF, 0x44, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          { 1024,  768, 161795, 105954, TRUE,
            { 0x7F, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
              0x00, 0xF0, 0x04,
              0xAB, 0xAF, 0xE0, 0xAF, 0x44, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          { 1280,  768, 161795, 126818, TRUE,
            { 0x6F, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
              0x90, 0xFA, 0x04,
              0x09, 0x0D, 0xE0, 0xAF, 0x4C, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          { 1280,  960, 161795, 126818, TRUE,
            { 0x6F, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
              0x90, 0xFA, 0x04,
              0x09, 0x0D, 0xE0, 0xAF, 0x4C, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          { 1280, 1024, 161795, 126818, TRUE,
            { 0x68, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
              0x40, 0xFA, 0x04,
              0xD0, 0xD4, 0xE0, 0xAF, 0x44, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
          { 1400, 1050, 161795, 144613, TRUE,
            { 0x68, 0x3F, 0x3F, 0x00, 0x86, 0x68, 0x7F, 0x3F, 0xE1, 0xAF, 0xAF, 0xE1, 0xE4, 0x24, 0xB0, 0x93,
              0x5E, 0xFA, 0x04,
              0xED, 0xF1, 0xE0, 0xAF, 0x44, 0xAF, 0xE1, 0x44, 0xB1, 0x44 } },
      }, {
          { 320, 200,
            { 0x09 },
            { 0x40 },
            1 },
          { 320, 240,
            { 0x09 },
            { 0x40 },
            1 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      }, {
          { 320, 200,
            { 0x09 },
            { 0x40 },
            1 },
          { 320, 240,
            { 0x09 },
            { 0x40 },
            1 },
          { 400, 300,
            { 0x09 },
            { 0x60 },
            1 },
      }
    }
};

#endif /* _VIA_PANEL_H_ */
