/*
 * Copyright 2005      Luc Verhaegen.
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_VIDEOREGS_H_
#define _VIA_VIDEOREGS_H_ 1

/*
 * V1/V3 Registers: MapBase + 0x200
 */
struct ViaVideoRegs { 
    volatile CARD32 Flags;              /* 0x200: */
#       define VIA_VIDEO_FLAGS_VBI 0x00000002  /* Vertical blanking */

    volatile CARD32 Status;             /* 0x204: */

    volatile CARD32 AlphaWindowStart;   /* 0x208: */
    volatile CARD32 AlphaWindowEnd;     /* 0x20C: */
    volatile CARD32 AlphaControl;       /* 0x210: */
#       define ALPHA_WIN_EXPIRENUMBER_4        0x00040000
#       define ALPHA_WIN_CONSTANT_FACTOR_4     0x00004000
#       define ALPHA_WIN_CONSTANT_FACTOR_12    0x0000c000
#       define ALPHA_WIN_BLENDING_CONSTANT     0x00000000
#       define ALPHA_WIN_BLENDING_ALPHA        0x00000001
#       define ALPHA_WIN_BLENDING_GRAPHIC      0x00000002
#       define ALPHA_WIN_PREFIFO_THRESHOLD_12  0x000c0000
#       define ALPHA_WIN_FIFO_THRESHOLD_8      0x000c0000
#       define ALPHA_WIN_FIFO_DEPTH_16         0x00100000

    volatile CARD32 CRTC1StartAddress;  /* 0x214: */
    volatile CARD32 CRTC2StartAddress;  /* 0x218: */
    volatile CARD32 AlphaStride;        /* 0x21C: */
    volatile CARD32 ColorKey;           /* 0x220: */
    volatile CARD32 AlphaAddress;       /* 0x224: */
    volatile CARD32 ChromaKeyLow;       /* 0x228: */
#       define V_CHROMAKEY_V3          0x80000000
#       define CHROMA_KEY_LOW          0x00FFFFFF

    volatile CARD32 ChromaKeyHigh;      /* 0x22C: */
#       define CHROMA_KEY_HIGH         0x00FFFFFF

    volatile CARD32 Video1Control;      /* 0x230: */
#       define V1_ENABLE               0x00000001
#       define V1_FULL_SCREEN          0x00000002
#       define V1_YUV422               0x00000000
#       define V1_RGB32                0x00000004
#       define V1_RGB15                0x00000008
#       define V1_RGB16                0x0000000C
#       define V1_YCbCr420             0x00000010
#       define V1_COLORSPACE_SIGN      0x00000080
#       define V1_SRC_IS_FIELD_PIC     0x00000200
#       define V1_SRC_IS_FRAME_PIC     0x00000000
#       define V1_BOB_ENABLE           0x00400000
#       define V1_FIELD_BASE           0x00000000
#       define V1_FRAME_BASE           0x01000000
#       define V1_SWAP_SW              0x00000000
#       define V1_SWAP_HW_HQV          0x02000000
#       define V1_SWAP_HW_CAPTURE      0x04000000
#       define V1_SWAP_HW_MC           0x06000000
/* #       define V1_DOUBLE_BUFFERS       0x00000000 */
/* #       define V1_QUADRUPLE_BUFFERS    0x18000000 */
#       define V1_EXPIRE_NUM           0x00050000
#       define V1_EXPIRE_NUM_A         0x000a0000
#       define V1_EXPIRE_NUM_F         0x000f0000 /* jason */
#       define V1_FIFO_EXTENDED        0x00200000
#       define V1_ON_CRT               0x00000000
#       define V1_ON_SND_DISPLAY       0x80000000
#       define V1_FIFO_32V1_32V2       0x00000000
#       define V1_FIFO_48V1_32V2       0x00200000

    volatile CARD32 Video1Fetch;        /* 0x234: */
#       define V1_FETCH_COUNT          0x3ff00000
#       define V1_FETCHCOUNT_ALIGNMENT 0x0000000f
#       define V1_FETCHCOUNT_UNIT      0x00000004   /* Doubld QWORD */

    volatile CARD32 Video1Address1;     /* 0x238: */
    volatile CARD32 Video1Stride;       /* 0x23C: */
#       define V1_STRIDE_YMASK         0x00001fff
#       define V1_STRIDE_UVMASK        0x1ff00000

    volatile CARD32 Video1WindowStart;  /* 0x240: */
    volatile CARD32 Video1WindowEnd;    /* 0x244: */
    volatile CARD32 Video1Address2;     /* 0x248: */
    volatile CARD32 Video1Zoom;         /* 0x24C: */
#       define V1_X_ZOOM_ENABLE        0x80000000
#       define V1_Y_ZOOM_ENABLE        0x00008000

    volatile CARD32 Video1Minify;       /* 0x250: */
#       define V1_X_INTERPOLY          0x00000002  /* X interpolation */
#       define V1_Y_INTERPOLY          0x00000001  /* Y interpolation */
#       define V1_YCBCR_INTERPOLY      0x00000004  /* Y, Cb, Cr all interpolation */
#       define V1_X_DIV_2              0x01000000
#       define V1_X_DIV_4              0x03000000
#       define V1_X_DIV_8              0x05000000
#       define V1_X_DIV_16             0x07000000
#       define V1_Y_DIV_2              0x00010000
#       define V1_Y_DIV_4              0x00030000
#       define V1_Y_DIV_8              0x00050000
#       define V1_Y_DIV_16             0x00070000

    volatile CARD32 Video1Address0;     /* 0x254: */
#       define SW_FLIP_ODD             0x08000000

    volatile CARD32 Video1Fifo;         /* 0x258: */
    /* IA2 has 32 level FIFO for packet mode video format
     *         32 level FIFO for planar mode video YV12. with extension reg 230 bit 21 enable
     *         16 level FIFO for planar mode video YV12. with extension reg 230 bit 21 disable
     * BCos of 128 bits. 1 level in IA2 = 2 level in VT3122
     */
#       define V1_FIFO_MASK  0x3F003F3F    

    volatile CARD32 Video1Address3;     /* 0x25C: */
    volatile CARD32 HighControl;        /* 0x260: */
    volatile CARD32 ColorKeySecond;     /* 0x264: */
    volatile CARD32 Video3AlphaPreFifo; /* 0x268: */
#       define V3_PREFIFO_MASK         0x0000007F

    volatile CARD32 Video1SrcSize;      /* 0x26C: */
    volatile CARD32 AlphaColorHigh;     /* 0x270: */
    volatile CARD32 Video1DisplayTemp;  /* 0x274: */
    volatile CARD32 Video3AlphaFifo;    /* 0x278: */
    /* IA2 has 32 level FIFO for packet mode video format
     *         32 level FIFO for planar mode video YV12. with extension reg 230 bit 21 enable
     *         16 level FIFO for planar mode video YV12. with extension reg 230 bit 21 disable
     *          8 level FIFO for ALPHA
     * BCos of 128 bits. 1 level in IA2 = 2 level in VT3122
     */
#       define V3_FIFO_MASK            0x0000FFFF
#       define ALPHA_FIFO_DEPTH8       0x00070000
#       define ALPHA_FIFO_THRESHOLD4   0x04000000
#       define ALPHA_FIFO_MASK         0xFFFF0000
#       define ALPHA_FIFO_PRETHRESHOLD4 0x00040000

    volatile CARD32 Video3SrcWidth;     /* 0x27C: */
    volatile CARD32 Video3ColorKey;     /* 0x280: */
    volatile CARD32 Video1ColorSpace1;  /* 0x284: */
    volatile CARD32 Video1ColorSpace2;  /* 0x288: */
    volatile CARD32 Video1UAddress0;    /* 0x28c: */
    volatile CARD32 Video1Opacity;      /* 0x290: */
    volatile CARD32 Video3Opacity;      /* 0x294: */
    volatile CARD32 Compose;            /* 0x298: */
#       define SELECT_VIDEO_IF_COLOR_KEY   0x00000001  /* select video if (color key),otherwise select graphics */
#       define SELECT_VIDEO3_IF_COLOR_KEY  0x00000020  /* For 3123C0, select video3 if (color key),otherwise select graphics */
#       define SELECT_VIDEO_IF_CHROMA_KEY  0x00000002  /* 0x0000000a  //select video if (chroma key ),otherwise select graphics */
#       define ALWAYS_SELECT_VIDEO         0x00000000  /* always select video,Chroma key and Color key disable */
#       define COMPOSE_V1_V3           0x00000000  /* V1 on top of V3 */
#       define COMPOSE_V3_V1           0x00100000  /* V3 on top of V1 */
#       define COMPOSE_V1_TOP          0x00000000
#       define COMPOSE_V3_TOP          0x00100000
#       define V1_COMMAND_FIRE         0x80000000  /* V1 commands fire */
#       define V3_COMMAND_FIRE         0x40000000  /* V3 commands fire */
#       define V_COMMAND_LOAD          0x20000000  /* Video register always loaded */
#       define V_COMMAND_LOAD_VBI      0x10000000  /* Video register always loaded at vbi without waiting source flip */
#       define V3_COMMAND_LOAD         0x08000000  /* CLE_C0 Video3 register always loaded */
#       define V3_COMMAND_LOAD_VBI     0x00000100  /* CLE_C0 Video3 register always loaded at vbi without waiting source flip */
#       define SECOND_DISPLAY_COLOR_KEY_ENABLE  0x00010000

    volatile CARD32 Video3Address2;     /* 0x29c: */
    volatile CARD32 Video3Control;      /* 0x2A0: */
#       define V3_ENABLE               0x00000001
#       define V3_FULL_SCREEN          0x00000002
#       define V3_YUV422               0x00000000
#       define V3_RGB32                0x00000004
#       define V3_RGB15                0x00000008
#       define V3_RGB16                0x0000000C
#       define V3_COLORSPACE_SIGN      0x00000080
#       define V3_EXPIRE_NUM           0x00040000
#       define V3_EXPIRE_NUM_F         0x000f0000
#       define V3_EXPIRE_NUM_3108      0x00100000
#       define V3_EXPIRE_NUM_7205      0x00080000
#       define V3_BOB_ENABLE           0x00400000
#       define V3_FIELD_BASE           0x00000000
#       define V3_FRAME_BASE           0x01000000
#       define V3_SWAP_SW              0x00000000
#       define V3_SWAP_HW_HQV          0x02000000
#       define V3_FLIP_HW_CAPTURE0     0x04000000
#       define V3_FLIP_HW_CAPTURE1     0x06000000
#       define V3_PREFETCH             0x40000000 /* For VT3108 */

    volatile CARD32 Video3Address0;     /* 0x2A4: */
    volatile CARD32 Video3Address1;     /* 0x2A8: */
    volatile CARD32 Video3Stride;       /* 0x2Ac: */
    volatile CARD32 Video3WindowStart;  /* 0x2B0: */
    volatile CARD32 Video3WindowEnd;    /* 0x2B4: */
    volatile CARD32 Video3AlphaFetch;   /* 0x2B8: */
#       define V3_FETCH_COUNT          0x3ff00000
#       define ALPHA_FETCH_COUNT       0x000003ff

    volatile CARD32 Video3Zoom;         /* 0x2BC: */
#       define V3_X_ZOOM_ENABLE        0x80000000
#       define V3_Y_ZOOM_ENABLE        0x00008000

    volatile CARD32 Video3Minify;       /* 0x2C0: */
#       define V3_X_INTERPOLY          0x00000002  /* X interpolation */
#       define V3_Y_INTERPOLY          0x00000001  /* Y interpolation */
#       define V3_YCBCR_INTERPOLY      0x00000004  /* Y, Cb, Cr all interpolation */

    volatile CARD32 Video3ColorSpace1;  /* 0x2C4: */
    volatile CARD32 Video3ColorSpace2;  /* 0x2C8: */
    volatile CARD32 Video3DisplayTemp;  /* 0x2CC: */
    volatile CARD32 reserved[5];        /* 0x2D0: */
    volatile CARD32 Video1UAddress1;    /* 0x2E4: */
    volatile CARD32 Video1UAddress2;    /* 0x2E8: */
    volatile CARD32 Video1UAddress3;    /* 0x2EC: */
    volatile CARD32 Video1VAddress0;    /* 0x2F0: */
    volatile CARD32 Video1VAddress1;    /* 0x2F4: */
    volatile CARD32 Video1VAddress2;    /* 0x2F8: */
    volatile CARD32 Video1VAddress3;    /* 0x2FC: */
};

/*
 * HQV Registers: MapBase + 0x200 + 0x1D0
 */
struct ViaHQVRegs {
    volatile CARD32 Control;     /* 0x1D0: */
#       define HQV_RGB32           0x00000000
#       define HQV_RGB16           0x20000000
#       define HQV_RGB15           0x30000000
#       define HQV_YUV422          0x80000000
#       define HQV_YUV420          0xC0000000
#       define HQV_ENABLE          0x08000000
#       define HQV_SRC_SW          0x00000000
#       define HQV_SRC_MC          0x01000000
#       define HQV_SRC_CAPTURE0    0x02000000
#       define HQV_SRC_CAPTURE1    0x03000000
#       define HQV_FLIP_EVEN       0x00000000
#       define HQV_FLIP_ODD        0x00000020
#       define HQV_SW_FLIP         0x00000010 /* Write 1 to flip HQV buffer */
#       define HQV_DEINTERLACE     0x00010000 /* First line of odd field will be repeated 3 times */
#       define HQV_FIELD_2_FRAME   0x00020000 /* Src is field. Display each line 2 times */
#       define HQV_FRAME_2_FIELD   0x00040000 /* Src is field. Display field */
#       define HQV_FRAME_UV        0x00000000 /* Src is Non-interleaved */
#       define HQV_FIELD_UV        0x00100000 /* Src is interleaved */
#       define HQV_IDLE            0x00000008
#       define HQV_FLIP_STATUS     0x00000001
#       define HQV_DOUBLE_BUFF     0x00000000
#       define HQV_TRIPLE_BUFF     0x04000000
#       define HQV_SUBPIC_FLIP     0x00008000
#       define HQV_FIFO_STATUS     0x00001000

    volatile CARD32 SrcAddressY; /* 0x1D4: */
    volatile CARD32 SrcAddressU; /* 0x1D8: */
    volatile CARD32 SrcAddressV; /* 0x1DC: */
    volatile CARD32 SrcFetch;    /* 0x1E0: */
    volatile CARD32 Filter;      /* 0x1E4: */
#       define HQV_H_LOWPASS_2TAP      0x00000001
#       define HQV_H_LOWPASS_4TAP      0x00000002
#       define HQV_H_LOWPASS_8TAP1     0x00000003
#       define HQV_H_LOWPASS_8TAP2     0x00000004
#       define HQV_H_HIGH_PASS         0x00000008
#       define HQV_H_LOW_PASS          0x00000000
#       define HQV_H_HIPASS_F1_DEFAULT 0x00000040
#       define HQV_H_HIPASS_F1_2TAP    0x00000050
#       define HQV_H_HIPASS_F1_4TAP    0x00000060
#       define HQV_H_HIPASS_F1_8TAP    0x00000080
#       define HQV_H_HIPASS_F2_DEFAULT 0x00000000
#       define HQV_H_HIPASS_F2_2TAP    0x00000100
#       define HQV_H_HIPASS_F2_4TAP    0x00000200
#       define HQV_H_HIPASS_F2_8TAP    0x00000400

#       define HQV_H_TAP4_121          0x00000042
#       define HQV_H_TAP8_12221        0x00000402

#       define HQV_V_LOWPASS_2TAP      0x00010000
#       define HQV_V_LOWPASS_4TAP      0x00020000
#       define HQV_V_LOWPASS_8TAP1     0x00030000
#       define HQV_V_LOWPASS_8TAP2     0x00040000
#       define HQV_V_HIGH_PASS         0x00080000
#       define HQV_V_LOW_PASS          0x00000000
#       define HQV_V_HIPASS_F1_DEFAULT 0x00400000
#       define HQV_V_HIPASS_F1_2TAP    0x00500000
#       define HQV_V_HIPASS_F1_4TAP    0x00600000
#       define HQV_V_HIPASS_F1_8TAP    0x00800000
#       define HQV_V_HIPASS_F2_DEFAULT 0x00000000
#       define HQV_V_HIPASS_F2_2TAP    0x01000000
#       define HQV_V_HIPASS_F2_4TAP    0x02000000
#       define HQV_V_HIPASS_F2_8TAP    0x04000000

#       define HQV_V_TAP4_121          0x00420000
#       define HQV_V_TAP8_12221        0x04020000

    volatile CARD32 Minify;      /* 0x1E8: */
#       define HQV_H_MINIFY_ENABLE  0x00000800
#       define HQV_V_MINIFY_ENABLE  0x08000000
#       define HQV_VDEBLOCK_FILTER  0x80000000
#       define HQV_HDEBLOCK_FILTER  0x00008000

    volatile CARD32 DstAddress0; /* 0x1EC: */
    volatile CARD32 DstAddress1; /* 0x1F0: */
    volatile CARD32 DstStride;   /* 0x1F4: */
    volatile CARD32 SrcStride;   /* 0x1F8: */
    volatile CARD32 DstAddress2; /* 0x1FC: */
};

#endif /* _VIA_VIDEOREGS_H_ */
