#include <time.h>
#include <sys/time.h>
#include "bool.h"

float
put_time()
{
    static struct timeval tpbase;
    struct timeval  tp;
    struct timezone tzp;
    float           t;
    long            usec, sec;
    static boolean_t     init = B_TRUE;
 
    if (init) {
        gettimeofday(&tpbase, &tzp);
        init = B_FALSE;
        return (float)0;
    }
    gettimeofday(&tp, &tzp);
 
    usec = tp.tv_usec - tpbase.tv_usec;
    sec = tp.tv_sec - tpbase.tv_sec;
 
    t = (float) (sec * 1000000 + usec) / 1000000.;
 
    return t;
}
