/*
 * 1998/04/25
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __XYAKU_XYAKU_H__
#define __XYAKU_XYAKU_H__

/* Atoms */
#define XA_TEXT				XInternAtom(dpy, "TEXT", False)
#define XA_COMPOUND_TEXT	XInternAtom(dpy, "COMPOUND_TEXT", False)
#define XA_CLIPBOARD		XInternAtom(dpy, "CLIPBOARD", False)
#define XA_TARGETS			XInternAtom(dpy, "TARGETS", False)


/* Structure definitions */
typedef struct _appRes{
	Pixel	foreground_pixel;
	XFontSet	fontset;
	char *confpath;
	Dimension max_width;
	int interval;
	int parse_msg;	/* for debug */
} AppResourcesRec, *AppResources;


typedef unsigned char	uchar;
typedef struct _XPopup XPopup; /* xpopup.h */


/* Global variables */
extern XtAppContext	app;
extern Display *dpy;
extern AppResourcesRec appResources;	/* application specific resources */


/* Global functions */
/* event.c */
extern void mainloop(XPopup *xpop);

/* xcomm.c */
extern void req_selection(Atom selection, Atom target, Atom prop, const Window w, const Time time);
extern uchar *get_selected_string(const XEvent *pxev, const Window w);

/* exec.c */
extern int exec_addin_cmd(const char *addin_cmd, char **argv, const uchar *target, uchar *retbuf, int size_buf);

#endif /* __XYAKU_XYAKU_H__ */
