/* Generated by re2c 0.9.1-C on Sat Oct 30 21:13:56 2004
 */
#line 1 "./modules/parsers/nasm/nasm-token.re"
/*
 * NASM-compatible re2c lexer
 *
 *  Copyright (C) 2001  Peter Johnson
 *
 *  Portions based on re2c's example code.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND OTHER CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR OTHER CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <util.h>
RCSID("$Id: nasm-token.re 1152 2004-10-02 06:18:30Z peter $");

#define YASM_LIB_INTERNAL
#include <libyasm.h>

#include "modules/parsers/nasm/nasm-parser.h"
#include "modules/parsers/nasm/nasm-defs.h"


#define BSIZE	8192

#define YYCURSOR	cursor
#define YYLIMIT		(s->lim)
#define YYMARKER	(s->ptr)
#define YYFILL(n)	{cursor = fill(parser_nasm, cursor);}

#define RETURN(i)	{s->cur = cursor; return i;}

#define SCANINIT()	{ \
	s->tchar = cursor - s->pos; \
	s->tline = s->cline; \
	s->tok = cursor; \
    }

#define TOKLEN		(size_t)(cursor-s->tok)


static YYCTYPE *
fill(yasm_parser_nasm *parser_nasm, YYCTYPE *cursor)
{
    Scanner *s = &parser_nasm->s;
    int first = 0;
    if(!s->eof){
	size_t cnt = s->tok - s->bot;
	if(cnt){
	    memcpy(s->bot, s->tok, (size_t)(s->lim - s->tok));
	    s->tok = s->bot;
	    s->ptr -= cnt;
	    cursor -= cnt;
	    s->pos -= cnt;
	    s->lim -= cnt;
	}
	if (!s->bot)
	    first = 1;
	if((s->top - s->lim) < BSIZE){
	    char *buf = yasm_xmalloc((size_t)(s->lim - s->bot) + BSIZE);
	    memcpy(buf, s->tok, (size_t)(s->lim - s->tok));
	    s->tok = buf;
	    s->ptr = &buf[s->ptr - s->bot];
	    cursor = &buf[cursor - s->bot];
	    s->pos = &buf[s->pos - s->bot];
	    s->lim = &buf[s->lim - s->bot];
	    s->top = &s->lim[BSIZE];
	    if (s->bot)
		yasm_xfree(s->bot);
	    s->bot = buf;
	}
	if((cnt = yasm_preproc_input(parser_nasm->preproc, s->lim,
				     BSIZE)) == 0) {
	    s->eof = &s->lim[cnt]; *s->eof++ = '\n';
	}
	s->lim += cnt;
	if (first && parser_nasm->save_input) {
	    int i;
	    char *saveline;
	    parser_nasm->save_last ^= 1;
	    saveline = parser_nasm->save_line[parser_nasm->save_last];
	    /* save next line into cur_line */
	    for (i=0; i<79 && &s->tok[i] < s->lim && s->tok[i] != '\n'; i++)
		saveline[i] = s->tok[i];
	    saveline[i] = '\0';
	}
    }
    return cursor;
}

static YYCTYPE *
save_line(yasm_parser_nasm *parser_nasm, YYCTYPE *cursor)
{
    Scanner *s = &parser_nasm->s;
    int i = 0;
    char *saveline;

    parser_nasm->save_last ^= 1;
    saveline = parser_nasm->save_line[parser_nasm->save_last];

    /* save next line into cur_line */
    if ((YYLIMIT - YYCURSOR) < 80)
	YYFILL(80);
    for (i=0; i<79 && &cursor[i] < s->lim && cursor[i] != '\n'; i++)
	saveline[i] = cursor[i];
    saveline[i] = '\0';
    return cursor;
}

void
nasm_parser_cleanup(yasm_parser_nasm *parser_nasm)
{
    if (parser_nasm->s.bot)
	yasm_xfree(parser_nasm->s.bot);
}

/* starting size of string buffer */
#define STRBUF_ALLOC_SIZE	128

/* string buffer used when parsing strings/character constants */
static char *strbuf = (char *)NULL;

/* length of strbuf (including terminating NULL character) */
static size_t strbuf_size = 0;

static int linechg_numcount;

#line 178 "./modules/parsers/nasm/nasm-token.re"



int
nasm_parser_lex(YYSTYPE *lvalp, yasm_parser_nasm *parser_nasm)
{
    Scanner *s = &parser_nasm->s;
    YYCTYPE *cursor = s->cur;
    YYCTYPE endch;
    size_t count, len;
    YYCTYPE savech;
    yasm_arch_check_id_retval check_id_ret;

    /* Catch EOF */
    if (s->eof && cursor == s->eof)
	return 0;

    /* Jump to proper "exclusive" states */
    switch (parser_nasm->state) {
	case DIRECTIVE:
	    goto directive;
	case LINECHG:
	    goto linechg;
	case LINECHG2:
	    goto linechg2;
	default:
	    break;
    }

scan:
    SCANINIT();

    
#line 181 "nasm-token.c"
{
	YYCTYPE yych;
	unsigned int yyaccept;
	static unsigned char yybm[] = {
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   6,   0,   4,   4,   6,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  6,   4,   4,  12,  12,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,  12,   4, 
	252, 252, 124, 124, 124, 124, 124, 124, 
	 60,  60,   4,   4,   4,   4,   4,  12, 
	 12,  28,  28,  28,  28,  28,  28,  12, 
	 12,  12,  12,  12,  12,  12,  12,  12, 
	 12,  12,  12,  12,  12,  12,  12,  12, 
	 12,  12,  12,   4,   4,   4,   4,  12, 
	  4,  28,  28,  28,  28,  28,  28,  12, 
	 12,  12,  12,  12,  12,  12,  12,  12, 
	 12,  12,  12,  12,  12,  12,  12,  12, 
	 12,  12,  12,   4,   4,   4,  12,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	};
	goto yy0;
	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	switch(yych){
	case '\t':	case '\r':	case ' ':	goto yy35;
	case '\n':	goto yy37;
	case '"':	case '\'':	goto yy9;
	case '$':	goto yy7;
	case '%':	goto yy11;
	case '&':	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':	case ':':	case '=':	case '[':	case '^':	case '|':	case '~':	goto yy28;
	case '.':	goto yy31;
	case '/':	goto yy27;
	case '0':	goto yy2;
	case '1':	goto yy4;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy5;
	case '8':
	case '9':	goto yy6;
	case ';':	goto yy33;
	case '<':	goto yy24;
	case '>':	goto yy26;
	case '?':	case 'A':	case 'C':	case 'F':
	case 'G':	case 'J':
	case 'K':
	case 'L':
	case 'M':	case 'O':
	case 'P':	case 'U':
	case 'V':	case 'X':
	case 'Y':
	case 'Z':	case '_':	case 'a':	case 'c':	case 'f':
	case 'g':	case 'j':
	case 'k':
	case 'l':
	case 'm':	case 'o':
	case 'p':	case 'u':
	case 'v':	case 'x':
	case 'y':
	case 'z':	goto yy32;
	case 'B':	case 'b':	goto yy12;
	case 'D':	case 'd':	goto yy16;
	case 'E':	case 'e':	goto yy21;
	case 'H':	case 'h':	goto yy14;
	case 'I':	case 'i':	goto yy20;
	case 'N':	case 'n':	goto yy23;
	case 'Q':	case 'q':	goto yy17;
	case 'R':	case 'r':	goto yy19;
	case 'S':	case 's':	goto yy22;
	case 'T':	case 't':	goto yy18;
	case 'W':	case 'w':	goto yy15;
	case ']':	goto yy29;
	default:	goto yy39;
	}
yy2:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 128)	goto yy184;
	if(yych <= 'a'){
		if(yych <= '7'){
			if(yych == '.')	goto yy167;
			if(yych >= '0')	goto yy180;
		} else {
			if(yych <= '@'){
				if(yych <= '9')	goto yy170;
			} else {
				if(yych <= 'F')	goto yy172;
				if(yych >= 'a')	goto yy172;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'b')	goto yy186;
			if(yych <= 'f')	goto yy172;
			if(yych >= 'h')	goto yy174;
		} else {
			if(yych <= 'q'){
				if(yych >= 'q')	goto yy182;
			} else {
				if(yych == 'x')	goto yy163;
			}
		}
	}
yy3:
#line 212 "./modules/parsers/nasm/nasm-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->intn = yasm_intnum_create_dec(s->tok, cur_line);
	    s->tok[TOKLEN] = savech;
	    RETURN(INTNUM);
	}
#line 319 "nasm-token.c"
yy4:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 128)	goto yy184;
	if(yych <= '`'){
		if(yych <= '7'){
			if(yych == '.')	goto yy167;
			if(yych <= '/')	goto yy3;
			goto yy180;
		} else {
			if(yych <= '9')	goto yy170;
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy172;
			goto yy3;
		}
	} else {
		if(yych <= 'g'){
			if(yych == 'b')	goto yy186;
			if(yych <= 'f')	goto yy172;
			goto yy3;
		} else {
			if(yych <= 'h')	goto yy174;
			if(yych == 'q')	goto yy182;
			goto yy3;
		}
	}
yy5:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 64)	goto yy180;
	if(yych <= 'F'){
		if(yych <= '/'){
			if(yych == '.')	goto yy167;
			goto yy3;
		} else {
			if(yych <= '9')	goto yy170;
			if(yych <= '@')	goto yy3;
			goto yy172;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '`')	goto yy3;
			if(yych <= 'f')	goto yy172;
			goto yy3;
		} else {
			if(yych <= 'h')	goto yy174;
			if(yych == 'q')	goto yy182;
			goto yy3;
		}
	}
yy6:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= '.'){
			if(yych <= '-')	goto yy3;
			goto yy167;
		} else {
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy170;
			goto yy3;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'F')	goto yy172;
			if(yych <= '`')	goto yy3;
			goto yy172;
		} else {
			if(yych == 'h')	goto yy174;
			goto yy3;
		}
	}
yy7:	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '?'){
		if(yych <= '/'){
			if(yych == '$')	goto yy161;
		} else {
			if(yych <= '9')	goto yy163;
			if(yych >= '?')	goto yy158;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '@')	goto yy8;
			if(yych <= 'Z')	goto yy158;
		} else {
			if(yych == '`')	goto yy8;
			if(yych <= 'z')	goto yy158;
		}
	}
yy8:
#line 365 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(s->tok[0]); }
#line 410 "nasm-token.c"
yy9:	yych = *++YYCURSOR;

#line 265 "./modules/parsers/nasm/nasm-token.re"
{
	    endch = s->tok[0];
	    goto stringconst;
	}
#line 418 "nasm-token.c"
yy11:	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '%')	goto yy151;
	if(yych == 'l')	goto yy153;
	goto yy8;
yy12:	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy147;
	if(yych == 'y')	goto yy147;
	goto yy45;
yy13:
#line 409 "./modules/parsers/nasm/nasm-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    check_id_ret = yasm_arch_parse_check_id(parser_nasm->arch,
						    lvalp->arch_data, s->tok,
						    cur_line);
	    s->tok[TOKLEN] = savech;
	    switch (check_id_ret) {
		case YASM_ARCH_CHECK_ID_NONE:
		    /* Just an identifier, return as such. */
		    lvalp->str_val = yasm__xstrndup(s->tok, TOKLEN);
		    RETURN(ID);
		case YASM_ARCH_CHECK_ID_INSN:
		    RETURN(INSN);
		case YASM_ARCH_CHECK_ID_PREFIX:
		    RETURN(PREFIX);
		case YASM_ARCH_CHECK_ID_REG:
		    RETURN(REG);
		case YASM_ARCH_CHECK_ID_SEGREG:
		    RETURN(SEGREG);
		case YASM_ARCH_CHECK_ID_TARGETMOD:
		    RETURN(TARGETMOD);
		default:
		    yasm__warning(YASM_WARN_GENERAL, cur_line,
			N_("Arch feature not supported, treating as identifier"));
		    lvalp->str_val = yasm__xstrndup(s->tok, TOKLEN);
		    RETURN(ID);
	    }
	}
#line 459 "nasm-token.c"
yy14:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy142;
	if(yych == 'w')	goto yy142;
	goto yy45;
yy15:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'O')	goto yy135;
		if(yych <= 'Q')	goto yy45;
		goto yy136;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy45;
			goto yy135;
		} else {
			if(yych == 'r')	goto yy136;
			goto yy45;
		}
	}
yy16:	yych = *++YYCURSOR;
	switch(yych){
	case 'B':	case 'b':	goto yy111;
	case 'D':	case 'd':	goto yy113;
	case 'H':	case 'h':	goto yy115;
	case 'Q':	case 'q':	goto yy116;
	case 'T':	case 't':	goto yy118;
	case 'W':	case 'w':	goto yy120;
	default:	goto yy45;
	}
yy17:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy106;
	if(yych == 'w')	goto yy106;
	goto yy45;
yy18:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych == 'I')	goto yy96;
		if(yych <= 'V')	goto yy45;
		goto yy97;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy45;
			goto yy96;
		} else {
			if(yych == 'w')	goto yy97;
			goto yy45;
		}
	}
yy19:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy79;
	if(yych == 'e')	goto yy79;
	goto yy45;
yy20:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy73;
	if(yych == 'n')	goto yy73;
	goto yy45;
yy21:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy70;
	if(yych == 'q')	goto yy70;
	goto yy45;
yy22:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy67;
	if(yych == 'e')	goto yy67;
	goto yy45;
yy23:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy60;
	if(yych == 'o')	goto yy60;
	goto yy45;
yy24:	yych = *++YYCURSOR;
	if(yych == '<')	goto yy58;
yy25:
#line 450 "./modules/parsers/nasm/nasm-token.re"
{
	    yasm__warning(YASM_WARN_UNREC_CHAR, cur_line,
			  N_("ignoring unrecognized character `%s'"),
			  yasm__conv_unprint(s->tok[0]));
	    goto scan;
	}
#line 536 "nasm-token.c"
yy26:	yych = *++YYCURSOR;
	if(yych == '>')	goto yy56;
	goto yy25;
yy27:	yych = *++YYCURSOR;
	if(yych == '/')	goto yy54;
	goto yy8;
yy28:	yych = *++YYCURSOR;
	goto yy8;
yy29:	yych = *++YYCURSOR;

#line 368 "./modules/parsers/nasm/nasm-token.re"
{
	    if (parser_nasm->state == DIRECTIVE2)
		parser_nasm->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 553 "nasm-token.c"
yy31:	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy25;
			if(yych <= '$')	goto yy46;
			goto yy25;
		} else {
			if(yych <= '.')	goto yy49;
			if(yych <= '/')	goto yy25;
			if(yych <= '9')	goto yy46;
			goto yy25;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy46;
			if(yych == '_')	goto yy46;
			goto yy25;
		} else {
			if(yych <= 'z')	goto yy46;
			if(yych == '~')	goto yy46;
			goto yy25;
		}
	}
yy32:	yych = *++YYCURSOR;
	goto yy45;
yy33:	yych = *++YYCURSOR;
	goto yy43;
yy34:
#line 439 "./modules/parsers/nasm/nasm-token.re"
{ goto scan; }
#line 585 "nasm-token.c"
yy35:	yych = *++YYCURSOR;
	goto yy41;
yy36:
#line 441 "./modules/parsers/nasm/nasm-token.re"
{ goto scan; }
#line 591 "nasm-token.c"
yy37:	yych = *++YYCURSOR;

#line 443 "./modules/parsers/nasm/nasm-token.re"
{
	    if (parser_nasm->save_input && cursor != s->eof)
		cursor = save_line(parser_nasm, cursor);
	    parser_nasm->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 601 "nasm-token.c"
yy39:	yych = *++YYCURSOR;
	goto yy25;
yy40:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy41:	if(yybm[0+yych] & 2)	goto yy40;
	goto yy36;
yy42:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy43:	if(yybm[0+yych] & 4)	goto yy42;
	goto yy34;
yy44:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy45:	if(yybm[0+yych] & 8)	goto yy44;
	goto yy13;
yy46:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy48;
			if(yych <= '$')	goto yy46;
		} else {
			if(yych == '/')	goto yy48;
			if(yych <= '9')	goto yy46;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy46;
			if(yych == '_')	goto yy46;
		} else {
			if(yych <= 'z')	goto yy46;
			if(yych == '~')	goto yy46;
		}
	}
yy48:
#line 381 "./modules/parsers/nasm/nasm-token.re"
{
	    /* override local labels in directive state */
	    if (parser_nasm->state == DIRECTIVE2) {
		lvalp->str_val = yasm__xstrndup(s->tok, TOKLEN);
		RETURN(ID);
	    } else if (!parser_nasm->locallabel_base) {
		lvalp->str_val = yasm__xstrndup(s->tok, TOKLEN);
		yasm__warning(YASM_WARN_GENERAL, cur_line,
			      N_("no non-local label before `%s'"),
			      lvalp->str_val);
	    } else {
		len = TOKLEN + parser_nasm->locallabel_base_len;
		lvalp->str_val = yasm_xmalloc(len + 1);
		strcpy(lvalp->str_val, parser_nasm->locallabel_base);
		strncat(lvalp->str_val, s->tok, TOKLEN);
		lvalp->str_val[len] = '\0';
	    }

	    RETURN(LOCAL_ID);
	}
#line 661 "nasm-token.c"
yy49:	yych = *++YYCURSOR;
	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy50;
			if(yych <= '$')	goto yy51;
		} else {
			if(yych == '/')	goto yy50;
			if(yych <= '9')	goto yy51;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy51;
		} else {
			if(yych <= 'z')	goto yy51;
			if(yych == '~')	goto yy51;
		}
	}
yy50:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 0:	goto yy3;
	case 4:	goto yy187;
	case 3:	goto yy169;
	case 1:	goto yy8;
	case 2:	goto yy25;
	}
yy51:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy53;
			if(yych <= '$')	goto yy51;
		} else {
			if(yych == '/')	goto yy53;
			if(yych <= '9')	goto yy51;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy51;
		} else {
			if(yych <= 'z')	goto yy51;
			if(yych == '~')	goto yy51;
		}
	}
yy53:
#line 375 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->str_val = yasm__xstrndup(s->tok, TOKLEN);
	    RETURN(SPECIAL_ID);
	}
#line 714 "nasm-token.c"
yy54:	yych = *++YYCURSOR;

#line 362 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(SIGNDIV); }
#line 719 "nasm-token.c"
yy56:	yych = *++YYCURSOR;

#line 361 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(RIGHT_OP); }
#line 724 "nasm-token.c"
yy58:	yych = *++YYCURSOR;

#line 360 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(LEFT_OP); }
#line 729 "nasm-token.c"
yy60:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy61;
	if(yych != 's')	goto yy45;
yy61:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy62;
	if(yych != 'p')	goto yy45;
yy62:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy63;
	if(yych != 'l')	goto yy45;
yy63:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy64;
	if(yych != 'i')	goto yy45;
yy64:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy65;
	if(yych != 't')	goto yy45;
yy65:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 357 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(NOSPLIT); }
#line 750 "nasm-token.c"
yy67:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy68;
	if(yych != 'g')	goto yy45;
yy68:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 354 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(SEG); }
#line 759 "nasm-token.c"
yy70:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy71;
	if(yych != 'u')	goto yy45;
yy71:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 350 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(EQU); }
#line 768 "nasm-token.c"
yy73:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy74;
	if(yych != 'c')	goto yy45;
yy74:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy75;
	if(yych != 'b')	goto yy45;
yy75:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy76;
	if(yych != 'i')	goto yy45;
yy76:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy77;
	if(yych != 'n')	goto yy45;
yy77:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 348 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(INCBIN); }
#line 786 "nasm-token.c"
yy79:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy80;
	if(yych != 's')	goto yy45;
yy80:	yych = *++YYCURSOR;
	switch(yych){
	case 'B':	case 'b':	goto yy81;
	case 'D':	case 'd':	goto yy83;
	case 'H':	case 'h':	goto yy85;
	case 'Q':	case 'q':	goto yy86;
	case 'T':	case 't':	goto yy88;
	case 'W':	case 'w':	goto yy90;
	default:	goto yy45;
	}
yy81:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 325 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 1; RETURN(RESERVE_SPACE); }
#line 805 "nasm-token.c"
yy83:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych <= '.'){
			if(yych <= '"')	goto yy84;
			if(yych <= '$')	goto yy44;
			if(yych >= '.')	goto yy44;
		} else {
			if(yych <= '9'){
				if(yych >= '0')	goto yy44;
			} else {
				if(yych <= '>')	goto yy84;
				if(yych <= 'P')	goto yy44;
				goto yy94;
			}
		}
	} else {
		if(yych <= 'p'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy44;
			} else {
				if(yych != '`')	goto yy44;
			}
		} else {
			if(yych <= 'z'){
				if(yych <= 'q')	goto yy94;
				goto yy44;
			} else {
				if(yych == '~')	goto yy44;
			}
		}
	}
yy84:
#line 334 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*2;
	    RETURN(RESERVE_SPACE);
	}
#line 843 "nasm-token.c"
yy85:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy92;
	if(yych == 'w')	goto yy92;
	goto yy45;
yy86:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 338 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*4;
	    RETURN(RESERVE_SPACE);
	}
#line 856 "nasm-token.c"
yy88:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 342 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 10; RETURN(RESERVE_SPACE); }
#line 862 "nasm-token.c"
yy90:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 330 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch);
	    RETURN(RESERVE_SPACE);
	}
#line 871 "nasm-token.c"
yy92:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 326 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)/2;
	    RETURN(RESERVE_SPACE);
	}
#line 880 "nasm-token.c"
yy94:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 343 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*8;
	    RETURN(RESERVE_SPACE);
	}
#line 889 "nasm-token.c"
yy96:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy102;
	if(yych == 'm')	goto yy102;
	goto yy45;
yy97:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy98;
	if(yych != 'o')	goto yy45;
yy98:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy99;
	if(yych != 'r')	goto yy45;
yy99:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy100;
	if(yych != 'd')	goto yy45;
yy100:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 295 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 10; RETURN(SIZE_OVERRIDE); }
#line 908 "nasm-token.c"
yy102:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy103;
	if(yych != 'e')	goto yy45;
yy103:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy104;
	if(yych != 's')	goto yy45;
yy104:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 352 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(TIMES); }
#line 920 "nasm-token.c"
yy106:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy107;
	if(yych != 'o')	goto yy45;
yy107:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy108;
	if(yych != 'r')	goto yy45;
yy108:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy109;
	if(yych != 'd')	goto yy45;
yy109:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 291 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*4;
	    RETURN(SIZE_OVERRIDE);
	}
#line 938 "nasm-token.c"
yy111:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 302 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 1; RETURN(DECLARE_DATA); }
#line 944 "nasm-token.c"
yy113:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych <= '.'){
			if(yych <= '"')	goto yy114;
			if(yych <= '$')	goto yy44;
			if(yych >= '.')	goto yy44;
		} else {
			if(yych <= '9'){
				if(yych >= '0')	goto yy44;
			} else {
				if(yych <= '>')	goto yy114;
				if(yych <= 'P')	goto yy44;
				goto yy133;
			}
		}
	} else {
		if(yych <= 'p'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy44;
			} else {
				if(yych != '`')	goto yy44;
			}
		} else {
			if(yych <= 'z'){
				if(yych <= 'q')	goto yy133;
				goto yy44;
			} else {
				if(yych == '~')	goto yy44;
			}
		}
	}
yy114:
#line 311 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*2;
	    RETURN(DECLARE_DATA);
	}
#line 982 "nasm-token.c"
yy115:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy131;
	if(yych == 'w')	goto yy131;
	goto yy45;
yy116:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= '.'){
			if(yych <= '"')	goto yy117;
			if(yych <= '$')	goto yy44;
			if(yych >= '.')	goto yy44;
		} else {
			if(yych <= '9'){
				if(yych >= '0')	goto yy44;
			} else {
				if(yych <= '>')	goto yy117;
				if(yych <= 'V')	goto yy44;
				goto yy126;
			}
		}
	} else {
		if(yych <= 'v'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy44;
			} else {
				if(yych != '`')	goto yy44;
			}
		} else {
			if(yych <= 'z'){
				if(yych <= 'w')	goto yy126;
				goto yy44;
			} else {
				if(yych == '~')	goto yy44;
			}
		}
	}
yy117:
#line 315 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*4;
	    RETURN(DECLARE_DATA);
	}
#line 1024 "nasm-token.c"
yy118:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 319 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 10; RETURN(DECLARE_DATA); }
#line 1030 "nasm-token.c"
yy120:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych <= '"')	goto yy121;
			if(yych <= '$')	goto yy44;
			if(yych >= '.')	goto yy44;
		} else {
			if(yych <= '9'){
				if(yych >= '0')	goto yy44;
			} else {
				if(yych <= '>')	goto yy121;
				if(yych <= 'N')	goto yy44;
				goto yy122;
			}
		}
	} else {
		if(yych <= 'n'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy44;
			} else {
				if(yych != '`')	goto yy44;
			}
		} else {
			if(yych <= 'z'){
				if(yych <= 'o')	goto yy122;
				goto yy44;
			} else {
				if(yych == '~')	goto yy44;
			}
		}
	}
yy121:
#line 307 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch);
	    RETURN(DECLARE_DATA);
	}
#line 1068 "nasm-token.c"
yy122:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy123;
	if(yych != 'r')	goto yy45;
yy123:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy124;
	if(yych != 'd')	goto yy45;
yy124:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 287 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*2;
	    RETURN(SIZE_OVERRIDE);
	}
#line 1083 "nasm-token.c"
yy126:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy127;
	if(yych != 'o')	goto yy45;
yy127:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy128;
	if(yych != 'r')	goto yy45;
yy128:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy129;
	if(yych != 'd')	goto yy45;
yy129:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 296 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*8;
	    RETURN(SIZE_OVERRIDE);
	}
#line 1101 "nasm-token.c"
yy131:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 303 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)/2;
	    RETURN(DECLARE_DATA);
	}
#line 1110 "nasm-token.c"
yy133:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 320 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*8;
	    RETURN(DECLARE_DATA);
	}
#line 1119 "nasm-token.c"
yy135:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy139;
	if(yych == 'r')	goto yy139;
	goto yy45;
yy136:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy137;
	if(yych != 't')	goto yy45;
yy137:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 355 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(WRT); }
#line 1132 "nasm-token.c"
yy139:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy140;
	if(yych != 'd')	goto yy45;
yy140:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 283 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch);
	    RETURN(SIZE_OVERRIDE);
	}
#line 1144 "nasm-token.c"
yy142:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy143;
	if(yych != 'o')	goto yy45;
yy143:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy144;
	if(yych != 'r')	goto yy45;
yy144:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy145;
	if(yych != 'd')	goto yy45;
yy145:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 279 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)/2;
	    RETURN(SIZE_OVERRIDE);
	}
#line 1162 "nasm-token.c"
yy147:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy148;
	if(yych != 't')	goto yy45;
yy148:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy149;
	if(yych != 'e')	goto yy45;
yy149:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8)	goto yy44;

#line 278 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 1; RETURN(SIZE_OVERRIDE); }
#line 1174 "nasm-token.c"
yy151:	yych = *++YYCURSOR;

#line 363 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(SIGNMOD); }
#line 1179 "nasm-token.c"
yy153:	yych = *++YYCURSOR;
	if(yych != 'i')	goto yy50;
	yych = *++YYCURSOR;
	if(yych != 'n')	goto yy50;
	yych = *++YYCURSOR;
	if(yych != 'e')	goto yy50;
	yych = *++YYCURSOR;

#line 271 "./modules/parsers/nasm/nasm-token.re"
{
	    parser_nasm->state = LINECHG;
	    linechg_numcount = 0;
	    RETURN(LINE);
	}
#line 1194 "nasm-token.c"
yy158:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy160;
			if(yych <= '$')	goto yy158;
		} else {
			if(yych == '/')	goto yy160;
			if(yych <= '9')	goto yy158;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy158;
			if(yych == '_')	goto yy158;
		} else {
			if(yych <= 'z')	goto yy158;
			if(yych == '~')	goto yy158;
		}
	}
yy160:
#line 403 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->str_val = yasm__xstrndup(s->tok, TOKLEN);
	    RETURN(ID);
	}
#line 1221 "nasm-token.c"
yy161:	yych = *++YYCURSOR;

#line 364 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(START_SECTION_ID); }
#line 1226 "nasm-token.c"
yy163:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 16)	goto yy164;
	goto yy50;
yy164:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 16)	goto yy164;

#line 242 "./modules/parsers/nasm/nasm-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    if (s->tok[1] == 'x')
		/* skip 0 and x */
		lvalp->intn = yasm_intnum_create_hex(s->tok+2, cur_line);
	    else
		/* don't skip 0 */
		lvalp->intn = yasm_intnum_create_hex(s->tok+1, cur_line);
	    s->tok[TOKLEN] = savech;
	    RETURN(INTNUM);
	}
#line 1248 "nasm-token.c"
yy167:	yyaccept = 3;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 32)	goto yy167;
	if(yych == 'E')	goto yy176;
	if(yych == 'e')	goto yy176;
yy169:
#line 256 "./modules/parsers/nasm/nasm-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->flt = yasm_floatnum_create(s->tok);
	    s->tok[TOKLEN] = savech;
	    RETURN(FLTNUM);
	}
#line 1265 "nasm-token.c"
yy170:	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '@'){
		if(yych <= '.'){
			if(yych <= '-')	goto yy3;
			goto yy167;
		} else {
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy170;
			goto yy3;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'F')	goto yy172;
			if(yych <= '`')	goto yy3;
		} else {
			if(yych == 'h')	goto yy174;
			goto yy3;
		}
	}
yy172:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'F'){
		if(yych <= '/')	goto yy50;
		if(yych <= '9')	goto yy172;
		if(yych <= '@')	goto yy50;
		goto yy172;
	} else {
		if(yych <= 'f'){
			if(yych <= '`')	goto yy50;
			goto yy172;
		} else {
			if(yych != 'h')	goto yy50;
		}
	}
yy174:	yych = *++YYCURSOR;

#line 235 "./modules/parsers/nasm/nasm-token.re"
{
	    s->tok[TOKLEN-1] = '\0'; /* strip off 'h' */
	    lvalp->intn = yasm_intnum_create_hex(s->tok, cur_line);
	    RETURN(INTNUM);
	}
#line 1312 "nasm-token.c"
yy176:	yych = *++YYCURSOR;
	if(yych <= ','){
		if(yych != '+')	goto yy50;
	} else {
		if(yych <= '-')	goto yy177;
		if(yych <= '/')	goto yy50;
		if(yych <= '9')	goto yy178;
		goto yy50;
	}
yy177:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy50;
	if(yych >= ':')	goto yy50;
yy178:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '/')	goto yy169;
	if(yych <= '9')	goto yy178;
	goto yy169;
yy180:	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 64)	goto yy180;
	if(yych <= 'F'){
		if(yych <= '/'){
			if(yych == '.')	goto yy167;
			goto yy3;
		} else {
			if(yych <= '9')	goto yy170;
			if(yych <= '@')	goto yy3;
			goto yy172;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '`')	goto yy3;
			if(yych <= 'f')	goto yy172;
			goto yy3;
		} else {
			if(yych <= 'h')	goto yy174;
			if(yych != 'q')	goto yy3;
		}
	}
yy182:	yych = *++YYCURSOR;

#line 228 "./modules/parsers/nasm/nasm-token.re"
{
	    s->tok[TOKLEN-1] = '\0'; /* strip off 'q' */
	    lvalp->intn = yasm_intnum_create_oct(s->tok, cur_line);
	    RETURN(INTNUM);
	}
#line 1363 "nasm-token.c"
yy184:	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 128)	goto yy184;
	if(yych <= '`'){
		if(yych <= '7'){
			if(yych == '.')	goto yy167;
			if(yych <= '/')	goto yy3;
			goto yy180;
		} else {
			if(yych <= '9')	goto yy170;
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy172;
			goto yy3;
		}
	} else {
		if(yych <= 'g'){
			if(yych == 'b')	goto yy186;
			if(yych <= 'f')	goto yy172;
			goto yy3;
		} else {
			if(yych <= 'h')	goto yy174;
			if(yych == 'q')	goto yy182;
			goto yy3;
		}
	}
yy186:	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'F'){
		if(yych <= '/')	goto yy187;
		if(yych <= '9')	goto yy172;
		if(yych >= 'A')	goto yy172;
	} else {
		if(yych <= 'f'){
			if(yych >= 'a')	goto yy172;
		} else {
			if(yych == 'h')	goto yy174;
		}
	}
yy187:
#line 221 "./modules/parsers/nasm/nasm-token.re"
{
	    s->tok[TOKLEN-1] = '\0'; /* strip off 'b' */
	    lvalp->intn = yasm_intnum_create_bin(s->tok, cur_line);
	    RETURN(INTNUM);
	}
#line 1411 "nasm-token.c"
}
#line 456 "./modules/parsers/nasm/nasm-token.re"


    /* %line linenum+lineinc filename */
linechg:
    SCANINIT();

    
#line 1421 "nasm-token.c"
{
	YYCTYPE yych;

	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,  64,   0,   0,   0,  64,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	 64,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	goto yy188;
	++YYCURSOR;
yy188:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= '\037'){
		if(yych <= '\n'){
			if(yych <= '\b')	goto yy198;
			if(yych <= '\t')	goto yy196;
			goto yy192;
		} else {
			if(yych == '\r')	goto yy196;
			goto yy198;
		}
	} else {
		if(yych <= '+'){
			if(yych <= ' ')	goto yy196;
			if(yych <= '*')	goto yy198;
			goto yy194;
		} else {
			if(yych <= '/')	goto yy198;
			if(yych >= ':')	goto yy198;
		}
	}
	yych = *++YYCURSOR;
	goto yy203;
yy191:
#line 463 "./modules/parsers/nasm/nasm-token.re"
{
	    linechg_numcount++;
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->intn = yasm_intnum_create_dec(s->tok, cur_line);
	    s->tok[TOKLEN] = savech;
	    RETURN(INTNUM);
	}
#line 1495 "nasm-token.c"
yy192:	yych = *++YYCURSOR;

#line 472 "./modules/parsers/nasm/nasm-token.re"
{
	    if (parser_nasm->save_input && cursor != s->eof)
		cursor = save_line(parser_nasm, cursor);
	    parser_nasm->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 1505 "nasm-token.c"
yy194:	yych = *++YYCURSOR;

#line 479 "./modules/parsers/nasm/nasm-token.re"
{
	    RETURN(s->tok[0]);
	}
#line 1512 "nasm-token.c"
yy196:	yych = *++YYCURSOR;
	goto yy201;
yy197:
#line 483 "./modules/parsers/nasm/nasm-token.re"
{
	    if (linechg_numcount == 2) {
		parser_nasm->state = LINECHG2;
		goto linechg2;
	    }
	    goto linechg;
	}
#line 1524 "nasm-token.c"
yy198:	yych = *++YYCURSOR;

#line 491 "./modules/parsers/nasm/nasm-token.re"
{
	    yasm__warning(YASM_WARN_UNREC_CHAR, cur_line,
			  N_("ignoring unrecognized character `%s'"),
			  yasm__conv_unprint(s->tok[0]));
	    goto linechg;
	}
#line 1534 "nasm-token.c"
yy200:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy201:	if(yybm[0+yych] & 64)	goto yy200;
	goto yy197;
yy202:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy203:	if(yybm[0+yych] & 128)	goto yy202;
	goto yy191;
}
#line 497 "./modules/parsers/nasm/nasm-token.re"


linechg2:
    SCANINIT();

    
#line 1553 "nasm-token.c"
{
	YYCTYPE yych;

	static unsigned char yybm[] = {
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128,   0, 128, 128,   0, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	};
	goto yy204;
	++YYCURSOR;
yy204:
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 128)	goto yy210;
	if(yych >= '\r')	goto yy208;
	yych = *++YYCURSOR;

#line 503 "./modules/parsers/nasm/nasm-token.re"
{
	    if (parser_nasm->save_input && cursor != s->eof)
		cursor = save_line(parser_nasm, cursor);
	    parser_nasm->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 1607 "nasm-token.c"
yy208:	yych = *++YYCURSOR;

#line 510 "./modules/parsers/nasm/nasm-token.re"
{ }
#line 1612 "nasm-token.c"
yy210:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 128)	goto yy210;

#line 512 "./modules/parsers/nasm/nasm-token.re"
{
	    parser_nasm->state = LINECHG;
	    lvalp->str_val = yasm__xstrndup(s->tok, TOKLEN);
	    RETURN(FILENAME);
	}
#line 1624 "nasm-token.c"
}
#line 517 "./modules/parsers/nasm/nasm-token.re"


    /* directive: [name value] */
directive:
    SCANINIT();

    
#line 1634 "nasm-token.c"
{
	YYCTYPE yych;

	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0,   0, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	goto yy213;
	++YYCURSOR;
yy213:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= 'Z'){
		if(yych == '\n')	goto yy215;
		if(yych <= '@')	goto yy219;
		goto yy217;
	} else {
		if(yych <= ']'){
			if(yych <= '\\')	goto yy219;
		} else {
			if(yych <= '`')	goto yy219;
			if(yych <= 'z')	goto yy217;
			goto yy219;
		}
	}
yy215:	yych = *++YYCURSOR;

#line 524 "./modules/parsers/nasm/nasm-token.re"
{
	    if (parser_nasm->save_input && cursor != s->eof)
		cursor = save_line(parser_nasm, cursor);
	    parser_nasm->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 1699 "nasm-token.c"
yy217:	yych = *++YYCURSOR;
	goto yy222;
yy218:
#line 531 "./modules/parsers/nasm/nasm-token.re"
{
	    parser_nasm->state = DIRECTIVE2;
	    lvalp->str_val = yasm__xstrndup(s->tok, TOKLEN);
	    RETURN(DIRECTIVE_NAME);
	}
#line 1709 "nasm-token.c"
yy219:	yych = *++YYCURSOR;

#line 537 "./modules/parsers/nasm/nasm-token.re"
{
	    yasm__warning(YASM_WARN_UNREC_CHAR, cur_line,
			  N_("ignoring unrecognized character `%s'"),
			  yasm__conv_unprint(s->tok[0]));
	    goto directive;
	}
#line 1719 "nasm-token.c"
yy221:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy222:	if(yybm[0+yych] & 128)	goto yy221;
	goto yy218;
}
#line 543 "./modules/parsers/nasm/nasm-token.re"


    /* string/character constant values */
stringconst:
    strbuf = yasm_xmalloc(STRBUF_ALLOC_SIZE);
    strbuf_size = STRBUF_ALLOC_SIZE;
    count = 0;

stringconst_scan:
    SCANINIT();

    
#line 1739 "nasm-token.c"
{
	YYCTYPE yych;

	goto yy223;
	++YYCURSOR;
yy223:
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych != '\n')	goto yy227;
	yych = *++YYCURSOR;

#line 555 "./modules/parsers/nasm/nasm-token.re"
{
	    if (cursor == s->eof)
		yasm__error(cur_line,
			    N_("unexpected end of file in string"));
	    else
		yasm__error(cur_line, N_("unterminated string"));
	    strbuf[count] = '\0';
	    lvalp->str_val = strbuf;
	    if (parser_nasm->save_input && cursor != s->eof)
		cursor = save_line(parser_nasm, cursor);
	    RETURN(STRING);
	}
#line 1764 "nasm-token.c"
yy227:	yych = *++YYCURSOR;

#line 568 "./modules/parsers/nasm/nasm-token.re"
{
	    if (s->tok[0] == endch) {
		strbuf[count] = '\0';
		lvalp->str_val = strbuf;
		RETURN(STRING);
	    }

	    strbuf[count++] = s->tok[0];
	    if (count >= strbuf_size) {
		strbuf = yasm_xrealloc(strbuf, strbuf_size + STRBUF_ALLOC_SIZE);
		strbuf_size += STRBUF_ALLOC_SIZE;
	    }

	    goto stringconst_scan;
	}
#line 1783 "nasm-token.c"
}
#line 583 "./modules/parsers/nasm/nasm-token.re"

}
