// BESContainer.cc

// This file is part of bes, A C++ back-end server implementation framework
// for the OPeNDAP Data Access Protocol.

// Copyright (c) 2004,2005 University Corporation for Atmospheric Research
// Author: Patrick West <pwest@ucar.edu> and Jose Garcia <jgarcia@ucar.edu>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// You can contact University Corporation for Atmospheric Research at
// 3080 Center Green Drive, Boulder, CO 80301
 
// (c) COPYRIGHT University Corporation for Atmostpheric Research 2004-2005
// Please read the full copyright statement in the file COPYRIGHT_UCAR.
//
// Authors:
//      pwest       Patrick West <pwest@ucar.edu>
//      jgarcia     Jose Garcia <jgarcia@ucar.edu>

#include "BESContainer.h"

/** @brief make a copy of the passed container
 *
 * @param copy_from The container to copy
 */
BESContainer::BESContainer( const BESContainer &copy_from )
    : _real_name( copy_from._real_name ),
      _constraint( copy_from._constraint ),
      _symbolic_name( copy_from._symbolic_name ),
      _container_type( copy_from._container_type ),
      _attributes( copy_from._attributes )
{
}

/** @brief duplicate this instance into the passed container
 *
 * @param copy_to The container to copy this instance into
 */
void
BESContainer::_duplicate( BESContainer &copy_to )
{
    copy_to._real_name = _real_name ;
    copy_to._constraint = _constraint ;
    copy_to._symbolic_name = _symbolic_name ;
    copy_to._container_type = _container_type ;
    copy_to._attributes = _attributes ;
}

/** @brief dumps information about this object
 *
 * Displays the pointer value of this instance along with information about
 * this container.
 *
 * @param strm C++ i/o stream to dump the information to
 */
void
BESContainer::dump( ostream &strm ) const
{
    strm << BESIndent::LMarg << "BESContainer::dump - ("
			     << (void *)this << ")" << endl ;
    BESIndent::Indent() ;
    strm << BESIndent::LMarg << "symbolic name: " << _symbolic_name << endl ;
    strm << BESIndent::LMarg << "real name: " << _real_name << endl ;
    strm << BESIndent::LMarg << "data type: " << _container_type << endl ;
    strm << BESIndent::LMarg << "constraint: " << _constraint << endl ;
    strm << BESIndent::LMarg << "attributes: " << _attributes << endl ;
    BESIndent::UnIndent() ;
}

