/* 
   Bluetooth device FirmWare loader
   Copyright (C) 2001-2002 Maxim Krasnyansky <maxk@qualcomm.com>
   Copyright (C) 2002 Marcel Holtmann <marcel@holtmann.org>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation;
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
   IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY CLAIM,
   OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER
   RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
   NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
   USE OR PERFORMANCE OF THIS SOFTWARE.
   
   ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS, COPYRIGHTS,
   TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS SOFTWARE IS DISCLAIMED.
*/

/*
 * $Id: bluefw.c,v 1.5 2002/10/28 00:24:51 holtmann Exp $
 */

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <syslog.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include "bluefw.h"
#include "usblib.h"
#include "pccard.h"

void usage(void)
{
	fprintf(stderr, "Usage:\n"
		"\tbluefw usb busnum/devnum\n"
		"\tbluefw pccard iobase\n");
}

#define USB    1
#define PCCARD 2

int main(int argc, char **argv)
{
	struct usb_device_descriptor desc;
	devinfo_t *info;
	devio_t io;
	int err, type, manfid, prodid;
	
	if (argc < 2) {
		usage();
		return 1;
	}
	argv++; argc--;
	
	type = 0;
	if (!strcmp(argv[0], "usb")) {
		type = USB;
		argv++; argc--;
	} else if (!strcmp(argv[0], "pccard")) {
		type = PCCARD;
		argv++; argc--;
	} else if (isdigit(argv[0][0])) {
		/* Compatibility with bluefw 0.X */
		type = USB;
	}

	if (!type || argc < 1) {
		usage();
		return 1;
	}
	
	openlog("bluefw", LOG_PERROR | LOG_PID, LOG_DAEMON);

	switch (type) {
	case USB:
		if ((io.fd = usb_dev_open(argv[0], &desc)) < 0)
			return 1;

		manfid = desc.idVendor;
		prodid = desc.idProduct;
		break;

	case PCCARD:
		io.iobase = strtol(argv[0], NULL, 16);

		if (pccard_get_manfid_from_iobase(io.iobase, &manfid, &prodid) < 0) {
			syslog(LOG_INFO, "Can't find a device at 0x%lx", io.iobase);
			return 1;
		}
		break;
	}

	err = 0;

	/* Check device table */
	info = devinfo_table;
	for (; info->vendorid; info++) {
		if (manfid != info->vendorid || prodid != info->productid)
			continue;

		syslog(LOG_INFO, "Loading firmware to %s device %04x:%04x",
			type == USB ? "usb" : "pccard",
			info->vendorid, info->productid);

		err = info->loader(io, info);
		break;
        }

	if (type == USB)
		usb_dev_close(io.fd);

	return err;
}
