/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "acpredictor.h"
#include <honoka_def.h>
#include <convertor.h>
#include <vector>

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#ifdef HAVE_GETTEXT
  #include <libintl.h>
  #define _(String) dgettext(GETTEXT_PACKAGE,String)
  #define N_(String) (String)
#else
  #define _(String) (String)
  #define N_(String) (String)
  #define bindtextdomain(Package,Directory)
  #define textdomain(domain)
  #define bind_textdomain_codeset(domain,codeset)
#endif

ACPredictor::ACPredictor(ConfigPointer cfg, HonokaInstance *i) 
: Predictor(cfg)
{
    instance = i;
    multi_mode = cfg->read(String(HONOKA_CONFIG_ACPREDICTOR_MULTI),HONOKA_DEFAULT_ACPREDICTOR_MULTI);
}


ACPredictor::~ACPredictor()
{
}




/*!
    \fn ACPredictor::getPredictionList(const WideString &str)
 */
ResultList ACPredictor::getPredictionList(const WideString &str)
{
    ResultList result;
    if (isConnected()) {
        instance->m_convertor->setYomiText(str);
        if (instance->m_convertor->ren_conversion() != -1) {
            vector<Segment> segments = instance->m_convertor->getSegmentList();
            WideString t,l;
            for(unsigned int i = 0;i < segments.size();i ++) t += segments[i].getKanji();
            if (multi_mode) l = t + utf8_mbstowcs(String(" (") + instance->m_convertor->getPropertyName() + String(")"));
            result.kType = PREDICTION;
            result.kouho.push_back(ResultEntry(t,l));
        }
        instance->m_convertor->reset();
    }
    if (multi_mode) {
        instance->m_convertor->unSelected();
        for(unsigned int i = 0;i < instance->convertors.size();i ++) {
            if (instance->convertors[i] != instance->m_convertor) {
                instance->convertors[i]->selected();
                if (instance->convertors[i]->isConnected()) {
                    instance->convertors[i]->setYomiText(str);
                    if (instance->convertors[i]->ren_conversion() != -1) {
                        vector<Segment> segments = instance->convertors[i]->getSegmentList();
                        WideString t,l;
                        for(unsigned int j = 0;j < segments.size();j ++) t += segments[j].getKanji();
                        l = t + utf8_mbstowcs(String(" (") + instance->convertors[i]->getPropertyName() + String(")"));
                        result.kType = PREDICTION;
                        result.kouho.push_back(ResultEntry(t,l));
                    }
                    instance->convertors[i]->reset();
                }
                instance->convertors[i]->unSelected();
            }
        }
        instance->m_convertor->selected();
    }
    
    return result;
}


/*!
    \fn ACPredictor::disconnect()
 */
void ACPredictor::disconnect()
{
    if (multi_mode) {
        for(unsigned int i = 0;i < instance->convertors.size();i ++) {
            if ((instance->convertors[i]->isConnected()) && (instance->m_convertor != instance->convertors[i])) {
                instance->convertors[i]->disconnect();
            }
        }
    }
    if (instance->m_convertor->isConnected()) instance->m_convertor->disconnect();
    return;
}


/*!
    \fn ACPredictor::connect()
 */
bool ACPredictor::connect()
{
    if (multi_mode) {
        for(unsigned int i = 0;i < instance->convertors.size();i ++) {
            if ((!instance->convertors[i]->isConnected()) && (instance->m_convertor != instance->convertors[i])) {
                instance->convertors[i]->connect();
            }
        }
    }
    if (!instance->m_convertor->isConnected()) return instance->m_convertor->connect();
    return true;
}


/*!
    \fn ACPredictor::isConnected()
 */
bool ACPredictor::isConnected()
{
    return instance->m_convertor->isConnected();
}


/*!
    \fn ACPredictor::getPropertyName()
 */
String ACPredictor::getPropertyName()
{
    return String(_("AutoConversion"));
}

/*!
    \fn ACPredictor::getName()
 */
String ACPredictor::getName()
{
    return String("ACPredictor");
}



/*!
    \fn ACPredictor::update(const WideString str,const WideString yomi)
 */
void ACPredictor::update(const WideString str,const WideString yomi)
{
    return;
}
