/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "multiconvertor.h"

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#ifdef HAVE_GETTEXT
  #include <libintl.h>
  #define _(String) dgettext(GETTEXT_PACKAGE,String)
  #define N_(String) (String)
#else
  #define _(String) (String)
  #define N_(String) (String)
  #define bindtextdomain(Package,Directory)
  #define textdomain(domain)
  #define bind_textdomain_codeset(domain,codeset)
#endif

MultiConvertor::MultiConvertor(ConfigPointer cfg , HonokaInstance *i)
 : Convertor(cfg)
{
    instance = i;
}


MultiConvertor::~MultiConvertor()
{
}

bool MultiConvertor::isConnected() {
    for(unsigned int i = 0;i < instance->convertors.size();i ++) {
        if (nuc.find(instance->convertors[i]) != nuc.end()) continue;
        if (!instance->convertors[i]->isConnected()) 
            return false;
    }
    return true;
}

void MultiConvertor::reset(){
    for(unsigned int i = 0;i < instance->convertors.size();i ++) {
        if (nuc.find(instance->convertors[i]) != nuc.end()) continue;
        instance->convertors[i]->reset();
    }
    nuc.clear();
}

void MultiConvertor::setYomiText(WideString yomi) {
    //for(unsigned int i = 0;i < instance->convertors.size();i ++) {
    //    if (nuc.find(instance->convertors[i]) != nuc.end()) continue;
    //    instance->convertors[i]->setYomiText(yomi);
    //}
    instance->m_def_convertor->setYomiText(yomi);
}

int MultiConvertor::ren_conversion() {
    if (nuc.find(instance->m_def_convertor) != nuc.end()) return -1;

    def = instance->m_def_convertor;
    texts.clear();
    yomi.clear();
    int b = instance->m_def_convertor->ren_conversion();
    WideString y;
    for(unsigned int i = 0;i < b;i ++) {
        ResultList l = instance->m_def_convertor->getResultList(i);
        texts.push_back(l.kouho[0].kanji);
        yomi.push_back(l.Yomi);
        y += l.Yomi;
    }
    for(unsigned int i = 0;i < instance->convertors.size();i ++) {
        if (nuc.find(instance->convertors[i]) != nuc.end()) continue;
        if (instance->m_def_convertor != instance->convertors[i]) {
            instance->convertors[i]->setYomiText(y);
            instance->convertors[i]->ren_conversion();
            for(unsigned int j = 0;j < b;j ++) {
                int bl = instance->m_def_convertor->getResultList(j).Yomi.length();
                int cl = instance->convertors[i]->getResultList(j).Yomi.length();
                if (bl != cl) instance->convertors[i]->resizeRegion(bl - cl);
            }
        }
    }
    setPos(0);
    return b;
}


const vector<Segment> MultiConvertor::getSegmentList() {
    vector<Segment> result;
    for(unsigned int i = 0;i < texts.size();i ++) result.push_back(Segment(texts[i],yomi[i]));
    return result;
};

int MultiConvertor::setPos(int p){
    int cp = instance->m_def_convertor->setPos(p);
    for(unsigned int i = 0;i < instance->convertors.size();i ++) {
        if (nuc.find(instance->convertors[i]) != nuc.end()) continue;
        if (instance->m_def_convertor != instance->convertors[i])
            instance->convertors[i]->setPos(cp);
    }
    return cp;
}

int MultiConvertor::getPos() {
    return instance->m_def_convertor->getPos();
}

ResultList MultiConvertor::getResultList(int p,ResultType kt){
    results.clear();
    result.kouho.clear();
    ResultList l;
    MultiResultList m;
    vector<MultiResultList> rs;
    // メインのConvertorからまず取得。
    ResultList t = instance->m_def_convertor->getResultList(p,kt);
    m.list.Title = t.Title;
    m.list.Yomi = t.Yomi;
    m.list.kType = t.kType;
    m.list.pos = 0;
    m.list.kouho.clear();
    m.convertor = instance->m_def_convertor;
    // 重複回避。メインのConvertorに関しては不要かも。
    set<WideString> d;
    for(unsigned int j = 0;j < t.count();j ++) {
        if (d.find(t.kouho[j].kanji) == d.end()) {
            d.insert(t.kouho[j].kanji);
            m.list.kouho.push_back(t.kouho[j]);
        }
    }
    rs.push_back(m);
    m.list = t;
    results.push_back(m);
    // その他のConvertorから取得。
    for(unsigned int i = 0;i < instance->convertors.size();i ++) {
        if (nuc.find(instance->convertors[i]) != nuc.end()) continue;
        if (instance->convertors[i] != instance->m_def_convertor) {
            m.list.Title = t.Title;
            m.list.Yomi = t.Yomi;
            m.list.kType = t.kType;
            m.list.pos = 0;
            m.convertor = instance->convertors[i];
            m.list.kouho.clear();
            t = instance->convertors[i]->getResultList(instance->m_def_convertor->getPos(),kt);
            // 重複回避。
            d.clear();
            for(unsigned int j = 0;j < t.count();j ++) {
                if (d.find(t.kouho[j].kanji) == d.end()) {
                    d.insert(t.kouho[j].kanji);
                    m.list.kouho.push_back(t.kouho[j]);
                }
            }
            rs.push_back(m);
            m.list = t;
            results.push_back(m);
        }
    }
    // リスト生成。
    for(unsigned int i = 0;i < rs.size();i ++) {
        for(unsigned int j = 0;j < rs[i].list.count();j ++) {
            int rp = l.find(rs[i].list.kouho[j].kanji);
            if (rp != -1) {
                l.kouho[rp].label = l.kouho[rp].label + utf8_mbstowcs(String(",")) +
                    utf8_mbstowcs(rs[i].convertor->getPropertyName());
            } else {
                l.kouho.push_back(ResultEntry(rs[i].list.kouho[j].kanji,
                    rs[i].list.kouho[j].kanji + utf8_mbstowcs(String(" (")) +
                    utf8_mbstowcs(rs[i].convertor->getPropertyName())));
            }
        }
    }
    for(unsigned int i = 0;i < l.count();i ++) {
        l.kouho[i].label = l.kouho[i].label + utf8_mbstowcs(String(")"));
    }
    l.Title = utf8_mbstowcs(String(_("lookup result (M)")));
    result = l;
    return l;
}


bool MultiConvertor::select(int p) {
    if (p < result.kouho.size()) texts[getPos()] = result.kouho[p].kanji;
    for(unsigned int i = 0;i < results.size();i ++) {
        int ps = results[i].list.find(result.kouho[p].kanji);
        if (ps != -1) results[i].convertor->select(ps);
    }
    return true;
}


bool MultiConvertor::resizeRegion(int w) {
    //return false;

    // 以下実装中。
    if (!instance->m_def_convertor->resizeRegion(w)) return false;
    texts.clear();
    yomi.clear();
    int p = getPos();
    vector<int> s;
    for(unsigned int i = 0;;i ++) {
        ResultList l = instance->m_def_convertor->getResultList(i);
        if (!l.count()) break;
        s.push_back(l.Yomi.length());
        texts.push_back(l.kouho[0].kanji);
        yomi.push_back(l.Yomi);
    }
    instance->m_def_convertor->setPos(p);
    for(unsigned int i = 0;i < instance->convertors.size();i ++) {
        if (nuc.find(instance->convertors[i]) != nuc.end()) continue;
        if (instance->m_def_convertor != instance->convertors[i]) {
            for(unsigned int j = 0;j < texts.size();j ++) {
                int bl = s[j];
                int cl = instance->convertors[i]->getResultList(j).Yomi.length();
                if (bl != cl) {
                    bool t = instance->convertors[i]->resizeRegion(bl - cl);
                    if (!t) {
                        nuc.insert(instance->convertors[i]);
                        break;
                    }
                }
            }
            instance->convertors[i]->setPos(p);
        }
    }
    return true;
}

void MultiConvertor::updateFrequency() {
    for(unsigned int i = 0;i < instance->convertors.size();i ++) {
        if (nuc.find(instance->convertors[i]) != nuc.end()) continue;
        instance->convertors[i]->updateFrequency();
    }
    return;
}

bool MultiConvertor::connect() {
    nuc.clear();
    for(unsigned int i = 0;i < instance->convertors.size();i ++) {
        if (!instance->convertors[i]->connect()) 
            nuc.insert(instance->convertors[i]);
    }
    return true;
}
void MultiConvertor::disconnect() {
    for(unsigned int i = 0;i < instance->convertors.size();i ++) {
        instance->convertors[i]->disconnect();
    }
    return;
}


String MultiConvertor::getName()
{
    return String("MultiConvertor");
}

String MultiConvertor::getPropertyName()
{
    return instance->m_def_convertor->getPropertyName() + String("(M)");
}



/*!
    \fn MultiConvertor::aline(Convertor *master,Convertor *slave)
 */
void MultiConvertor::aline(Convertor *master,Convertor *slave)
{
    vector<Segment> segs = master->getSegmentList();
    for(unsigned int i = 0;i < segs.size();i ++) {
        int bl = segs[i].getYomi().length();
        int cl = slave->getResultList(i).Yomi.length();
        if (bl != cl) slave->resizeRegion(bl - cl);
    }
}



