/*
 * IIIMF-CANNA, Japanese Language Engine for 
 *                        IIIMF (Internet/Intranet Input Method Framework)
 * 
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Shingo Akagaki <famao@momonga-linux.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: cannapalette.c,v 1.1.2.3 2003/08/03 14:51:29 famao Exp $ */

/* vi:set ts=4 sw=4: */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <locale.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xmd.h>
#include <canna/mfdef.h>
#include "xaux_common.h"
#include "xaux_ext_common.h"
#include "canna_xaux.h"


#if 0
#include "pixmaps/hira.xpm"
#include "pixmaps/kata.xpm"
#include "pixmaps/jisx0208.xpm"
#include "pixmaps/jisx0201.xpm"
#include "pixmaps/off.xpm"
#endif
#include "pixmaps/ascii.xpm"
#ifndef notdef
#include "pixmaps/code.xpm"
#endif

#include "wmutil.h"
#include "cannapalette.h"
#include "codetable.h"
#include "support.h"

#include "pixmaputil.h"
#include "menu.h"

xaux_class_t xaux_class = {
	"org.momonga-linux.canna.PaletteAux", 1,
	 NULL, (Window) 0, (Window) 0,
	(Atom) 0, (Atom) 0, (Atom) 0,
	{(Atom) 0,}, 0, {(Atom) 0,} , 
	0, NULL,
};

static CannaPalette *g_palette = NULL;
static xaux_class_t *xc_ = 0;
static int im_ = 0;
static int ic_ = 0;

static gboolean _handle_wm (Palette *p, gint wm_type, gint new_detected);
static gboolean _handle_tray (Palette *p, gint tray_type, gint new_detected);
static void _gnome_hints (Palette *palette, gint wm_type);
static void _ewmh_hints (Palette *palette, gint wm_type);
static void _gnome_hints_tray (TrayWindow *tray);
static void _ewmh_hints_tray (TrayWindow *tray, gint tray_type);

static void _prepare_button (CannaPalette *palette);
/* Position */
static void _palette_reposition (CannaPalette *palette);

/* Event */
static GdkFilterReturn _ext_event_handler (GdkXEvent *gdk_xevent, GdkEvent *event, gpointer user_data);

static void _status_changed (gchar *text, gint type);
static void _set_menu (GtkWidget *menu, gint type, gpointer data);
static void _add_menu (GtkWidget *menu, const gchar *name, int mode);

/* Menu Detach */
static void _menu_detach_func (GtkWidget *attach_widget, GtkMenu *menu);

/* Signal */
static void _code_button_clicked (GtkWidget *widget, gpointer user_data);
static void _status_button_clicked (GtkWidget *widget, gpointer user_data);
static void _status_menu_activate (GtkMenuItem *menu_item, gpointer user_data);

static void _show_codetable (void);
static void _register_xpm (void);

/* Error */
static int palette_x_error (Display *d, XErrorEvent *error);

void canna_aux_palette_send_engine (gint int_count, gint *integers, gint str_count, gchar **strings);


static int
palette_x_error (Display *d, XErrorEvent *error)
{
	if (error->error_code) {
		char buf[64];
		XGetErrorText (d, error->error_code, buf, 63);
		fprintf (stderr, 
				"IIIMF-CANNA (PaletteAux) **: %s\n serial %ld error_code %d request_code %d minor_code %d\n",
				buf,
				error->serial,
				error->error_code,
				error->request_code,
				error->minor_code);
	}
	return 0;
}

static void
_menu_detach_func (GtkWidget *attach_widget, GtkMenu *menu)
{
	/* nothing to do */
	return;
}

static void
_register_xpm (void)
{
	pixmap_pool_add_xpm (CANNA_MODE_AlphaMode, ascii_xpm);
	pixmap_pool_add_xpm (CANNA_MODE_HenkanMode, ascii_xpm);
	pixmap_pool_add_xpm (CANNA_MODE_ZenHiraKakuteiMode, ascii_xpm);
	pixmap_pool_add_xpm (CANNA_MODE_ZenKataKakuteiMode, ascii_xpm);
	pixmap_pool_add_xpm (CANNA_MODE_HanKataKakuteiMode, ascii_xpm);
	pixmap_pool_add_xpm (CANNA_MODE_ZenAlphaKakuteiMode, ascii_xpm);
	pixmap_pool_add_xpm (CANNA_MODE_HanAlphaKakuteiMode, ascii_xpm);
}

static void
_palette_reposition (CannaPalette *palette)
{
	GtkRequisition sizereq;
	gint x, y, width, height, wmflag;
	if (!GTK_WIDGET_REALIZED (CANNA_PALETTE_WIDGET (palette)))
		return;
	wmflag = CANNA_PALETTE (palette)->running_wm;
	if (wmflag & WM_IS_BLACKBOX) {
		return;
	} else if (wmflag & WM_IS_EWMH) {
		wmutil_window_workarea_ewmh (CANNA_PALETTE_WINDOW (palette),
				&x, &y, &width, &height);
		if (x < 0) {
			/* TODO */
			goto fallback;
		}
		width = x + width;
		height = y + height;
	} else {
fallback:
		width = gdk_screen_width ();
		height = gdk_screen_height ();
	}
	gtk_widget_size_request (CANNA_PALETTE_WIDGET (palette), &sizereq);
#ifdef USE_GTK2
	gtk_window_move (GTK_WINDOW (CANNA_PALETTE_WIDGET (palette)),
			width - sizereq.width,
			height - sizereq.height);
#else
	gtk_window_reposition (GTK_WINDOW (CANNA_PALETTE_WIDGET (palette)),
			width - sizereq.width,
			height - sizereq.height);
#endif
	return;
}

static GdkFilterReturn
_ext_event_handler (GdkXEvent *gdk_xevent, GdkEvent *event, gpointer user_data)
{
    XEvent *xevent;
    xevent = (XEvent *) gdk_xevent;
    if (xevent->type == ClientMessage) {
	    if (xaux_ext_process_client_message(GDK_DISPLAY(), (XClientMessageEvent *) xevent))
		    return GDK_FILTER_REMOVE;
	    else {
		static Atom take_focus = None;
		static Atom wm_protocols = None;
		GdkWindow *win = event->any.window;
		if (wm_protocols == None)
			wm_protocols = XInternAtom (GDK_WINDOW_XDISPLAY (win), "WM_PROTOCOLS", False);
		if (take_focus == None)
			take_focus = XInternAtom (GDK_WINDOW_XDISPLAY (win), "WM_TAKE_FOCUS", False);
		if (((Atom) xevent->xclient.message_type == wm_protocols) &&
				((Atom) xevent->xclient.data.l[0] == take_focus)) {
				return GDK_FILTER_REMOVE;
		}
	    }
	    return GDK_FILTER_CONTINUE;
    } else if (xevent->type == KeyRelease) {
	 //   key_event_handler(0, 0, xevent, 0);
		    return GDK_FILTER_REMOVE;
    } else if (xevent->type == ReparentNotify) {
	    XReparentEvent *re = (XReparentEvent *)xevent;
	    g_message ("ext reparent %lx %lx -> %lx",
			    re->event,
			    re->window,
			    re->parent
		      );
    } else if (xevent->type == PropertyNotify) {
	    XPropertyEvent *pe = (XPropertyEvent *)xevent;
	    g_message ("ext property notify %lx %d %s",
			    pe->window,
			    pe->state,
			    XGetAtomName (GDK_DISPLAY(), pe->atom)
		      );
    }
    g_message ("ext type %d", xevent->type);
    return GDK_FILTER_CONTINUE;
}

static void
_status_menu_activate (GtkMenuItem *menu_item, gpointer user_data)
{
	gint send_status[2];
#ifdef USE_GTK2
	if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (menu_item))) {
#else
	if (GTK_CHECK_MENU_ITEM (menu_item)->active) {
#endif
		send_status[0] = AUX_MODE_CHANGE;
		send_status[1] = GPOINTER_TO_INT (menu_item_get_activate_data (GTK_WIDGET (menu_item)));
		canna_aux_palette_send_engine (2, send_status, 0, NULL);
	}
}

static void
_status_button_clicked (GtkWidget *widget, gpointer user_data)
{
	CannaPalette *palette = (CannaPalette *)user_data;
	gtk_menu_popup (GTK_MENU (CANNA_PALETTE_MENU (palette)),
			NULL, NULL, NULL,
			CANNA_PALETTE_WIDGET (palette),
			0, 0);
	return;
}

static void
_code_button_clicked (GtkWidget *widget, gpointer user_data)
{
	CannaPalette *palette = (CannaPalette *)user_data;
	gtk_widget_show (palette->codetable);
	return;
}

static void
_add_menu (GtkWidget *menu, const gchar *name, int mode)
{
	MenuEntry entry[2];
#ifdef USE_GTK2
	gchar *ustr;
#endif
	if (!name)
		return;
#ifdef USE_GTK2
	ustr = g_locale_to_utf8 (name, -1, NULL, NULL, NULL);
	entry[0].label = ustr;
#else
	entry[0].label = (gchar *)name;
#endif
	entry[0].data = mode;
	entry[0].func = _status_menu_activate;
	entry[1].label = NULL;
	radio_menu_add_entry (menu, entry, (gpointer) g_palette);
#ifdef USE_GTK2
	g_free (ustr);
#endif
	return;
}

static void
_set_menu (GtkWidget *menu, gint type, gpointer data)
{
	GtkWidget *menuitem;
	gchar *id;
	gchar *label;
	if (!menu)
		return;
	id = g_strdup_printf ("%d", type);
	menuitem = (GtkWidget *)gtk_object_get_data (GTK_OBJECT (menu), id);
	g_free (id);
	if (!menuitem)
		return;
	gtk_signal_handler_block_by_data (GTK_OBJECT (menuitem), data);
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menuitem), TRUE);
	gtk_signal_handler_unblock_by_data (GTK_OBJECT (menuitem), data);

#ifdef USE_GTK2
	label = g_locale_from_utf8 (gtk_label_get_text (GTK_LABEL (GTK_BIN (menuitem)->child)),
			-1, NULL, NULL, NULL);
#else
	gtk_label_get (GTK_LABEL (GTK_BIN (menuitem)->child), &label);
#endif
	_status_changed (label, type);

#ifdef USE_GTK2
	g_free (label);
#endif
	return;

}

static void
_status_changed (gchar *text, gint type)
{
	GdkBitmap *mask;
	GdkPixmap *pix;
	GtkWidget *item;
#ifdef USE_GTK2
	gchar *ustr;
#endif
	if (!text)
		return;

	item = palette_get_element_label_nth (CANNA_PALETTE (g_palette), 0);
	if (item) {
#ifdef USE_GTK2
		ustr = g_locale_to_utf8 (text, -1, NULL, NULL, NULL);
		gtk_label_set_text (GTK_LABEL (item), ustr);
		g_free (ustr);
#else
		gtk_label_set_text (GTK_LABEL (item), text);
#endif
	} else {
		g_message ("item not found\n");
	}
	item = palette_get_element_icon_nth (CANNA_PALETTE (g_palette), 0);
	if (item) {
		pixmap_get (item, &pix, &mask, type);
#ifndef USE_GTK2
			gtk_pixmap_set (GTK_PIXMAP (item), pix, mask);
#else
			if (GTK_IS_PIXMAP (item)) {
				gtk_pixmap_set (GTK_PIXMAP (item), pix, mask);
			} else if (GTK_IS_IMAGE (item)) {
				gtk_image_set_from_pixmap (GTK_IMAGE (item), pix, mask);
			}
#endif
	}
	/* RePositioning */
	_palette_reposition (g_palette);
	return;
}

static void
_show_codetable (void)
{
	GtkWidget *code;
	code = g_palette->codetable;
	if (!code)
		return;
	/* 
	  in the case of having codetable in DISPLAY,
	  raise window
	 */ 
	if (GTK_WIDGET_VISIBLE (code)) {
		gdk_window_raise (code->window);
		return;
	}
	gtk_widget_show (code);
	/* TODO need it ? */
	gdk_window_raise (code->window);
	return;
}

static void
_reply_initialize (void)
{
	gint status[1];
	status[0] = AUX_PALETTE_OK;
	canna_aux_palette_send_engine (1, status, 0, NULL);
	return;
}

Bool
xaux_ext_Start (xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	g_message ("ext_Start");
#if 0
	gtk_widget_show (CANNA_PALETTE_WIDGET (g_palette));
	gdk_window_raise (CANNA_PALETTE_WINDOW (g_palette));
	_palette_reposition (g_palette);
	g_palette = canna_palette_new ();
#endif
	return True;
}

Bool
xaux_ext_Done (xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	g_message ("ext_Done");
	gtk_main_quit ();
	return True;
}

Bool
xaux_ext_Draw (xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	gint i;
	xc_ = xc;
	im_ = aux_ext_data->im;
	ic_ = aux_ext_data->ic;
	g_message("%d %d %d", aux_ext_data->im,
			aux_ext_data->ic,
			aux_ext_data->aux_index);

	if (!GTK_WIDGET_VISIBLE (CANNA_PALETTE_WIDGET (g_palette))) {
		g_message ("Draw palette_show");
		palette_show (CANNA_PALETTE (g_palette));
	}
#if 0
	g_message ("fuga %d\n", aux_ext_data->integer_count);
	for (i = 0; i < aux_ext_data->string_count; i++) {
		printf ("\tsv[%02d]=%s\n",i, aux_ext_data->string_list[i].ptr);
	}
#endif
	for (i = 0; i < aux_ext_data->integer_count; i++) {
		switch (aux_ext_data->integer_list[i]) {
			/* Initialize Request */
			case AUX_PALETTE_INIT:
				_reply_initialize ();
				break;
			case AUX_PALETTE_CODE:
				_show_codetable ();
				break;
			case AUX_STATUSLINE_CHANGE:
				_status_changed (aux_ext_data->string_list[i].ptr, CANNA_MODE_AlphaMode);
				break;
			case AUX_MODE_CHANGE:
				/* integer_list[i + 1] - mode id */
				_set_menu (CANNA_PALETTE_MENU (g_palette), aux_ext_data->integer_list[i + 1], 
						(gpointer) g_palette);
				_set_menu (canna_tray_window_get_menu (CANNA_TRAY (g_palette)), aux_ext_data->integer_list[i + 1],
						(gpointer) CANNA_TRAY (g_palette));
				i++;
				break;
			case AUX_MODE_ADD:
				/* integer_list[i + 1] - mode id to add */
				/* integer_list[i + 2] - internal icon type */
				/* string_list[i] - mode name to add */

				_add_menu (CANNA_PALETTE_MENU (g_palette), 
						aux_ext_data->string_list[i].ptr,
						aux_ext_data->integer_list[i + 1]);
				_add_menu (canna_tray_window_get_menu (CANNA_TRAY (g_palette)), 
						aux_ext_data->string_list[i].ptr,
						aux_ext_data->integer_list[i + 1]);
				i++;
				break;
			case AUX_MODE_CLEAR:
				break;
			/* Mode */
#if 0
			case CANNA_MODE_JMODE_HIRA:
			case CANNA_MODE_JMODE_KATA:
			case CANNA_MODE_ABBREV:
			case CANNA_MODE_LATIN:
			case CANNA_MODE_JISX0201_KANA:
			case CANNA_MODE_JISX0208_LATIN:
				_status_changed (aux_ext_data->string_list[i].ptr,
						aux_ext_data->integer_list[i]);
				break;
			case CANNA_MODE_OFF:
				_status_changed (aux_ext_data->string_list[i].ptr, CANNA_MODE_OFF);
				break;
#endif
			case AUX_PALETTE_SHOW:
				gtk_widget_show (CANNA_PALETTE_WIDGET(g_palette));
				break;
			case AUX_PALETTE_HIDE:
				gtk_widget_hide (CANNA_PALETTE_WIDGET(g_palette));
				break;
			case AUX_SET_FOCUS:
			case AUX_UNSET_FOCUS:
			default:
				break;
		}
	}
	return True;
}

static MenuEntry _status_menu_entry[] =
{
	{ NULL, 0, NULL }
};

void
canna_aux_palette_send_engine (gint int_count, gint *integers, gint str_count, gchar **strings) 
{
	gint i;
	aux_ext_data_t *aux_data;

	if (!xc_)
		return;

	aux_data = (aux_ext_data_t *) g_new0 (aux_ext_data_t,1);
	aux_data->im = im_;
	aux_data->ic = ic_;
	aux_data->integer_count = int_count;
	aux_data->string_count = str_count;

	if (aux_data->integer_count) {
		aux_data->integer_list = (int *) g_new0 (int, aux_data->integer_count);
		for (i = 0; i < aux_data->integer_count; i++) {
			aux_data->integer_list[i] = integers[i];
		}
	}
	if (aux_data->string_count) {
		aux_data->string_list = (aux_ext_string_t *) g_new0 (aux_ext_string_t, aux_data->string_count);
		for (i = 0; i < aux_data->string_count; i++) {
			aux_ext_string_t *p = &aux_data->string_list[i];
			p->length = strlen (strings[i]);
			p->ptr = (guchar *) g_strdup (strings[i]);
		}
	}
	xaux_ext_SetValue (GDK_DISPLAY(), xc_, aux_data);

	if (aux_data->integer_list) {
		g_free (aux_data->integer_list);
	}
	if (aux_data->string_list) {
		for (i = 0; i < aux_data->string_count; i++) {
			aux_ext_string_t *p = &aux_data->string_list[i];
			if (p && p->ptr)
				g_free (p->ptr);
		}
		g_free (aux_data->string_list);
	}
	g_free (aux_data);
	return;
}

static gboolean
_handle_wm (Palette *palette, gint wm_type, gint new_detected)
{
	g_message ("_handle_wm");
#if 0
	gtk_widget_hide (PALETTE_WIDGET (palette));
#endif
	gdk_window_set_override_redirect (PALETTE_WINDOW (palette), FALSE);
	if (wm_type & WM_IS_BLACKBOX) {
		g_message ("withdraw");
		gtk_widget_hide (PALETTE_WIDGET (palette));
		wmutil_window_hints_icccm (PALETTE_WINDOW (palette), WithdrawnState);
		gtk_widget_show (PALETTE_WIDGET (palette));
		return TRUE;
	}
	if (wm_type & WM_IS_EWMH) {
		gtk_widget_hide (PALETTE_WIDGET (palette));
		_ewmh_hints (palette, wm_type);
	}
	if (wm_type & WM_IS_GNOME) {
		gtk_widget_hide (PALETTE_WIDGET (palette));
		_gnome_hints (palette, wm_type);
	}
	gtk_widget_show (PALETTE_WIDGET (palette));
#if 1
	if (wm_type & WM_IS_EWMH) {
		_ewmh_hints (palette, wm_type);
	}
#endif
	return TRUE;
}

static gboolean
_handle_tray (Palette *palette, gint tray_type, gint new_detected)
{
	g_message ("_handle_tray");
#if 1
	tray_window_set_parent (CANNA_TRAY (g_palette), CANNA_PALETTE_WIDGET (g_palette));
#endif
	tray_window_realize (CANNA_TRAY (g_palette));
	gtk_widget_set_name (CANNA_TRAY(g_palette)->window, "canna-tray");
	if (tray_type & WM_IS_EWMH) {
		_ewmh_hints_tray (CANNA_TRAY (g_palette), tray_type);
	}
	if (tray_type & WM_IS_GNOME) {
		_gnome_hints_tray (CANNA_TRAY (g_palette));
	}
	tray_window_show (CANNA_TRAY (g_palette));
#if 1
	if (tray_type & WM_IS_EWMH) {
		_ewmh_hints_tray (CANNA_TRAY (g_palette), tray_type);
	}
	if (tray_type & WM_IS_GNOME) {
		_gnome_hints_tray (CANNA_TRAY (g_palette));
	}
#endif
	return TRUE;
}

static void
_prepare_button (CannaPalette *palette)
{
	GtkWidget *button;
	GtkWidget *icon;

	icon = pixmap_new (CANNA_PALETTE_WIDGET (palette), CANNA_MODE_HenkanMode);

#ifndef USE_GTK2
	button = pixmap_button_new ("CANNA", icon);
	gtk_container_set_resize_mode (GTK_CONTAINER (button), GTK_RESIZE_PARENT);
	button = palette_add_widget (CANNA_PALETTE (palette), button, 
			_("Change Input Mode"));
#else
	button = palette_add_button (CANNA_PALETTE (palette), icon, "CANNA",
			_("Change Input Mode"));
#endif
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC (_status_button_clicked), (gpointer)palette);
	gtk_widget_show (button);

#if 1
	icon = pixmap_new_with_xpm (CANNA_PALETTE_WIDGET (palette), code_xpm);
	button = pixmap_button_new (NULL, icon);
#else
	icon = gtk_image_new_from_stock (GTK_STOCK_INDEX, GTK_ICON_SIZE_BUTTON);
#endif
	button = palette_add_widget (CANNA_PALETTE (palette),  button , 
			_("Insert special characters"));
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC (_code_button_clicked), palette);
	gtk_widget_show (button);

	return;
}

CannaPalette *
canna_palette_new (void)
{
	CannaPalette *ret;
	GtkWidget *tray_menu;
	ret = g_new0 (CannaPalette, 1);
	ret->palette = palette_new ();
	ret->palette->detected_wm = _handle_wm;
	ret->palette->detected_tray = _handle_tray;
	ret->tray = canna_tray_window_new ();
	tray_menu = canna_tray_window_get_menu (ret->tray);
#if 0
	if (tray_menu)
		menu_add_entry (tray_menu, _tray_additional_entry, (gpointer)ret);
	ret->status_menu = radio_menu_new (_status_menu_entry, ret);
#endif
	ret->status_menu = radio_menu_new (_status_menu_entry, ret);
	ret->codetable = canna_aux_code_new ();
	gdk_window_set_transient_for (CANNA_PALETTE_WINDOW (ret), ret->codetable->window);
	_prepare_button (ret);
	gtk_menu_attach_to_widget (GTK_MENU (ret->status_menu) , CANNA_PALETTE_WIDGET (ret),
			_menu_detach_func);
#if 1
	wmutil_window_input_icccm (CANNA_PALETTE_WINDOW (ret), FALSE);
#endif
	return ret;
}

static void
_ewmh_hints_tray (TrayWindow *tray, gint tray_type)
{
	GdkAtom docked_ewmh[1];
	GdkAtom state[3];
	state[0] = gdk_atom_intern ("_NET_WM_STATE_STICKY", FALSE); /* sticky */
	state[1] = gdk_atom_intern ("_NET_WM_STATE_SKIP_TASKBAR", FALSE);
	state[2] = gdk_atom_intern ("_NET_WM_STATE_SKIP_PAGER", FALSE);
	if (GTK_WIDGET_VISIBLE (TRAY_WIDGET (tray))) {
		wmutil_window_state_ewmh_client_message (TRAY_WINDOW (tray),
				state[0], state[1]);
		wmutil_window_state_ewmh_client_message (TRAY_WINDOW (tray),
				state[2], None);
	} else {
		if (!(tray_type & WM_IS_KWIN)) {
			docked_ewmh[0] = gdk_atom_intern ("_NET_WM_WINDOW_TYPE_DOCK", FALSE);
			wmutil_window_type_ewmh (TRAY_WINDOW (tray),
					docked_ewmh, 1, GDK_PROP_MODE_REPLACE);
		}
		wmutil_window_state_ewmh_prop (TRAY_WINDOW (tray),
				state, 3, GDK_PROP_MODE_REPLACE);
		wmutil_window_desktop_ewmh_prop (TRAY_WINDOW (tray),
				0xffffffff);
	}
}

static void
_gnome_hints_tray (TrayWindow *tray)
{
	wmutil_window_hints_gnome (TRAY_WINDOW (tray),
			(WIN_HINTS_SKIP_FOCUS | WIN_HINTS_SKIP_TASKBAR |
			 WIN_HINTS_SKIP_WINLIST));
}

static void
_ewmh_hints (Palette *palette, gint wm_type)
{
	GdkAtom docked_ewmh[1];
	GdkAtom state[4];
	state[0] = gdk_atom_intern ("_NET_WM_STATE_STICKY", FALSE); /* sticky */
	state[1] = gdk_atom_intern ("_NET_WM_STATE_SKIP_TASKBAR", FALSE);
	state[2] = gdk_atom_intern ("_NET_WM_STATE_SKIP_PAGER", FALSE);
	state[3] = gdk_atom_intern ("_NET_WM_STATE_STAYS_ON_TOP", FALSE); /* KDE only ? */
	/* 
	 * when use metacity, we need to set 
	 * _NET_WM_WINDOW_TYPE_DOCK or _NET_WM_WINDOW_TYPE_DESKTOP for sticky option
	 */
#if 0
	if (!(wm_type & WM_IS_KWIN)) {
		docked_ewmh[0] = gdk_atom_intern ("_NET_WM_WINDOW_TYPE_DOCK", FALSE);
	} else {
		/*
		 * kwin 3.x has trouble with NET_WM_WINDOW_TYPE
		 * 3.1 is ok?
		 */
		docked_ewmh[0] = gdk_atom_intern ("_NET_WM_WINDOW_TYPE_DOCK", FALSE);
	}
#endif
	docked_ewmh[0] = gdk_atom_intern ("_NET_WM_WINDOW_TYPE_DOCK", FALSE);

	if (GTK_WIDGET_VISIBLE (PALETTE_WIDGET (palette))) {
		wmutil_window_state_ewmh_client_message (PALETTE_WINDOW (palette),
				state[0], None);
		wmutil_window_state_ewmh_client_message (PALETTE_WINDOW (palette),
				state[1], None);
		wmutil_window_state_ewmh_client_message (PALETTE_WINDOW (palette),
				state[2], None);
		wmutil_window_state_ewmh_client_message (PALETTE_WINDOW (palette),
				state[3], None);
		wmutil_window_desktop_ewmh_client_message (PALETTE_WINDOW (palette),
				0xffffffff);
	} else {
		wmutil_window_type_ewmh (PALETTE_WINDOW (palette),
				docked_ewmh, 1, GDK_PROP_MODE_REPLACE);
		wmutil_window_state_ewmh_prop (PALETTE_WINDOW (palette),
				state, 4, GDK_PROP_MODE_REPLACE);
		/* metacity check it */
		wmutil_window_desktop_ewmh_prop (PALETTE_WINDOW (palette),
				0xffffffff);
	}
}

static void
_gnome_hints (Palette *palette, gint wm_type)
{
	wmutil_window_state_gnome (PALETTE_WINDOW (palette),
			WIN_STATE_STICKY);
	wmutil_window_hints_gnome (PALETTE_WINDOW (palette),
			(WIN_HINTS_SKIP_FOCUS | WIN_HINTS_SKIP_TASKBAR |
			 WIN_HINTS_SKIP_WINLIST));
	wmutil_window_layer_gnome (PALETTE_WINDOW (palette),
			WIN_LAYER_ABOVE_DOCK);
}

int
main (int argc, char *argv[])
{
	/* force to EUC-JP */
#ifdef HAVE_SETENV
	setenv ("LC_ALL",JA_LOCALE ,True);
#elif HAVE_PUTENV
	putenv ("LC_ALL=" JA_LOCALE);
#endif
	gtk_set_locale ();

#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
#ifdef USE_GTK2
	bind_textdomain_codeset (PACKAGE, "UTF-8");
#endif
	textdomain (PACKAGE);
#endif

	gtk_init (&argc, &argv);
	_register_xpm ();
	g_palette = canna_palette_new ();
	gtk_widget_set_name (CANNA_PALETTE_WIDGET (g_palette), "canna-palette");
	palette_show (CANNA_PALETTE (g_palette));
	gdk_window_add_filter (CANNA_PALETTE_WINDOW (g_palette), _ext_event_handler, 0);

	if (xaux_ext_init_classes (GDK_WINDOW_XDISPLAY (CANNA_PALETTE_WINDOW (g_palette)),
				&xaux_class, 
				GDK_WINDOW_XWINDOW (CANNA_PALETTE_WINDOW (g_palette))) == False) {
		exit (1);
	}
	/* set Error Handler */
	XSetErrorHandler (palette_x_error);
	gtk_main ();
	return 0;
}
