/*
 * IIIMF-Canna, Japanese Language Engine for 
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Shingo Akagaki <dora@momonga-linux.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: im_aux.c,v 1.4.2.4 2003/08/04 09:27:29 famao Exp $ */

/* vi:set ts=4 sw=4: */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <canna_xaux.h>

#include "im_aux.h"
#include "im_util.h"

static void im_aux_draw (iml_session_t *s, char *class_name, int int_count, int *integers,
                                  int str_count, UTFCHAR **strings);
static void im_aux_start (iml_session_t *s, char *class_name);
#define im_aux_status_start(s) im_aux_start ((s), AUX_PALETTE_CLASS_NAME)
#define im_aux_dict_start(s) im_aux_start ((s), AUX_ADD_DICT_CLASS_NAME)
static void im_aux_done (iml_session_t *s, char *class_name);
#define im_aux_status_done(s) im_aux_done ((s), AUX_PALETTE_CLASS_NAME)
#define im_aux_dict_done(s) im_aux_done ((s), AUX_ADD_DICT_CLASS_NAME)

static Bool im_aux_palette_ok = False;
static Bool im_aux_dict_ok = False;

static void
im_aux_start (iml_session_t *s, char *class_name)
{
    iml_inst *lp;
    IMAuxStartCallbackStruct *aux = (IMAuxStartCallbackStruct *)
        s->If->m->iml_new (s, sizeof (IMAuxStartCallbackStruct));
    aux->aux_name = class_name;
    lp = s->If->m->iml_make_aux_start_inst (s, aux);
    s->If->m->iml_execute (s, &lp);
    return;
}

void
im_aux_statusline_draw (iml_session_t *s,char* currentMode)
{
    int send_status[1];
    char *str;
    UTFCHAR *ustr;
    UTFCHAR *send_string[1];

    if (!im_aux_palette_ok)
	    return;
    send_status[0] = AUX_STATUSLINE_CHANGE;
    str = currentMode;
    ustr = im_string_to_UTFCHAR (str);
    send_string[0] = ustr;
    im_aux_draw (s, AUX_PALETTE_CLASS_NAME, 1, send_status, 1, send_string);
    free (ustr);
    return;
}

void
im_aux_mode_change (iml_session_t *s, int mode)
{
    int status[2];
    if (!im_aux_palette_ok)
	    return;
    status[0] = AUX_MODE_CHANGE;
    status[1] = mode;
    fprintf (stderr, "mode %d\n", mode);
    im_aux_draw (s, AUX_PALETTE_CLASS_NAME, 2, status, 0, NULL);
}

static void
im_aux_done (iml_session_t *s, char *class_name)
{
    iml_inst *lp;
    IMAuxDoneCallbackStruct *aux = (IMAuxDoneCallbackStruct *)
        s->If->m->iml_new (s, sizeof (IMAuxDoneCallbackStruct));
    aux->aux_name = class_name;
    lp = s->If->m->iml_make_aux_done_inst (s, aux);
    s->If->m->iml_execute (s, &lp);
    return;
}

static void
im_aux_draw (iml_session_t *s, char *class_name, int int_count, int *integers,
                int str_count, UTFCHAR **strings)
{
    iml_inst *lp;
    int i,len;
    IMText *lts, *lt;
    IMAuxDrawCallbackStruct *aux;
    aux = (IMAuxDrawCallbackStruct *) s->If->m->iml_new (s, sizeof (IMAuxDrawCallbackStruct));
    memset (aux, 0, sizeof (IMAuxDrawCallbackStruct));
    aux->aux_name = class_name;
    aux->count_integer_values = int_count;
    if (aux->count_integer_values) {
        aux->integer_values = (int *) s->If->m->iml_new (s, sizeof (int) * aux->count_integer_values);
        memset (aux->integer_values, 0, sizeof (int) * aux->count_integer_values);

        for (i = 0; i < aux->count_integer_values; i++) {
            aux->integer_values[i] = integers[i];
        }
    }
    aux->count_string_values = str_count;
    if (aux->count_string_values) {
        aux->string_values = lts = (IMText *) s->If->m->iml_new (s, sizeof (IMText) * aux->count_string_values);
        memset (aux->string_values, 0, sizeof (IMText) * aux->count_string_values);
        for (i = 0, lt = lts; i < aux->count_string_values; i++, lt++) {
            UTFCHAR *p = strings[i];
            for (len = 0; *p; p++)
                len++;
            lt->text.utf_chars = (UTFCHAR *) s->If->m->iml_new (s, sizeof (UTFCHAR) * len);
            lt->char_length = len;
            memcpy (lt->text.utf_chars, strings[i], sizeof (UTFCHAR) * len);
        }
    }
    lp = s->If->m->iml_make_aux_draw_inst (s, aux);
    s->If->m->iml_execute (s, &lp);
    return;
}

#if 0
void
im_aux_dict_add (iml_session_t *s, const char *query_str)
{
    int status[1];
    UTFCHAR *send_string[1];
    if (!query_str)
            return;
    if (im_aux_dict_ok == False) {
        im_aux_start (s, AUX_ADD_DICT_CLASS_NAME);
        /* send initialize request */
        status[0] = AUX_DICT_INIT;
        im_aux_draw (s, AUX_ADD_DICT_CLASS_NAME,
                            1, status, 0, NULL);
    } /* TODO */
    status[0] = AUX_DICT_ADD;
    send_string[0] = im_string_to_UTFCHAR ((char*)query_str);
    im_aux_draw (s, AUX_ADD_DICT_CLASS_NAME,
                    1, status, 1, send_string);
    free (send_string[0]);
    return;
}
#endif

void
im_aux_menu_add (iml_session_t *s,int id,unsigned char* str)
{
    int send_status[2];
    UTFCHAR *send_string[1];
    if (!im_aux_palette_ok)
	    return;
    send_status[0] = AUX_MODE_ADD;
    send_status[1] = id;
    send_string[0] = im_string_to_UTFCHAR (str);

    im_aux_draw (s, AUX_PALETTE_CLASS_NAME, 2,
                    send_status, 1, send_string);
    free (send_string[0]);
    return;
}

IMAuxCallbacks im_aux_callbacks;

void
im_aux_process_event (iml_session_t *s, IMAuxDrawCallbackStruct *aux)
{
    switch (aux->integer_values[0]) {
    case AUX_MODE_CHANGE:
        if (im_aux_callbacks.mode_change)
            im_aux_callbacks.mode_change(s,aux->integer_values[1]);
        break;
    case AUX_CODE_DEFINED:
        if (im_aux_callbacks.code_defined)
            im_aux_callbacks.code_defined(s,&aux->string_values[0]);
        break;
    case AUX_DICT_ADD:
        if (im_aux_callbacks.dict_add)
            im_aux_callbacks.dict_add(s,aux->integer_values[1],&aux->string_values[0],&aux->string_values[1]);
        break;
    case AUX_PALETTE_OK:
        im_aux_palette_ok = True;
        break;
    case AUX_DICT_OK:
        im_aux_dict_ok = True;
        break;
    default:
        break;
    }
    return;
}


IMObjectDescriptorStruct*
im_aux_get_objects (void)
{
    static UTFCHAR AuxName[] = { 'c','a','n','n','a' };
    static IMObjectDescriptorStruct *objects = NULL;

    if (!objects) {
        int obj_id = 0;
        objects = (IMObjectDescriptorStruct *) calloc (4, sizeof (IMObjectDescriptorStruct));
        objects[obj_id].leid = "canna";
        objects[obj_id].type = IM_DOWNLOADINGOBJECT_BINGUI_TYPE;
        objects[obj_id].name = AuxName;
        objects[obj_id].name_length = 5;
                        objects[obj_id].domain = "org.momonga-linux";
        objects[obj_id].scope = "canna";
        objects[obj_id].path = "./locale/ja/canna/xaux/xaux.so";
        objects[obj_id].signature = "";
        obj_id++;
    }
    return objects;
}

void
im_aux_setup (iml_session_t *s,IMAuxCallbacks *callbacks)
{
    int send_status[1];

    memcpy(&im_aux_callbacks,callbacks,sizeof(IMAuxCallbacks));

    im_aux_status_start (s);
    /* Send Initialize Request */
    send_status[0] = AUX_PALETTE_INIT;
    im_aux_draw (s, AUX_PALETTE_CLASS_NAME,
            1, send_status, 0, NULL);
    send_status[0] = AUX_MODE_CLEAR;
    im_aux_draw (s, AUX_PALETTE_CLASS_NAME,
            1, send_status, 0, NULL);
/*  im_aux_dict_start (s); */
}
