/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                          
/* $Id: tray.c,v 1.5 2003/03/14 02:32:47 famao Exp $ */
                                                                                                          
/* vi:set ts=4 sw=4: */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "tray.h"
#include "wmutil.h"

static GdkFilterReturn
_tray_event_filter (GdkXEvent *gdk_xevent, GdkEvent *event, gpointer user_data)
{
	XEvent *xev;
	TrayWindow *tray = (TrayWindow *)user_data;
	static Atom xembed_atom = None;
	xev = (XEvent *) gdk_xevent;
	if (xev->type == ClientMessage) {
		XClientMessageEvent *cev = (XClientMessageEvent *)xev;
		if (xembed_atom == None)
			xembed_atom = XInternAtom (GDK_WINDOW_XDISPLAY (tray->window->window),
					"_XEMBED",
					FALSE);
		if (cev->format == 32 && cev->message_type == xembed_atom) {
			if (tray->xembed_event_handler)  {
				g_message ("_XEMBED message");
				return tray->xembed_event_handler (tray, cev);
			}

		}
	} else if (xev->type == ReparentNotify) {
		XReparentEvent *rev = (XReparentEvent *)xev;
		if (rev->parent == GDK_ROOT_WINDOW ()) {
			/* tansaction ended */
			if (tray->xembed_ended_handler) {
				g_message ("_XEMBED ended");
				tray->xembed_ended_handler (tray);
			}
		}
	}
	return GDK_FILTER_CONTINUE;
}

TrayWindow *
tray_window_new (void)
{
	TrayWindow *ret;
	ret = g_new0 (TrayWindow, 1);
	ret->parent = NULL;
	ret->window = NULL;
	ret->embed_win = None;
	ret->create_window = NULL;
	ret->wm_mask = WM_IS_UNKNOWN;
	ret->flags = 0;
	ret->xembed_event_handler = NULL;
	ret->xembed_ended_handler = NULL;
	return ret;
}

void
tray_window_destroy (TrayWindow *tray)
{
	if (!tray)
		return;
	if (tray->window)
		gtk_widget_destroy (tray->window);
	return;
}

void
tray_window_realize (TrayWindow *tray)
{
	if (!tray)
		return;
	if (!tray->create_window)
		return;
	if (tray->flags & TRAY_REALIZED)
		return;
	tray->window = tray->create_window (tray);
	if (tray->window) {
		gtk_widget_realize (tray->window);
		tray->flags |= TRAY_REALIZED;
	}
}

void
tray_window_set_create_window (TrayWindow *tray, TrayCreateFunc func)
{
	if (!func)
		return;
	if (!tray)
		return;
	tray->create_window = func;
}

void
tray_window_show (TrayWindow *tray)
{
	if (!tray)
		return;
	if (!(tray->flags & TRAY_REALIZED)) {
		tray_window_realize (tray);
	}
	if (!tray->window)
		return;
	tray->wm_mask = wmutil_window_check_wm_type ();
#if 0
	if ((tray->wm_mask & WM_IS_KWIN)) {
		g_message ("Entering KDE Tray");
		if (tray->parent) {
			wmutil_window_tray_kde (tray->window->window, tray->parent->window);
		} else {
			wmutil_window_tray_kde (tray->window->window, GDK_ROOT_PARENT ());
		}
	}
#endif
#if 0
	if (tray->wm_mask & WM_IS_ICEWM) {
		g_message ("Entering ICEWM Tray");
		wmutil_window_tray_icewm (tray->window->window, ICEWM_TRAY_MINIMIZED);
	}
#endif
#if 0
	if ((tray->wm_mask & WM_CAN_TRAY_SPEC) && !(tray->wm_mask & WM_IS_KWIN)) {
		g_message ("Entering EWMH Tray");
		wmutil_window_tray_xembed (tray->window->window);
		wmutil_window_tray_spec (tray->window->window);
	}
#endif
	gdk_window_set_decorations (tray->window->window, 0);
	gtk_widget_show (tray->window);
	gdk_window_add_filter (tray->window->window, _tray_event_filter, (gpointer) tray);
#if 1
	if (((tray->wm_mask & WM_CAN_TRAY_SPEC))) {
		g_message ("Entering EWMH Tray");
		wmutil_window_tray_xembed (tray->window->window);
		wmutil_window_tray_spec (tray->window->window);
	}
#endif
#if 0
	if (tray->wm_mask & WM_IS_ICEWM) {
		g_message ("Entering ICEWM Tray");
		wmutil_window_tray_icewm (tray->window->window, ICEWM_TRAY_MINIMIZED);
	}
#endif
	return;
}

void
tray_window_set_parent (TrayWindow *tray, GtkWidget *widget)
{
	if (!tray)
		return;
	if (!widget)
		return;
	tray->parent = widget;
	return;
}

void
tray_window_set_xembed_ended_handler (TrayWindow *tray, XEmbedEndedHandler handler)
{
	if (!tray)
		return;
	tray->xembed_ended_handler = handler;
	return;
}

void
tray_window_set_xembed_event_handler (TrayWindow *tray, XEmbedEventHandler handler)
{
	if (!tray)
		return;
	tray->xembed_event_handler = handler;
	return;
}

#ifdef SKK_AUX_TRAY_DEBUG
static GtkWidget *
create_win (TrayWindow *tray)
{
	GtkWidget *plug = gtk_plug_new (0);
	GtkWidget *button = gtk_button_new_with_label ("test");
	gtk_plug_construct (GTK_PLUG (plug), 0);
	gtk_widget_show (button);
	gtk_widget_realize (plug);
	gtk_container_add (GTK_CONTAINER (plug), button);
	return plug;
}

int
main (int argc, char **argv)
{
	GtkWidget *window;
	TrayWindow *tray;
	gtk_init (&argc, &argv);
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	tray = tray_window_new ();
	gtk_widget_show (window);
	tray_window_set_parent (tray, window);
	tray_window_set_create_window (tray, create_win);
	tray_window_show (tray);
	gtk_main ();
	return 0;
}
#endif
