/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                          
/* $Id: tray.h,v 1.2 2003/02/19 17:44:50 famao Exp $ */
                                                                                                          
/* vi:set ts=4 sw=4: */

#ifndef HAVE_TRAY_H
#define HAVE_TRAY_H

#include <gtk/gtk.h>
#include <wmutil.h>

#define TRAY_REALIZED ( 1 << 0 )
#define TRAY_EMBEDDED ( 1 << 1 )

typedef struct _TrayWindow TrayWindow;

#define TRAY_WIDGET(X) (X)->window
#define TRAY_WINDOW(X) (X)->window->window
#define TRAY_EMBEDED_WIN(X) (X)->embed_win

typedef GtkWidget* (*TrayCreateFunc)(TrayWindow *tray);
typedef GdkFilterReturn (*XEmbedEventHandler) (TrayWindow *tray, XClientMessageEvent *event);
typedef void (*XEmbedEndedHandler) (TrayWindow *tray);

struct _TrayWindow {
	GtkWidget *parent;
	GtkWidget *window;
	Window embed_win;
	guint wm_mask;
	guint flags;
	gpointer data;
	
	GtkWidget * (*create_window) (TrayWindow *tray);
	GdkFilterReturn (*xembed_event_handler) (TrayWindow *tray, XClientMessageEvent *event);
	void (*xembed_ended_handler) (TrayWindow *tray);
};

TrayWindow *tray_window_new (void);
void tray_window_destroy (TrayWindow *tray);

void tray_window_realize (TrayWindow *tray);
void tray_window_set_create_window (TrayWindow *tray, TrayCreateFunc func);
void tray_window_set_xembed_event_handler (TrayWindow *tray, XEmbedEventHandler handler);
void tray_window_set_xembed_ended_handler (TrayWindow *tray, XEmbedEndedHandler handler);
void tray_window_set_parent (TrayWindow *tray, GtkWidget *parent);

void tray_window_show (TrayWindow *tray);

#endif
