/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITALISTVIEWITEM_H_
#define _KITALISTVIEWITEM_H_

#include <klistview.h>

namespace Kita
{
    class ListViewItem : public KListViewItem
    {
        QColor m_textColor;  /* text color */
        QColor m_baseColor;  /* background color */

    public:

        ListViewItem( QListView *parent, QListViewItem *after,
                      QString, QString = QString::null,
                      QString = QString::null, QString = QString::null,
                      QString = QString::null, QString = QString::null,
                      QString = QString::null, QString = QString::null );

        ListViewItem( QListViewItem *parent, QListViewItem *after,
                      QString, QString = QString::null,
                      QString = QString::null, QString = QString::null,
                      QString = QString::null, QString = QString::null,
                      QString = QString::null, QString = QString::null );

        ListViewItem( QListView* parent, QString = QString::null, QString = QString::null );

        ListViewItem( QListViewItem* parent, QString = QString::null, QString = QString::null );

        ~ListViewItem();

        void setColor( QColor textColor, QColor baseColor );
        virtual void paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int align );

    private:
        void init();
    };
}

#endif
