/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAKITA_MISC_H
#define KITAKITA_MISC_H

#include "boardmanager.h"

#include <qstring.h>

class KURL;
class QDateTime;

struct RESDAT;


/* URL conversion mode. see also Kita::convertURL()  */
enum{
    URLMODE_DAT,
    URLMODE_THREAD
};

namespace Kita
{
    /**
     * @author Hideki Ikemoto
     */

    /*------------------------------*/
    /* text codecs */
    QString qcpToUnicode( const QString& str );
    QString utf8ToUnicode( const QString& str );
    QString ecuToUnicode( const QString& str );


    /*------------------------------*/
    /* conversion of DAT  */
    QString DatToHtml( const QString& rawData, int num );
    void DatToText( const QString &rawData, QString& text );
    QString parseSpecialChar( const QChar *cdat, unsigned int& pos );


    /*------------------------------*/
    /* conversion of URL */
    KURL getDatURL( const KURL& url , QString& refstr );
    KURL getDatURL( const KURL& url );

    QString getThreadURL( const KURL& url, QString& refstr );
    QString getThreadURL( const KURL& url );

    QString convertURL( int mode, const KURL& url , QString& refstr );

    QString datToOfflaw( const KURL& datURL );


    /*------------------------------*/
    /* utilities */
    bool mkdir( const QString& path );
    QString unescape( const QString& str );
    uint datToSince( const KURL& datURL );
    int isEqual( const QChar *cdat, const QString& str );
    int stringToPositiveNum( const QChar *cdat, const unsigned int length );


    /*------------------------------*/
    /* internal parsing funtions */


    /* for MACHI BBS */
    void InitParseMachiBBS();
    QString ParseMachiBBSOneLine( const QString& inputLine, int& nextNum );

    /* for JBBS */
    QString ParseJBBSOneLine( const QString& line, int& nextNum );


    /* for Flash CGI/Mini Thread */
    QString ParseFlashCGIOneLine( const QString& line );


    /* for 2ch */
    bool parseResDat( RESDAT& resdat, QString& subject );

    void parseName( const QString& rawStr, RESDAT& resdat );
    void parseDateId( const QString& rawStr, RESDAT& resdat );
    void parseBody( const QString &rawStr, RESDAT& resdat );

    bool parseLink( const QChar *cdat, const unsigned int length,
                    QString& linkstr, QString& linkurl, unsigned int& pos );
    bool parseResAnchor( const QChar *cdat, const unsigned int length,
                         QString& linkstr, int* refNum, unsigned int& pos );
    bool createResAnchor( const QString &rawStr, RESDAT& resdat,
                          const QChar *chpt, unsigned int &i, unsigned int &index );

    void createTitleHTML( RESDAT& resdat, QString& titletext );


    /*--------------------------------*/
    /* obsolete */
    QString datToBoard( const KURL& datURL );
    int boardType( const KURL& url );
}

#endif
