/*
 * ninjacmd.h:
 * 
 * this file contains code declaring routines dealing 
 * with /commands for ninja irc
 * 
 * written by Kraig Amador and Joshua J. Drake
 *
 */

#ifndef __ninja_cmd_h
#define __ninja_cmd_h

#include "defs.h"

/* general commands */
	void	whois2 _((u_char *, u_char *, u_char *));

/* name/host commands */
	void	chhost _((u_char *, u_char *, u_char *));
	void	chuname _((u_char *, u_char *, u_char *));

/* internal information commands */
	void	ninja_about _((u_char *, u_char *, u_char *));
	void	uptime _((u_char *, u_char *, u_char *));
	void	update_cmd _((u_char *, u_char *, u_char *));

/* channel commands */
#ifdef ALLOW_RESYNC
	void	resync _((u_char *, u_char *, u_char *));
#endif
	void	ninja_scan _((u_char *, u_char *, u_char *));
	void	users _((u_char *, u_char *, u_char *));
	void	cycle _((u_char *, u_char *, u_char *));
	void	do_wall _((u_char *, u_char *, u_char *));
	void	show_ban_cache _((u_char *, u_char *, u_char *));
	/* kick commands */
	void	do_special_k _((u_char *, u_char *, u_char *));
	void	filter_kick _((u_char *, u_char *, u_char *));
	void	lamer_kick _((u_char *, u_char *, u_char *));
	/* (de)op commands */
	void	give_or_take_ops _((u_char *, u_char *, u_char *));
#ifdef ALLOW_OJ
	void	oj _((u_char *, u_char *, u_char *));
#endif
	/* misc mode commands */
	void	chkey _((u_char *, u_char *, u_char *));
	void	change_channel_limit _((u_char *, u_char *, u_char *));
	/* mass modes! */
	void	mass _((u_char *, u_char *, u_char *));
	void	mass_abbrev _((u_char *, u_char *, u_char *));
	void	mdop _((u_char *, u_char *, u_char *));
	/* (un)ban commands */
	void	do_ban_stuff _((u_char *, u_char *, u_char *));

/* server commands */
	void	addserver _((u_char *, u_char *, u_char *));
	void	removeserver _((u_char *, u_char *, u_char *));

/* misc commands */
	void	ninja_save _((u_char *, u_char *, u_char *));
	void	ninja_redirect _((u_char *, u_char *, u_char *));

/* away log commands */
	void	short_eraselog _((u_char *, u_char *));
	void	away _((u_char *, u_char *, u_char *));
	void	back _((u_char *, u_char *, u_char *));

/* /all type commands */
	void	ame _((u_char *, u_char *, u_char *));

#endif
