/*
 * Main include file for Ninja IRC additions to ircII
 * 
 * written by Joshua J. Drake and Kraig Amador
 */

#ifndef __ninja_h_
# define __ninja_h_

#include "list.h"
#include "channels.h"
#include "nicks.h"
#include "window.h"

#ifdef __MSDOS__
#define NINJA_DIR		"ninja"
#else
#define NINJA_DIR_1		"/.ninja"
#define NINJA_DIR		"~" NINJA_DIR_1
#endif
#define NINJA_AWAY_FILE		NINJA_DIR "/away"
#define NINJA_FRIEND_FILE      	NINJA_DIR "/friends"
#define NINJA_ENEMY_FILE	NINJA_DIR "/enemies"
#define NINJA_SAVE_FILE		NINJA_DIR "/save"
#define NINJA_CKEY_FILE		NINJA_DIR "/ckeys"
#define NINJA_HISTORY_FILE	NINJA_DIR "/history"
#define NINJA_RC_FILE		NINJA_DIR_1 "/rc"
#define NINJA_QUICK_FILE       	NINJA_DIR_1 "/quick"

#define NINJA_EMAIL		"ninja@qoop.org"
#define NINJA_AUTHOR		"Joshua J. Drake <jduck@EFNet> and Kraig Amador."

	u_char	*ninja_size _((unsigned long));
	u_char	*ninja_etime _((unsigned long));
	u_char	*ninja_host _((struct in_addr));

	u_char	*ninja_strftime _((time_t *, u_char *));
	u_char	*ninja_date _((time_t *));
	u_char	*ninja_ctime _((time_t *));

	void	ninja_load_saves _((void));
	void	ninja_check_update _((int));

	void	usage _((u_char *, u_char *));

	void	do_server_lag_check _((int, time_t));
extern	u_char *leader;


#ifdef HAVE_STDARG_H
extern void add_to_awaylog _((char *, ...));
#else
extern void add_to_awaylog();
#endif
extern void close_away_log _((u_char *));
extern void open_away_log _((u_char *));
extern void load_userlist _((void));
extern void save_userlist _((int));
extern void wrong _((char *));
extern char *make_nice _((char *));
extern char *un_nice _((char *));
extern char *strip_8bit _((char *));
/* extern void strip_mean_ansi _((char *)); */
extern char *strip_ansi _((char *));
extern char *strip_path _((char *));
extern void add_to_bans();
extern int checkgrep();
extern char *strfill(char c, int num);
extern void ninja_check();
extern	void	check_idleaway();
extern void adddelayop();

extern	int	ninja_chkfiles _((char **, char *, unsigned long *));

extern char ansi_stripped[BIG_BUFFER_SIZE + 1];
extern char bit_stripped[BIG_BUFFER_SIZE + 1];

typedef struct delayop_stru
{
   struct delayop_stru *next;
   u_char *nick;
   u_char *channel;
   int server;
   int delay;
   time_t time;
} DelayOp;

#endif /* __ninja_h_ */
