/*
 * channel grep feature
 * 
 * written by Kraig Amador
 */

#include "irc.h"
#include "ircaux.h"
#include "grep.h"
#include "output.h"
#include "list.h"
#include "dma.h"

#include "channels.h"
#include "ninja.h"

ChanGrep *grep_list = (ChanGrep *) NULL;

/*
 * add/remove channel greps.. 
 * 
 * this is intended to be called from edit.c
 */
void
grep(u_char *command, u_char *args, u_char *subargs)
{
   ChanGrep *channel;
   u_char *chan;

   if (!(args && *args) && grep_list)
     {
	put_info("Channel grep list:");
	for (channel = grep_list; channel; channel = channel->next)
	   put_info("%s: %s",
	       channel->channel, channel->words);
	return;
     }
   else if (!(args && *args) && !grep_list)
     {
	usage("grep", "[-]<channel> <mask1> ... <maskn>");
	return;
     }
   chan = next_arg(args, &args);
   if (chan && *chan == '-')
     {
	chan++;
	if (*chan)
	  {
	     channel = (ChanGrep *) find_in_list((List **)&grep_list, make_chan(chan), 0);
	     if (!channel)
	       {
		  put_info("%s is not in your channel grep list.", make_chan(chan));
		  return;
	       }
	     if ((channel = (ChanGrep *) remove_from_list((List **) & grep_list, make_chan(chan))) != NULL)
	       {
		  dma_Free(&channel->words);
		  dma_Free(&channel->channel);
		  dma_Free(&channel);
	       }
	     put_info("%s removed from your channel grep list.",
		 make_chan(chan));
	     return;
	  }
	else
	  {
	     usage("grep", "[-]<channel> <masks1> .. <maskn>");
	     return;
	  }
     }
   else
     {
	channel = (ChanGrep *) find_in_list((List **)&grep_list, make_chan(chan), 0);
	if (!channel && args && *args)
	  {
	     channel = (ChanGrep *) dma_Malloc(sizeof(ChanGrep));
	     channel->channel = NULL;
	     channel->words = NULL;
	     dma_strcpy(&channel->channel, make_chan(chan));
	     dma_strcpy(&channel->words, args);
	     add_to_list((List **) & (grep_list), (List *) channel);
	     put_info("Grep list for %s is: %s", channel->channel, args);
	  }
	else if (!channel && !(args && *args))
	  {
	     put_info("%s is not in your channel grep list.", make_chan(chan));
	     return;
	  }
	else if (channel && args && *args)
	  {
	     dma_strcpy(&channel->words, args);
	     put_info("Grep list for %s is: %s",
		 channel->channel, args);
	  }
	else if (channel && !(args && *args))
	  {
	     put_info("Channel grep list:");
	     put_info("%s: %s",
		 channel->channel, channel->words);
	  }
     }
}

/*
 * see if we are grep'n this channel and if so, see if it matches the grep(s)
 * returns: 1 (print it)
 *          0 (don't print it)
 */
int
checkgrep(u_char *chan, u_char *line)
{
   ChanGrep *channel;
   u_char *ptr, *ptr2 = NULL, *ptr2_free, tmpbuf[1024], tmp2buf[1024];

   channel = (ChanGrep *) find_in_list((List **)&grep_list, chan, 0);
   if (channel && !line)
      return 0;
   if (!channel)
      return 1;
   strncpy(tmpbuf, line, sizeof(tmpbuf)-1);
   dma_strcpy(&ptr2, channel->words);
   ptr2_free = ptr2;
   while ((ptr = my_strsep(&ptr2, " ")))
     {
	if (*ptr)
	  {
	     snprintf(tmp2buf, sizeof(tmp2buf)-1, "*%s*", ptr);
	     if (match(tmp2buf, tmpbuf))
	       {
		  dma_Free(&ptr2_free);
		  return 1;
	       }
	  }
     }
   dma_Free(&ptr2_free);
   return 0;
}

