#!/bin/sh
#
# Attatch patches for ptex, mendex, makejvf under TeX Live 2007.
#

echo ${PATCH:=patch} > /dev/null
echo ${CP:=cp -fp}   > /dev/null
echo ${RM:=rm -f}    > /dev/null
echo ${MV:=mv -f}    > /dev/null

## check

if test ! -d kpathsea; then
    cat <<-EOF

	This script should be executed under 'texk'.
	Excute as following.

	  cd /your/path/to/texk
	  ./ptexenc/patches/texlive2007.sh

EOF
    exit 1
fi

if grep "2006 TeX Users Group" ../README > /dev/null; then
    echo "dummy" > /dev/null
else
    echo "This is for TeX Live 2007."
    exit 1
fi

## for ptex

$PATCH -p1 -d web2c/ptexdir < ptexenc/patches/ptex-src-3.1.10-ptexenc.patch || exit

(cd web2c/ptexdir
$RM Makefile.in  ptexextra.c  version.c  mkconf  pconvert
$CP ../lib/openclose.c .
$CP ../lib/printversion.c .
$MV kanji.defines ptex.defines
$MV ptexextra.h ptexextra.in
$MV pltotf.ch ppltotf.ch
$MV tftopl.ch ptftopl.ch
)

$PATCH -p1 -d .. < ptexenc/patches/ptex-src-3.1.10-texlive2007.patch || exit

## for mendex, makejvf

if test -d mendexk; then
    $PATCH -p1 -d mendexk < ptexenc/patches/mendexk2.6e-ptexenc.patch || exit
fi

if test -d makejvf; then
    $PATCH -p1 -d makejvf < ptexenc/patches/makejvf-1.1a-ptexenc.patch || exit
fi
