/* # skkinput (Simple Kana-Kanji Input)
 * MyError.h --- Handle X Error Events
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(MyError_h)
#define MyError_h

void initialize_myerrorhandler( void ) ;
int  IsWindowExist( Display *disp, Window win ) ;
int  isWindowExistIfExistsGetXWA
( Display *disp, Window win, XWindowAttributes *xwa ) ;
int xerror_occured( void ) ;
void xerror_clearflag( void ) ;
int XSafeSync( Display *disp, int flag ) ;
int XSafeFlush( Display *disp ) ;
void XtSafeAppNextEvent
( XtAppContext app_context, XEvent *event_return ) ;
Status XSafeSendEvent
( Display *disp, Window win, Bool propagate, 
  long event_mask, XEvent *event_send ) ;
int XtSafeDispatchEvent( XEvent *xevent ) ;

void XSafeSelectInput( Display *disp, Window win, long event_mask ) ;
void XSafeDestroyWindow( Display *disp, Window win ) ;
void XSafeGetWindowProperty
( Display *disp, Window win, Atom property, long loffset, long llength,
  Bool delete, Atom req_type, Atom *actual_type_return,
  int *actual_format_return, 
  unsigned long *nitems_return, unsigned long *bytes_after_return,
  unsigned char **prop_return ) ;
void XSafeChangeProperty
( Display *disp, Window win, Atom property, Atom type, int format,
  int mode, unsigned char *data, int nelements ) ;
void XtSafeDestroyApplicationContext( XtAppContext app_context ) ;

#endif
