/* # skkinput (Simple Kana-Kanji Input)
 * skkel.c --- Emacs-lisp -> C
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * ΥϤɤΥåȤˤ°ʤ()ؿνǤȤߤ
 * äơɤΥåȤƤӽФȤǽǤĤȤ롣
 * Ǥʤݤ顣(^^;;;;
 */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <limits.h>
#include <time.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/ShellP.h>

#include "commondef.h"
#include "buffers.h"
#include "skkbuf.h"
#include "SeparateWin.h"
#include "OverWin.h"
#include "table.h"
#include "skkel.h"
#include "skkkey.h"

/*
 * ץȥ
 */
/* skkel.c */
static int delete_char
( struct SKKInputNode *node, int pos, int count ) ;
static int j_insert_myChara
( struct SKKInputNode *node, int pos, struct myChar wchara ) ;
static int j_insert_str
( struct SKKInputNode *node, int pos, struct myChar *str ) ;
static void j_n_convert_to_kana( struct SKKInputNode *node ) ;
static void j_input_by_code_or_menu_jmp_showCandidate
( struct SKKInputNode *node, int code ) ;
static int j_compute_numeric_henkan_key
( struct myChar *dptr, struct myChar *sptr, struct myChar *j_num_list ) ;
static int j_insert_word
( struct SKKInputNode *node, int pos, struct myChar *word ) ;
static int j_start_henkan_sub( Widget gw, struct SKKInputNode *node ) ;
static int j_numeric_convert
( struct SKKInputNode *node,
  struct myChar *sptr, struct myChar *dptr, int dbufsize ) ;
static struct myChar *j_num_exp
( struct myChar *j_num_list_ptr, int type, struct myChar *dptr,
  int dbufsize ) ;
static int j_quote_char( struct myChar *word ) ;
static int j_quote_semicolon( struct myChar *word ) ;
static int save_ringbuffer
( struct myChar *buffer, int bufsize, int *startpos, int *endpos,
  struct myChar *string ) ;
static void j_keyboard_quit_henkanrestart
( Widget gw, struct SKKInputNode *node, int flag ) ;
static int find_next_completion( struct SKKInputNode *node ) ;

/* skkmbuf.c */
extern int skkinput_j_henkan_in_minibuff_init
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node ) ;
extern void free_Minibuffer
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node ) ;
extern int j_read_string
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, char *string, int minibuff_usage ) ;

/* skkwin.c */
/* skksvect.c */
extern int copyCandidate
( struct myChar *dest, SkkinpSearchVector *sNode, int position, int length ) ;
/* skkmarker.c */
extern int move_marker_ByInsert
( struct SKKInputNode *node, int startpoint, int effect ) ;
extern int move_marker_ByDeleteRegion
( struct SKKInputNode *node, int startpoint, int endpoint ) ;
extern int set_marker_ByGeqPosition
( struct SKKInputNode *node, int startpos, int setpos ) ;

/* skkldrec.c*/
extern void add_SudeniHenkanKakuteiShitamono
( struct myChar *henkankey, VectorIndex **vectorindextop,
  VectorIndex *hresult, int okuri ) ;
extern void add_SudeniHenkanKakuteiShitamonoByString
( struct myChar *henkankey, struct myChar *hresult, int okuri ) ;
extern SkkinpSearchVector *searchSudeniHenkanKakuteiShitamono
( struct myChar *henkankey, SkkinpSearchVector *top, int okuri ) ;
extern SkkinpSearchVector *searchSudeniPurgeSaretamono
( struct myChar *henkankey, SkkinpSearchVector *top, int okuri ) ;
extern void purge_SudeniHenkanKakuteiShitamono
( struct SKKInputNode *node ) ;
extern SkkinpSearchVector *j_completion_search_sudeniKakuteiShitaKouho
( SkkinpSearchVector *top, struct myChar *completion_key ) ;
extern SkkinpSearchVector *j_completion_search_sudeniPurgeSaretamono
( SkkinpSearchVector *top, struct myChar *completion_key ) ;

/* skkldic.c */
extern SkkinpSearchVector *j_search_skkinput_local_jisyo
( struct myChar *key, SkkinpSearchVector *top, int okuri ) ;
extern SkkinpSearchVector *j_completion_skkinput_local_jisyo
( SkkinpSearchVector *top, struct myChar *completion_key ) ;

/* skksvect.c */
extern void free_VectorIndex( VectorIndex **top ) ;
extern void free_SkkinpSearchVector( SkkinpSearchVector **top ) ;
extern VectorIndex *makeSearchVectorIndex
( SkkinpSearchVector *top, int *totalnum, int flag ) ;

/* skksoc.c */
extern SkkinpSearchVector *skkinput_Request
( struct myChar *str, SkkinpSearchVector *top ) ;

/* lispeval.c */
extern int skkinputlisp_eval
( struct myChar *commandstring, struct myChar *buffer ) ;
extern int skkinput_create_j_num_list
( struct myChar *string ) ;

/*
 * Хѿ
 */
/* ִȤκݤѤ٤ƥݥΥХåե*/
struct myChar temporary_buffer[ TEXTBUFSIZE * 2 ] ;
/* ʸΥХȿ*/
static const int j_input_by_code_or_menu_jump_default = 161 ;

static char *j_input_by_code_menu_keys1 = "asdfghqwerty" ;
static char *j_input_by_code_menu_keys2 = "asdfghjklqwertyu" ;
static unsigned char j_input_by_code_menu1_codes[] =
{ 33, 49, 65, 81, 97, 113 } ;
static const int j_code_n1_min = 33, j_code_n1_max = 116 ;
static const int j_code_n2_min = 33, j_code_n2_max = 126 ;

/*
 * ȤƤ륰Хѿ
 */
extern struct skk_rom_kana_rule *skkinput_rom_kana_rule_list ;
extern int                       skkinput_use_numeric_conversion ;
extern struct myChar            *skkinput_input_vector[ 128 ] ;
extern struct myChar            *skkinput_zenkaku_vector[ 128 ] ;
extern int                       skkinput_date_ad ;
extern int                       skkinput_number_style ;
extern int                       skkinput_delete_implies_kakutei ;
extern int                       skkinput_use_numeric_conversion ;
extern int                       skkinput_tab_width ;
extern unsigned long             skkinput_j_count_kakutei ;
extern unsigned long             skkinput_j_count_touroku ;
extern Boolean                   skkinput_jisyo_dirty ;
extern int			 skkinput_dabbrev_like_completion ;
extern Boolean			 skkinput_autosave_jisyo_dirty ;

/*
 * 顼ɽؿľˤ⤦äȤޤʤΤѲ뤳ȤǤ餦
 */
void err_msg( struct SKKInputNode *node, char *fmt, ... )
{
  unsigned char tempbuffer[ TEXTBUFSIZE ] ;
  va_list valist ;
  va_start( valist, fmt ) ;
  vsprintf( tempbuffer, fmt, valist ) ;
  va_end( valist ) ;
  /* ǤϴƤޤɤˤ뤳ȡ */
  myCharCharStrncpy( node->mtextbuffer, tempbuffer, TEXTMAXLEN ) ;
  MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ TEXTMAXLEN ] ) ;
  return ;
}

/*
 * ʸʸľ֤ؿĤäơǤʤɬפʤΡ Ȥ
 * 줽
 */
char *charaToString( int chara )
{
  static char cbuf[ 4 ] ;
  const char dispChara[] = "[\\]^_" ;

  /* ʬϡؾ󹩳زĸ漼θƣΥѥåǤ*/
  /*-----  -----  -----  -----  -----*/
  if( chara == 0x1b ) {/*ESC"ESC"Ȥ*/
    cbuf[ 0 ] = 'E';
    cbuf[ 1 ] = 'S';
    cbuf[ 2 ] = 'C';
    cbuf[ 3 ] = '\0';
  } else if( chara < 0x20 || chara == 0x7F ){
  /*----- ޤ ----- ޤ ----- ޤ ----- ޤ -----*/
    cbuf[ 0 ] = 'C' ;
    cbuf[ 1 ] = '-' ;
    cbuf[ 3 ] = '\0' ;
    if( chara == 0 ){
      /* Del key ξ硣*/
      cbuf[ 2 ] = '@' ;
    } else if( chara == 0x7F ){
      /* Del key ξ硣*/
      cbuf[ 2 ] = '?' ;
    } else if( chara >= 0x1b ){
      /* ʳΥȥ륳ɤξǥե٥åȤʤ*/
      cbuf[ 2 ] = dispChara[ chara - 0x1b ] ;
    } else {
      /* ե٥åȤɽǤ륳ȥ륳ɤξ硣*/
      cbuf[ 2 ] = ( 'a' - 1 ) + chara ;
    }
  } else {
    cbuf[ 0 ] = chara ;
    cbuf[ 1 ] = '\0' ;
  }
  return cbuf ;
}

static void j_n_convert_to_kana( struct SKKInputNode *node )
{
  static struct myChar string_nn[] = {
    { CHARSET_JISX0208_1983, 0x2473 },
    { CHARSET_JISX0208_1983, 0x2573 },
  } ;
  delete_char( node, node->j_kana_start_point, 1 ) ;
  j_insert_myChara
    ( node, node->j_kana_start_point, 
      string_nn[ node->j_katakana_mode ] ) ;
  return ;
}

static struct myChar last_character_of( struct myChar *prefix )
{
  int length = myCharStrlen( prefix ) ;
  struct myChar chara ;
  if( length > 0 ){
    return prefix[ length - 1 ] ;
  } 
  MYCHAR_SET_END_OF_STRING( chara ) ;
  return ( chara ) ;
}

/*
 * 겾̾⡼ɤ˰ܹԤƤ褤ɤȽǤؿ
 */
static int is_okurigana_start_ok( struct SKKInputNode *node )
{
  struct myChar pchara ;
  int pos ;
  /* ֤ˤʤʸäƤ줿Τʤɤɡǽ *
   * ʸƼʸ겾̾ʤƸ줿ˤϡ̾ *
   * ϳϰ֤鸫ʤܤ顣*/
  pos = ( node->j_kana_mode )? node->j_kana_start_point : node->cur_pos ;
  /* ֤Ѵϰ֤ܤǤ롣*/
  if( pos == node->j_henkan_start_point || pos <= 0 )
    return False ;
  /* Ϥ줿ʸǤ뤫ˤʤ롣*/
  pchara = node->textbuffer[ pos - 1 ] ;
  if( pchara.charset == CHARSET_JISX0208_1983 ){
    /* ʸ "" Τɤ줫ʤ겾 *
     * ̾⡼ɤˤϤʤʤ*/
    if( pchara.chara >= 0xA3B0 && pchara.chara <= 0xA3B9 )
      return False ;
  } else if( IS_ASCII_CHARA( pchara ) ){
    /* ʸ "0123456789><?" Τɤ줫ʤ겾̾⡼*
     * ˤϤʤʤ*/
    if( pchara.chara >= '0' && pchara.chara <= '9' )
      return False ;
    if( pchara.chara == '>' || pchara.chara == '<' ||
	pchara.chara == '?' )
      return False ;
  }
  return True ;
}

/*
 * ĶŬѴ롼Ҥؿ
 */
static struct skk_rom_kana_rule *j_assoc_rule
( struct myChar *prefix )
{
  struct skk_rom_kana_rule *element = skkinput_rom_kana_rule_list ;
  /* ꤵƤʤä顢Ҥʤ*/
  if( element == NULL )
    return NULL ;
  /* 㤢õޤ礦*/
  while( element->state != NULL ){
    if( !myCharStrcmp( element->state, prefix ) )
      return element ;
    element ++ ;
  }
  return NULL ;
}

/*
 * ꤵ줿ʸʤΤɤȽǤؿ
 */
static int is_hatsuon_ok
( struct myChar *j_prefix, int rchara )
{
  int lchara, schara ;
  /* ʸȾʸѴˤɤʤΤƤ*/
  lchara = ( rchara >= 'a' && rchara <= 'z' )?
    rchara + ( 'A' - 'a' ) : rchara ;
  schara = ( rchara >= 'A' && rchara <= 'Z' )?
    rchara + ( 'a' - 'A' ) : rchara ;
  /* ե٥åȤ³ʤǡǤ*/
  if( schara < 'a' || schara > 'z' )
    return False ;
  /* "X" äƤȤϤʤȻפɤ͡*/
  if( schara == 'x' )
    return False ;
  /* ʸʤä顢ܤǤ硩 */
  if( !IS_END_OF_STRING( j_prefix[ 1 ] ) )
    return False ;
  if( !IS_ASCII_EQUAL( j_prefix[ 0 ], lchara ) &&
      !IS_ASCII_EQUAL( j_prefix[ 0 ], schara ) )
    return False ;
  return True ;
}

/*
 * ֤ʸؿ
 */
static int j_insert_str
( struct SKKInputNode *node, int pos, struct myChar *str )
{
  int len_txt = myCharStrlen( node->textbuffer ) ;
  int len_str = myCharStrlen( str ) ;
  int count ;
  struct myChar *sptr, *dptr ;

  /* ʸ¸ߤʤν*/
  if( str == NULL )
    return 0 ;

  /* ξ꤫ʸȡǥХåե̤Ķ硣*/
  if( pos + len_str > TEXTMAXLEN ){
    memccpy
      ( node->textbuffer + pos, str,
	sizeof( struct myChar ), TEXTMAXLEN - pos ) ;
    MYCHAR_SET_END_OF_STRING( node->textbuffer[ TEXTMAXLEN ] ) ;
    /* ξ硢֤Ͼ \0 ǤʤȤʤ*/
    move_marker_ByInsert( node, pos, TEXTMAXLEN - pos ) ;
    /* cur_pos = TEXTMAXLEN ; */
    return 0 ;
  }
  if( pos != len_txt ){
    if( len_txt + len_str > TEXTMAXLEN ){
      /* ʸǥȡʸʸХåե̤Ķ硣*/
      count = TEXTMAXLEN - len_str - pos ;
      sptr  = node->textbuffer + TEXTMAXLEN - len_str ;
      dptr  = node->textbuffer + TEXTMAXLEN ; /* = '\0' */
    } else {
      /* ʸʸХåեդʤ硣*/
      count = len_txt - pos ;
      sptr  = node->textbuffer + len_txt ;
      dptr  = node->textbuffer + len_txt + len_str ;
    }
    /* ʬʸư롣*/
    MYCHAR_SET_END_OF_STRING( *sptr ) ;
    while( count >= 0 ){
      *dptr -- = *sptr -- ;
      count -- ;
    }
    /* ʸԤ*/
    dptr = node->textbuffer + pos ;
    sptr = str ;
    while( !IS_END_OF_STRING( *sptr ) )
      *dptr ++ = *sptr ++ ;
  } else {
    /* ʸԤ*/
    dptr = node->textbuffer + pos ;
    sptr = str ;
    while( !IS_END_OF_STRING( *sptr ) )
      *dptr ++ = *sptr ++ ;
    MYCHAR_SET_END_OF_STRING( *dptr ) ;
  }
  /* ʸʬޡư롣*/
  move_marker_ByInsert( node, pos, len_str ) ;
  return 0 ;
}

/*
 * ꤵ줿֤ʸޡưؿ
 */
int j_insert_myChara
( struct SKKInputNode *node, int pos, struct myChar wchara )
{
  int i ;
  int len = myCharStrlen( node->textbuffer ) ;
  struct myChar *ptr ;

  /* ϥƥȤΰֺǸؤƤΤʡ */
  if( IS_END_OF_STRING( node->textbuffer[ pos ] ) ){
    if( pos < TEXTMAXLEN ){
      /* ʤǤֺǸ­餤Ǥϥޡϰưʤ*/
      node->textbuffer[ pos ++ ] = wchara ;
      MYCHAR_SET_END_OF_STRING( node->textbuffer[ pos ] ) ;
      node->cur_pos ++ ;
    } else {
      MYCHAR_SET_END_OF_STRING( node->textbuffer[ TEXTMAXLEN ] ) ;
    }
    return 0 ;
  }
  if( len >= TEXTMAXLEN ){
    len = TEXTMAXLEN ;
    ptr = node->textbuffer + TEXTMAXLEN ;
  } else {
    ptr = node->textbuffer + len + 1 ;
  }
  MYCHAR_SET_END_OF_STRING( *ptr ) ;
  ptr -- ;
  for( i = len ; i > pos ; i -- ){
    *ptr = *( ptr - 1 ) ;
    ptr -- ;
  }
  *ptr = wchara ;
  /* ޡΰư*/
  move_marker_ByInsert( node, pos, 1 ) ;
  /* cur_pos ++ ; */
  return 0 ;
}

/*
 * ꤵ줿֤ʸޡưؿ
 */
int j_insert_chara
( struct SKKInputNode *node, int pos, int chara )
{
  struct myChar wchara ;

  if( chara & 0x80 ){
    /* ޤͤƤʤɡľϤʤƥʤΡ */
    return 0 ;
  } else {
    wchara.charset = CHARSET_ASCII ;
    wchara.chara   = chara ;
  }
  return j_insert_myChara( node, pos, wchara ) ;
}

/*
 * Ϥ줿ʸ¸ߤ prefix ǤСTrue 򡢤Ǥʤ
 * False ֤ؿ
 */
static int j_kana_prefix_check
( struct myChar *str, int chara )
{
  int i, length = myCharStrlen( str ) ;

  for( i = 0 ; skk_prefix_list[ i ] != NULL ; i ++ ){
    /* ץեʤΤǤ礦 */
    if( !myCharCharStrncmp( str, skk_prefix_list[ i ], length ) ){
      /* ٤äǸϤ줿ʸΤȰפˤ *
       * ̵뤹롣*/
      if( ( skk_prefix_list[ i ] )[ length + 0 ] != chara )
	continue ;
      /* Ϥ줿ʸäơ٤ʤäܤ */
      if( ( skk_prefix_list[ i ] )[ length + 1 ] != '\0' )
	continue ;
      return True ;
    }
  }
  return False ;
}

/*
 * j_prefix Ϥ줿ʸ­ؿ
 */
static int j_prefix_add
( struct myChar *j_prefix, int chara )
{
  struct myChar wchara ;
  /* ޤΤľϤǤΤǤ礦 */
  if( chara & 0x80 )
    return False ;
  wchara.charset = CHARSET_ASCII ;
  wchara.chara   = chara ;
  while( j_prefix->chara != '\0' )
    j_prefix ++ ;
  *j_prefix ++ = wchara ;
  MYCHAR_SET_END_OF_STRING( *j_prefix ) ;
  return True ;
}

/*
 * ꤵ줿ΰؿ
 */
int j_delete_region
( struct SKKInputNode *node, int startpoint, int endpoint )
{
  struct myChar *sptr, *dptr ;

  if( startpoint == endpoint || startpoint > endpoint )
    return 0 ;

#ifdef DEBUG_LV1
  fprintf( stderr, "j-delete-region : \"" ) ;
#endif
  /* ΰκԤ*/
  dptr = node->textbuffer + startpoint ;
  sptr = node->textbuffer + endpoint ;
  while( !IS_END_OF_STRING( *sptr ) ){
    *dptr ++ = *sptr ++ ;
  }
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
#ifdef DEBUG_LV1
  fprintf( stderr, "\"\n" ) ;
#endif
  /* ޡ(ߡ)ΰư*/
  move_marker_ByDeleteRegion( node, startpoint, endpoint ) ;
  return 0 ;
}

/*
 * ꤵ줿֤饫̤ʸäؿ
 *-----
 * delete_region ޤΤȤǤ衣
 */
static int delete_char
( struct SKKInputNode *node, int pos, int count )
{
  int i, length ;
  struct myChar *sptr, *dptr ;

  length = myCharStrlen( node->textbuffer ) ;
  i = length - ( pos + count ) ;
  if( i <= 0 ){
    MYCHAR_SET_END_OF_STRING( node->textbuffer[ pos ] ) ;
    /* õ褦ȤƤ֤鱦Υޡƾõ֤ء*/
    set_marker_ByGeqPosition( node, pos, pos ) ;
    return 0 ;
  }
  dptr = node->textbuffer + pos ;
  sptr = node->textbuffer + pos + count ;
  while( i > 0 ){
    *dptr ++ = *sptr ++ ;
    i -- ;
  }
  if( IS_END_OF_STRING( *sptr ) )
    MYCHAR_SET_END_OF_STRING( *dptr ) ;
  /* ޡΰư*/
  move_marker_ByDeleteRegion( node, pos, pos + count ) ;
  return 0 ;
}

/*
 * Emacs-Lisp  Looking-At ؿ
 *-----
 * ͡äˤʤǤ졣
 */
static int looking_at
( struct SKKInputNode *node, int pos, struct myChar chara )
{
  /* ɤʸ°ƤƤ chara ʤäܡ*/
  if( node->textbuffer[ pos ].chara != chara.chara )
    return False ;
  /* Ʊʸ°ƤСchara ɤ*/
  if( node->textbuffer[ pos ].charset == chara.charset )
    return True ;
  /* ɤ ASCII ä顢chara ɤ*/
  if( IS_ASCII_CHARA( chara ) &&
      IS_ASCII_CHARA( node->textbuffer[ pos ] ) )
    return True ;
  return False ;
}

int j_kakutei_kana_mode
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  if( !node->j_kana_mode )
    return False ;
  /* ԥʤɡrom-kana-rule-list 줿ʤ˻Ȥ '\0' */
  if( chara != '\0' ){
    if( rom_kana_rule_list_check( node, chara ) ){
      /* 겾̾ϤǥҥåȤ顢̾γˤѴ *
       * ʤФʤʤ*/
      if( node->j_henkan_mode && !node->j_henkan_on &&
	  node->j_okurigana_mode ){
	j_set_okurigana( gw, sbuffer, node, node->j_okuri_chara ) ;
      }
      return True ;
    }
  }
  /* Ǹ "n" äƤơ줬ѤϤ ""ˤʤä顩 */
  if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'n' ) &&
      IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
    j_n_convert_to_kana( node ) ;
    node->j_kana_mode = False ;
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
    if( node->j_henkan_mode && !node->j_henkan_on &&
	node->j_okurigana_mode ){
      struct myChar chara ;
      MYCHAR_SET_CHARA( chara, 'n' ) ;
      j_set_okurigana( gw, sbuffer, node, chara ) ;
    }
    return False ;
  }
  j_delete_region( node, node->j_kana_start_point, node->cur_pos ) ;
  node->j_kana_mode = False ;
  MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
  return False ;
}

/*
 * ̾ѴγȤԤؿʤΤǤ롣
 */
int j_kakutei
( Widget gw, struct SKKInputNode *node )
{
  int pos ;
  struct myChar j_toroku_string[ TEXTBUFSIZE ] ;
  struct myChar chara ;

  node->j_mode    = True ;
  node->j_zenkaku = False ;
  node->j_abbrev  = False ;
  node->j_henkan_show_candidate_mode = False ;

  MYCHAR_SET_END_OF_STRING( node->j_num_list[ 0 ] ) ;

  /* Ѵ⡼ɤäƤΤɤǧ롣ΥȤ active  *
   * on β᤬դˤʤäƤ롣                                          */
  if( node->j_henkan_mode ){
    if( node->j_henkan_on && ( node->j_henkan_count > 0 ) ){
      /* ǡιʤ뤬...ޤưʡ */
      if( node->j_current_henkan_vector_index != NULL ){
	struct myChar *henkankey = ( node->j_okurigana_mode )? 
	  node->j_henkan_key : node->j_search_key ; 
	/* ΤޤϿƤޤȤޤã뤫⤷ʤΤ *
	 * 롣*/
	copyCandidate
	  ( j_toroku_string,
	    node->j_current_henkan_vector_index->node,
	    node->j_current_henkan_vector_index->position,
	    node->j_current_henkan_vector_index->length ) ;
	if( j_quote_char( j_toroku_string ) ){
	  /* ʸνä顢ʤĤʤϿ *
	   * ʤʸϿ롣*/
	  add_SudeniHenkanKakuteiShitamonoByString
	    ( henkankey, j_toroku_string, node->j_okurigana_mode ) ;
	  /* Ͽñο䤹*/
	  skkinput_j_count_touroku ++ ;
	} else {
	  /* ʸνʤäˤϡ list Τޤ޻Ȥ *
	   * 뤫list ĤʤϿ롣*/
	  add_SudeniHenkanKakuteiShitamono
	    ( henkankey,
	      &node->j_henkan_vector_index_top,
	      node->j_current_henkan_vector_index,
	      node->j_okurigana_mode ) ;
	}
	skkinput_j_count_kakutei ++ ;
      }
      /* ѤƤβ*/
      free_VectorIndex( &( node->j_henkan_vector_index_top ) ) ;
      free_SkkinpSearchVector( &( node->j_henkan_vector_top ) ) ;
      node->j_current_henkan_vector_index = NULL ;
    }
    pos = node->j_henkan_start_point - 1 ;	/* goto-char */
    if( node->j_henkan_on ){
      MYCHAR_SET_JISX0208_1983( chara, 0x2227 /**/ ) ;
      /* Ѵϰ֤ˡ֢פϤΤ ̵ä顢ѡ*/
      if( looking_at( node, pos, chara ) ){
	delete_char( node, pos, 1 ) ;
      } else {
	err_msg( node, "It seems that you have deleted ." ) ;
      }
    } else {
      MYCHAR_SET_JISX0208_1983( chara, 0x2226 /**/ ) ;
      if( looking_at( node, pos, chara ) ){
	delete_char( node, pos, 1 ) ;
      } else {
	err_msg( node, "It seems that you have deleted ." ) ;
      }
    }
    /* ư겾̾⡼ɤäν*/
    if( node->j_okurigana_mode ){
      MYCHAR_SET_CHARA( chara, 0x2A /* "*" */ ) ;
      /* 겾̾ϰ֤ˤ "*" ¸ߤȦʤǤɡġ*/
      pos = node->j_okurigana_start_point ;
      if( looking_at( node, pos, chara ) ){
	delete_char( node, pos, 1 ) ;
      }
      /* Ȥ櫓ǡ겾̾⡼ɤߤˤʤ櫓Ǥ*/
      node->j_okurigana_mode = False ;
      MYCHAR_SET_END_OF_STRING( node->j_okuri_chara ) ;
    }
    /* j_abbrev = False ; */
  }
  node->j_henkan_mode      = False ;
  node->j_henkan_on        = False ;
  node->j_okurigana_mode   = False ;
  MYCHAR_SET_END_OF_STRING( node->j_okuri_chara ) ;
  node->j_henkan_count     = 0 ;
  /* Ѵ⡼ɤǤϤʤʤäΤ顢ʤȤѴϰ֤Ѵ *
   * λ֡겾̾ΰ֤ϥꥢ롣*/
  node->j_henkan_start_point    = -1 ;
  node->j_henkan_end_point      = -1 ;
  node->j_okurigana_start_point = -1 ;
  return 0 ;
}

/*
 * skkinput-rom-kana-rule-list ŬѤؿ
 */
int rom_kana_rule_list_check
( struct SKKInputNode *node, int chara )
{
  struct skk_rom_kana_rule *element ;
  struct myChar wchara ;
  int length = myCharStrlen( node->j_prefix ) ;

  /* ɤľϤʤƤΤϥʤΤǤ礦 */
  if( chara & 0x80 )
    return False ;

  /* Ѵ롣*/
  MYCHAR_SET_CHARA( wchara, chara ) ;

  /* ʸäޤ*/
  node->j_prefix[ length + 0 ] = wchara ;
  MYCHAR_SET_END_OF_STRING( node->j_prefix[ length + 1 ] ) ;
  /* ޤߤΥץեǥơ֥Ҥޤ*/
  element = j_assoc_rule( node->j_prefix ) ;
  /* ҥåȤޤ */
  if( element == NULL ){
    /* j-prefix ϸᤷƤޤ*/
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ length + 0 ] ) ;
    return False ;
  }
  /* ̾ץե롣*/
  j_delete_region
    ( node, node->j_kana_start_point, node->cur_pos ) ;
  MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
  /* ̾⡼ɤǤϤʤʤġ*/
  node->j_kana_mode = False ;
  /* ҥåȤʸ롣*/
  if( node->j_katakana_mode ){
    if( element->koutput != NULL )
      j_insert_str( node, node->cur_pos, element->koutput ) ;
  } else {
    if( element->houtput != NULL )
      j_insert_str( node, node->cur_pos, element->houtput ) ;
  }
  if( element->next != NULL ){
    /* ֤¸ߤʤ顢롣*/
    node->j_kana_start_point = node->cur_pos ;
    j_insert_str( node, node->cur_pos, element->next ) ;
    myCharStrcpy( node->j_prefix, element->next ) ;
    node->j_kana_mode = True ;
  }
  /* ŬѤǤȤȤϲ̾γ꤬ä顢ѴϤ¾ *
   * ̣Ȥ롣*/
  return True ;
}

/*
 * ʸե٥åȤϤ褦ȤƤνԤؿ
 *----
 * ʸե٥åȤϡϲ̾Ϥ褦ȤƤִ֤̣
 * ΤǤ롣
 */
int j_kana_input
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  /* skkinput ֤ȴФ*/
  int status = ( node->j_henkan_mode << 3 ) | ( node->j_henkan_on << 2 ) |
    ( node->j_kana_mode << 1 ) | ( node->j_okurigana_mode ) ;
  /* int length ;*/
  struct myChar lchara ;

#ifdef DEBUG_LV0
  fprintf( stderr, "K( j_henkan_mode, j_henkan_on, j_kana_mode,\
j_okurigana_mode ) = (%d,%d,%d,%d)\n", node->j_henkan_mode, 
	   node->j_henkan_on, node->j_kana_mode, node->j_okurigana_mode ) ;
#endif
  if( chara == 'o' ){
    j_insert_o( gw, sbuffer, node, chara ) ;
    MYCHAR_SET_CHARA( node->j_prefix[ 0 ], 'o' ) ;
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
    node->j_kana_mode   = True ;
    /* "o" 줿Υ֤̾γϰ֤ˤʤ롣*/
    node->j_kana_start_point = node->cur_pos ;
    return 0 ;
  }
  /* ɽ*/
  switch( status ){
    /* ѴԤƤǡ̾Ϥʤ겾̾äƤ硣*/
  case J_HENKAN_MODE_ON | J_HENKAN_ON | J_KANA_MODE_OFF | J_OKURIGANA_ON :
    /* 겾̾ѴˤäѴԤ줿ľˡʸϤ *
     * 硣ޤꤷƤ顢Ϥ줿ʸɽ롣*/
    j_kakutei( gw, node ) ;
    goto j_kana_input_label1 ;

    /* ѴԤƤǡ̾Ϥʤ硣*/
  case J_HENKAN_MODE_ON | J_HENKAN_ON | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    /* ȤԤ롣 OFF ξƱ*/
    j_kakutei( gw, node ) ;

  case J_HENKAN_MODE_ON | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON :

    /* ̤˽ФƤβ̾ϡǤ⡢Ĥ...ȴʤΤ *
     * 顢J_HENKAN_MODE_OFF λƱJ_HENKAN_MODE ΤѲ  *
     * ʤפǤ礦                                        */
  case J_HENKAN_MODE_ON | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :

    /* ϤƤʤ֤β̾ϡ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    j_kana_input_label1 : ;
    /* ֤˲̾Ѵϥޡꤹ롣*/
    node->j_kana_start_point = node->cur_pos ;
    /* Ϥ饯ɽ롣ĤǤˡưƤ*
     * */
    j_insert_chara( node, node->cur_pos, chara ) ;
    /* ̾Ϥ顢j-prefix ͭˤʤĤΥߥ󥰤 *
     * ɤΡ */
    j_prefix_add( node->j_prefix, chara ) ;
    /* ̾⡼ɤˤʤ롣*/
    node->j_kana_mode = True ;
    break ;

    /* ֢*sפȤ褦ʾ֤Ǥ롣Ѵ⡼ɤǤꡢ겾̾⡼ *
     * Ǥꡢ̾⡼ɤǤȤΤϡ                                 */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON :
#if 0
    /* ѴԤƤǡ̾prefixϡ겾̾ϤΤ硣*/
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON :
    /* ξϳꤷƤϤʤ겾̾⡼ɤĤƤȤȤ *
     * 겾̾ʤΤꤷƤʤȤȤ顣                 */
#endif
    /* Ѵ⡼ɤǤꡢ˲̾ϤƤ硣*/
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_OFF :

    /* ̾Ϥ褦ȤƤ硣*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
    /* 롼ꥹȤҤޤǡj-prefix Ϲޤ*/
    if( rom_kana_rule_list_check( node, chara ) ){
      /* 겾̾ϤǤꡢ 'n' Ϥˤä *
       * ̾Ǥä 'n' ꤷƤޤν*/
      if( node->j_henkan_mode && node->j_okurigana_mode )
	j_set_okurigana( gw, sbuffer, node, node->j_okuri_chara ) ;
      break ;
    }
    if( chara == 'y' ) {
      if( !myCharCharStrcmp( node->j_prefix, "oh" ) &&
         IS_ASCII_EQUAL( node->textbuffer[ node->j_kana_start_point ], 'h' ) ){
        MYCHAR_SET_CHARA( node->j_prefix[ 0 ], 'h' ) ;
        MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
      }
    }
    /* ̤ơ prefix ¸ߤǤޤΡ 䤵*/
    if( !j_kana_prefix_check( node->j_prefix, chara ) ){
      /* äѤꡢ¸ߤǤޤΤ͡פä̤Ǥ*/
      if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'n' ) && 
	  IS_END_OF_STRING( node->j_prefix[ 1 ] ) ) {
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	/* ̾ϳϰ֤򤺤餹*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	/* ̾Ϥ顢j-prefix ͭˤʤĤΥߥ *
	 * ɤΡ */
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
	/* j_kana_mode = True */
	break ;
      }
      if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o' ) && 
	  IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
	if( chara == 'h' ){
	  node->j_kana_mode = True ;
	  /* ̾ϰ֤򤺤餷ޤȡ*/
	  node->j_kana_start_point = node->cur_pos ;
	  /* Ϥʸ򥫡֤롣*/
	  j_insert_chara( node, node->cur_pos, chara ) ;
	  j_prefix_add( node->j_prefix, chara ) ;
	  break ;
	} else {
	  /*  "o" ϤƤȤϾä*/
	  MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
	  goto j_kana_input_label3 ;
	}
      }
      /* "oh" ΥåԤ*/
      if( !myCharCharStrcmp( node->j_prefix, "oh" ) &&
	  IS_ASCII_EQUAL
	  ( node->textbuffer[ node->j_kana_start_point ], 'h' ) ){
	delete_char( node, node->j_kana_start_point, 1 ) ;
	if( node->j_katakana_mode ){
	  MYCHAR_SET_JISX0208_1983( lchara, 0x252a /*""*/ ) ;
	} else {
	  MYCHAR_SET_JISX0208_1983( lchara, 0x242a /*""*/ ) ;
	}
	j_insert_myChara( node, node->j_kana_start_point, lchara ) ;
	/* ̾ϰ֤򤺤餷ޤȡ*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
	break ;
      }
      /* ɤåΤǤ롣*/
      if( is_hatsuon_ok( node->j_prefix, chara ) ){
	/* ɽƤʸäޤ礦*/
	delete_char( node, node->j_kana_start_point, 1 ) ;
	/* ¥ؤޤ礦*/
	/* ΤȤcur_pos == j_kana_start_point ȦǤ롣*/
	if( node->j_katakana_mode ){
	  MYCHAR_SET_JISX0208_1983( lchara, 0x2543 /*""*/ ) ;
	} else {
	  MYCHAR_SET_JISX0208_1983( lchara, 0x2443 /*""*/ ) ;
	}
	j_insert_myChara( node, node->j_kana_start_point, lchara ) ;
	/* ̾ϰ֤򤺤餷ޤȡ*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
	/* j_kana_mode = True */
	break ;
      }
      /* פʤ prefix ϾõޤƤ衣*/
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
      /* ̾Ѵϰ֤ѹޤ͡*/
      node->j_kana_start_point = node->cur_pos ;
      /* Ϥʸ˽ޤ*/
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
    }
    goto j_kana_input_label3 ;

    /* Ĥɤ롢ɤʤ롢ܿ
     * ɤäƲ褹Τ */
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON :
    /* 겾̾ѴˤäѴԤ줿ľˡʸϤä硣*
     * ޤꤷƤ顢Ϥ줿ʸɽ롣*/
#if 0
    /* ޤǰ̾γ꤬äɤȽǤ롩 ʤ
       ɤߤ顢ϥѥ뤬̤ʤ褦ˤƤ*/
    if( ( node->j_okurigana_start_point + 1 ) <
	node->j_kana_start_point ){
      j_kakutei( gw, node ) ;
      goto j_kana_input_label2 ;
    }
#endif
    /* 롼ꥹȤҤޤǡj-prefix Ϲޤ*/
    if( rom_kana_rule_list_check( node, chara ) ){
      break ;
    }
    /* ̤ơ prefix ¸ߤǤޤΡ 䤵*/
    if( !j_kana_prefix_check( node->j_prefix, chara ) ){
      if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o' ) &&
	  IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
	if( chara == 'h' ){
	  node->j_kana_mode = True ;
	  /* ̾ϰ֤򤺤餷ޤȡ*/
	  node->j_kana_start_point = node->cur_pos ;
	  /* Ϥʸ򥫡֤롣*/
	  j_insert_chara( node, node->cur_pos, chara ) ;
	  j_prefix_add( node->j_prefix, chara ) ;
	  break ;
	} else {
	  /* ξϤ */
	  j_kakutei( gw, node ) ;
	  /*  "o" ϤƤȤϾä*/
	  MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
	  goto j_kana_input_label3 ;
	}
      }
      /* ξϤ */
      j_kakutei( gw, node ) ;
      if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'n' ) && 
	  IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	/* ̾ϳϰ֤򤺤餹*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	/* ̾Ϥ顢j-prefix ͭˤʤĤΥߥ *
	 * ɤΡ */
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
	/* j_kana_mode = True */
	break ;
      }
      /* "oh" ΥåԤ*/
      if( !myCharCharStrcmp( node->j_prefix, "oh" ) &&
	  IS_ASCII_EQUAL( node->textbuffer[ node->j_kana_start_point ], 
			  'h' ) ){
	delete_char( node, node->j_kana_start_point, 1 ) ;
	if( node->j_katakana_mode ){
	  MYCHAR_SET_JISX0208_1983( lchara, 0x252a /*""*/ ) ;
	} else {
	  MYCHAR_SET_JISX0208_1983( lchara, 0x242a /*""*/ ) ;
	}
	j_insert_myChara( node, node->j_kana_start_point, lchara ) ;
	/* ̾ϰ֤򤺤餷ޤȡ*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸɽ*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
	/* node->j_kana_mode = True ;*/
	break ;
      }
      /* ɤåΤǤ롣*/
      if( is_hatsuon_ok( node->j_prefix, chara ) ){
	/* ɽƤʸäޤ礦*/
	delete_char( node, node->j_kana_start_point, 1 ) ;
	/* ¥ؤޤ礦*/
	/* ΤȤcur_pos == j_kana_start_point ȦǤ롣*/
	if( node->j_katakana_mode ){
	  MYCHAR_SET_JISX0208_1983( lchara, 0x2543 /*""*/ ) ;
	} else {
	  MYCHAR_SET_JISX0208_1983( lchara, 0x2443 /*""*/ ) ;
	}
	j_insert_myChara( node, node->j_kana_start_point, lchara ) ;
	/* ̾ϰ֤򤺤餷ޤȡ*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
	/* j_kana_mode = True */
	break ;
      }
      /* פʤ prefix ϾõޤƤ衣*/
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
      /* ̾Ѵϰ֤ѹޤ͡*/
      node->j_kana_start_point = node->cur_pos ;
      /* Ϥʸ˽ޤ*/
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
    } else {
      j_kakutei( gw, node ) ;
    }
  j_kana_input_label3:
    /* Ϥʸɽ*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    j_prefix_add( node->j_prefix, chara ) ;
    break ;

    /* ʲä㤤ʤ֤󤫤ʡ */
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON :
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON :

    /* νϡѴ⡼ɤˤʤäƤʤΤˡѴƤ뤫顣*/
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON :

  default :
    /* λ֤ϤꤨʤΤǡ顼*/
    err_msg( node, "ERROR : Illegal status %d\n", status ) ;
    break ;
  }
  return 0 ;
}

/*
 * ޡѲؿ
 *-----
 * Ϥϥޡΰ֤Ǥ˥ޡ̵ä顢顼֤ޤ
 */
static int j_change_marker( struct SKKInputNode *node, int pos )
{
  if( node->textbuffer[ pos ].charset != CHARSET_JISX0208_1983 ||
      node->textbuffer[ pos ].chara != 0x2226 /**/ )
    return True ;
  MYCHAR_SET_JISX0208_1983( node->textbuffer[ pos ], 0x2227 /**/ ) ;
  return False ;
}

/*
 * ޡѲؿ
 *-----
 * Ϥϥޡΰ֤Ǥ˥ޡ̵ä顢顼֤ޤ
 */
static int j_change_marker_to_write( struct SKKInputNode *node, int pos )
{
  if( node->textbuffer[ pos ].charset != CHARSET_JISX0208_1983 ||
      node->textbuffer[ pos ].chara != 0x2227 /**/ )
    return True ;
  MYCHAR_SET_JISX0208_1983( node->textbuffer[ pos ], 0x2226 /**/ ) ; 
  return False ;
}

/* Show candidates in the minibuffer */
static VectorIndex *j_henkan_show_candidates
( struct SKKInputNode *node, int *count )
{
  int i, restnum, mojisuu, h_count ;
  static char *j_henkan_show_candidates_keys[ 7 ] = {
    "A:", "S:", "D:", "F:", "J:", "K:", "L:",
  } ;
  VectorIndex *vNode ;
  /* 󡢤ˤ⤳ʤǤäХåեɬפˤʤää(;_;) */
  struct myChar buffer[ TEXTBUFSIZE ] ;
  struct myChar *rptr ;

  vNode   = node->j_current_henkan_vector_index ;
  h_count = node->j_henkan_count ; 
  MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;

  /* ĸ䤬ĤäƤΤʡ */
  restnum = node->j_henkan_vector_index_length - h_count + 1 ;

  /* ɽǽʸꡢʾȥХåեդ롣*/
  mojisuu = TEXTMAXLEN ;

  /* 󤷤ޤ*/
  for( i = 0 ; i < 7 && vNode != NULL ; i ++, restnum -- ){
    /* 򥭡դä롣*/
    myCharCharStrncat
      ( node->mtextbuffer, j_henkan_show_candidates_keys[ i ],
	mojisuu ) ;
    mojisuu -= 2 ;
    if( mojisuu <= 0 )
      break ;

    /* դä롣*/
    copyCandidate
      ( temporary_buffer, vNode->node, vNode->position, TEXTMAXLEN ) ;
    rptr = temporary_buffer ;
    if( !IS_END_OF_STRING( node->j_num_list[ 0 ] ) && 
	skkinput_use_numeric_conversion ){
      j_numeric_convert( node, temporary_buffer, buffer, TEXTBUFSIZE ) ;
      rptr = buffer ;
    }
    /* θؤ褦ꤹ롣*/
    vNode = vNode->next ;

    /* ܤθ䤫ꤹ롣*/
    h_count ++ ;
    myCharStrncat( node->mtextbuffer, rptr, mojisuu ) ;
    mojisuu -= myCharStrlen( rptr ) ;
    if( mojisuu <= 0 )
      break ;
    /* ä롣*/
    myCharCharStrncat( node->mtextbuffer, " ", mojisuu ) ;
    mojisuu -- ;
    if( mojisuu <= 0 )
      break ;
  }
  /* ޤʸХåե;͵ޤ */
  if( mojisuu > 0 ){
    /* [Ĥ %d] ä롣*/
    MYCHAR_SET_CHARA( temporary_buffer[ 0 ], '[' ) ;
    temporary_buffer[ 1 ].charset = CHARSET_JISX0208_1983 ;
    temporary_buffer[ 1 ].chara   = 0x3b44 ; /**/
    temporary_buffer[ 2 ].charset = CHARSET_JISX0208_1983 ;
    temporary_buffer[ 2 ].chara   = 0x246a ; /**/
    MYCHAR_SET_CHARA( temporary_buffer[ 3 ], ' ' ) ;
    myCharItoa( temporary_buffer + 4, restnum ) ;
    myCharCharStrcat( temporary_buffer, "]" ) ;
    myCharStrncat( node->mtextbuffer, temporary_buffer, mojisuu ) ;
  }
  /* ʸȤƽü롣*/
  MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ TEXTMAXLEN ] ) ;
  node->j_henkan_show_candidate_mode = True ;

  /* ºݡɤޤǸɽδ֤ơ */
  if( count != NULL )
    *count = h_count ;

  /* ݥ󥿤֤*/
  return vNode ;
}

/*
 * ̾Ѵ򳫻Ϥ˸ƽФ륳Хåؿ
 */
static void j_get_henkan_results
( struct SKKInputNode *node )
{
  SkkinpSearchVector *j_purge_vector_top ;
  VectorIndex *j_purge_vector_index_top ;
  struct myChar *henkankey ;

  /* Ѵ򤹤롣*/
  henkankey = ( node->j_okurigana_mode )?
    node->j_henkan_key : node->j_search_key ;

  node->j_henkan_vector_top = NULL ;
  /* ˵Ƥ뼭񤫤鸡Ԥ*/
  node->j_henkan_vector_top = searchSudeniHenkanKakuteiShitamono
    ( henkankey, node->j_henkan_vector_top,
      node->j_okurigana_mode ) ;
  /* ޤɽ꼭񤫤鸡Ԥ*/
  node->j_henkan_vector_top = j_search_skkinput_local_jisyo
    ( henkankey, node->j_henkan_vector_top, node->j_okurigana_mode ) ;
  /* SKK ֻϤޤ */
  node->j_henkan_vector_top = skkinput_Request
    ( henkankey, node->j_henkan_vector_top ) ;
  /* ơɤ줫ĤǤѴġ*/
  if( node->j_henkan_vector_top != NULL ){
    /* äϥѡθ*/
    j_purge_vector_index_top = NULL ;
    j_purge_vector_top = NULL ;
    j_purge_vector_top = searchSudeniPurgeSaretamono
      ( henkankey, j_purge_vector_top,
	node->j_okurigana_mode ) ;
    /* öϥå˸ߥѡƤáࡣ*/
    /* ڤФ˥ϥå夬ꥢƤϺΤǡFalse Ǥ *
     * 롣ɤ줫ĤǤҥåȤʤСѡꥹȤ򸡺 *
     * ̵̣*/
    if( j_purge_vector_top != NULL ){
      int tmp ;
      j_purge_vector_index_top = makeSearchVectorIndex
	( j_purge_vector_top, &tmp, False ) ;
    }
    /* SKK ֻڤФ*/
    node->j_henkan_vector_index_top =
      makeSearchVectorIndex( node->j_henkan_vector_top,
			     &node->j_henkan_vector_index_length, True ) ;
    /* purge ʤ󤫤ι򤫤路ڤФΤä *
     * ν*/
    if( node->j_henkan_vector_index_top != NULL ){
      /* Ѵꡣ*/
      node->j_henkan_count = 1 ;
      /* Ƭθؤ褦ˤ롣*/
      node->j_current_henkan_vector_index = 
	node->j_henkan_vector_index_top ;
    } else {
      /* purge αƶĲ񤫤äƤɡϤ *
       * ߤܤäʤλȤä㤤ʤä*/
      free_SkkinpSearchVector( &node->j_henkan_vector_top ) ;
      node->j_current_henkan_vector_index = NULL ;
      /* Ѵꡣ*/
      node->j_henkan_count = 0 ;
    }
    /* ѡΤξϤ⤷Ƥ⤦ס */
    free_VectorIndex( &j_purge_vector_index_top ) ;
    free_SkkinpSearchVector( &j_purge_vector_top ) ;
  }
  return ;
}

/*
 * ѴưԤؿ
 *-----
 * δؿ j_start_henkan ƤФƤɬפޤ衣
 */
static int j_henkan
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  int found = False ;

  /* 줬ǽѴäˤϡ*/
  if( node->j_henkan_on != True ){
    /* ֢פ֢פѴ... */
    if ( j_change_marker
	 ( node, node->j_henkan_start_point - 1 ) ){
      err_msg( node, "It seems that you have deleted ." ) ;
      node->j_henkan_mode    = False ;
      node->j_okurigana_mode = False ;
      node->j_kana_mode      = False ;
      return 0 ;
    }
    /* Ѵե饰ΩƤΤǤ롣*/
    node->j_henkan_on    = True ;
    node->j_henkan_count = 0 ;
  }
  /* ѴꤵƤʤΤѴ褦Ȥ顢ꤷƤޤ*/
  if( !myCharStrlen( node->j_henkan_key ) ){
    j_kakutei( gw, node ) ;
    return 0 ;
  }
  /* 줬ǽѴäˤ Σ */
  if( node->j_henkan_count == 0 ){
    /* Ѵγ׵ȯԤ롣*/
    j_get_henkan_results( node ) ;

    /* η̡j_henkan_vector ¾Ѵ̤ȥꥹȤˤʤ*
     * ΤǤ롣*/

    /* Ѵη̤ϤɤäΤʡ */
    if( node->j_henkan_count ){
      found = True ;
    } else {
      found = False ;
    }
  } else {
    if( node->j_henkan_count < 4 ){
      /* ϻͲʾˤʤä顢ɽڤؤȤ롣*/
      if( ( node->j_current_henkan_vector_index )->next != NULL ){
	node->j_current_henkan_vector_index =
	  ( node->j_current_henkan_vector_index )->next ;
	node->j_henkan_count ++ ;
	found = True ;
      }
    } else {
      /* Ͳʾˤʤä顢ɽڤؤ롣*/
      if( ( node->j_current_henkan_vector_index )->next != NULL ){
	/* Ͳʾˤʤäִ֤ NULL Ȥäơ䤬⤦̵ *
	 * ʤäƤ뤳ȤʤȤǧ롣*/
	node->j_current_henkan_vector_index =
	  ( node->j_current_henkan_vector_index )->next ;

	/* ǣĤȤȤˤʤ롣*/
	node->j_henkan_count ++ ;

	node->j_henkan_show_candidate_mode = True ;
	/* Ѵäޤ*/
	j_delete_region
	  ( node, node->j_henkan_start_point, node->j_henkan_end_point ) ;
	/* ΰɽޤȡ*/
	j_henkan_show_candidates( node, NULL ) ;
	/* ǡ򤤤ʤȴޤ*/
	return 0 ;
      }
    }
  }
  if( found ){
#if 1
    if( node->j_henkan_vector_index_top == NULL ){
      fprintf( stderr, "found, but no candidates exist.\n" ) ;
      fflush( stderr ) ;
    } else {
#endif
      /* Ѵäޤ*/
      node->cur_pos2 = node->j_kana_start_point ;
      node->cur_pos3 = node->j_okurigana_start_point ;
      j_delete_region
	( node, node->j_henkan_start_point, node->j_henkan_end_point ) ;
      copyCandidate
	( temporary_buffer, ( node->j_current_henkan_vector_index )->node,
	  ( node->j_current_henkan_vector_index )->position,
	  TEXTMAXLEN ) ;
      node->j_kana_start_point = node->cur_pos ;
      /* Ѵλ֤Ĵ*/
      node->cur_pos_backup = node->cur_pos ;
      node->cur_pos        = node->j_henkan_start_point ;
      /* ʸ*/
#if 0
      j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
#else
      j_insert_word
	( node, node->j_henkan_start_point, temporary_buffer ) ;
#endif
      node->j_henkan_end_point = node->cur_pos ;
      node->j_kana_start_point = node->cur_pos2 ;
      node->j_okurigana_start_point = node->cur_pos3 ;
      node->cur_pos = node->cur_pos_backup ;
    }
  } else {
    /* minibuffer 򳫤ƤѴȤ˰ư롣*/
    skkinput_j_henkan_in_minibuff_init( gw, sbuffer, node ) ;
  }
  return 0 ;
}

/*
 * ʸΥե٥åȤϤ줿ȤˤꡢѴϰ֤ꤵ
 * Ѵ⡼ɤؤȰܹԤȤԤؿ
 * -----
 * 첻ϤͤƤʤϤΤϻҲ
 * ȤȤ򤷤ĺ첻Ϥ줿ξܤ
 * δؿ˵Ҥ뤳Ȥˤʤ롣
 * -----
 * Ҳ ....
 *   1. ̾ϤƤ ... ̾prefixΥå¥֤פΥå
 *   2. ɽȲ̾,Ѵꤹ롣
 *   3. 겾̾⡼ɤɬפ
 */
static int j_set_henkan_point_ByConsonat
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  /* skkinput ֤ȴФ*/
  int status = ( node->j_henkan_mode << 3 ) | ( node->j_henkan_on << 2 ) |
    ( node->j_kana_mode << 1 ) | ( node->j_okurigana_mode ) ;
  int rchara, ret ;
  struct myChar tchara, lchara ;

#ifdef DEBUG_LV0
  fprintf( stderr, "C( j_henkan_mode, j_henkan_on, j_kana_mode,\
j_okurigana_mode ) = (%d,%d,%d,%d)\n", node->j_henkan_mode, 
	   node->j_henkan_on, node->j_kana_mode, node->j_okurigana_mode ) ;
#endif
  /* ʸĤƤ*/
  rchara = chara ;
  /* ʸʸѴ*/
  if( chara >= 'A' && chara <='Z' )
    chara += 'a' - 'A' ;

  /* ɽ*/
  switch( status ){

    /* ϤƤʤ֤Ѵֻꡣ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    j_set_henkan_point_label1 : ;
    MYCHAR_SET_JISX0208_1983( lchara, 0x2226 /*""*/ ) ;
    /* ɽơ*/
    j_insert_myChara( node, node->cur_pos, lchara ) ;
    /* Ѵϰ֤򥫡֤˷ꤷơ*/
    node->j_henkan_start_point = node->cur_pos ;
    node->j_kana_start_point   = node->cur_pos ;
    /* Ѵ⡼ɡ̾ϥ⡼ɤ򥪥ˤ롣*/
    node->j_henkan_mode = node->j_kana_mode = True ;
    /* ֤˥饯ɽ롣*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
    break ;

    /* ѴǤʤΤ겾̾⡼ɤˤʤ뤳ȤϤʤ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON :
    break ;

    /* ˲̾⡼ɤǤäν*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON | J_OKURIGANA_OFF :
    /* ǽ˾ʸäƤ顢ʸäĥ롼ꥹ *
     * Ȥ˥ҥåȤˤϡѴϤˤϤʤʤ*/
    if( rom_kana_rule_list_check( node, rchara ) ){
      break ;
    }
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
      node->j_kana_mode = False ;
      /* β̾⡼ɤ "o" ˤΤǤä顢Ȥ¸ߤ *
       * ʤΤȤư*/
      goto j_set_henkan_point_label1 ;
    }
    /* 괺Ѵ⡼ɤذܹԤ롣*/
    node->j_henkan_mode = True ;
    /* ("sk" "sk" ("". "")) Ȥ§äˤϡprfix check *
     * ʤäƤϤޤޥ*/
    if( !rom_kana_rule_list_check( node, chara ) ){
      /* ξ硢prefix Ȥ¥νȤޤ롣*/
      if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'n' ) &&
	  IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	/* ޡ*/
	MYCHAR_SET_JISX0208_1983( lchara, 0x2226 /*""*/ ) ;
	j_insert_myChara( node, node->cur_pos, lchara ) ;
	/* Ѵϰ֤ꡣϡ֢פΰ֤ˤ碌롣*/
	node->j_henkan_start_point = node->cur_pos ;
	node->j_kana_start_point   = node->cur_pos ;
	j_insert_chara( node, node->cur_pos, chara ) ;
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
	node->j_kana_mode = True ;
	break ;
      }
      /* ¥ɤåΤǤ롣*/
      if( IS_ASCII_EQUAL( node->textbuffer[ node->j_kana_start_point ],
			  chara ) && chara != 'x' ){
	/* ɽƤʸäޤ礦*/
	delete_char( node, node->j_kana_start_point, 1 ) ;
	/* ¥ؤޤ礦*/
	/* ΤȤcur_pos == j_kana_start_point ȦǤ롣*/
	if( node->j_katakana_mode ){
	  MYCHAR_SET_JISX0208_1983( lchara, 0x2543 /*""*/ ) ;
	} else {
	  MYCHAR_SET_JISX0208_1983( lchara, 0x2443 /*""*/ ) ;
	}
	j_insert_myChara( node, node->j_kana_start_point, lchara ) ;
	/* ޡ*/
	MYCHAR_SET_JISX0208_1983( lchara, 0x2226 /*""*/ ) ;
	j_insert_myChara( node, node->j_kana_start_point, lchara ) ;
	node->j_henkan_start_point =
	  node->j_kana_start_point + 1 ;
	/* ̾ϰ֤򤺤餷ޤȡ*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
#if 0
	fprintf( stderr, "(c,k,h) = ( %d, %d, %d )\n", node->cur_pos,
		 node->j_kana_start_point, node->j_henkan_start_point ) ;
#endif
	/* j_kana_mode = True */
	break ;
      }
      /* ̤ơ prefix ¸ߤǤޤΡ 䤵*/
      if( !j_kana_prefix_check( node->j_prefix, chara ) ){
	/* äѤꡢ¸ߤǤޤΤ͡פä̤Ǥ*/
	/* פʤ prefix ϾõޤƤ衣*/
	delete_char( node, node->j_kana_start_point, 
		     node->cur_pos - node->j_kana_start_point ) ;
	/* ̾Ѵϰ֤ѹޤ͡*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸɽ*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
      } else {
	/* Ϥʸɽ*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	j_prefix_add( node->j_prefix, chara ) ;
      }
    }
    /* ޡ*/
    MYCHAR_SET_JISX0208_1983( lchara, 0x2226 /*""*/ ) ;
    j_insert_myChara( node, node->j_kana_start_point, lchara ) ;
    /* Ѵϰ֤ꡣϡ֢פΰ֤ˤ碌롣*/
    node->j_henkan_start_point =
      node->j_kana_start_point + 1 ;
    node->j_kana_start_point   =
      node->j_henkan_start_point ; /* 2 == strlen( "" ) */
    break ;

    /* ѴǤʤΤ겾̾⡼ɤˤʤ뤳ȤϤʤ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON :

    /* Ѵ⡼ɤ˰ܹԤƤʤΤˡѴǤ뤳ȤϤʤ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    break ;
    
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
    if( rom_kana_rule_list_check( node, rchara ) ){
      break ;
    }
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
      node->j_kana_mode = False ;
      /* β̾⡼ɤ "o" ˤΤǤä顢Ȥ¸ߤ *
       * ʤΤȤư*/
      goto j_set_henkan_point_label2 ;
    }
    /* ξ硢prefix Ȥ¥νȤޤ롣*/
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'n' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      if( node->j_henkan_start_point == node->j_kana_start_point ){
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	if( chara == 'n' ){
	  node->j_kana_mode = False ;
	  MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
	} else {
	  /* ֤ꡣ*/
	  node->j_kana_start_point = node->cur_pos ;
	  /* ̾ϥ⡼ɤذܹԡ*/
	  node->j_kana_mode = True ;
	  /* Ϥʸɽ롣*/
	  j_insert_chara( node, node->cur_pos, chara ) ;
	  MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	  MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
	}
      } else {
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	/* ֤겾̾γϥݥȡ*/
	node->j_okurigana_start_point = node->cur_pos ;
	/* 겾̾γϥݥȤˡ*פ롣*/
	j_insert_chara( node, node->cur_pos, '*' ) ;
	/* 겾̾⡼ɤذܹԤ롣*/
	node->j_okurigana_mode = True ;
	MYCHAR_SET_CHARA( node->j_okuri_chara, chara ) ;
	/* ֤ꡣ*/
	node->j_kana_start_point = node->cur_pos ;
	/* ̾ϥ⡼ɤذܹԡ*/
	node->j_kana_mode = True ;
	/* Ϥʸɽ롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
      }
      break ;
    }
    /* Ϥ "n" Ǥäν*/
    if( chara == 'n' ){
      /*
       * ξϴǼ¹ԤƤΤǡǤϤʤ
       * if( textbuffer[ j_kana_start_point ] == 'n' ){
       */
      delete_char( node, node->j_kana_start_point, 1 ) ;
      /* ֤ꡣ*/
      node->j_kana_start_point = node->cur_pos ;
      /* ̾ϥ⡼ɤذܹԡ*/
      node->j_kana_mode = True ;
      /* Ϥʸɽ롣*/
      j_insert_chara( node, node->cur_pos, chara ) ;
      MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
      break ;
    }
    /* ¥ɤåΤǤ롣*/
    if( IS_ASCII_EQUAL
	( node->textbuffer[ node->j_kana_start_point ], chara ) && 
	chara != 'x' ){
      /* ɽƤʸäޤ礦*/
      delete_char( node, node->j_kana_start_point, 1 ) ;
      /* ¥ؤޤ礦*/
      /* ΤȤcur_pos == j_kana_start_point ȦǤ롣*/
      if( node->j_katakana_mode ){
	MYCHAR_SET_JISX0208_1983( lchara, 0x2543 /*""*/ ) ;
      } else {
	MYCHAR_SET_JISX0208_1983( lchara, 0x2443 /*""*/ ) ;
      }
      j_insert_myChara( node, node->j_kana_start_point, lchara ) ;

      /* ֤겾̾γϥݥȡ*/
      node->j_okurigana_start_point = node->cur_pos ;
      /* 겾̾γϥݥȤˡ*פ롣*/
      j_insert_chara( node, node->cur_pos, '*' ) ;
      /* 겾̾⡼ɤذܹԤ롣*/
      node->j_okurigana_mode = True ;
      MYCHAR_SET_CHARA( node->j_okuri_chara, chara ) ;
      /* ֤ꡣ*/
      node->j_kana_start_point = node->cur_pos ;
      /* Ϥʸɽ롣*/
      j_insert_chara( node, node->cur_pos, chara ) ;
      MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
      /* j_kana_mode = True */
      break ;
    }
    /* rom-kana-rule-list Ƥޤä顢j-prefix Ͻ *
     *   Ƥޤ⤷ޤ*/
    /* ֤ƤäȡȤϤ餫ФƤФäƤȤʡ*/
    /* ֤îޡ*/
    tchara = node->j_prefix[ 0 ] ;
    /* ("sk" "sk" ("". "")) Ȥ§äˤϡprfix check *
     * ʤäƤϤޤ*/
    if( rom_kana_rule_list_check( node, chara ) ){
      /* ְãǤʤˤꤤޤΤˡġQskK ʤ *
       *   Ϥʤʤơġ */
      node->cur_pos_backup = node->cur_pos ;
      node->cur_pos = node->j_kana_start_point ;
      ret = is_okurigana_start_ok( node ) ;
      node->cur_pos = node->cur_pos_backup ;
      /* ֤ۤۤ顢ͤͤ"QskK"  "Ӥ" äƽФ *
       *   衣Ƹơġ */
      /* 餱ޤ(ϥХ) */
      if( ret ){
	/* ֤겾̾γϥݥȡ*/
	node->j_okurigana_start_point = node->j_kana_start_point ;
	node->cur_pos2 = node->j_kana_start_point ;
	/* 겾̾γϥݥȤˡ*פ롣*/
	j_insert_chara( node, node->j_okurigana_start_point, '*' ) ;
	node->j_kana_start_point = node->cur_pos2 ;
	/* 겾̾⡼ɤذܹԤ롣*/
	node->j_okurigana_mode = True ;
	node->j_okuri_chara = tchara ;
	j_set_okurigana( gw, sbuffer, node, node->j_okuri_chara ) ;
      }
      break ;
    }
    /* ̤ơ prefix ¸ߤǤޤΡ 䤵*/
    if( !j_kana_prefix_check( node->j_prefix, chara ) ){
      /* פʤ prefix ϾõޤƤ衣*/
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
      /* äѤꡢ¸ߤǤޤΤ͡פä̤Ǥ*/
      if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'n' ) &&
	  IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
	/* nפ֤פѴʤȤʤΤɤå*/
	/* ̾ϰ֤ɽƤnפä*/
	j_n_convert_to_kana( node ) ;
	/* ̾ϳϰ֤򤺤餹*/
	node->j_kana_start_point = node->cur_pos ;
	/* Ϥʸ򥫡֤롣*/
	j_insert_chara( node, node->cur_pos, chara ) ;
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
	/* j_kana_mode = True */
	break ;
      }
      if( is_okurigana_start_ok( node ) ){
	/* ֤겾̾γϥݥȡ*/
	node->j_okurigana_start_point = node->cur_pos ;
	/* 겾̾γϥݥȤˡ*פ롣*/
	j_insert_chara( node, node->cur_pos, '*' ) ;
	/* 겾̾⡼ɤذܹԤ롣*/
	node->j_okurigana_mode = True ;
	MYCHAR_SET_CHARA( node->j_okuri_chara, chara ) ;
      }
      node->j_kana_start_point = node->cur_pos ;
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
    } else {
      if( !IS_END_OF_STRING( node->j_prefix[ 0 ] ) && 
	  is_okurigana_start_ok( node ) ){
	/* ޤʸõ롣*/
	j_delete_region
	  ( node, node->j_kana_start_point, node->cur_pos ) ;
	/* ֤겾̾γϥݥȡ*/
	node->j_okurigana_start_point = node->cur_pos ;
	/* 겾̾γϥݥȤˡ*פ롣*/
	j_insert_chara( node, node->cur_pos, '*' ) ;
	/* 겾̾⡼ɤذܹԤ롣*/
	node->j_okurigana_mode = True ;
	/* ʤȡ줿ΤǰߤĤ*/
	MYCHAR_SET_CHARA( node->j_okuri_chara, chara ) ;
	node->j_kana_start_point = node->cur_pos ;
      }
    }
    /* ̾ϥ⡼ɤذܹԡ*/
    node->j_kana_mode = True ;
    /* Ϥʸɽ롣*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    j_prefix_add( node->j_prefix, chara ) ;
    break ;

    /* Ѵ⡼ɤʸե٥åȤϤ줿ˤ겾̾⡼ɤ */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    j_set_henkan_point_label2 : ;
    /* ǥ֤ 0 礭ȤƤޤɡ *
     * ͳϴñƬѴ򳫻ϤƤ⡢2 ˤʤ뤫顣*/
    if( is_okurigana_start_ok( node ) ){
      /* ֤겾̾γϥݥȡ*/
      node->j_okurigana_start_point = node->cur_pos ;
      /* 겾̾γϥݥȤˡ*פ롣*/
      j_insert_chara( node, node->cur_pos, '*' ) ;
      /* 겾̾⡼ɤذܹԤ롣*/
      node->j_okurigana_mode = True ;
      MYCHAR_SET_CHARA( node->j_okuri_chara, chara ) ;
    }
    /* ֤ꡣ*/
    node->j_kana_start_point = node->cur_pos ;
    /* ̾ϥ⡼ɤذܹԡ*/
    node->j_kana_mode = True ;
    /* Ϥʸɽ롣*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
    break ;

    /* ֢*sפȤ褦ʾ֤Ǥ롣Ѵ⡼ɤǤꡢ겾̾⡼ *
     * Ǥꡢ̾⡼ɤǤȤΤϡ̾⡼ɤǤʤʤ   *
     * 겾̾⡼ɤȦϤʤΤǡξ֤¸ߤʤ             */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
    break ;

    /* ֢*sפȤ褦ʾ֤Ǥ롣Ѵ⡼ɤǤꡢ겾̾⡼ *
     * Ǥꡢ̾⡼ɤǤȤΤϡ                                 */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    if( rom_kana_rule_list_check( node, rchara ) ){
      break ;
    }
    /* ˰Ϥ "o" ȤäĤȤϤꤨʤ*
     * ͳ j_henkan_off ǤϤʤ顣ɬѴäƤ롪 */
#if defined(DEBUG)
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      fprintf
	( stderr, "stray \"o\" in j-set-henkan-point-by-consonat.\n" ) ;
    }
#endif
    /* ξʸϤ⾮ʸϤطʤʸλν롣*/
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'n' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      /* nפ֤פѴʤȤʤΤɤå*/
      /* ̾ϰ֤ɽƤnפä*/
      j_n_convert_to_kana( node ) ;
      /* ̾ϳϰ֤򤺤餹*/
      node->j_kana_start_point = node->cur_pos ;
      /* Ϥʸ򥫡֤롣*/
      j_insert_chara( node, node->cur_pos, chara ) ;
      MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
      /* j_kana_mode = True */
      /* äȡ֤פ˳ꤷƤޤȤȤѴȤɬפˤʤ롣*/
      /* ȻפäɡǤʤߤ*/
      break ;
    }
    /* ¥ɤåΤǤ롣*/
    if( IS_ASCII_EQUAL( node->textbuffer[ node->j_kana_start_point ],
			chara ) && chara != 'x' ){
      /* ɽƤʸäޤ礦*/
      delete_char( node, node->j_kana_start_point, 1 ) ;
      /* ¥ؤޤ礦*/
      /* ΤȤcur_pos == j_kana_start_point ȦǤ롣*/
      if( node->j_katakana_mode ){
	MYCHAR_SET_JISX0208_1983( lchara, 0x2543 /*""*/ ) ;
      } else {
	MYCHAR_SET_JISX0208_1983( lchara, 0x2443 /*""*/ ) ;
      }
      j_insert_myChara( node, node->j_kana_start_point, lchara ) ;
      /* ̾ϰ֤򤺤餷ޤȡ*/
      node->j_kana_start_point = node->cur_pos ;
      /* Ϥʸ򥫡֤롣*/
      j_insert_chara( node, node->cur_pos, chara ) ;
      MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
      /* j_kana_mode = True */
      break ;
    }
    /* ̤ơ prefix ¸ߤǤޤΡ 䤵*/
    if( !j_kana_prefix_check( node->j_prefix, chara ) ){
      /* äѤꡢ¸ߤǤޤΤ͡פä̤Ǥ*/
      /* פʤ prefix ϾõޤƤ衣*/
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
      /* ̾Ѵϰ֤ѹޤ͡*/
      node->j_kana_start_point = node->cur_pos ;
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
    }
    /* Ϥʸɽ*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    j_prefix_add( node->j_prefix, chara ) ;
    break ;
    
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    /* ξˤϳȤԤ줿塢not_active, henkan_off Ʊ*/
    j_kakutei( gw, node ) ;
    goto j_set_henkan_point_label1 ;

    /* ѴԤƤǡ̾prefixϤʤ겾̾ϤΤ硣*/
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
    /* ξˤϳȤԤ줿塢not_active, henkan_off, okuri_off */
    j_kakutei( gw, node ) ;
    goto j_set_henkan_point_label1 ;

  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    /* o ˤäơ̾⡼ɤǤꡢѴ椫겾̾⡼ɤ¸
       ߤ롣λˤɤ뤫 */
    /* ʳξˤϡ̾ꤹСѴϳꤷƤޤΤǡ
       ξ֤ˤʤ뤳Ȥ̵ȹͤƤ롣*/
    if( rom_kana_rule_list_check( node, rchara ) ){
      break ;
    }
    /* ꤹ롣*/
    j_kakutei( gw, node ) ;
    goto j_set_henkan_point_label1 ;
  }
  return 0 ;
}

/*
 * ʴѴơ֥ơ̤֤ؿ
 */
static struct myChar *my_assoc_table_search
( struct SKKInputNode *node, struct roma_kana_table *table,
  struct myChar *key )
{
  struct roma_kana_table *ptr = table ;
  /* ơ֥Ҥ*/
  while( !IS_END_OF_STRING( *( ptr->prefix ) )
	 || !IS_END_OF_STRING( *( ptr->kana ) )
	 || !IS_END_OF_STRING( *( ptr->katakana ) ) ){
    if( !myCharStrcmp( ptr->prefix, key ) ){
      if( node->j_katakana_mode ){
	/* Ҳ̾äν*/
	return ptr->katakana ;
      } else {
	/* ʿ̾äν*/
	return ptr->kana ;
      }
    }
    ptr ++ ;
  }
  return NULL ;
}

/*
 * 겾̾ꤷѴȤؤȰưؿ
 *-----
 * Ĥޤꡢ֢ߡפξ֤ʸ "R" Ϥˡ֢*פ
 * ʤä ֢פؤѲȤԤ
 */
int j_set_okurigana
( Widget gw, struct skkinputBuffer *sbuffer, 
  struct SKKInputNode *node, struct myChar j_okuri_chara )
{
  int usage, copy_sareta_mojisuu ;
  int henkan_stpos, okuri_stpos, okuri_endpos, copy_suru_mojisuu ;
  /* Ѵλ֤ꡣ*/
  node->j_henkan_end_point = node->j_okurigana_start_point ;
  /* '*' ¸ߤ뤫ɤΥå*/
  if( !IS_ASCII_EQUAL
      ( node->textbuffer[ node->j_okurigana_start_point ], '*' ) ){
    j_insert_chara( node, node->j_okurigana_start_point, '*' ) ;
  }
  /* ñϿλɽʸ¸Ƥ*/
  copy_suru_mojisuu =
    node->j_okurigana_start_point - node->j_henkan_start_point ;
  /* Хåե򤢤դ뤳Ȥʤ̵Ȼפɤ͡*/
  if( copy_suru_mojisuu >= 0 ){
    henkan_stpos = node->j_henkan_start_point ;
  } else {
    henkan_stpos      = node->j_okurigana_start_point ;
    copy_suru_mojisuu = -copy_suru_mojisuu ;
  }
  if( node->j_katakana_mode ){
    copy_sareta_mojisuu = myCharHiraKataStrnncpy
      ( node->j_henkan_key2,             TEXTMAXLEN,
	node->textbuffer + henkan_stpos, copy_suru_mojisuu ) ;
  } else {
    myCharStrncpy
      ( node->j_henkan_key2, node->textbuffer + henkan_stpos,
	copy_suru_mojisuu ) ;
    copy_sareta_mojisuu = copy_suru_mojisuu ;
  }
  usage = copy_sareta_mojisuu ;
  MYCHAR_SET_CHARA( node->j_henkan_key2[ usage ], '*' ) ;
  usage ++ ;
  MYCHAR_SET_END_OF_STRING( node->j_henkan_key2[ usage ] ) ;
  /* 겾̾ȴФƲä롣*/
  okuri_stpos = ( node->j_okurigana_start_point < TEXTMAXLEN )?
    node->j_okurigana_start_point + 1 : node->j_okurigana_start_point ;
  if( node->j_kana_mode ){
    okuri_endpos = node->j_kana_start_point ;
  } else {
    okuri_endpos = node->cur_pos ;
  }
  /* ɤΰ̤ʸȴФΡ */
  if( okuri_stpos > okuri_endpos ){
    swap_int( okuri_stpos, okuri_endpos ) ;
  }
  copy_suru_mojisuu = okuri_endpos - okuri_stpos ;
  /* ȡХåե줵뤳Ȥ̵褦ꤷޤ*/
  if( ( copy_suru_mojisuu + usage ) > TEXTMAXLEN ){
    copy_suru_mojisuu = TEXTMAXLEN - usage ;
  }
  /* ȡʸäޤ*/
  if( node->j_katakana_mode ){
    copy_sareta_mojisuu = myCharHiraKataStrnncat
      ( node->j_henkan_key2,            copy_suru_mojisuu,
	node->textbuffer + okuri_stpos, copy_suru_mojisuu ) ;
  } else {
    myCharStrncat
      ( node->j_henkan_key2, node->textbuffer + okuri_stpos,
	copy_suru_mojisuu ) ;
    copy_sareta_mojisuu = copy_suru_mojisuu ;
  }
  MYCHAR_SET_END_OF_STRING
    ( node->j_henkan_key2[ copy_sareta_mojisuu + usage ] ) ;

  copy_suru_mojisuu = node->j_henkan_end_point - node->j_henkan_start_point ;
  if( copy_suru_mojisuu >= 0 ){
    henkan_stpos      = node->j_henkan_start_point ;
  } else {
    henkan_stpos      = node->j_henkan_end_point ;
    copy_suru_mojisuu = -copy_suru_mojisuu ;
  }
  /* Ѵꡣ*/
  if( node->j_katakana_mode ){
    copy_sareta_mojisuu = myCharHiraKataStrnncpy
      ( node->j_henkan_key,              TEXTMAXLEN,
	node->textbuffer + henkan_stpos, copy_suru_mojisuu ) ;
  } else {
    myCharStrncpy
      ( node->j_henkan_key, node->textbuffer + henkan_stpos,
	copy_suru_mojisuu ) ;
    copy_sareta_mojisuu = copy_suru_mojisuu ;
  }
  node->j_okurigana_offset       = usage = copy_sareta_mojisuu ;
  node->j_henkan_key[ usage ++ ] = j_okuri_chara ;
  MYCHAR_SET_END_OF_STRING( node->j_henkan_key[ usage ] ) ;
  /* `*' õ롣*/
  j_delete_region
    ( node, 
      node->j_okurigana_start_point, node->j_okurigana_start_point + 1 ) ;
  /* ѴȤԤ*/
  j_henkan( gw, sbuffer, node ) ;
  return 0 ;
}

/*
 * ʤꤹؿ
 *----
 * kana inserting functions.
 */
static int j_kanakakutei
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node,
  struct roma_kana_table *table, int chara )
{
  struct myChar j_okuri_chara, *str ;

  /* ̾ϤǤ */
  if( !node->j_kana_mode ){
    /* ̾ϤǤʤν*/
#ifdef DEBUG_LV0
    fprintf( stderr, "Now not kana input mode\n" ) ;
#endif
    /* ̾Ϥγϰ֤롣*/
    node->j_kana_start_point = node->cur_pos ;
    /* ̾ prefix ϲ̾γˤäƶˤʤ롣*/
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
    j_okuri_chara = node->j_okuri_chara ;
  } else {
    /* ̾ϤξνĤǤ⡢rule-list ⤢ꡣ*/
    if( rom_kana_rule_list_check( node, chara ) )
      goto j_kanakakutei_rom_kana_rulelist_hit ;

    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ],'o' ) ){
      if( IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
	node->j_kana_mode = False ;
      } else if( IS_ASCII_EQUAL( node->j_prefix[ 1 ],'h' ) &&
		 IS_END_OF_STRING( node->j_prefix[ 2 ] ) ){
	MYCHAR_SET_CHARA( node->j_prefix[ 0 ], 'h' ) ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
      }
    }
    j_okuri_chara = node->j_okuri_chara ;
  }
  /* ̾ prefix 򸫤ơ޻̾ѴԤ*/
  str = my_assoc_table_search( node, table, node->j_prefix ) ;
  /* ޻̾Ѵޤ */
  if( str == NULL ){
    /* ޻̾Ѵ˼Ԥν*/
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
    /* j_okuri_chara = '\0' ; */
    str = my_assoc_table_search( node, table, node->j_prefix ) ;
  }
  /* ꤷƤޤ*/
  /* if( j_kakutei_early && j_henkan_mode ) */
  if( node->j_henkan_on ){
    /* ̾Ϥäܡ*/
    j_kakutei( gw, node ) ;
  }
  if( node->j_kana_mode ){
    /* kana prefix Ĺʬʸä*/
    j_delete_region( node, node->j_kana_start_point, node->cur_pos ) ;
    node->j_kana_mode = False ;
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
  }
  /* ä˲̾Ϥ롣*/
  j_insert_str( node, node->cur_pos, str ) ;
  /* 겾̾⡼ɤäˤϡ겾̾ꤹ롣*/
  /* Ĥޤꡢ겾̾ꤷѴ˰ܤΤ͡*/
  if( node->j_okurigana_mode )
    j_set_okurigana( gw, sbuffer, node, j_okuri_chara ) ;
  return 0 ;

j_kanakakutei_rom_kana_rulelist_hit:
  if( node->j_henkan_on )
    j_kakutei( gw, node ) ;
  if( node->j_okurigana_mode )
    j_set_okurigana( gw, sbuffer, node, node->j_okuri_chara ) ;
  return 0 ;
}

/* 첻Ϥ줿ˤϡ̾ϤγȤ롣*/
int j_insert_a
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  return j_kanakakutei( gw, sbuffer, node, skk_roma_kana_a, chara ) ;
}

/* 첻Ϥ줿ˤϡ̾ϤγȤ롣*/
int j_insert_i
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  return j_kanakakutei( gw, sbuffer, node, skk_roma_kana_i, chara ) ;
}

/* 첻Ϥ줿ˤϡ̾ϤγȤ롣*/
int j_insert_u
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  return j_kanakakutei( gw, sbuffer, node, skk_roma_kana_u, chara ) ;
}

/* 첻Ϥ줿ˤϡ̾ϤγȤ롣*/
int j_insert_e
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  return j_kanakakutei( gw, sbuffer, node, skk_roma_kana_e, chara ) ;
}

/* 첻Ϥ줿ˤϡ̾ϤγȤ롣*/
int j_insert_o
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  return j_kanakakutei( gw, sbuffer, node, skk_roma_kana_o, chara ) ;
}

/*
 * ʸΥե٥åȤϤ줿ȤˤꡢѴϰ֤ꤵ
 * Ѵ⡼ɤؤȰܹԤȤԤؿ
 * -----
 * 첻Ϥ줿νԤ
 * -----
 * 첻 ....
 *   1. ̾ϤƤ ... ޻̾ѴԤ
 *   2. ɽȲ̾,Ѵꤹ롣
 *   3. 겾̾⡼ɤɬפ
 */
static int j_set_henkan_point_ByVowel
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node,
  struct roma_kana_table *table, int chara )
{
  /* skkinput ֤ȴФ*/
  int status = ( node->j_henkan_mode << 3 ) | ( node->j_henkan_on << 2 ) |
    ( node->j_kana_mode << 1 ) | ( node->j_okurigana_mode ) ;
  int pos, rchara ;
  struct myChar pchara, lchara ;

#ifdef DEBUG
  fprintf( stderr, "V( j_henkan_mode, j_henkan_on, j_kana_mode,\
j_okurigana_mode ) = (%d,%d,%d,%d)\n", node->j_henkan_mode,
	   node->j_henkan_on, node->j_kana_mode,
	   node->j_okurigana_mode ) ;
#endif

  /* ʸʸѴ*/
  rchara = chara ;
  if( chara >= 'A' && chara <='Z' )
    chara += 'a' - 'A' ;

  /* ɽ*/
  switch( status ){

    /* ϤƤʤ֤Ѵֻꡣ*/
    /* ξ첻餤ʤ겾̾ѴɤΤǡ̾⡼ɤϥ *
     * ΤޤޤʤΤǤ롣                                                 */
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    j_set_henkan_point_label1 : ;
    /* ɽơ*/
    MYCHAR_SET_JISX0208_1983( lchara, 0x2226 /*""*/ ) ;
    j_insert_myChara( node, node->cur_pos, lchara ) ;
    /* Ѵϰ֤򥫡֤˷ꤷơ*/
    node->j_henkan_start_point = node->cur_pos ;
    /* Ѵ⡼ɤ򥪥ˤ롣*/
    node->j_henkan_mode = True ;
    /* ޻̾ѴԤ*/
    j_kanakakutei( gw, sbuffer, node, table, chara ) ;
    /* "oh" νΤᡣ̾⡼ɤդǤʤȡνϤʤ
       ǤʤС첻ȤƤ o ˤäƲ̾ꤵƤޤ 
       Ǥ롣*/
    if( chara == 'o' ){
      MYCHAR_SET_CHARA( node->j_prefix[ 0 ], 'o' ) ;
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
      /* ̾⡼ɤˤʤ롪 */
      node->j_kana_mode   = True ;
      /* "o" Ϥξ꤬ϰ֡*/
      node->j_kana_start_point = node->cur_pos ;
    } else {
      /* ʤ顢̾⡼ɤϥա*/
      node->j_kana_mode   = False ;
    }
    break ;

  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
    pchara = last_character_of( node->j_prefix ) ;
    /* 롼ꥹȤҤ*/
    if( rom_kana_rule_list_check( node, rchara ) ){
      break ;
    }
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
      node->j_kana_mode = False ;
      /* β̾⡼ɤ "o" ˤΤǤä顢Ȥ¸ߤ *
       * ʤΤȤư*/
      goto j_set_henkan_point_label2 ;
    }
    /* 겾̾ѴˤפʤΤʡ */
    if( is_okurigana_start_ok( node ) ){
      node->cur_pos_backup = node->cur_pos ;
      /* ֤겾̾γϥݥȡ*/
      node->cur_pos = node->j_okurigana_start_point =
	node->j_kana_start_point ;
      /* 겾̾γϥݥȤˡ*פ롣*/
      j_insert_chara( node, node->j_okurigana_start_point, '*' ) ;
      /* ̾ϰ֤ν*/
      node->j_kana_start_point = node->cur_pos ;
      /* ֤򸵤᤹*/
      node->cur_pos = node->cur_pos_backup ;
      /* 겾̾⡼ɤذܹԤ롣*/
      node->j_okurigana_mode = True ;
      node->j_okuri_chara = pchara ;
    }
    /* ޻̾ѴԤ*/
    j_kanakakutei( gw, sbuffer, node, table, chara ) ;
    /* ʤ顢̾⡼ɤϥա*/
#if 0
    node->j_kana_mode   = False ;
    node->j_prefix[ 0 ] = '\0' ;
#endif
    break ;
    
    /* ˲̾⡼ɤǤäν*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
    /* 롼ꥹȤҤ*/
    if( rom_kana_rule_list_check( node, rchara ) ){
      break ;
    }
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
      node->j_kana_mode = False ;
      /* β̾⡼ɤ "o" ˤΤǤä顢Ȥ¸ߤ *
       * ʤΤȤư*/
      goto j_set_henkan_point_label1 ;
    }
    /* β̾ϰ֤򵭲Ƥ*/
    pos = node->j_kana_start_point ;
#if 0
    /* if( IS_ASCII_EQUAL( node->textbuffer[ pos ], 'n' ) ){*/
#else
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'n' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
#endif
      j_n_convert_to_kana( node ) ;
      node->j_kana_mode = False ;
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
      pos = node->cur_pos ;
    }
    /* ޻̾ѴԤ*/
    j_kanakakutei( gw, sbuffer, node, table, chara ) ;
    /* ɽơ*/
    MYCHAR_SET_JISX0208_1983( lchara, 0x2226 /*""*/ ) ;
    j_insert_myChara( node, pos, lchara ) ;
    /* Ѵ⡼ɤ򥪥ˤ롣*/
    node->j_henkan_mode = True ;
    /* Ѵϰ֤ꤷơ*/
    node->j_henkan_start_point = pos + 1 ;
#if 0
    /* ʤ顢̾⡼ɤϥա*/
    node->j_kana_mode   = False ;
#endif
    break ;

    /* ѴǤʤΤ겾̾⡼ɤˤʤ뤳ȤϤʤ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON :
  case J_HENKAN_MODE_OFF | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON :
    break ;

    /* Ѵ⡼ɤ˰ܹԤƤʤΤˡѴǤ뤳ȤϤʤ*/
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_OFF | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    break ;
    
    /* Ѵ⡼ɤʸե٥åȤϤ줿ˤ겾̾⡼ɤ */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    j_set_henkan_point_label2 : ;
    if( is_okurigana_start_ok( node ) ){
      /* ֤겾̾γϥݥȡ*/
      node->j_okurigana_start_point = node->cur_pos ;
      /* 겾̾γϥݥȤˡ*פ롣*/
      j_insert_chara( node, node->cur_pos, '*' ) ;
      /* 겾̾⡼ɤذܹԤ롣*/
      node->j_okurigana_mode = True ;
      MYCHAR_SET_CHARA( node->j_okuri_chara, chara ) ;
    }
    /* Ϥ첻ˤĤƥ޻̾ѴԤ*/
    j_kanakakutei( gw, sbuffer, node, table, chara ) ;
    /* "oh" ν롣*/
    if( chara == 'o' ){
      MYCHAR_SET_CHARA( node->j_prefix[ 0 ], chara ) ;
      MYCHAR_SET_END_OF_STRING( node->j_prefix[ 1 ] ) ;
      /* ̾⡼ɤˤʤ롪 */
      node->j_kana_mode   = True ;
      /* "o" Ϥξ꤬ϰ֡*/
      node->j_kana_start_point = node->cur_pos ;
    }
    break ;

    /* ֢*sפȤ褦ʾ֤Ǥ롣Ѵ⡼ɤǤꡢ겾̾⡼ *
     * Ǥꡢ̾⡼ɤǤȤΤϡ̾⡼ɤǤʤʤ   *
     * 겾̾⡼ɤȦϤʤΤǡξ֤¸ߤʤ             */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
    break ;

    /* ֢*sפȤ褦ʾ֤Ǥ롣Ѵ⡼ɤǤꡢ겾̾⡼ *
     * Ǥꡢ̾⡼ɤǤȤΤϡ                                 */
  case J_HENKAN_MODE_ON  | J_HENKAN_OFF | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    /* 롼ꥹȤҤ*/
    if( rom_kana_rule_list_check( node, rchara ) ){
      break ;
    }
    /* ˰Ϥ "o" ȤäĤȤϤꤨʤ*
     * ͳ j_henkan_off ǤϤʤ顣ɬѴäƤ롪 */
#if defined(DEBUG)
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o'  ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      fprintf
	( stderr, "stray \"o\" in j-set-henkan-point-by-vowel.\n" ) ;
    }
#endif
    /* ξʸϤ⾮ʸϤطʤʸλν롣*/
    /* ޻̾ѴԤ*/
    j_kanakakutei( gw, sbuffer, node, table, chara ) ;
#if 0
    /* ̾⡼ɤϽλ롣*/
    node->j_kana_mode = False ;
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
#endif
    break ;
	
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_OFF :
    /* ξˤϳȤԤ줿塢not_active, henkan_off Ʊ*/
    j_kakutei( gw, node ) ;
    goto j_set_henkan_point_label1 ;

    /* ѴԤƤǡ̾prefixϤʤ겾̾ϤΤ硣*/
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_OFF | J_OKURIGANA_ON  :
    /* ξˤϳȤԤ줿塢not_active, henkan_off, okuri_off */
    j_kakutei( gw, node ) ;
    goto j_set_henkan_point_label1 ;

  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_OFF :
  case J_HENKAN_MODE_ON  | J_HENKAN_ON  | J_KANA_MODE_ON  | J_OKURIGANA_ON  :
    j_kakutei( gw, node ) ;
    goto j_set_henkan_point_label1 ;
  }
  return 0 ;
}

/*
 * üʸФʸˤäѴϰ֤ꤹν
 */
static int j_set_henkan_point_by_special_midashi_char
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  struct myChar lchara ;

  /* ̾椫"n"ʤ""ˤƤޤ*/
  if( node->j_kana_mode ){
    /* 롼ꥹȤҤ*/
    if( rom_kana_rule_list_check( node, chara ) ){
      return 0 ;
    }
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      /* ̾ʤ饭󥻥뤷Ƥޤ*/
      goto j_set_henkan_point_by_special_midashi_char_label1 ;
    }
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o' ) &&
	IS_ASCII_EQUAL( node->j_prefix[ 1 ], 'h' ) &&
	IS_END_OF_STRING( node->j_prefix[ 2 ] ) ){
      if( IS_ASCII_EQUAL( node->textbuffer[ node->j_kana_start_point ],
			  'h' ) ){
	delete_char
	  ( node, node->j_kana_start_point, 1 ) ;
	if( node->j_katakana_mode ){
	  MYCHAR_SET_JISX0208_1983( lchara, 0x252a /*""*/ ) ;
	} else {
	  MYCHAR_SET_JISX0208_1983( lchara, 0x242a /*""*/ ) ;
	}
	j_insert_myChara( node, node->j_kana_start_point, lchara ) ;
      }
      /* ̾ʤ饭󥻥뤷Ƥޤ*/
      goto j_set_henkan_point_by_special_midashi_char_label1 ;
    }
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'n' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      j_n_convert_to_kana( node ) ;
    } else {
      delete_char
	( node, node->j_kana_start_point,
	  node->cur_pos - node->j_kana_start_point ) ;
    }
  j_set_henkan_point_by_special_midashi_char_label1:
    /* ̾ʤ饭󥻥뤷Ƥޤ*/
    node->j_kana_mode = False ;
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
  }
  /* ơѴ⡼ɤѴưʤΤʤ */
  if( node->j_henkan_mode == False || node->j_henkan_on == True ){
    if( node->j_henkan_mode ){
      /* Ѵϰ֤Ǥ뤽ʡ*/
      j_set_henkan_point_subr( gw, sbuffer, node, chara ) ;
      /* Τ ϡġ*/
      j_insert_chara( node, node->cur_pos, chara ) ;
    } else if( node->j_henkan_on ){
      /* ꥸʥΥޥåפ򥨥ߥ졼Ȥ뤽ʡ*/
      j_self_insert( gw, sbuffer, node, chara ) ;
    } else {
      /* ʸ뤽ʡ*/
      j_self_insert( gw, sbuffer, node, chara ) ;
    }
  } else {
    /* Ѵν*/
    j_start_henkan_sub( gw, node ) ;
    /* üʸ롣*/
    j_insert_chara( node, node->cur_pos, chara ) ;
    /* Ѵλ֤ꤹ롣*/
    node->j_henkan_end_point = node->cur_pos ;
    /* ѴڤФ*/
    myCharStrncpy
      ( node->j_henkan_key,
	node->textbuffer + node->j_henkan_start_point,
	node->j_henkan_end_point - node->j_henkan_start_point ) ;
    MYCHAR_SET_END_OF_STRING
      ( node->j_henkan_key
	[ node->j_henkan_end_point - node->j_henkan_start_point ] ) ;
    /*
     *֤⤷ơ겾̾⡼ɤȤȤϤޤǤ礦
     */
    if( node->j_okurigana_mode ){
      /* ԹˤƤʤȤ򵧤äƤΤġ*/
      if( node->j_okurigana_start_point > node->j_henkan_start_point ){
	node->j_okurigana_offset =
	  node->j_okurigana_start_point - node->j_henkan_start_point ;
      } else {
	node->j_okurigana_offset =
	  node->j_henkan_end_point - node->j_henkan_start_point ;
      }
    } else {
      node->j_okurigana_offset =
	node->j_henkan_end_point - node->j_henkan_start_point ;
    }
    /* ñϿλ˻Ȥ¸Ƥ*/
    myCharStrcpy( node->j_henkan_key2, node->j_henkan_key ) ;
    myCharStrcpy( node->j_search_key, node->j_henkan_key ) ;
    /* ơѴԤޤ*/
    j_henkan( gw, sbuffer, node ) ;
  }
  return 0 ;
}


/*
 * ֤ʸؿ
 * ----
 * skkήʸΤǤꡢ줬 j_insert ȰۤʤäƤ롣
 * j_insert  emacs-lisp  insert ǰƬ֤ƺäؿʤΤǤ롣
 */
int j_self_insert
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  if( chara < 0 || chara > 128 || skkinput_input_vector == NULL )
    return 1 ;

  /* Ѵưʤꤹ롣*/
  if( node->j_henkan_on == True )
    j_kakutei( gw, node ) ;
  /* Ϥˤ겾̾prefixγȤȤ롣*/
  if( j_kakutei_kana_mode( gw, sbuffer, node, chara ) )
    return 0 ;

  /* Ѵơ֥˵ҤʤСѤ롣*/
  if( skkinput_input_vector[ chara ] != NULL ){
    j_insert_str
      ( node, node->cur_pos, skkinput_input_vector[ chara ] ) ;
  } else {
    /* ʳ default  keymap ˽ȤΤȤǤ롣*/
    j_insert_chara( node, node->cur_pos, chara ) ;
  }
  return 0 ;
}

int j_insert_zenkaku
( struct SKKInputNode *node, int pos, int chara )
{
  if( chara < 0 || chara > 128 || skkinput_zenkaku_vector == NULL )
    return 1 ;
  /* Ѵơ֥˵ҤʤСѤ롣*/
  if( skkinput_zenkaku_vector[ chara ] != NULL ){
    j_insert_str
      ( node, node->cur_pos, skkinput_zenkaku_vector[ chara ] ) ;
  }
  return 0 ;
}

static int j_char_to_hex( struct myChar chara )
{
  if( !IS_ASCII_CHARA( chara ) )
    return 0 ;
  if( chara.chara >='a' && chara.chara <='f' )
    return ( chara.chara - 'a' + 10 ) ;
  if( chara.chara >= 'A' && chara.chara <= 'F' )
    return ( chara.chara - 'A' + 10 ) ;
  if( chara.chara >='0' && chara.chara <= '9' )
    return ( chara.chara - '0' ) ;
  return 0 ;
}

/*
 * Ϥ client ĤȤԤ( = ԡ )
 */
int j_newline
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  struct SKKInputNode *pNode = node->parentbuffer ;
  int len, lchara[ 3 ], i, retkeysend = False ;
  struct myChar chara, *ptr, *tmp ;
  struct myChar j_toroku_string[ TEXTBUFSIZE ] ;
  struct myChar *henkankey ;

  /* Ѵ⤷ϲ̾ϤǤʤСꤹ롣  *
   * Хȷϥɤϥ⡼ɤʤ顢ưϤʤ*/
  if( node->j_mode ){
    int flag = node->j_henkan_mode ;
    j_kakutei( gw, node ) ;
    /*  "n" ʤƤΤäƤ顢""˳ꤷʤܡ   *
     * Ǥ⡢"nn" Ȥ rom-kana-rule-list ҤɬפϤʤ¿ʬ *
     * äơ "\0" ˤʤäƤ롣*/
    j_kakutei_kana_mode( gw, sbuffer, node, '\0' ) ;
    /* Τߤ j_newline ¸ߤΤʤ顢Ѵ⡼ɤˤϤä *
     * 顢Ƥ˳ѤޤꤹĤäơäƿƤǤäߤ  *
     *  */
    if( flag && sbuffer->egg_like_newline )
      return 0 ;
  }
  /*  newline ϰֿƤΥΡɤǼ¹Ԥ줿ΤǤ */
  if( pNode == NULL ){
    /* Window  Active Ǥä硣*/

    /* ʸ򵭲ƤפʲԤղäΤ˻ߤ */
    /* 뤿ˤ chatadapter mode Ƚ˹Ԥ*/
    if( sbuffer->historybuffer != NULL &&
	!sbuffer->overthespot_like_input ){
      save_ringbuffer
	( sbuffer->historybuffer, TEXTBUFSIZE, 
	  &sbuffer->hist_start, &sbuffer->hist_end, node->textbuffer ) ;
      sbuffer->hist_cur = -1 ;
    }
    if( !IS_END_OF_STRING( node->textbuffer[ 0 ] ) ){
      /* ʸ롣ʤΤǡcallback Ȥ*/
      XtCallCallbacks( gw, XtNfixNotify, ( XtPointer )node->textbuffer ) ;
      /* ƥȥХåե롣*/
      MYCHAR_SET_END_OF_STRING( node->textbuffer[ 0 ] ) ;

      /* over-the-spot ⡼ɤξˤϡ꥿󤬲줿Ȥ
       * ɬפˤʤ롣egg-nl ʤطʤɤ͡*/
      if( sbuffer->chat_adapter || sbuffer->overthespot_like_input )
	retkeysend = True ;
    } else {
      retkeysend = True ;
    }
    /* ԥ롣*/
    if( retkeysend ){
      j_sendback_keypress( gw, &( sbuffer->xevent ) ) ;
    }
    /* ƬؤȰư롣*/
    node->cur_pos        = 0 ;
    node->cur_pos2       = 0 ;
    node->cur_pos3       = 0 ;
    node->cur_pos_backup = 0 ;
    node->cur_pos_top    = 0 ;
    node->j_okurigana_start_point = -1 ;
    node->j_kana_start_point      = -1 ;
    node->j_henkan_start_point    = -1 ;
    node->j_henkan_end_point      = -1 ;
    return 0 ;
  }

  /*  newline ϲ褾Υߥ˥ХåեǼ¹Ԥ줿ΤǤ(羸) */

  switch( node->j_minibuff_usage ){
    /* ߥ˥ХåեǤѴ˰ܤäƤġ*/
  case J_HENKAN_IN_MINIBUFF_MODE :
    /* ߥ˥ХåեǲʸϤƤΤʤ顢Ƥؤ *
     * ֤ʤФʤʤ⤷ϤƤʤΤʤ顢 * 
     * ϤĤƤʤȤʤ*/
    if( !IS_END_OF_STRING( node->textbuffer[ node->cur_pos_top ] ) ){
      j_delete_region
	( pNode, pNode->j_henkan_start_point, pNode->j_henkan_end_point ) ;

      /* ǽФƤ륻ߥǤϤʤΤǡѴɬפꡣ */
      myCharStrcpy
	( j_toroku_string, node->textbuffer + node->cur_pos_top ) ;
      for( tmp = j_toroku_string ; !IS_END_OF_STRING( *tmp ) ; tmp ++ ){
	if( IS_ASCII_CHARA( *tmp ) && IS_ASCII_EQUAL(*tmp, ';')){
	  j_quote_semicolon ( j_toroku_string ) ;
	  break ;
	}
      }

      /* mini-buffer Ρ֢礦 װʲʸ򽦤äơ *
       * ؤ֤*/
#if 0
      myCharStrcpy ( temporary_buffer, j_toroku_string ) ;
      j_insert_word
	( pNode, pNode->j_henkan_start_point, temporary_buffer ) ;
#else
      j_insert_word
	( pNode, pNode->j_henkan_start_point, j_toroku_string ) ;
#endif
      pNode->j_henkan_end_point = pNode->cur_pos ;

      /* ǡιʤ뤬...ޤưʡ */
      henkankey = ( pNode->j_okurigana_mode )? 
	pNode->j_henkan_key : pNode->j_search_key ;
      /* ΤޤϿƤޤȤޤã뤫⤷ʤΤǽ *
       * 롣*/
      j_quote_char( j_toroku_string ) ;
      
      /* Ǥʤߥ⽤롣 */
      for( tmp = j_toroku_string ; !IS_END_OF_STRING( *tmp ) ; tmp ++ ){
	if( IS_ASCII_CHARA( *tmp ) && IS_ASCII_EQUAL(*tmp, ';')){
	  j_quote_semicolon ( j_toroku_string ) ;
	  break ;
	}
      }

      add_SudeniHenkanKakuteiShitamonoByString
	( henkankey, j_toroku_string, node->j_okurigana_mode ) ;
      /* Ͽñο䤹*/
      skkinput_j_count_touroku ++ ;

      pNode->j_current_henkan_vector_index = NULL ;
      /* Ƹ椵ϳꤷޤ*/
      j_kakutei( gw, pNode ) ;
    } else {
      /* ߥ˥ХåեǤѴ⡼ɤäƤʤ顢äȤҥå *
       * Τ̵äν*/
      if( pNode->j_henkan_count == 0 && pNode->j_henkan_mode &&
	  pNode->j_henkan_on ){
	/* ΤޤޤǤϤʤؤȾܤ롣*/
	j_keyboard_quit_henkanrestart
	  ( gw, pNode, pNode->j_okurigana_mode ) ;
      }
    }
    break ;
  case J_INPUT_BY_CODE_OR_MENU_MODE :
    ptr = node->textbuffer + node->cur_pos_top ;
    while( IS_ASCII_EQUAL( *ptr, 0x20 ) || IS_ASCII_EQUAL( *ptr, 0x08 ) )
      ptr ++ ;
    len = myCharStrlen( ptr ) >> 1 ;
    if( len == 0 ){
      lchara[ 0 ] = j_code_n1_min ;
      pNode->j_input_by_code_current_charset = CHARSET_JISX0208_1983 ;
      goto j_input_by_code_or_menu_jmp_start ;
    }
    /* ʸ­ʤСȴ롣*/
    if( len < 2 ){
      pNode->j_input_by_code_or_menu_mode = False ;
      break ;
    }
    if( len > 3 )
      len = 3 ;
    /* Ϥ줿Τ֤ʤΤĴ٤롣*/
    for( i = 0 ; i < len ; i ++ ){
      lchara[ i ] = 
	( j_char_to_hex( ptr[ 0 ] ) << 4 | 
	  j_char_to_hex( ptr[ 1 ] ) ) ;
      ptr ++ ; ptr ++ ;
    }
    /* ʸ̵¿Ƥ̵뤷Ƥ뤫͡ */
    switch( lchara[ 0 ] ){
    case 0x8E :
      chara.charset = CHARSET_JISX0201_1976 ;
      chara.chara   = lchara[ 1 ] | 0x80 ;
      break ;
    case 0x8F :
      pNode->j_input_by_code_current_charset = CHARSET_JISX0212_1990 ;
      if( len == 2 ){
	lchara[ 0 ] = j_code_n1_min ;
	goto j_input_by_code_or_menu_jmp_start ;
      }
      if( lchara[ 1 ] == 0 ){
	lchara[ 1 ] = lchara[ 2 ] & 0x7F ;
	goto j_input_by_code_or_menu_jmp_start ;
      }
      chara.charset = CHARSET_JISX0212_1990 ;
      chara.chara   = ( ( lchara[ 1 ] << 8 ) | lchara[ 2 ] ) & 0x7F7F ;
      break ;
    default :
      pNode->j_input_by_code_current_charset = CHARSET_JISX0208_1983 ;
      if( len == 1 ){
	lchara[ 0 ] = j_code_n1_min ;
	goto j_input_by_code_or_menu_jmp_start ;
      }
      if( lchara[ 0 ] == 0 ){
	lchara[ 0 ] = lchara[ 1 ] & 0x7F ;
	goto j_input_by_code_or_menu_jmp_start ;
      }
      chara.charset = CHARSET_JISX0208_1983 ;
      chara.chara   = ( ( lchara[ 0 ] << 8 ) | lchara[ 1 ] ) & 0x7F7F ;
      break ;
    }
    /* ξʸƤޤġ*/
    pNode->j_input_by_code_or_menu_mode = False ;
    j_insert_myChara
      ( pNode, pNode->j_input_by_code_or_menu_point, chara ) ;
    break ;

  j_input_by_code_or_menu_jmp_start:
    if( lchara[ 0 ] < j_code_n1_min )
      lchara[ 0 ] = j_code_n1_min ;
    if( lchara[ 0 ] > j_code_n1_max )
      lchara[ 0 ] = j_code_n1_max ;
    pNode->j_input_by_code_or_menu_mode = True ;
    pNode->j_input_by_code_current_code = lchara[ 0 ] ;
    j_input_by_code_or_menu_jmp_showCandidate( pNode, lchara[ 0 ] ) ;
    goto j_newline_exit1 ;
  case J_PURGE_YES_OR_NO_P :
    if( !myCharCharStrcmp
	( node->textbuffer + node->cur_pos_top, "yes" ) ){
      /* ƤθܤƤѴä롣*/
      purge_SudeniHenkanKakuteiShitamono( pNode ) ;

      /* ɽƤ֢פõ롣*/
      j_delete_region
	( pNode, pNode->j_henkan_start_point, pNode->j_henkan_end_point ) ;
      pNode->j_henkan_end_point = pNode->cur_pos ;
      pNode->j_current_henkan_vector_index = NULL ;
      /* Ƹ椵ϳꤷޤ*/
      j_kakutei( gw, pNode ) ;
    }
    /* οͤ purge  no äˤϲ⤷ޤ*/
    break ;
  default :
    break ;
  }
  MYCHAR_SET_END_OF_STRING( pNode->mtextbuffer[ 0 ] ) ;
j_newline_exit1:
  /* ߥ˥ХåեѤߤΤǡꥢ롣*/
  XtVaSetValues( gw, XtNclearMinibuffer, True, NULL ) ;
  /* Υߥ˥ХåեפˤʤäΤǡޤ*/
  free_Minibuffer( gw, sbuffer, node ) ;
  /* Ƥ˥֤ޤ礦*/
  pNode->cur_exist = True ;
  return 0 ;
}

/*
 * ̾Ϥäˡβ̾ץե򤹤ؿ
 */
void j_delete_kanaprefix( struct SKKInputNode *node )
{
  /* ѴʤˤƤޤ*/
  if( node->j_kana_mode ){
    /* ̾Ϥ 'n' νĤäƤ硣*/
    /* ̾Ϥ 'n' ǤäƤ⡢*n Ȥ֤¸ߤǤ *
     * Τա */
    if( IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'n' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
      j_n_convert_to_kana( node ) ;
    } else {
      delete_char( node, node->j_kana_start_point,
		   node->cur_pos - node->j_kana_start_point ) ;
    }
    /* ̾ʤ饭󥻥뤷Ƥޤ*/
    node->j_kana_mode = False ;
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
  }
  return ;
}

/*
 * ̾Ѵ򳫻Ϥ˸ƽФ륳Хåؿ
 */
static void j_get_completion_results
( struct SKKInputNode *node )
{
  SkkinpSearchVector *j_purge_vector_top ;
  VectorIndex *j_purge_vector_index_top ;
  int tmp ;

  /* Ѥ줿⤷ʤץ꡼ξϼΤƤ롣*/
  free_VectorIndex( &node->j_completion_vector_index_top ) ;
  free_SkkinpSearchVector( &node->j_completion_vector_top ) ;

  node->j_completion_vector_top = NULL ;
  /* ˵Ƥ뼭񤫤鸡Ԥ*/
  node->j_completion_vector_top =
    j_completion_search_sudeniKakuteiShitaKouho
    ( node->j_completion_vector_top, node->j_henkan_key ) ;
  /* ޤɽ꼭񤫤鸡Ԥ*/
  node->j_completion_vector_top = 
    j_completion_skkinput_local_jisyo
    ( node->j_completion_vector_top, node->j_henkan_key ) ;
  /* ơɤ줫ĤǤѴġ*/
  if( node->j_completion_vector_top != NULL ){
    /* äϥѡθ*/
    j_purge_vector_index_top = NULL ;
    j_purge_vector_top       = NULL ;
    j_purge_vector_top = j_completion_search_sudeniPurgeSaretamono
      ( j_purge_vector_top, node->j_henkan_key ) ;
    /* öϥå˸ߥѡƤáࡣ*/
    /* ڤФ˥ϥå夬ꥢƤϺΤǡFalse Ǥ *
     * 롣ɤ줫ĤǤҥåȤʤСѡꥹȤ򸡺 *
     * ̵̣*/
    if( j_purge_vector_top != NULL ){
      j_purge_vector_index_top = makeSearchVectorIndex
	( j_purge_vector_top, &tmp, False ) ;
    }
    /* SKK ֻڤФ*/
    node->j_completion_vector_index_top =
      makeSearchVectorIndex( node->j_completion_vector_top, &tmp, True ) ;
    /* purge ʤ󤫤ι򤫤路ڤФΤä *
     * ν*/
    if( node->j_completion_vector_index_top != NULL ){
      /* Ƭθؤ褦ˤ롣*/
      node->j_current_completion_vector_index = 
	node->j_completion_vector_index_top ;
      node->j_completion_mode = True ;
    } else {
      /* purge αƶĲ񤫤äƤɡϤ *
       * ߤܤäʤλȤä㤤ʤä*/
      free_SkkinpSearchVector( &node->j_completion_vector_top ) ;
      node->j_current_completion_vector_index = NULL ; 
   }
    /* ѡΤξϤ⤷Ƥ⤦ס */
    free_VectorIndex( &j_purge_vector_index_top ) ;
    free_SkkinpSearchVector( &j_purge_vector_top ) ;
  }
  return ;
}

/*
 * 䴰ײߤؿǤϤʤơʸ䴰Ԥؿ
 */
int j_try_completion( Widget gw, struct SKKInputNode *node )
{
  int length, startpos, endpos ;

  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;

  if( node->j_completion_mode ){
    /* θ롣*/
    if( skkinput_dabbrev_like_completion )
      return find_next_completion( node ) ;
    /* ǤʤСץ꡼⡼ɤöȴƤ顢ĩ
       魯롣*/
    j_completion_close( node ) ;
  }
  /* ѴưԤäǤꡢºݤѴڹԤƤʤ *
   * ʤ顢completion Ϥ롣*/
  if( node->j_henkan_mode && !node->j_henkan_on ){
    if( node->cur_pos < node->j_henkan_start_point ){
      startpos = node->cur_pos ;
      endpos   = node->j_henkan_start_point ;
    } else {
      startpos = node->j_henkan_start_point ;
      endpos   = node->cur_pos ;
    }
    length = endpos - startpos ;
    /* 䴰褦ȤʸĹä顣*/
    if( length <= 0 ){
      err_msg( node, "Cannot complete an empty string!" ) ;
      return 1 ;
    }
    /* 괺֤Ѵϰ֤δ֤ʸȴФ*/
    myCharStrncpy
      ( node->j_henkan_key,
	node->textbuffer + startpos, length ) ;
    MYCHAR_SET_END_OF_STRING( node->j_henkan_key[ length ] ) ;
    /* completion ˤƤߤĤΥ르ꥺϷ빽äƤ롣*
     * (^^;; */
    j_get_completion_results( node ) ;
    
    /* ĤҥåȤޤǤ(^^;;; */
    if( !node->j_completion_mode ){
      int clen ;
      /* ǤϴƤޤɤˤ뤳ȡ */
      myCharCharStrcpy
	( node->mtextbuffer, "No completions for \"" ) ;
      if( length >= ( TEXTBUFSIZE - 22 ) ){
	clen = TEXTBUFSIZE - 22 ;
      } else {
	clen = length ;
      }
      myCharStrncat
	( node->mtextbuffer, node->j_henkan_key, clen ) ;
      MYCHAR_SET_CHARA
	( node->mtextbuffer[ clen + 20 ], 0x22 ) ;
      MYCHAR_SET_END_OF_STRING
	( node->mtextbuffer[ clen + 21 ] ) ;
      return 1 ;
    }
    /* 괺Ѵϰ֤饫֤ޤǤɽƤʸ *
     * õ롣*/
    j_delete_region( node, startpos, endpos ) ;
    /* 䴰ǤʸȴФ*/
    copyCandidate
      ( temporary_buffer,
	( node->j_current_completion_vector_index )->node,
	( node->j_current_completion_vector_index )->position,
	TEXTMAXLEN ) ;
    j_insert_str( node, startpos, temporary_buffer ) ;
  } else {
    /* 롣*/
    for( length = 0 ; length < skkinput_tab_width ; length ++ )
      j_insert_chara( node, node->cur_pos, ' ' ) ;
  }
  return 0 ;
}

/*
 * ֤Υɤɽؿ
 *-----
 */
int j_display_code_for_char_at_point( struct SKKInputNode *node )
{
  unsigned char tempstring[ TEXTBUFSIZE ] ;
  struct myChar wchara ;

  j_delete_kanaprefix( node ) ;
  /* Ǥʤ줿硣*/
  if( IS_END_OF_STRING( node->textbuffer[ node->cur_pos ] ) ){
    err_msg( node, "Cursor is at the end of the buffer." ) ;
    return 1 ;
  }
  /* ʤȤ̵ȻפɡϤͤ롣*/
  if( node->cur_pos < node->cur_pos_top ){
    node->cur_pos = node->cur_pos_top ;
    return 0 ;
  }
  wchara = node->textbuffer[ node->cur_pos ] ;
  /* ɤʤΤʤ ʤΤʤ ۤȤΤȤϤɤ *
   * ʤΤʤ */
  switch( wchara.charset ){
    /* ASCII ڤ JISX0201-ROMAN ɽ롣*/
  case CHARSET_ISO8859_1 :
  case CHARSET_ISO8859_2 :
  case CHARSET_ISO8859_3 :
  case CHARSET_ISO8859_4 :
  case CHARSET_ISO8859_5 :
  case CHARSET_ISO8859_6 :
  case CHARSET_ISO8859_7 :
  case CHARSET_ISO8859_8 :
  case CHARSET_ISO8859_9 :
    if( wchara.chara & 0x80 ){
      sprintf
	( tempstring, "\"A\"  ISO8859-%d: %02x (%3d)",
	  wchara.charset - CHARSET_ISO8859_1 + 1 ,
	  wchara.chara, wchara.chara ) ;
    } else {
      sprintf
	( tempstring, "\"A\"  %02x (%3d)",
	  wchara.chara, wchara.chara ) ;
    }
    myCharCharStrcpy( node->mtextbuffer, tempstring ) ;
    /* ľܥɤɽʤФʤʤʬϼ롣*/
    node->mtextbuffer[ 1 ] = wchara ;
    break ;
    /* JISX0201-1976 ɽ롣*/
  case CHARSET_JISX0201_1976 :
    if( wchara.chara & 0x80 ){
      sprintf
	( tempstring,
	  "[@]  EUC: 8e%02x (142, %3d), JISX0201: %02x (%3d)", 
	  node->textbuffer[ node->cur_pos ].chara | 0x0080,
	  node->textbuffer[ node->cur_pos ].chara | 0x0080,
	  node->textbuffer[ node->cur_pos ].chara,
	  node->textbuffer[ node->cur_pos ].chara ) ;
      goto multibyte_chara_print ;
    }  else {
      sprintf
	( tempstring, "\"A\"  %02x (%3d)",
	  wchara.chara, wchara.chara ) ;
      myCharCharStrcpy( node->mtextbuffer, tempstring ) ;
      /* ľܥɤɽʤФʤʤʬϼ롣*/
      node->mtextbuffer[ 1 ] = wchara ;
      break ;
    }
    /* JISX0212-1978, 1983 Υɽ̲ƤޤäƤ롣JIS 
     * ȤȤ̤ɬפϤΡ */
  case CHARSET_JISX0208_1978 :
  case CHARSET_JISX0208_1983 :
    sprintf
      ( tempstring,
	"[@]  EUC: %04x (%3d, %3d), JISX0208: %04x (%3d, %3d)",
	( wchara.chara | 0x8080 ), 
	( wchara.chara >> 8 ) | 0x80, ( wchara.chara & 0x00FF ) | 0x80,
	wchara.chara,
	( wchara.chara >> 8 ), ( wchara.chara & 0x00FF ) ) ;
    goto multibyte_chara_print ;
    /* JISX0212-1990 Υɽ*/
  case CHARSET_JISX0212_1990 :
    sprintf
      ( tempstring,
	"[@]  EUC: 8f%04x (143, %3d, %3d), JISX0212: %04x (%3d, %3d)",
	( wchara.chara | 0x8080 ),
	( ( wchara.chara >> 8 ) | 0x80 ), ( ( wchara.chara & 0x00FF ) | 0x80 ),
	wchara.chara,
	( wchara.chara >> 8 ), ( wchara.chara & 0x00FF ) ) ;
    /* 2ХȷϤʸɽζʬ*/
  multibyte_chara_print:
    myCharCharStrcpy( node->mtextbuffer, tempstring ) ;
    MYCHAR_SET_JISX0208_1983
      ( node->mtextbuffer[ 0 ], 0x2158 /**/ ) ;
    node->mtextbuffer[ 1 ] = node->textbuffer[ node->cur_pos ] ;
    MYCHAR_SET_JISX0208_1983
      ( node->mtextbuffer[ 2 ], 0x2159 /**/ ) ;
    break ;
  default :
    break ;
  }
  return 0 ;
}

/*
 * ľܥϤԤؿ
 */
int j_input_by_code_or_menu_start
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  j_delete_kanaprefix( node ) ;
  /* ߤΥ֤򵭲롣*/
  node->j_input_by_code_or_menu_point = node->cur_pos ;
  /* ߥ˥ХåեѤơʸϤ롣*/
  j_read_string
    ( gw, sbuffer, node, "JIS or EUC code (00nn or CR for Jump Menu): ",
      J_INPUT_BY_CODE_OR_MENU_MODE ) ;
  return 0 ;
}

/*
 * "/" ˤѴ
 */
int j_abbrev_input
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int rchara )
{
  if( node->j_henkan_mode && !node->j_henkan_on ){
    err_msg( node, "Already in  mode" ) ;
    return 1 ;
  }
  j_kakutei( gw, node ) ;
  j_set_henkan_point_subr( gw, sbuffer, node, rchara ) ;
  node->j_abbrev = True ;
  return 0 ;
}

/*
 * Ϳ줿֤饫̤ưؿ
 * ---------
 * ΤޤޡControl-F νбƤ롣
 */
int j_forward_char( struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  /* ư롣*/
  if( !IS_END_OF_STRING( node->textbuffer[ node->cur_pos ] ) )
    node->cur_pos ++ ;
  return 0 ;
}

/*
 * Ϳ줿֤饫̤᤹ؿ
 * ---------
 * ΤޤޡControl-B νбƤ롣
 */
int j_backward_char( struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  /* ư롣*/
  if( node->cur_pos > node->cur_pos_top )
    node->cur_pos -- ;
  return 0 ;
}

/*
 * ֤ʸäؿ
 *----
 * ͡äˤʤ
 */
int j_delete_char( struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  delete_char( node, node->cur_pos, 1 ) ;
  return 0 ;
}

/*
 * Υäؿ
 */
static int delete_backward_char
( Widget gw, struct SKKInputNode *node, XEvent *xevent, int sbflag )
{
  /* ϥХåեƬޤƤΤǤ */
  if( node->cur_pos > node->cur_pos_top ){
    /* ХåեƬޤǤƤޤΤǡ᤻ޤ*/
    node->cur_pos -- ;
    /* ᤷȤǡξɽƤʸäޤ*/
    delete_char( node, node->cur_pos, 1 ) ;
  } else {
    /* ֿƤäꤷˤϡХåڡ򲡤᤹*/
    if( node->parentbuffer == NULL && sbflag ){
      /* ᤷޤ礦*/
      j_sendback_keypress( gw, xevent ) ;
    }
  }
  return 0 ;
}

/*
 * completion ư˰θؿ
 *----
 * completion ưˤϡҥåȤǤꥹȤηݻ
 * Ƥ롣ɽƤǤΰǤ򤽤ΥꥹȤȴ
 * ơŬڤʰ֤롣
 */
static int find_previous_completion( struct SKKInputNode *node )
{
  int startpos ;

  /* Ϥ䤳ʾϤʤ*/
  if( node->j_current_completion_vector_index == NULL ){
    err_msg( node, "No previous completions." ) ;
    return 1 ;
  }
  /* θ򤷤ơġ*/
  node->j_current_completion_vector_index = 
    node->j_current_completion_vector_index->prev ;
  startpos = ( node->j_henkan_start_point < node->cur_pos )?
    node->j_henkan_start_point : node->cur_pos ;
  if( node->j_current_completion_vector_index != NULL ){
    j_delete_region
      ( node, node->j_henkan_start_point, node->cur_pos ) ;
    /* 䴰ǤʸȴФ*/
    copyCandidate
      ( temporary_buffer,
	( node->j_current_completion_vector_index )->node,
	( node->j_current_completion_vector_index )->position,
	TEXTMAXLEN ) ;
    j_insert_str( node, startpos, temporary_buffer ) ;
    return 0 ;
  } else {
    /* 䴰ʸɽġ¤ϤǤԽʬʤΤ*/
    j_delete_region
      ( node, node->j_henkan_start_point, node->cur_pos ) ;
    j_insert_str( node, startpos, node->j_henkan_key ) ;
    return 0 ;
  }
}

/*
 * comma ؿ
 *-----
 */
int j_insert_comma
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  /* 䴰ײ¹ʤСġ*/
  if( node->j_completion_mode ){
    return find_previous_completion( node ) ;
  }
  return j_self_insert( gw, sbuffer, node, ',' ) ;
}

int j_abbrev_comma( Widget gw, struct SKKInputNode *node )
{
  /* 䴰ײ¹ʤСġ*/
  if( node->j_completion_mode ){
    return find_previous_completion( node ) ;
  }
  return j_insert_chara( node, node->cur_pos, ',' ) ;
}

/*
 * completion ư˰ļθؿ
 *----
 * completion ưˤϡҥåȤǤꥹȤηݻ
 * Ƥ롣ɽƤǤΰļǤ򤽤ΥꥹȤȴ
 * ơŬڤʰ֤롣
 */
static int find_next_completion( struct SKKInputNode *node )
{
  int startpos ;
  /* ƬƬؤƤΤʤ顢ǽ䴰̤ˤ碌롣*/
  if( node->j_current_completion_vector_index == NULL ){
    node->j_current_completion_vector_index =
      node->j_completion_vector_index_top ;
  } else {
    /* ʾ弡θɽ뤳ȤϲǽǤ */
    if( node->j_current_completion_vector_index->next == NULL ){
      err_msg( node, "No more completions." ) ;
      return 1 ;
    }
    /* 䴰̤˰ưޤ礦*/
    node->j_current_completion_vector_index =
      node->j_current_completion_vector_index->next ;
  }
  j_delete_region
    ( node, node->j_henkan_start_point, node->cur_pos ) ;
  /* 䴰ǤʸȴФ*/
  copyCandidate
    ( temporary_buffer,
      ( node->j_current_completion_vector_index )->node,
      ( node->j_current_completion_vector_index )->position,
      TEXTMAXLEN ) ;
  startpos = ( node->j_henkan_start_point < node->cur_pos )?
    node->j_henkan_start_point : node->cur_pos ;
  j_insert_str( node, startpos, temporary_buffer ) ;
  return 0 ;
}

/*
 * period ؿ
 *-----
 * j_completion ʽΤ󡢤εǽ
 * ͽϤʤΤǡڡ
 */
int j_insert_period
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  /* 䴰ײ¹ʤСġ*/
  if( node->j_completion_mode ){
    return find_next_completion( node ) ;
  }
  return j_self_insert( gw, sbuffer, node, '.' ) ;
}

int j_abbrev_period( Widget gw, struct SKKInputNode *node )
{
  /* 䴰ײ¹ʤСġ*/
  if( node->j_completion_mode ){
    return find_next_completion( node ) ;
  }
  return j_insert_chara( node, node->cur_pos, '.' ) ;
}

int j_date_ad
( struct myChar *buffer, int bufsize, int date_ad, int number_style )
{
  static struct myChar skk_week_alist[] = {
    { CHARSET_JISX0208_1983, 0x467c /*""*/ },
    { CHARSET_JISX0208_1983, 0x376e /*""*/ },
    { CHARSET_JISX0208_1983, 0x3250 /*""*/ },
    { CHARSET_JISX0208_1983, 0x3f65 /*""*/ },
    { CHARSET_JISX0208_1983, 0x4c5a /*""*/ },
    { CHARSET_JISX0208_1983, 0x3662 /*""*/ },
    { CHARSET_JISX0208_1983, 0x455a /*""*/ },
  } ;
  time_t tval ;
  int year ;
  struct myChar *dptr ;
  struct tm *lt ;

  /* 1970/1/1ηв롣*/
  if( time( &tval ) == -1 )
    return False ;
  /* ɽˡǥեȤɤĴ٤롣*/
  if( date_ad < 0 ){
    date_ad = skkinput_date_ad ;
  }
  if( number_style < 0 ){
    number_style = skkinput_number_style ;
  }
  /* time_t  struct tm * Ѵ롣*/
  lt = localtime( &tval ) ;
  /* ǯβǤ뤫롣*/
  year = lt->tm_year + 1900 ;
  if( !date_ad && bufsize > 2 ){
    /* ǯ롣*/
    if( year <= 1867 ){		/*""*/
      MYCHAR_SET_JISX0208_1983( buffer[ 0 ], 0x403e ) ;
      MYCHAR_SET_JISX0208_1983( buffer[ 1 ], 0x4e71 ) ;
      MYCHAR_SET_END_OF_STRING( buffer[ 2 ] ) ;
    } else if( year < 1911 ){	/*""*/
      year -= 1867 ;
      MYCHAR_SET_JISX0208_1983( buffer[ 0 ], 0x4c4d ) ;
      MYCHAR_SET_JISX0208_1983( buffer[ 1 ], 0x3c23 ) ;
      MYCHAR_SET_END_OF_STRING( buffer[ 2 ] ) ;
    } else if( year < 1925 ){	/*""*/
      year -= 1911 ;
      MYCHAR_SET_JISX0208_1983( buffer[ 0 ], 0x4267 ) ;
      MYCHAR_SET_JISX0208_1983( buffer[ 1 ], 0x4035 ) ;
      MYCHAR_SET_END_OF_STRING( buffer[ 2 ] ) ;
    } else if( year < 1988 ){	/*""*/
      year -= 1925 ;
      MYCHAR_SET_JISX0208_1983( buffer[ 0 ], 0x3e3c ) ;
      MYCHAR_SET_JISX0208_1983( buffer[ 1 ], 0x4f42 ) ;
      MYCHAR_SET_END_OF_STRING( buffer[ 2 ] ) ;
    } else {			/*"ʿ"*/
      year -= 1988 ;
      MYCHAR_SET_JISX0208_1983( buffer[ 0 ], 0x4a3f ) ;
      MYCHAR_SET_JISX0208_1983( buffer[ 1 ], 0x402e ) ;
      MYCHAR_SET_END_OF_STRING( buffer[ 2 ] ) ;
    }
    dptr = buffer + 2 ;
    bufsize -= 2 ;
  } else {
    /* ǯ̵ˤʤ롣*/
    MYCHAR_SET_END_OF_STRING( buffer[ 0 ] ) ;
    dptr = buffer ;
  }
  myCharItoa( temporary_buffer, year ) ;

  if( year == 1 && date_ad ){	    /*"ǯ"*/
    if( bufsize > 2 ){
      MYCHAR_SET_JISX0208_1983( *dptr, 0x3835 ) ;
      dptr ++ ; bufsize -- ;
      MYCHAR_SET_JISX0208_1983( *dptr, 0x472f ) ;
      dptr ++ ; bufsize -- ;
      MYCHAR_SET_END_OF_STRING( *dptr ) ;
    }
  } else {
    /* ǯŸ롣*/
    j_num_exp
      ( temporary_buffer, number_style + '0', dptr, bufsize ) ;
    /* դ­줿ʸΰֺǸؤȰư롣*/
    while( !IS_END_OF_STRING( *dptr ) ){
      dptr ++ ;
      bufsize -- ;
    }
    if( bufsize > 1 ){
      MYCHAR_SET_JISX0208_1983( *dptr, 0x472f ) ;
      dptr ++ ; bufsize -- ;
    }
  }
  /* ǯβǤ뤫롣*/
  myCharItoa( temporary_buffer, lt->tm_mon + 1 ) ;
  /* Ÿ롣*/
  j_num_exp( temporary_buffer, number_style + '0', dptr, bufsize ) ;
  /* դ­줿ʸΰֺǸؤȰư롣*/
  while( !IS_END_OF_STRING( *dptr ) ){
    dptr ++ ;
    bufsize -- ;
  }
  if( bufsize > 1 ){
    MYCHAR_SET_JISX0208_1983( *dptr, 0x376e /*""*/ ) ;
    dptr ++ ; bufsize -- ;
  }
  myCharItoa( temporary_buffer, lt->tm_mday ) ;
  /* Ÿ롣 TEXTBUFSIZE ϱɡޤդʤȻפ
   * ĤǤ*/ 
  j_num_exp( temporary_buffer, number_style + '0', dptr, bufsize ) ;
  /* դ­줿ʸΰֺǸؤȰư롣*/
  while( !IS_END_OF_STRING( *dptr ) ){
    dptr ++ ;
    bufsize -- ;
  }
  if( bufsize > 1 ){
    MYCHAR_SET_JISX0208_1983( *dptr, 0x467c /*""*/ ) ;
    dptr ++ ; bufsize -- ;
  }
  /* 򼨤*/
  if( bufsize > 1 ){
    MYCHAR_SET_CHARA( *dptr, '(' ) ;
    dptr ++ ; bufsize -- ;
  }
  if( bufsize > 1 ){
    *dptr ++ = skk_week_alist[ lt->tm_wday ] ;
    bufsize -- ;
  }
  if( bufsize > 1 ){
    MYCHAR_SET_CHARA( *dptr, ')' ) ;
    dptr ++ ; bufsize -- ;
  }
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  return True ;
}

/*
 * դϤؿ
 */
int j_today( struct SKKInputNode *node )
{
  struct myChar buffer[ TEXTBUFSIZE ] ;

  j_delete_kanaprefix( node ) ;
  if( !j_date_ad( buffer, TEXTBUFSIZE, -1, -1 ) )
    return 1 ;

  /* ʸ롣*/
  j_insert_str( node, node->cur_pos, buffer ) ;
  return 0 ;
}

/*
 * ꤵ줿ϰʸȾѤѤѴؿ
 */
static int j_zenkaku_region
( struct SKKInputNode *node, int startpoint, int endpoint )
{
  struct myChar *sptr, *ptr ;
  int pos ;

  if( startpoint > endpoint ){
    err_msg( node, "Henkan end point must be after henkan start point." ) ;
    return 0 ;
  }
  sptr = node->textbuffer + startpoint ;
  ptr  = temporary_buffer ;
  for( pos = startpoint ; pos < endpoint ; pos ++ ){
    if( IS_END_OF_STRING( *sptr ) )
      break ;
    if( IS_ASCII_CHARA( *sptr ) ){
      if( sptr->chara >= 'a' && sptr->chara <= 'z' ){
	ptr->charset = CHARSET_JISX0208_1983 ;
	ptr->chara   = 0x2361 + ( sptr->chara - 'a' ) ;
	ptr ++ ;
	sptr ++ ;
	continue ;
      }
      if( sptr->chara >= 'A' && sptr->chara <= 'Z' ){
	ptr->charset = CHARSET_JISX0208_1983 ;
	ptr->chara   = 0x2341 + ( sptr->chara - 'A' ) ;
	ptr ++ ;
	sptr ++ ;
	continue ;
      }
    }
    *ptr ++ = *sptr ++ ;
  }
  MYCHAR_SET_END_OF_STRING( *ptr ) ;
  j_delete_region( node, startpoint, endpoint ) ;
  j_insert_str( node, startpoint, temporary_buffer ) ;
  return 0 ;
}

int j_zenkaku_henkan
( Widget gw, struct SKKInputNode *node )
{
  if( node->j_henkan_mode && !node->j_henkan_on ){
    node->j_mode = True ;
    if( node->j_henkan_start_point > node->cur_pos ){
      err_msg( node, "Henkan end point must be after henkan start point." ) ;
      return 1 ;
    }
    j_zenkaku_region( node, node->j_henkan_start_point, node->cur_pos ) ;
    j_kakutei( gw, node ) ;
  }
  return 0 ;
}

/*
 * ꤵ줿ΰʿ̾Ҳ̾ѴؿǤ롣
 * ----
 * arg Ϥ줿οȤΤ emacs-lisp äˤäƤ
 * ǤɡεǽΥݡȤʬǤΤǡ̵뤷ƺޤ
 */
static int j_katakana_region
( struct SKKInputNode *node, int startpoint, int endpoint, int flag )
{
  struct myChar *sptr, *ptr ;
  int pos, length ;

  length = endpoint - startpoint ;
  if( length < 0 ){
    err_msg( node, "Henkan end point must be after henkan start point." ) ;
    return 0 ;
  }

  sptr = node->textbuffer + startpoint ;
  ptr  = temporary_buffer ;

  for( pos = startpoint ; pos < endpoint ; pos ++ ){
    /* äˤ...*/
    switch( sptr->charset ){
    case CHARSET_JISX0208_1978 :
    case CHARSET_JISX0208_1983 :
      ptr->charset = sptr->charset ;
      if( sptr->chara >= 0x2421 && sptr->chara <= 0x2473 ){
	if( sptr->chara == 0x2426 && ( pos + 1 ) < endpoint &&
	    sptr[ 1 ].chara == 0x212b &&
	    ( sptr[ 1 ].charset == CHARSET_JISX0208_1978 ||
	      sptr[ 1 ].charset == CHARSET_JISX0208_1983 ) ){
	  ptr->chara = 0x2574 ; /*  */
	  /* ʸ򸫤ʬФ*/
	  sptr ++ ;
	  pos ++ ;
	} else {
	  ptr->chara = sptr->chara + 0x0100 ;
	}
      } else {
	ptr->chara = sptr->chara ;
      }
      sptr ++ ;
      ptr ++ ;
      break ;
    default :
      *ptr ++ = *sptr ++ ;
      break ;
    }
  }
  MYCHAR_SET_END_OF_STRING( *ptr ) ;

  j_delete_region( node, startpoint, endpoint ) ;
  j_insert_str( node, startpoint, temporary_buffer ) ;
  return 0 ;
}

static int j_hiragana_region
( struct SKKInputNode *node, int startpoint, int endpoint, int flag )
{
  struct myChar *sptr, *ptr ;
  int pos, length ;

  length = endpoint - startpoint ;
  if( length < 0 ){
    err_msg( node, "Henkan end point must be after henkan start point." ) ;
    return 0 ;
  }

  sptr = node->textbuffer + startpoint ;
  ptr  = temporary_buffer ;

  for( pos = startpoint ; pos < endpoint ; pos ++ ){
    /* äˤ...*/
    switch( sptr->charset ){
    case CHARSET_JISX0208_1978 :
    case CHARSET_JISX0208_1983 :
      ptr->charset = sptr->charset ;
      if( sptr->chara >= 0x2521 && sptr->chara <= 0x2573 ){
	if( sptr->chara == 0x2574 &&
	    ( sptr[ 1 ].charset == CHARSET_JISX0208_1978 ||
	      sptr[ 1 ].charset == CHARSET_JISX0208_1983 ) ){
	  ptr->chara = 0x2426 ; /*  */
	  ptr ++ ;
	  ptr->chara = 0x212b ; /*  */
	} else {
	  ptr->chara = sptr->chara - 0x0100 ;
	}
      } else {
	ptr->chara = sptr->chara ;
      }
      sptr ++ ;
      ptr ++ ;
      break ;
    default :
      *ptr ++ = *sptr ++ ;
      break ;
    }
  }
  MYCHAR_SET_END_OF_STRING( *ptr ) ;

  j_delete_region( node, startpoint, endpoint ) ;
  j_insert_str( node, startpoint, temporary_buffer ) ;
  return 0 ;
}

/*
 * ̾⡼ɤҲ̾⡼ɤڤؤؿ
 *-----
 * ΰˤϡESC פˤ륳ޥɤϤ줿ä롣
 * Ǥ⡢ߤεǽ򥵥ݡȤͽϤʤΤǡˤ NULL 
 * ääƤ뤳ȤǤ餦
 */
int j_toggle_kana
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int arg, int chara )
{
  /* "q" ˳ rule-list ̵ͤ롣*/
  if( j_kakutei_kana_mode( gw, sbuffer, node, chara ) )
    return 0 ;
  if( node->j_henkan_mode && !node->j_henkan_on ){
    /* ѴʤСҲ̾Ѵ֤겾̾⡼ɤʤ̵롣*/
    if( !node->j_katakana_mode ){
      j_katakana_region
	( node, node->j_henkan_start_point, node->cur_pos, True ) ;
    } else {
      j_hiragana_region
	( node, node->j_henkan_start_point, node->cur_pos, True ) ;
    }
    j_kakutei( gw, node ) ;
  } else {
    /* ʳξä顢Ҳ̾⡼ɤȲ̾⡼ɤڤؤ롣*/
    j_kakutei( gw, node ) ;
    node->j_katakana_mode = !node->j_katakana_mode ;
  }
  return 0 ;
}

/*
 * Ѵ⤷ϲ̾ϤʤгεǽԤѿ⡼ɤʤ
 * ޻̾ϥ⡼ɤؤȰܹԤؿ
 */
int j_kanainput_mode_on
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node )
{
  /* Ѵ⤷ϲ̾ϤǤʤСꤹ롣*/
  j_kakutei( gw, node ) ;
  j_kakutei_kana_mode( gw, sbuffer, node, '\0' ) ;
  /* ѿ⡼ɤϤޤθƤʤΤǡνϤʤ*/
  return 0 ;
}

int j_mode_off
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  if( j_kakutei_kana_mode( gw, sbuffer, node, chara ) )
    return 0 ;
  j_kakutei( gw, node ) ;
  node->j_mode    = False ;
  node->j_zenkaku = False ;
  return 0 ;
}

/*
 * ϥ⡼ɤؤȰܹԤԤؿǤ롣
 */
int j_zenkaku_eiji
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  if( j_kakutei_kana_mode( gw, sbuffer, node, chara ) )
    return 0 ;
  j_kakutei( gw, node ) ;
  node->j_mode    = False ;
  node->j_zenkaku = True ;
  return 0 ;
}

static int j_start_henkan_sub( Widget gw, struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  /* Ѵ褦ȤƤ֤ΤǤ */
  if( node->j_henkan_start_point > node->cur_pos ){
    err_msg( node, "Henkan end point must be after henkan start point." ) ;
    return 1 ;
  }
  return 0 ;
}

/*
 * Ѵϴؿ
 *----
 * ѴˤɬϸƤФͽۤؿǤ롣
 */
int j_start_henkan
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  int okuri_is_n, copy_sareta_mojisuu, copy_suru_mojisuu ;
  struct myChar lchara ;

  okuri_is_n =
    ( ( IS_ASCII_EQUAL  ( node->j_prefix[ 0 ], 'n' ) &&
	IS_END_OF_STRING( node->j_prefix[ 1 ] ) )? True : False ) ;

  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;

  if( !node->j_henkan_mode ){
    /* Ѵǽʾ֤Ǥʤä顢򵭹ν *
     * ʤ*/
    j_insert_chara( node, node->cur_pos, ' ' ) ;
    return 0 ;
  }
  /* Ѵǽʾ֤ˤʤäƤΤʤСѴ򤹤롣*/
  node->j_mode = True ;
  /* ˰ʾѴԤƤΤǤСθõ*/
  if( node->j_henkan_on ){
    /* ơѴԤޤ*/
    j_henkan( gw, sbuffer, node ) ;
  } else {
    /* Ѵν*/
    if( j_start_henkan_sub( gw, node ) )
      return 1 ;
    if( node->j_okurigana_mode && okuri_is_n ){
      MYCHAR_SET_CHARA( lchara, 'n' ) ;
      j_set_okurigana( gw, sbuffer, node, lchara ) ;
    } else {
      /* ߤΥ֤Ѵλ֤Ȥʤ꿽*/
      node->j_henkan_end_point = node->cur_pos ;
      /* ѴڤФ*/
      copy_suru_mojisuu =
	node->j_henkan_end_point - node->j_henkan_start_point ;
      if( node->j_katakana_mode ){
	copy_sareta_mojisuu = myCharHiraKataStrnncpy
	  ( node->j_henkan_key, TEXTMAXLEN,
	    node->textbuffer + node->j_henkan_start_point,
	    copy_suru_mojisuu ) ;
      } else {
	myCharStrncpy
	  ( node->j_henkan_key,
	    node->textbuffer + node->j_henkan_start_point,
	    copy_suru_mojisuu ) ;
	copy_sareta_mojisuu = copy_suru_mojisuu ;
      }
      MYCHAR_SET_END_OF_STRING
	( node->j_henkan_key[ copy_sareta_mojisuu ] ) ;
      /* ñϿλ˻Ȥ¸Ƥ*/
      myCharStrcpy( node->j_henkan_key2, node->j_henkan_key ) ;
      /* #ʸѴΤν*/
      if( skkinput_use_numeric_conversion ){
	j_compute_numeric_henkan_key
	  ( node->j_search_key, node->j_henkan_key, node->j_num_list ) ;
	/* (times) ưν*/
	skkinput_create_j_num_list( node->j_num_list ) ;
      } else {
	myCharStrcpy( node->j_search_key, node->j_henkan_key ) ;
	MYCHAR_SET_END_OF_STRING( node->j_num_list[ 0 ] ) ;
      }
      /* ơѴԤޤ*/
      j_henkan( gw, sbuffer, node ) ;
    }
  }
  return 0 ;
}

/*
 * θؤѴ᤹ؿ
 *----
 * ܸܲ skk Ʊ̾δؿưʬʤȤ⤢ޤɡ
 * ޤɤǤ͡äȤʬäƤľޤ
 */
int j_previous_candidate
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node )
{
  int pos ;

  if( node->j_henkan_mode && node->j_henkan_on ){
    if( node->j_henkan_count == 0 ){
      /* ξ֤ˤʤꤦΤ */
      /* j_henkan_count = 0 ȤƤޤȡj_henkan_on  off ˤʤäƤ *
       * ޤȻפΤ...ޤϤȲꤹ뤱ɡ      */
      return 0 ;
    } else if( node->j_henkan_count == 1 ){
      /* ѴƤʤ֤ذܹԤ롣*/
      node->j_henkan_on     = False ;
      node->j_henkan_count  = 0 ;
      MYCHAR_SET_END_OF_STRING( node->j_num_list[ 0 ] ) ;

      /* ѴλƽФ*/
      free_VectorIndex( &( node->j_henkan_vector_index_top ) ) ;
      free_SkkinpSearchVector( &( node->j_henkan_vector_top ) ) ;
      node->j_current_henkan_vector_index = NULL ;

      /* Ѵˤäƽ񤫤Ƥʸõ롣*/
      j_delete_region
	( node, node->j_henkan_start_point, node->j_henkan_end_point ) ;
      node->cur_pos = node->j_henkan_end_point ;
      /* Ȥʸ᤹*/
      pos = myCharStrlen( node->j_henkan_key ) - 1 ;
      if( IS_ASCII_CHARA( node->j_henkan_key[ pos ] ) &&
	  node->j_henkan_key[ pos ].chara >='a' &&
	  node->j_henkan_key[ pos ].chara <= 'z' &&
	  !node->j_abbrev )
	MYCHAR_SET_END_OF_STRING( node->j_henkan_key[ pos ] ) ;
      j_insert_str( node, node->cur_pos, node->j_henkan_key ) ;
      /* Ѵλ֤򸵤᤹*/
      node->j_henkan_end_point = node->cur_pos ;
      /* ֢פ֢פ᤹*/
      j_change_marker_to_write
	( node,	node->j_henkan_start_point - 1 ) ;
    } else {
      /* θФ*/
      if( ( node->j_current_henkan_vector_index )->prev != NULL ){
	node->j_current_henkan_vector_index =
	  ( node->j_current_henkan_vector_index )->prev ;
	node->j_henkan_count -- ;
      }
      /* ߤθä*/
      j_delete_region
	( node, node->j_henkan_start_point, node->j_henkan_end_point ) ;
      /* ФХåեˤĤ*/
      copyCandidate
	( temporary_buffer,
	 ( node->j_current_henkan_vector_index )->node,
	 ( node->j_current_henkan_vector_index )->position,
	 TEXTMAXLEN ) ;
      node->cur_pos_backup = node->cur_pos ;
      node->cur_pos = node->j_henkan_start_point ;
      /* 񤭹ࡣ*/
      j_insert_word
	( node, node->j_henkan_start_point, temporary_buffer ) ;
      node->j_henkan_end_point = node->cur_pos ;
      node->cur_pos = node->cur_pos_backup ;
    }
  } else {
    j_kana_input( gw, sbuffer, node, 'x' ) ;
  }
  return 0 ;
}

/*
 * ܡɤ Control-H νԤؿ
 *----
 * sbflag  kterm ʤɤ C-h 뤫ɤ
 * sendflag ϳꤷʸѴ饤Ȥ뤫ɤ
 */
int j_backward_delete_char
( Widget gw, struct skkinputBuffer *sbuffer, 
  struct SKKInputNode *node, int sbflag )
{
  if( node->j_henkan_mode && 
      node->cur_pos == node->j_henkan_start_point ){
    /* Ѵ⡼ɤǤꡢѴϰ֤ˤˤϡäƤޤ *
     * ȤˤʤäƤޤΤǡꤹ뤳Ȥˤʤ롣                   */
    node->j_henkan_count = 0 ;
    j_kakutei( gw, node ) ;
  } else if( node->j_henkan_on ){
    /* Ѵ⡼ɤǤꡢʾºݤѴԤƤˤϡ   *
     * θФ⡼ɤ롣                                   */
    if( node->cur_pos == node->j_henkan_end_point &&
	!skkinput_delete_implies_kakutei ){
      j_previous_candidate( gw, sbuffer, node ) ;
    } else {
      int p = node->j_henkan_end_point ;
      /*  delete_backward_char  end_point ưƤޤ *
       * cur_pos == end_point äˤϡܤˤʤäƤޤͤ */
      delete_backward_char( gw, node, &sbuffer->xevent, sbflag ) ;
      if( node->cur_pos < p )
	j_kakutei( gw, node ) ;
    }
  } else  {
    /* 겾̾ϤƤä顢̵ˤ롣*/
    if( node->j_okurigana_mode ){
      node->j_okurigana_mode = False ;
      MYCHAR_SET_END_OF_STRING( node->j_okuri_chara ) ;
      if( IS_ASCII_EQUAL
	  ( node->textbuffer[ node->j_okurigana_start_point ], '*' ) ){
	/* ȡ"*äääät"  C-h 򲡤ȤäѤä *
	 * */
	if( node->j_kana_mode == True &&
	    node->j_kana_start_point > node->j_okurigana_start_point ){
	  j_delete_region
	    ( node, node->j_okurigana_start_point,
	      node->j_kana_start_point ) ;
	} else {
	  delete_char( node, node->j_okurigana_start_point, 1 ) ;
	}
      }
      /* ̾ϤκʤСβ̾ץեƺ롣*/
      if( node->j_kana_mode ){
	node->j_kana_mode = False ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
	/* ̾ץեγϰ֤饫֤ޤǤ롣*/
	j_delete_region( node, node->j_kana_start_point, node->cur_pos ) ;
      }
    } else {
      /* ̾ϤκʤСβ̾ץեƺ롣*/
      if( node->j_kana_mode ){
	node->j_kana_mode = False ;
	MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
	/* ̾ץեγϰ֤饫֤ޤǤ롣*/
	j_delete_region( node, node->j_kana_start_point, node->cur_pos ) ;
      } else {
	delete_backward_char( gw, node, &sbuffer->xevent, sbflag ) ;
      }
    }
  }
  return 0 ;
}

/*
 * ԤƬذưؿ
 */
int j_beginning_of_line( struct SKKInputNode *node )
{
  /* ̾Ϥʤ顢Υץե롣*/
  j_delete_kanaprefix( node ) ;
  /* Ƭء*/
  node->cur_pos = node->cur_pos_top ;
  return 0 ;
}

/*
 * ԤκǸذưؿ
 */
int j_end_of_line( struct SKKInputNode *node )
{
  /* ̾Ϥʤ顢Υץե롣*/
  j_delete_kanaprefix( node ) ;
  /* ء*/
  node->cur_pos = myCharStrlen( node->textbuffer ) ;
  return 0 ;
}

/*
 * ְʹߤʸ򥫥åȥХåե˰ưؿ
 */
int j_kill_line( struct SKKInputNode *node, struct myChar *cutbuffer )
{
  int last_pos ;
  /* ̾Ϥʤ顢Υץե롣*/
  j_delete_kanaprefix( node ) ;

  last_pos = myCharStrlen( node->textbuffer ) ;
  /* åȥХåե˥ԡ롣*/
  myCharStrcpy( cutbuffer, node->textbuffer + node->cur_pos ) ;
  /* ʹߤʸõ롣*/
  j_delete_region( node, node->cur_pos, last_pos ) ;
  return 0 ;
}

/*
 * åȥХåեäƤʸŽդؿ
 *----------------
 * åȥХåե򥦥åȤäƤΤĤ
 * ѤĤޤäʡɤˤҤäڤʤȡĥåȤĤΤ
 * ΤɡåȤ򤳤ĤϤΤϤäȡġ
 */
int j_yank( struct SKKInputNode *node, struct myChar *cutbuffer )
{
  j_insert_str( node, node->cur_pos, cutbuffer ) ;
  return 0 ;
}

/*
 * ֤ΰΥȥ֤Υ򴹤ƥ
 * ĿʤԤؿ
 *-----
 * 뤬äˤϥΰưϤʤ򴹤
 * 륭ϥΰȤ⤦Ǥ롣
 *()
 * EUC-3byte ɤ̵뤷Ƥޤ
 */
int j_transpose_chars( struct SKKInputNode *node )
{
  struct myChar transpose_buffer[ 3 ] ;

  /* ̾Ϥʤ顢Υץե롣*/
  j_delete_kanaprefix( node ) ;
  /* Ƭʤ鲿⤷ʤȴ롣*/
  if( node->cur_pos == node->cur_pos_top ){
    err_msg( node, "Beginning of buffer" ) ;
    return 0 ;
  } else if( IS_END_OF_STRING( node->textbuffer[ node->cur_pos ] ) )
    return 0 ;
  /* 򴹤ʸȴФʸˤƤ*/
  transpose_buffer[ 0 ] = node->textbuffer[ node->cur_pos     ] ;
  transpose_buffer[ 1 ] = node->textbuffer[ node->cur_pos - 1 ] ;
  MYCHAR_SET_END_OF_STRING( transpose_buffer[ 2 ] ) ;
  /* 򴹤ΰõ롣*/
  j_delete_region( node, node->cur_pos - 1, node->cur_pos + 1 ) ;
  /* 򴹸ʸ롣*/
  j_insert_str( node, node->cur_pos, transpose_buffer ) ;
  return 0 ;
}

static int search_previous_history
( struct myChar *buffer, int spos, int nowpos )
{
  nowpos -- ;
  do {
    nowpos -- ;
    if( nowpos < 0 )
      nowpos += TEXTBUFSIZE ;
  } while( !IS_END_OF_STRING( buffer[ nowpos ] ) && nowpos != spos ) ;

  /* θγϰ֡*/
  if( nowpos != spos ){
    nowpos = ( nowpos + 1 ) % TEXTBUFSIZE ;
  }
  return nowpos ;
}

/*
 * ιԤĤäơǥʤϤĤäƤ
 * ɽؿ
 *-----
 * Ȥ櫓ǡΤΤϳꤵƤޤҥȥΰֺǸ
 * ¸롣( ʤʤäƤޤä顢äȺ顣)
 */
int j_previous_line
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  struct myChar *ptr ;
  int pos, length, prev_j_mode, prev_j_zenkaku ;
  /* ֿƤΥХåեǤͭǤʤȤ롣*/
  if( node->parentbuffer != NULL || sbuffer->historybuffer == NULL ||
      sbuffer->hist_start == sbuffer->hist_end ||
      sbuffer->overthespot_like_input ){
    /* ̾Ϥʤ顢ΥץեƤʤ
       С̾ϤǤ C-p  C-n ̤ʤʤäƤޤ */
    j_delete_kanaprefix( node ) ;
    return 1 ;
  }
  /* ꤷƤޤȡj-mode ѹƤޤΤǳФƤ*/
  prev_j_mode    = node->j_mode ;
  prev_j_zenkaku = node->j_zenkaku ;
  /* ꤹ롣ʤˤʤ롣*/
  j_kakutei( gw, node ) ;
  j_kakutei_kana_mode( gw, sbuffer, node, '\0' ) ;
  /* ʾθϤʤΤǡ⤷ʤǵ롣*/
  if( sbuffer->hist_cur == sbuffer->hist_start ){
    node->j_mode    = prev_j_mode ;
    node->j_zenkaku = prev_j_zenkaku ;
    return 0 ;
  }
  /* θѤǽäǤ*/
  if( sbuffer->hist_cur < 0 || sbuffer->hist_cur >= TEXTBUFSIZE ){
    /* ߤʸ¸Ƥ*/
    myCharStrcpy( sbuffer->histcurbackbuffer, node->textbuffer ) ;
    sbuffer->hist_cur = sbuffer->hist_end ;
  }
  /* θ롣*/
  sbuffer->hist_cur = search_previous_history
    ( sbuffer->historybuffer, sbuffer->hist_start, sbuffer->hist_cur ) ;
  /* ȴФ*/
  ptr = node->textbuffer ;
  pos = sbuffer->hist_cur ;
  length = 0 ;
  while( !IS_END_OF_STRING( sbuffer->historybuffer[ pos ] ) ){
    *ptr ++ = sbuffer->historybuffer[ pos ++ ] ;
    length ++ ;
    if( pos >= TEXTBUFSIZE )
      pos = 0 ;
  }
  MYCHAR_SET_END_OF_STRING( *ptr ) ;
  /* ֤ν*/
  node->cur_pos = length ;
  /*  j-mode ᤹*/
  node->j_mode    = prev_j_mode ;
  node->j_zenkaku = prev_j_zenkaku ;
  return 0 ;
}

static int search_next_history
( struct myChar *buffer, int epos, int nowpos )
{
  do {
    nowpos ++ ;
    if( nowpos >= TEXTBUFSIZE )
      nowpos = 0 ;
  } while( !IS_END_OF_STRING( buffer[ nowpos ] ) && nowpos != epos ) ;

  /* θγϰ֡*/
  if( nowpos != epos ){
    nowpos = ( nowpos + 1 ) % TEXTBUFSIZE ;
  }
  return nowpos ;
}

/*
 * ιԤعԤĤäơǥʤäƤˤ
 * ᤷѤ櫓Ǥ
 *-----
 * Ȥ櫓ǡΤΤϳꤵƤޤҥȥΰֺǸ
 * ¸롣( ʤʤäƤޤä顢äȺ顣)
 */
int j_next_line
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  struct myChar *sptr, *dptr ;
  int pos, length, prev_j_mode, prev_j_zenkaku ;

  /* ֿƤΥХåեǤͭǤʤȤ롣*/
  if( node->parentbuffer != NULL || sbuffer->historybuffer == NULL ||
      sbuffer->hist_cur < 0 || sbuffer->overthespot_like_input ){
    /* ̾Ϥʤ顢ΥץեƤʤ
       С̾ϤǤ C-p  C-n ̤ʤʤäƤޤ */
    j_delete_kanaprefix( node ) ;
    return 1 ;
  }
  /* ꤷƤޤȡj-mode ѹƤޤΤǳФƤ*/
  prev_j_mode    = node->j_mode ;
  prev_j_zenkaku = node->j_zenkaku ;
  /* ޤꤹ롣*/
  j_kakutei( gw, node ) ;
  j_kakutei_kana_mode( gw, sbuffer, node, '\0' ) ;
  /* θܤ*/
  sbuffer->hist_cur = search_next_history
    ( sbuffer->historybuffer, sbuffer->hist_end, sbuffer->hist_cur ) ;
  /* ֺǸؤƤäƤȤϡ */
  if( sbuffer->hist_cur == sbuffer->hist_end ){
    myCharStrcpy( node->textbuffer, sbuffer->histcurbackbuffer ) ;
    node->cur_pos = myCharStrlen( node->textbuffer ) ;
    sbuffer->hist_cur = -1 ;
    /* Υ⡼ɤᤷƤѴȤ
       Ƥ롣*/ 
    node->j_mode    = prev_j_mode ;
    node->j_zenkaku = prev_j_zenkaku ;
    return 0 ;
  }
  /* ȴФ*/
  pos  = sbuffer->hist_cur ;
  sptr = sbuffer->historybuffer + pos ;
  dptr = node->textbuffer ;
  length = 0 ;
  while( !IS_END_OF_STRING( *sptr ) && pos != sbuffer->hist_end ){
    *dptr ++ = *sptr ++ ;
    pos ++ ;
    length ++ ;
    if( pos >= TEXTBUFSIZE ){
      sptr = sbuffer->historybuffer ;
      pos  = 0 ;
    }
  } 
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  /* ֤*/
  node->cur_pos = length ;
  /* Υ⡼ɤᤷƤѴȤ
     Ƥ롣*/ 
  node->j_mode    = prev_j_mode ;
  node->j_zenkaku = prev_j_zenkaku ;
  return 0 ;
}

/*
 * Ѵϰ֤ꤹؿ
 *----
 * ʸϤˤѴϰ֤ꤵ뤳Ȥ˥ǥեȤǤϤʤ
 * Ƥ롣
 */
void j_set_henkan_point
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  switch( chara ){
  case 'A' :
    /* 첻Ϥ뤳ȤˤѴϰ֤ꤵν*/
    j_set_henkan_point_ByVowel
      ( gw, sbuffer, node, skk_roma_kana_a, chara ) ;
    break ;
  case 'E' :
    /* 첻Ϥ뤳ȤˤѴϰ֤ꤵν*/
    j_set_henkan_point_ByVowel
      ( gw, sbuffer, node, skk_roma_kana_e, chara ) ;
    break ;
  case 'I' :
    /* 첻Ϥ뤳ȤˤѴϰ֤ꤵν*/
    j_set_henkan_point_ByVowel
      ( gw, sbuffer, node, skk_roma_kana_i, chara ) ;
    break ;
  case 'O' :
    /* 첻Ϥ뤳ȤˤѴϰ֤ꤵν*/
    j_set_henkan_point_ByVowel
      ( gw, sbuffer, node, skk_roma_kana_o, chara ) ;
    break ;
  case 'U' :
    /* 첻Ϥ뤳ȤˤѴϰ֤ꤵν*/
    j_set_henkan_point_ByVowel
      ( gw, sbuffer, node, skk_roma_kana_u, chara ) ;
    break ;
    /* üʸФʸˤäѴγϰ֤ꤵ硣*/
  case '<' :
  case '>' :
  case '?' :
    j_set_henkan_point_by_special_midashi_char
      ( gw, sbuffer, node, chara ) ;
    break ;
  default :
    j_set_henkan_point_ByConsonat( gw, sbuffer, node, chara ) ;
    break ;
  }
  return ;
}

void j_set_henkan_point_subr
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int rchara )
{
  struct myChar lchara ;
  /* ̾椫"n"ʤ""ˤƤޤ*/
  if( j_kakutei_kana_mode( gw, sbuffer, node, rchara ) )
    return ;
  /* ºݤȰ㤦褦ɡƤǽ褦*/
  if( node->j_henkan_mode )
    j_kakutei( gw, node ) ;
  /* ɽơ*/
  MYCHAR_SET_JISX0208_1983( lchara, 0x2226 /*""*/ ) ;
  j_insert_myChara( node, node->cur_pos, lchara ) ;
  /* Ѵϰ֤򥫡֤˷ꤷơ*/
  node->j_henkan_start_point = node->cur_pos ;
  node->j_henkan_mode = True ;
  node->j_henkan_on   = False ;
  return ;
}

/*
 * C-g ˤäѴ֢פξ֤֢פξ֤ؤܤν
 * Ԥؿ
 */
static void j_keyboard_quit_henkanrestart
( Widget gw, struct SKKInputNode *node, int flag )
{
  int endp_is_bigger_than_startp ;
  /* ѴƤʤ֤ذܹԤ롣*/
  node->j_henkan_on      = False ;
  node->j_henkan_count   = 0 ;
  node->j_henkan_show_candidate_mode = False ;
  /* ѴλƽФ*/
  free_VectorIndex( &( node->j_henkan_vector_index_top ) ) ;
  free_SkkinpSearchVector( &( node->j_henkan_vector_top ) ) ;
  node->j_current_henkan_vector_index = NULL ;
  /* Ѵäޤ*/
  node->cur_pos2 = node->j_kana_start_point ;
  node->cur_pos3 = node->j_okurigana_start_point ;

  if( node->j_okurigana_mode ){
    /* ɤɤʬʤɡĥɥۥåбɡġ*/
    if( !IS_ASCII_EQUAL
	( node->textbuffer[ node->j_okurigana_start_point ], '*' ) )
      node->j_okurigana_mode = False ;
    endp_is_bigger_than_startp = node->j_henkan_start_point <
      node->j_henkan_end_point ;
    MYCHAR_SET_END_OF_STRING
      ( node->j_henkan_key[ node->j_okurigana_offset ] ) ;
    j_delete_region
      ( node, node->j_henkan_start_point, node->j_okurigana_start_point ) ;
  } else {
#if 0
    pos = myCharStrlen( node->j_henkan_key ) ;
    MYCHAR_SET_END_OF_STRING( node->j_henkan_key[ pos ] ) ;
#endif
    endp_is_bigger_than_startp = False ;
    j_delete_region
      ( node, node->j_henkan_start_point, node->j_henkan_end_point ) ;
  }
  if( !flag ){
    node->cur_pos4 = node->j_henkan_end_point ;
    if( !node->j_katakana_mode ){
      j_insert_str( node, node->j_henkan_end_point, node->j_henkan_key ) ;
    } else {
      myCharKatakanaStrcpy
	( temporary_buffer, node->j_henkan_key ) ;
      j_insert_str( node, node->j_henkan_end_point, temporary_buffer ) ;
    }
    /* Ѵλ֤򸵤᤹*/
    node->j_henkan_end_point = node->cur_pos4 ;
  } else if( endp_is_bigger_than_startp ){
    if( !node->j_katakana_mode ){
      j_insert_str
	( node, node->j_henkan_start_point, node->j_henkan_key ) ;
    } else {
      myCharKatakanaStrcpy
	( temporary_buffer, node->j_henkan_key ) ;
      j_insert_str( node, node->j_henkan_start_point, temporary_buffer ) ;
    }
  }
  node->j_kana_start_point = node->cur_pos2 ;
  node->j_okurigana_start_point = node->cur_pos3 ;
  /* ֢פ֢פ᤹*/
  j_change_marker_to_write
    ( node, node->j_henkan_start_point - 1 ) ;
  return ;
}

/*
 * C-g ˤäѴ֢פξ֤λνԤؿ
 */
static void j_keyboard_quit_henkanclose
( Widget gw, struct SKKInputNode *node )
{
  int pos ;

  /* Ѵ⡼ɤȴФ*/
  node->j_henkan_mode    = False ;
  node->j_henkan_on      = False ;
  node->j_abbrev         = False ;
  node->j_henkan_show_candidate_mode = False ;
  pos = node->j_henkan_start_point - 1 ;
  /* Ѵϰ֤ˡ֢פϤΤ ̵ä顢ѡ*/
  if( node->textbuffer[ pos ].charset == CHARSET_JISX0208_1983 &&
      node->textbuffer[ pos ].chara == 0x2226 /*""*/ ){
    delete_char( node, pos, 1 ) ;
  } else {
    err_msg( node, "It seems that you have deleted ." ) ;
  }
  /* 겾̾⡼ɤäн襳ɡ*/
  if( node->j_okurigana_mode && 
      IS_ASCII_EQUAL
      ( node->textbuffer[ node->j_okurigana_start_point ], '*' ) )
    delete_char( node, node->j_okurigana_start_point, 1 ) ;
  /* Ѵϰ֤饫֤ޤǤõ롣*/
  j_delete_region
    ( node, node->j_henkan_start_point, node->cur_pos ) ;
  node->j_okurigana_mode = False ;
  return ;
}

/*
 * Control-G 򲡤ν
 */
void j_keyboard_quit
( Widget gw, struct skkinputBuffer *buffer, struct SKKInputNode *node )
{
  /* ̾ʤΥץե򥭥󥻥뤷Ƥޤ*/
  if( node->j_kana_mode ){
    /* β̾ץեä롣*/
    delete_char
      ( node, node->j_kana_start_point,
	node->cur_pos - node->j_kana_start_point ) ;
    node->j_kana_mode = False ;
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
    return ;
  }
  /* Ѵ⡼ɤ˰ưƤΤǤ */
  if( node->j_henkan_mode ){
    /* ºݤѴϰٰʾԤƤΤǤ */
    if( node->j_henkan_on ){
      /* ֢פ֢פؤȾܤơѴκǽؤ᤹*/
      j_keyboard_quit_henkanrestart( gw, node, False ) ;
      node->j_okurigana_mode = False ;
    } else {
      /* ֢פõѴλ롣*/
      j_keyboard_quit_henkanclose( gw, node ) ;
    }
    return ;
  }

  /* ľܥϥ⡼ɤäν*/
  if( node->j_input_by_code_or_menu_mode ){
    node->j_input_by_code_or_menu_mode = False ;
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
    return ;
  }

  /* ʾΤɤǤʤä顢mini-buffer mode ˤʤäɤ *
   * Ƚꤹ롣*/
  if( node->parentbuffer != NULL ){
    struct SKKInputNode *pNode = node->parentbuffer ;
    int usage = node->j_minibuff_usage ;
    /* ߥ˥ХåեѤߤΤǡꥢ롣*/
    XtVaSetValues( gw, XtNclearMinibuffer, True, NULL ) ;
    /* 󥻥ȤȤǡΥΡɤϲƤޤޤ*/
    free_Minibuffer( gw, buffer, node ) ;
    /* Ƥ˥֤ޤ礦*/
    pNode->cur_exist = True ;

    /* ǡĿƤ򤷤ƤΤȽǤŬڤʽƤˤ¹Ԥ롣*/
    switch( usage ){
      /* ߥ˥ХåեǤѴ˰ܤäƤġ*/
    case J_HENKAN_IN_MINIBUFF_MODE :
      /* ߥ˥ХåեǤѴ⡼ɤäƤʤ顢äȤҥå *
       * Τ̵äν*/
      if( pNode->j_henkan_count == 0 && pNode->j_henkan_mode &&
	  pNode->j_henkan_on ){
	/* ΤޤޤǤϤʤؤȾܤ롣*/
	j_keyboard_quit_henkanrestart
	  ( gw, pNode, pNode->j_okurigana_mode ) ;
      }
      break ;
    case J_INPUT_BY_CODE_OR_MENU_MODE :
      pNode->j_input_by_code_or_menu_mode = False ;
      MYCHAR_SET_END_OF_STRING( pNode->mtextbuffer[ 0 ] ) ;
      break ;
      /* ѡʤäˤ̵ƤǤʤʤġ *
       * ȤܡĤǤɤˤʤΤͤ*/
    case J_PURGE_YES_OR_NO_P :
      MYCHAR_SET_END_OF_STRING( pNode->mtextbuffer[ 0 ] ) ;
      break ;
    default :
      break ;
    }
    /* ƤѴɽ⡼ɤǤʤä顢ˤƤ*/
    if( !pNode->j_henkan_show_candidate_mode )
      MYCHAR_SET_END_OF_STRING( pNode->mtextbuffer[ 0 ] ) ;
    return ;
  }
#if 0
  XBell( XtDisplay( gw ), 2 ) ;
#endif
  err_msg( node, "Quit" ) ;
  return ;
}

/*
 * νԤäƤΥ٥Ȥνؿ
 *----
 * ϥХɤѹ뤳ȤϤǤʤ skk.el Ǥ⤽ʤ
 * ƤȦ̤ѹǤ褦ˤƤ⹽ʤɤ͡
 */
int do_Function_jhenkanShowCandidateMode
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  VectorIndex *vNode ;
  struct keyBuffer *keybuf ;
  int h_count, kouho_num, i ;

  /* 顼ɽǾäƤޤäƤ뤫⤷ʤɽ */
  /* Emacs ϼưƤߤɡġ */
  vNode     = j_henkan_show_candidates( node, &h_count ) ;
  kouho_num = h_count - node->j_henkan_count ;
  keybuf    = &sbuffer->keybuf ;

  switch( keybuf->buffer[ keybuf->usage - 1 ] ){
    /* ֺθ򤹤롣*/
  case 'a' :
    /* ȴФơġ*/
    copyCandidate
      ( temporary_buffer,
	( node->j_current_henkan_vector_index )->node,
	( node->j_current_henkan_vector_index )->position,
	TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
    j_insert_word
      ( node, node->j_henkan_start_point, temporary_buffer ) ;
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
    break ;

    /* 飲ܤθ򤹤롣*/
  case 's' :
    if( kouho_num < 2 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next ;
    
    /* ȴФơġ*/
    copyCandidate
      ( temporary_buffer,
	( node->j_current_henkan_vector_index )->node,
	( node->j_current_henkan_vector_index )->position,
	TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
    j_insert_word
      ( node, node->j_henkan_start_point, temporary_buffer ) ;
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
    break ;

    /* 飳ܤθ򤹤롣*/
  case 'd' :
    if( kouho_num < 3 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next->next ;

    /* ȴФơġ*/
    copyCandidate
      ( temporary_buffer,
	( node->j_current_henkan_vector_index )->node,
	( node->j_current_henkan_vector_index )->position,
	TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
    j_insert_word
      ( node, node->j_henkan_start_point, temporary_buffer ) ;
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
    break ;

    /* 飴ܤθ򤹤롣*/
  case 'f' :
    if( kouho_num < 4 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next->next->next ;

    /* ȴФơġ*/
    copyCandidate
      ( temporary_buffer,
	( node->j_current_henkan_vector_index )->node,
	( node->j_current_henkan_vector_index )->position,
	TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
    j_insert_word
      ( node, node->j_henkan_start_point, temporary_buffer ) ;
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
    break ;

    /* 飵ܤθ򤹤롣*/
  case 'j' :
    if( kouho_num < 5 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next->next->next->next ;

    /* ȴФơġ*/
    copyCandidate
      ( temporary_buffer,
	( node->j_current_henkan_vector_index )->node,
	( node->j_current_henkan_vector_index )->position,
	TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
    j_insert_word
      ( node, node->j_henkan_start_point, temporary_buffer ) ;
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
    break ;

    /* 飶ܤθ򤹤롣*/
  case 'k' :
    if( kouho_num < 6 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next->next->next->next->next ;

    /* ȴФơġ*/
    copyCandidate
      ( temporary_buffer,
	( node->j_current_henkan_vector_index )->node,
	( node->j_current_henkan_vector_index )->position,
	TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
    j_insert_word
      ( node, node->j_henkan_start_point, temporary_buffer ) ;
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
    break ;

    /* 飷ܤθ򤹤롣*/
  case 'l' :
    if( kouho_num < 7 )
      break ;

    node->j_current_henkan_vector_index =
      node->j_current_henkan_vector_index->next->next->next->next->next->next ;

    /* ȴФơġ*/
    copyCandidate
      ( temporary_buffer,
	( node->j_current_henkan_vector_index )->node,
	( node->j_current_henkan_vector_index )->position,
	TEXTMAXLEN ) ;
    /* Ѵλ֤Ĵ*/
    node->cur_pos_backup = node->cur_pos ;
    node->cur_pos        = node->j_henkan_start_point ;
    /* ʸ*/
    j_insert_word
      ( node, node->j_henkan_start_point, temporary_buffer ) ;
    node->j_henkan_end_point = node->cur_pos ;
    node->cur_pos = node->cur_pos_backup ;
    /* Υ⡼ɤνλ*/
    j_kakutei( gw, node ) ;
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
    break ;

    /* θɽ롣*/
  case 'x' :
    /* 󤹤⡼ɤλʤФʤʤΤ */
    if( node->j_henkan_count == 5 ){
      /* ϤλʤƤϤʤޤ*/
      node->j_current_henkan_vector_index = 
	( node->j_current_henkan_vector_index )->prev ;
      node->j_henkan_count -- ;
      /* ȴФơġ*/
      copyCandidate
	( temporary_buffer,
	  ( node->j_current_henkan_vector_index )->node,
	  ( node->j_current_henkan_vector_index )->position,
	  TEXTMAXLEN ) ;
      /* Ѵλ֤Ĵ*/
      node->cur_pos_backup = node->cur_pos ;
      node->cur_pos        = node->j_henkan_start_point ;
      /* ʸ*/
      j_insert_word
	( node, node->j_henkan_start_point, temporary_buffer ) ;
      node->j_henkan_end_point = node->cur_pos ;
      node->cur_pos = node->cur_pos_backup ;
      /* Υ⡼ɤνλ*/
      node->j_henkan_show_candidate_mode = False ;
      MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
    } else {
      /* λʤƤ⹽ʤǤ*/
      node->j_henkan_count -= 7 ;
      /* θɽ٤᤹*/
      for( i = 0 ; i < 7 ; i ++ )
	node->j_current_henkan_vector_index = 
	  ( node->j_current_henkan_vector_index )->prev ;
      /* ɽľ*/
      j_henkan_show_candidates( node, NULL ) ;
    }
    break ;
    /* θɽ롣*/
  case ' ' :
    if( vNode != NULL ){
      /* ƬθؤƤݥ󥿤ư롣*/
      node->j_current_henkan_vector_index = vNode ;
      node->j_henkan_count                = h_count ;
      /* ɽľ*/
      j_henkan_show_candidates( node, NULL ) ;
    } else {
      /* minibuffer 򳫤ƤѴȤ˰ư롣*/
      skkinput_j_henkan_in_minibuff_init( gw, sbuffer, node ) ;
    }
    break ;
    /* Keyboard-Quit äν*/
  case 0x07 :
    j_keyboard_quit( gw, sbuffer, node ) ;
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
    break ;
    /* ̤νľ*/
  case 0x0c :
    /* ɽľ*/
    j_henkan_show_candidates( node, NULL ) ;
    break ;
    /* ʥϤä硣*/
  default :
    err_msg( node, "`%s' is not valid here!",
	     charaToString( keybuf->buffer[ keybuf->usage - 1 ] ) ) ;
    break ;
  }
  return 0 ;
}

static int lookup_at_string( char *string, int chara )
{
  char *ptr = string ;
  int i ;

  for( i = 0 ; *ptr != '\0' ; ptr ++, i ++ ){
    if( *ptr == chara )
      return i ;
  }
  return (-1) ;
}

/*
 * ľܥϤλΥߥ˥Хåեɽؿ
 */
static void j_input_by_code_or_menu_jmp_showCandidate
( struct SKKInputNode *node, int code )
{
  struct myChar *ptr ;
  int i ;
  /* ¹ԤɬפΤɤϵ䡣initialize Ǥ *
   * Ƥޤ٤*/
  j_input_by_code_menu1_codes[ 0 ] = j_code_n1_min ;

  /* ϰˤ뤫ɤȽǤ롣*/
  if( code < j_code_n1_min )
    code = j_code_n1_min ;

  ptr = node->mtextbuffer ;
  /* ˥塼Ĥ롣*/
  for( i = 0 ; i < 6 ; i ++ ){
    /* 줰 code menu keys ˴ʤ褦ˡ*/
    MYCHAR_SET_CHARA
      ( *ptr, upcase_char( j_input_by_code_menu_keys1[ i ] ) ) ;
    ptr ++ ;
    ptr->charset = node->j_input_by_code_current_charset ;
    ptr->chara   = ( code << 8 ) |
      j_input_by_code_menu1_codes[ i ] ;
    ptr ++ ;
    MYCHAR_SET_CHARA( *ptr, ' ' ) ;
    ptr ++ ;
  }
  code ++ ;
  /* ϰˤ뤫ɤȽǤ롣*/
  if( code > j_code_n1_max )
    code = j_code_n1_min ;

  /* ˥塼Ĥ롣(ĤŤ)*/
  for( i = 0 ; i < 6 ; i ++ ){
    /* 줰 code menu keys ˴ʤ褦ˡ*/
    MYCHAR_SET_CHARA
      ( *ptr, upcase_char( j_input_by_code_menu_keys1[ i + 6 ] ) ) ;
    ptr ++ ;
    ptr->charset = node->j_input_by_code_current_charset ;
    ptr->chara   = ( code << 8 ) |
      j_input_by_code_menu1_codes[ i ] ;
    ptr ++ ;
    MYCHAR_SET_CHARA( *ptr, ' ' ) ;
    ptr ++ ;
  }
  MYCHAR_SET_END_OF_STRING( *ptr ) ;
  return ;
}

static void j_input_by_code_or_menu_1_jmp_showCandidate
( struct SKKInputNode *node, int code )
{
  unsigned int n1, n2, i ;
  struct myChar *ptr ;

  n1 = ( code >> 8 ) ;
  n2 = ( code & 0x00FF ) ;

#if 0
  fprintf( stderr, "code, n1, n2 = %x, %x, %x\n", code, n1, n2 ) ;
#endif
  ptr = node->mtextbuffer ;

  for( i = 0 ; i < 16 ; i ++ ){
    MYCHAR_SET_CHARA
      ( *ptr, upcase_char( j_input_by_code_menu_keys2[ i ] ) ) ;
    ptr ++ ;
    ptr->charset = node->j_input_by_code_current_charset ;
    ptr->chara   = ( n1 << 8 ) | n2 ;
    ptr ++ ;
    MYCHAR_SET_CHARA( *ptr, ' ' ) ;
    ptr ++ ;

    n2 ++ ;
    if( n2 > j_code_n2_max )
      n2 = j_code_n2_min ;
    if( n2 == j_code_n2_min ){
      n1 ++ ;
      if( n1 > j_code_n1_max )
	n1 = j_code_n1_min ;
    }
  }
  MYCHAR_SET_END_OF_STRING( *ptr ) ;
  return ;
}

int do_function_j_input_by_code_or_menu_jump
( Widget gw, struct skkinputBuffer *buffer, struct SKKInputNode *node )
{
  struct keyBuffer *keybuf ;
  unsigned char kbuf[ 3 ] ;
  int func_no ;

  /* 顼ɽǾäƤޤäƤ뤫⤷ʤɽ */
  /* Emacs ϼưƤߤɡġ */
  j_input_by_code_or_menu_jmp_showCandidate
    ( node, node->j_input_by_code_current_code ) ;

  keybuf  = &buffer->keybuf ;
  func_no = lookup_at_string
    ( j_input_by_code_menu_keys1, keybuf->buffer[ keybuf->usage - 1 ] ) ;
  
  if( func_no < 0 ){
    switch( keybuf->buffer[ keybuf->usage - 1 ] ){
      /* θɽ롣*/
    case 'x' :
      node->j_input_by_code_current_code -= 2 ;
      if( node->j_input_by_code_current_code < j_code_n1_min )
	node->j_input_by_code_current_code = j_code_n1_max ;
      break ;
      /* ļθɽ롣*/
    case ' ' :
      node->j_input_by_code_current_code += 2 ;
      if( node->j_input_by_code_current_code > j_code_n1_max )
	node->j_input_by_code_current_code = j_code_n1_min ;
      break ;
      /* C-g ˤ Quit */
    case 0x07 :
      j_keyboard_quit( gw, buffer, node ) ;
      goto exit_menu ;
      /* ̤ɽʤ*/
    case 0x0c :
      MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
      j_input_by_code_or_menu_jmp_showCandidate
	( node, node->j_input_by_code_current_code ) ;
      goto exit_menu ;
      /* ʳΥ̵*/
    default :
      err_msg
	( node, "`%s' is not valid here!",
	  charaToString( keybuf->buffer[ keybuf->usage - 1 ] ) ) ;
      goto exit_menu ;
    }
    /* ɽ*/
    j_input_by_code_or_menu_jmp_showCandidate
      ( node, node->j_input_by_code_current_code ) ;
  } else {
    /* 䤬򤵤줿ν*/
    kbuf[ 0 ] = node->j_input_by_code_current_code + ( func_no / 6 ) ;
    kbuf[ 1 ] = j_input_by_code_menu1_codes[ func_no % 6 ] ;
    kbuf[ 2 ] = '\0' ;
    
    node->j_input_by_code_current_code = kbuf[ 0 ] << 8 | kbuf[ 1 ] ;
    node->j_input_by_code_or_menu_mode ++ ;

    /* öߥ˥Хåեؤɽ򥯥ꥢ롣*/
    XtVaSetValues( gw, XtNclearMinibuffer, True, NULL ) ;
    /* ɽƤͿ롣*/
    j_input_by_code_or_menu_1_jmp_showCandidate
      ( node, node->j_input_by_code_current_code ) ;
  }
exit_menu:
  return 0 ;
}

int do_function_j_input_by_code_or_menu_1_jump
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  struct keyBuffer *keybuf ;
  int func_no ;
  unsigned int n1, n2 ;

  /* 顼ɽǾäƤޤäƤ뤫⤷ʤɽ */
  /* Emacs ϼưƤߤɡġ */
  j_input_by_code_or_menu_1_jmp_showCandidate
    ( node, node->j_input_by_code_current_code ) ;

  keybuf  = &sbuffer->keybuf ;
  func_no = lookup_at_string
    ( j_input_by_code_menu_keys2, keybuf->buffer[ keybuf->usage - 1 ] ) ;

  if( func_no < 0 ){
  /* 'a','s',ĤǤʤäν*/
    n1 = ( node->j_input_by_code_current_code ) >> 8 ;
    n2 = ( node->j_input_by_code_current_code ) & 0x00FF ;
    switch( keybuf->buffer[ keybuf->usage - 1 ] ){
      /* θؤ롣*/
    case 'x' :
      n2 -= 15 ;
      if( n2 < j_code_n2_min ){
	n2 = j_code_n2_max - ( j_code_n2_min - n2 ) ;
	n1 -- ;
	if( n1 < j_code_n1_min )
	  n1 = j_code_n1_max ;
      }
      break ;
      /* θõ*/
    case ' ' :
      n2 += 17 ;
      if( n2 > j_code_n2_max ){
	n2 = ( n2 - j_code_n2_max ) + j_code_n2_min ;
	n1 ++ ;
	if( n1 > j_code_n1_max )
	  n1 = j_code_n1_min ;
      }
      break ;
      /* j_keyboard quit ξνġ*/
    case 0x07 :
      j_keyboard_quit( gw, sbuffer, node ) ;
      goto exit_menu_1 ;
      /* ̤ɽ롣*/
    case 0x0c :
      MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
      j_input_by_code_or_menu_1_jmp_showCandidate
	( node, node->j_input_by_code_current_code ) ;
      /* ޤ褵Ȥޤ*/
      /* skkinput_RedrawScreen( gw ) ; */
      goto exit_menu_1 ;
      /* ʳΥϥ顼ˤʤ롣*/
    default :
      err_msg
	( node, "`%s' is not valid here!",
	  charaToString( keybuf->buffer[ keybuf->usage - 1 ] ) ) ;
      goto exit_menu_1 ;
    }
    node->j_input_by_code_current_code = ( n1 << 8 ) | ( n2 & 0x00FF ) ;
    j_input_by_code_or_menu_1_jmp_showCandidate
      ( node, node->j_input_by_code_current_code ) ;
  } else {
    /* ̵ */
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 3 * func_no + 2 ] ) ;
    j_insert_myChara
      ( node, node->j_input_by_code_or_menu_point,
	node->mtextbuffer[ 3 * func_no + 1 ] ) ;
    node->j_input_by_code_or_menu_mode = False ;
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
  }
exit_menu_1:
  return 0 ;
}

/*
 * 񤫤ñ()ؿľ꤯ưɤ档
 */
int j_purge_from_jisyo
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  if( node->j_henkan_on && !IS_END_OF_STRING( node->j_henkan_key[ 0 ] ) ){
    /* ߥ˥ХåեѤơʸϤ롣*/
    j_read_string
      ( gw, sbuffer, node, "Really purge? (yes or no) ",
	J_PURGE_YES_OR_NO_P ) ;
    /* Ƶ Widget ǤäˤʤäΤǡϤȤʤġ*/
  }
  return 0 ;
}

/*
 * ޡ򥻥åȤؿ
 */
int j_set_mark_command( struct SKKInputNode *node )
{
  node->mark_pos = node->cur_pos ;
  err_msg( node, "Mark set" ) ;
  return 0 ;
}

/*
 * ꤵ줿ϰϤʸȴФcutbufferˤޤؿ
 * õ뤫ɤ flag ͤˤ롣
 */
static int j_kill_region_sub
( struct SKKInputNode *node, struct myChar *cutbuffer, int flag )
{
  int startpos, cutlen ;

  /* ޡåȤƤʤäܡ*/
  if( node->mark_pos < 0 ){
    err_msg( node, "The mark is not set now" ) ;
    return 1 ;
  }
  if( node->mark_pos < node->cur_pos ){
    startpos = node->mark_pos ;
    cutlen   = node->cur_pos - node->mark_pos ;
  } else {
    startpos = node->cur_pos ;
    cutlen   = node->mark_pos - node->cur_pos ;
  }
  /* ڤФ̣ʤä顢¨ȴ롣*/
  if( cutlen <= 0 )
    return 1 ;
  /* Ȼꤵ줿̤ȴФ*/
  myCharStrncpy( cutbuffer, node->textbuffer + startpos, cutlen ) ;
  MYCHAR_SET_END_OF_STRING( cutbuffer[ cutlen ] ) ;

  if( flag )
    /* ʹߤʸõ롣*/
    j_delete_region( node, startpos, startpos + cutlen ) ;
  return 0 ;
}

/*
 * ޡȥ֤ʸʸ򥫥åȥХåե
 * ¸ؿ
 */
int j_kill_region( struct SKKInputNode *node, struct myChar *cutbuffer )
{
  j_delete_kanaprefix( node ) ;
  return j_kill_region_sub( node, cutbuffer, True ) ;
}

/*
 * ȥޡ֤ʸ򥫥åȥХåե˼ؿϤ
 * ʤ
 */
int j_kill_ring_save( struct SKKInputNode *node, struct myChar *cutbuffer )
{
  j_delete_kanaprefix( node ) ;
  return j_kill_region_sub( node, cutbuffer, False ) ;
}

/*
 * ޡ֤ȥ֤򴹤ؿ
 *---
 * ޡ֤ʤ(ʸ󤬤ޤ̵)ˤϡˤä
 * ȤˤƤ롣tcsh Ǥ̵򴹤Ǥꤷƴ֤ NUL 
 * Ƴڤ
 */
int j_exchange_point_and_mark( struct SKKInputNode *node )
{
  int tmp, length ;
  j_delete_kanaprefix( node ) ;
  /* ޡꤵƤʤˤϸԲǽǤ롣*/
  if( node->mark_pos < 0 ){
    err_msg( node, "No mark set in this buffer" ) ;
    return 1 ;
  }
  /* ޡ֤ˤä硣*/
  length = myCharStrlen( node->textbuffer ) ;
  if( node->mark_pos > length ){
    node->mark_pos = length ;
  }
  tmp = node->cur_pos ;
  node->cur_pos  = node->mark_pos ;
  node->mark_pos = tmp ;
  return 0 ;
}

/*
 * ͤڤФؿ
 */
static struct myChar *j_skip_numeric_character
( struct myChar *ptr, struct myChar **j_num_list_top )
{
  struct myChar *j_num_list = *j_num_list_top ;

  /* ʸ󤬽üޤ³*/
  while( !IS_END_OF_STRING( *ptr ) ){
    switch( ptr->charset ){
    case CHARSET_JISX0208_1978 :
    case CHARSET_JISX0208_1983 :
      /* ɤΣХܤν*/
      if( ptr->chara < 0x2330 || ptr->chara > 0x2339 )
	goto exit_j_skip_numeric_character ;
      MYCHAR_SET_CHARA( *j_num_list, ptr->chara - 0x2330 + '0' ) ;
      j_num_list ++ ;
      ptr ++ ;
      break ;
    default :
      if( IS_ASCII_CHARA( *ptr ) &&
	  ptr->chara >= '0' && ptr->chara <= '9' ){
	/* 0  9 δ֤äġ*/
	*j_num_list ++ = *ptr ++ ;
	break ;
      }
      goto exit_j_skip_numeric_character ;
    }
  }
exit_j_skip_numeric_character:
  /* ɤޤѤƤ*/
  *j_num_list_top = j_num_list ;
  return ptr ;
}

static struct myChar *j_identity
( struct myChar *sptr, struct myChar *dptr, int dbufsize )
{
  while( !IS_END_OF_STRING( *sptr ) && !IS_ASCII_EQUAL( *sptr, '/' ) &&
	 dbufsize > 1 ){
    *dptr ++ = *sptr ++ ;
    dbufsize -- ;
  }
  /* üʸ뤿ˤ 1 ĤϻĤäƤʤȤʤ顣*/
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  return sptr ;
}

static struct myChar *j_zenkaku_num_str
( struct myChar *sptr, struct myChar *dptr, int dbufsize )
{
  while( !IS_END_OF_STRING( *sptr ) && !IS_ASCII_EQUAL( *sptr, '/' ) &&
	 dbufsize > 1 ){
    dptr->charset = CHARSET_JISX0208_1983 ;
    dptr->chara   = 0x2330 + ( sptr->chara - '0' ) ;
    dptr ++ ;
    sptr ++ ;
    dbufsize -- ;
  }
  /* üʸ뤿ˤ 1 ĤϻĤäƤʤȤʤ顣*/
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  return sptr ;
}

static struct myChar *j_kanji_num_str
( struct myChar *sptr, struct myChar *dptr, int dbufsize )
{
  while( !IS_END_OF_STRING( *sptr ) && !IS_ASCII_EQUAL( *sptr, '/' ) &&
	 dbufsize > 1 ){
    *dptr ++ = kanji_num_list[ sptr->chara - '0' ] ;
    sptr ++ ;
    dbufsize -- ;
  }
  /* üʸ뤿ˤ 1 ĤϻĤäƤʤȤʤ顣*/
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  return sptr ;
}

static struct myChar *j_kanji_num_str2
( struct myChar *sptr, struct myChar *dptr, int dbufsize )
{
  int len = 0, silent, num ;
  struct myChar *ptr ;

  /* ޤĹȽ̤롣*/
  while( !IS_END_OF_STRING( sptr[ len ] ) &&
	 !IS_ASCII_EQUAL( sptr[ len ], '/' ) )
    len ++ ;
  /* ƬɽʤΤ̵뤵ɡġ*/
  while( IS_ASCII_EQUAL( *sptr, '0' ) ){
    len -- ;
    sptr ++ ;
  }
  if( len == 0 ){
    if( dbufsize > 1 ){
      *dptr ++ = kanji_num_list[ 0 ] ;
      dbufsize -- ;
    }
  } else {
    num = ( ( len - 1 ) / 4 ) - 1 ;
    /* 礭᤮Ǥ */
    if( num >= 17 ){
      /* ʤǤ̵ͤ뤹롣*/
      while( !IS_ASCII_EQUAL( *sptr, '/' ) && !IS_END_OF_STRING( *sptr ) )
	sptr ++ ;
      goto exit_j_kanji_num_str2 ;
    }
    silent = True ;
    while( len > 0 ){
      if( sptr->chara > '1' ||
	  ( !IS_ASCII_EQUAL( *sptr, '0' ) &&
	    ( len % 4 ) == 1 ) ){
	if( dbufsize > 1 ){
	  *dptr ++ = kanji_num_list[ sptr->chara - '0' ] ;
	  dbufsize -- ;
	}
      }
      if( !IS_ASCII_EQUAL( *sptr, '0' ) ){
	/* ɴΰ̤˰ĤǤ⡻ǤʤΤСۤäƤ *
	 * ġǡۤäƤʤäƤΤϡȤȤɽ   *
	 * äựʤߤˡΰ̤λǤʤä顢Ȥ *
	 * ɽĤʤĤͤ*/
	if( len % 4 == 2 ){
	  if( dbufsize > 1 ){
	    MYCHAR_SET_JISX0208_1983( *dptr, 0x3d3d /*""*/ ) ;
	    dptr ++ ; dbufsize -- ;
	  }
	} else if( len % 4 == 3 ){
	  if( dbufsize > 1 ){
	    MYCHAR_SET_JISX0208_1983( *dptr, 0x4934 /*"ɴ"*/ ) ;
	    dptr ++ ; dbufsize -- ;
	  }
	} else if( len % 4 == 0 ){
	  if( dbufsize > 1 ){
	    MYCHAR_SET_JISX0208_1983( *dptr, 0x4069 /*""*/ ) ;
	    dptr ++ ; dbufsize -- ;
	  }
	}
	silent = False ;
      }
      if( !silent || !IS_ASCII_EQUAL( *sptr, '0' ) ){
	num = len - 1 ;
	if( num % 4 == 0 ){
	  num = num / 4 - 1 ;
	  /* ȤȤȤΤɽ롩 */
	  if( num >= 0 ){
	    /* ñ̤򥳥ԡ롣*/
	    ptr = kazu_no_tanni[ num ] ;
	    while( !IS_END_OF_STRING( *ptr ) && dbufsize > 1 ){
	      *dptr ++ = *ptr ++ ;
	      dbufsize -- ;
	    }
	    /* ɽۤ뤳Ȥˤ롣*/
	    silent = True ;
	  }
	}
      }
      len -- ;
      sptr ++ ;
    }
  }
exit_j_kanji_num_str2:
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  return sptr ;
}

static struct myChar *j_shogi_num_str
( struct myChar *sptr, struct myChar *dptr, int dbufsize )
{
  /* ʸܤϱѿʤɡġ*/
  if( !IS_ASCII_EQUAL( *sptr, '/' ) && !IS_END_OF_STRING( *sptr ) && 
      dbufsize > 1 ){
    dptr->charset = CHARSET_JISX0208_1983 ;
    dptr->chara   = 0x2330 + ( sptr->chara - '0' ) ;
    dptr ++ ;
    dbufsize -- ;
    MYCHAR_SET_END_OF_STRING( *dptr ) ;
    sptr ++ ;
  } else {
    MYCHAR_SET_END_OF_STRING( *dptr ) ;
    return sptr ;
  }
  /* ʸܤϴˤʤ롣*/
  if( !IS_ASCII_EQUAL( *sptr, '/' ) && !IS_END_OF_STRING( *sptr ) && 
      dbufsize > 1 ){
    *dptr ++ = kanji_num_list[ sptr->chara - '0' ] ;
    dbufsize -- ;
    MYCHAR_SET_END_OF_STRING( *dptr ) ;
    sptr ++ ;
  } else {
    MYCHAR_SET_END_OF_STRING( *dptr ) ;
    return sptr ;
  }
  /* ڤʸޤʤ롣*/
  while( !IS_ASCII_EQUAL( *sptr, '/' ) && !IS_END_OF_STRING( *sptr ) )
    sptr ++ ;
  return sptr ;
}

/*
 * # Ÿؿ
 *---
 * dbufsize  dptr ̤Ǥ̥Ф򤱤뤿ˤ餫Ϥ
 * Ƥޤ skkinput ǤĹʸԽǤʤȤ
 * Ƥޤeditor ʤΤ 
 * (Japanese-Input-Method-Editor Ȥ Windows'95 Ǥϸ餷Ǥ
 * ) ǤĹԽǽɬפϤʤȻפޤɤ͡
 */
static struct myChar *j_num_exp
( struct myChar *j_num_list_ptr, int type, struct myChar *dptr,
  int dbufsize )
{
  switch( type ){
  case '0' :
    return j_identity( j_num_list_ptr, dptr, dbufsize ) ;
  case '1' :
    return j_zenkaku_num_str( j_num_list_ptr, dptr, dbufsize ) ;
  case '2' :
    return j_kanji_num_str( j_num_list_ptr, dptr, dbufsize ) ;
  case '3' :
    return j_kanji_num_str2( j_num_list_ptr, dptr, dbufsize ) ;
  case '9' :
    return j_shogi_num_str( j_num_list_ptr, dptr, dbufsize ) ;
  default:
    break ;
  }
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  return j_num_list_ptr ;
}

/*
 * dbufsize  dptr ̤Ǥ
 */
static int j_numeric_convert
( struct SKKInputNode *node,
  struct myChar *sptr, struct myChar *dptr, int dbufsize )
{
  struct myChar *nptr = node->j_num_list ;

  while( !IS_END_OF_STRING( *sptr ) ){
    if( IS_ASCII_EQUAL( *sptr, '#' ) ){
      sptr ++ ;
      /* # Ÿ롣*/
      nptr = j_num_exp( nptr, sptr->chara, dptr, dbufsize ) ;
      /* դ­줿ʸΰֺǸؤȰư롣*/
      while( !IS_END_OF_STRING( *dptr ) ){
	dptr ++ ;
	dbufsize -- ;
      }
      /* ڤʸФ*/
      if( IS_ASCII_EQUAL( *nptr, '/' ) )
	nptr ++ ;
      sptr ++ ;
    } else {
      *dptr ++ = *sptr ++ ;
      dbufsize -- ;
    }
  }
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  return 0 ;
}

/*
 * ѴʸѴפοڤФ "#" ֤
 * ؿ
 */
static int j_compute_numeric_henkan_key
( struct myChar *dptr, struct myChar *sptr, struct myChar *j_num_list ) 
{
  while( !IS_END_OF_STRING( *sptr ) ){
    /* ɤβХܤȽǤ롣*/
    switch( sptr->charset ){
    case CHARSET_JISX0208_1978 :
    case CHARSET_JISX0208_1983 :
      if( sptr->chara >= 0x2330 && sptr->chara <= 0x2339 ){
	/* 饯 0  9 δ֤ä */
	MYCHAR_SET_CHARA( *dptr, '#' ) ;
	dptr ++ ;
	MYCHAR_SET_CHARA( *j_num_list, sptr->chara - 0x2330 + '\0' ) ;
	j_num_list ++ ;
	/* ³¤ꥹåפ롣*/
	sptr = j_skip_numeric_character( sptr, &j_num_list ) ;
	/* ڤ국Ƥ*/
	MYCHAR_SET_CHARA( *j_num_list, '/' ) ;
	j_num_list ++ ;
      } else {
	*dptr ++ = *sptr ++ ;
      }
      break ;
#if 0
    case CHARSET_ASCII :
    case CHARSET_JISX0201_ROMAN :
    case CHARSET_JISX0201_KATAKANA :
    case CHARSET_JISX0212_1990 :
#endif
    default :
      if( IS_ASCII_CHARA( *sptr ) &&
	  sptr->chara >= '0' && sptr->chara <= '9' ){
	/* 饯 0  9 δ֤ä */
	MYCHAR_SET_CHARA( *dptr, '#' ) ;
	dptr ++ ;
	sptr = j_skip_numeric_character( sptr, &j_num_list ) ;
	/* ڤ국Ƥ*/
	MYCHAR_SET_CHARA( *j_num_list, '/' ) ;
	j_num_list ++ ;
      } else {
	*dptr ++ = *sptr ++ ;
      }
      break ;
    }
  }
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  MYCHAR_SET_END_OF_STRING( *j_num_list ) ;
  return 0 ;
}

/*
 * ֤ͤᤷʸؿ
 */
static int j_insert_word
( struct SKKInputNode *node, int pos, struct myChar *word )
{
  struct myChar buffer[ TEXTBUFSIZE ] ;
  /*    struct myChar note[ TEXTBUFSIZE ] ; */
  struct myChar *tmp ;
  int len ;

  if( !IS_END_OF_STRING( node->j_num_list[ 0 ] ) &&
      skkinput_use_numeric_conversion ){
    j_numeric_convert( node, word, buffer, TEXTBUFSIZE ) ;
    word = buffer ;
  }
  len  = myCharStrlen( word ) ;

  /* ʸ򡢸ʬ򤹤롣*/
  if (len > 2){
    for( tmp = word ; !IS_END_OF_STRING( *tmp ) ; tmp ++ ){
      if( IS_ASCII_CHARA( *tmp ) && IS_ASCII_EQUAL(*tmp, ';')){
	/*        myCharStrcpy(note, tmp + 1); */
	  MYCHAR_SET_END_OF_STRING(*tmp) ;
	  len  = myCharStrlen( word ) ;
	  break;
      }
    }
  }

  if( IS_ASCII_EQUAL( word[ 0 ], '('  ) &&
      IS_ASCII_EQUAL( word[ len - 1 ], ')' ) ){
    /*
     * 󡣲¹ԤäƤʤ櫓ʤɤ͡ġ
     */
    if( skkinputlisp_eval( word, buffer ) ){
      word = buffer ;
    }
  }
  if( !node->j_katakana_mode ){
    /* ʿ̾Ҳ̾θ򴹤Ϥʤ*/
    j_insert_str( node, pos, word ) ;
  } else {
    struct myChar katakana_buffer[ TEXTBUFSIZE ] ;
    /* ʿ̾Ҳ̾θ򴹤򤹤롣*/
    len = myCharHiraKataStrnncpy
      ( katakana_buffer, TEXTMAXLEN, word, TEXTMAXLEN ) ;
    MYCHAR_SET_END_OF_STRING( katakana_buffer[ len ] ) ;
    /* 򴹤줿ʸ롣*/
    j_insert_str( node, pos, katakana_buffer ) ;
  }
  return 0 ;
}

/*
 * Ϳ줿ɸʹ˰ñưȲޤǹԤΤ׻
 * ؿ
 * ֤ͤɤƤʴؿɬפʤΡ ꤵ
 * ֤ upcase-word  downcase-word, capitalize-word ˤ
 *   
 * ֤ա󡣤ʤܥʬä衪
 */
static int j_calc_forward_word( struct SKKInputNode *node, int pos )
{
  /* ư롣*/
  if( !MYCHAR_IS_ALPHABETIC( node->textbuffer[ pos ] ) ) {
    /* ե٥åȤʤ֤Ϥ󤺤ʤࡣ*/
    while( !IS_END_OF_STRING( node->textbuffer[ pos ] ) &&
	   !MYCHAR_IS_ALPHABETIC( node->textbuffer[ pos ] ) )
      pos ++ ;
  }
  /* ⤦ʾ奫ϰưǤʤΤǽλ롣*/
  if( IS_END_OF_STRING( node->textbuffer[ pos ] ) )
    return pos ;
  /* ե٥åȤδ֤Ϥ󤺤ʤࡣ*/
  while( !IS_END_OF_STRING( node->textbuffer[ pos ] ) &&
	 MYCHAR_IS_ALPHABETIC( node->textbuffer[ pos ] ) ){
    pos ++ ;
  }
  return pos ;
}

/*
 * ñưؿ
 */
int j_forward_word( struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  /* ư롣*/
  node->cur_pos = j_calc_forward_word( node, node->cur_pos ) ;
  return 0 ;
}

/*
 * ñʸѴ{/ʸѴ/ԥ饤}ؿ
 */
int j_caseword( struct SKKInputNode *node, int pattern )
{
  int pos ;
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;

  /* ߤΥ֤ФƤ*/
  pos = node->cur_pos ;
  /* ޤǥϰưΤʡ */
  node->cur_pos = j_calc_forward_word( node, pos ) ;

  /* 뤬ưǤʤäȤȤϡϹ顢*
   * ʸѴʤȤʤʸˤʤȤȤˤʤ*/
  if( pos < node->cur_pos ){ 
    if( pattern == 'c' ){
      /* capitilaize ξ硣*/
      while( pos < node->cur_pos ){
	/* ֺǽ˸դäե٥åȤʸѴơ *
	 * ʹߤϾʸѴ롣*/
	if( MYCHAR_IS_LOWERCASE( node->textbuffer[ pos ] ) ){
	  node->textbuffer[ pos ].chara += ( 'A' - 'a' ) ;
	  pos ++ ;
	  break ;
	}
	/* ֺǽ˸դäե٥åȤʸʤѴ */
	if( MYCHAR_IS_UPPERCASE( node->textbuffer[ pos ] ) ){
	  pos ++ ;
	  break ;
	}
	pos ++ ;
      }
      /*  downcase ξƱˤʤ롣*/
      pattern = 'd' ;
    }
    while( pos < node->cur_pos ){ 
      /* ʸѴ롣*/
      if( MYCHAR_IS_LOWERCASE( node->textbuffer[ pos ] ) &&
	  pattern == 'u' ){
	node->textbuffer[ pos ].chara += ( 'A' - 'a' ) ;
      } else if( MYCHAR_IS_UPPERCASE( node->textbuffer[ pos ] ) &&
		 pattern == 'd' ){
	node->textbuffer[ pos ].chara += ( 'a' - 'A' ) ;
      }
      pos ++ ;
    }
  }
  return 0 ;
}

/*
 * ñưؿ
 */
int j_backward_word( struct SKKInputNode *node )
{
  /* ̾ʤˤƤޤ*/
  j_delete_kanaprefix( node ) ;
  /* ֤ */
  if( node->cur_pos <= node->cur_pos_top )
    return 1 ;
  /* ʬ߸Ƥϸʤ*/
  node->cur_pos -- ;
  /* ư롣*/
  if( !MYCHAR_IS_ALPHABETIC( node->textbuffer[ node->cur_pos ] ) ) {
    /* ե٥åȤʤ֤Ϥ󤺤ʤࡣ*/
    while( node->cur_pos > node->cur_pos_top &&
	   !MYCHAR_IS_ALPHABETIC( node->textbuffer[ node->cur_pos ] ) ){
      /* ʸ˰ư롣*/
      node->cur_pos -- ;
    }
  }
  /* ⤦ʾ奫ϰưǤʤΤǽλ롣*/
  if( node->cur_pos == node->cur_pos_top )
    return 0 ;
  /* ե٥åȤδ֤Ϥ󤺤ʤࡣ*/
  while( node->cur_pos >= node->cur_pos_top &&
	 MYCHAR_IS_ALPHABETIC( node->textbuffer[ node->cur_pos ] ) ){
    /* ʸ˰ư롣*/
    node->cur_pos -- ;
  }
  node->cur_pos ++ ;
  return 0 ;
}

/*
 * Τޤ޼ϿƤޤȤޤãѴؿ
 *----
 * Υ֤ɡ
 */
static int j_quote_char_sub( struct myChar *word )
{
  struct myChar *dptr, *sptr ;
  int bufsize ;
  /* Τޤ¸ߤޤã󤷤Ƥ롣*/
  struct chara_string_pair conv_pattern[] = {
    { '\r', "\\r"   }, { '\n', "\\n"   }, { '/',  "\\057" },
    { '\\', "\\\\"  }, { '[',  "\["    }, { '\"', "\\\""  },
    { '\0', NULL    },
  } ;
  struct chara_string_pair *cptr ;

  /* ޤϤޤʤѰդ롣*/
  myCharCharStrcpy( temporary_buffer, "(concat \"" ) ;
  bufsize = myCharStrlen( temporary_buffer ) ;
  dptr = temporary_buffer + bufsize ;
  sptr = word ;
  bufsize = TEXTMAXLEN - bufsize - 2 ;

  /* Ѵ롼ס*/
  while( !IS_END_OF_STRING( *sptr ) && bufsize > 0 ){
    /* ASCII ʸξˤ̣Ȥǽ롣*/
    if( IS_ASCII_CHARA( *sptr ) ){
      /* ̣ΥꥹȤʤ롣*/
      cptr = conv_pattern ;
      while( cptr->chara != '\0' ){
	if( sptr->chara == cptr->chara ){
	  int tmplen = strlen( cptr->string ) ;
	  if( bufsize < tmplen )
	    goto exit_j_quote_sub ;
	  myCharCharStrcpy( dptr, cptr->string ) ;
	  dptr += tmplen ;
	  bufsize -= tmplen ;
	  sptr ++ ;
	  break ;
	}
	cptr ++ ;
      }
      if( cptr->chara != '\0' )
	continue ;
    }
    /* ȡˤҥåȤʤäĤޤ꽤פä硣*/
    *dptr ++ = *sptr ++ ;
    bufsize -- ;
  }
 exit_j_quote_sub:
  /* ǸĤƤνʸ뤿 -2 ʤƤΤ *
   * Ƥ櫓*/
  MYCHAR_SET_CHARA( *dptr, '\"' ) ;
  dptr ++ ;
  MYCHAR_SET_CHARA( *dptr, ')' ) ;
  dptr ++ ;
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  /* Ǹ˽ʸ֤*/
  myCharStrcpy( word, temporary_buffer ) ;
  return True ;
}

/*
 * Τޤ޼ϿƤޤȤޤãѴؿ
 *----
 * () temporary_buffer Ѥ롣
 */
static int j_quote_char( struct myChar *word )
{
  struct myChar *ptr, *tmp ;
  int len;
  /* ȡlisp ̿äˤϽʤǤ⡢skkinput  *
   * Ǥ lisp ̿äƾʤġ*/
  len = myCharStrlen( word ) ;
  if( len > 2 && IS_ASCII_EQUAL( word[ 0 ], '(' ) &&
      MYCHAR_IS_ALPHABETIC( word[ 1 ] ) &&
      IS_ASCII_EQUAL( word[ len - 1 ], ')' ) ){
    return False ;
  }
  /*  դΤȤ⽤ʤ*/
  if (len > 2){
    for( tmp = word ; !IS_END_OF_STRING( *tmp ) ; tmp ++ ){
      if( IS_ASCII_CHARA( *tmp ) && IS_ASCII_EQUAL(*tmp, ';'))
	return False;
      }
  }

  /* ˽ʤȤʤʸäƤ뤫ɤå롣*/
  for( ptr = word ; !IS_END_OF_STRING( *ptr ) ; ptr ++ ){
    if( IS_ASCII_CHARA( *ptr ) ){
      switch( ptr->chara ){
      case '/' :
      case '\n' :
      case '\r' :
      case '\\' :
      case '[' :
      case ']' :
	return j_quote_char_sub( word ) ;
      default :
	break ;
      }
    }
  }
  return False ;
}

/*
 * ǤʤߥѴؿ
 */
static int j_quote_semicolon( struct myChar *word )
{
  struct myChar *dptr, *sptr ;
  int bufsize ;
  /* Τޤ¸ߤޤã󤷤Ƥ롣*/
  struct chara_string_pair conv_pattern[] = {
    { ';',  "\\073" },
    { '\r', "\\r"   }, { '\n', "\\n"   }, { '/',  "\\057" },
    { '\\', "\\\\"  }, { '[',  "\["    }, { '\"', "\\\""  },
    { '\0', NULL    },
  } ;
  struct chara_string_pair *cptr ;

  /* ޤϤޤʤѰդ롣*/
  myCharCharStrcpy( temporary_buffer, "(concat \"" ) ;
  bufsize = myCharStrlen( temporary_buffer ) ;
  dptr = temporary_buffer + bufsize ;
  sptr = word ;
  bufsize = TEXTMAXLEN - bufsize - 2 ;

  /* Ѵ롼ס*/
  while( !IS_END_OF_STRING( *sptr ) && bufsize > 0 ){
    /* ASCII ʸξˤ̣Ȥǽ롣*/
    if( IS_ASCII_CHARA( *sptr ) ){
      /* ̣ΥꥹȤʤ롣*/
      cptr = conv_pattern ;
      while( cptr->chara != '\0' ){
	if( sptr->chara == cptr->chara ){
	  int tmplen = strlen( cptr->string ) ;
	  if( bufsize < tmplen )
	    goto exit_j_quote_sub ;
	  myCharCharStrcpy( dptr, cptr->string ) ;
	  dptr += tmplen ;
	  bufsize -= tmplen ;
	  sptr ++ ;
	  break ;
	}
	cptr ++ ;
      }
      if( cptr->chara != '\0' )
	continue ;
    }
    /* ȡˤҥåȤʤäĤޤ꽤פä硣*/
    *dptr ++ = *sptr ++ ;
    bufsize -- ;
  }
 exit_j_quote_sub:
  /* ǸĤƤνʸ뤿 -2 ʤƤΤ *
   * Ƥ櫓*/
  MYCHAR_SET_CHARA( *dptr, '\"' ) ;
  dptr ++ ;
  MYCHAR_SET_CHARA( *dptr, ')' ) ;
  dptr ++ ;
  MYCHAR_SET_END_OF_STRING( *dptr ) ;
  /* Ǹ˽ʸ֤*/
  myCharStrcpy( word, temporary_buffer ) ;
  return True ;
}

/*
 * 󥰥Хåե¤ʸǼؿ
 *----
 * Х롩
 */
static int save_ringbuffer
( struct myChar *buffer, int bufsize, int *startpos, int *endpos,
  struct myChar *string )
{
  int spos, overrightflag ;
  struct myChar *ptr ;

  /* ʸäꡢƬԥɤäꤷˤϿʤ*/
  if( IS_ASCII_EQUAL( string[ 0 ], '\n' ) ||
      IS_ASCII_EQUAL( string[ 0 ], '\r' ) ||
      IS_END_OF_STRING( string[ 0 ] ) )
    return 0 ;
  /*  ring buffer ؤ save */
  spos          = *endpos ;
  ptr           = buffer + spos ;
  overrightflag = False ;
  do {
    /* ʸ ring buffer ؤȤ롣*/
    *ptr ++ = *string ++ ;
    spos ++ ;
    /* ХåեκǸޤãƤޤäƬ᤹*/
    if( spos >= bufsize ){
      spos = 0 ;
      ptr  = buffer ;
    }
    if( spos == *startpos )
      overrightflag = True ;
  } while( !IS_END_OF_STRING( *string ) ) ;

  /* NUL μؤ롣*/
  spos ++ ;
  MYCHAR_SET_END_OF_STRING( *ptr ) ;
  ptr ++ ;
  if( spos >= bufsize ){
    spos = 0 ;
    ptr  = buffer ;
  }

  /* Ͽä񤭤Ƥޤä */
  *endpos = spos ;
  if( overrightflag ){
    /* 괺ߤΰ֤ϼθ䤬Ͽˤʤ롣*/
    /* θγϰ֤ޤǥåפ롣*/
    do {
      MYCHAR_SET_END_OF_STRING( *ptr ) ;
      ptr ++ ;
      spos ++ ;
      /* ХåեκǸޤãƤޤäƬ᤹*/
      if( spos >= bufsize ){
	spos = 0 ;
	ptr  = buffer ;
      }
    } while( !IS_END_OF_STRING( *ptr ) ) ;
    /* '\0' μ餬*/
    *startpos = spos ;
  }
  return 0 ;
}

/*
 * ץ꡼λؿ
 *---------
 * ץ꡼ǽ˹ԤäꥹȤԤä
 * 롣
 */
void j_completion_close
( struct SKKInputNode *node )
{
  /* Ѥ줿⤷ʤץ꡼ξϼΤƤ롣*/
  free_VectorIndex( &node->j_completion_vector_index_top ) ;
  free_SkkinpSearchVector( &node->j_completion_vector_top ) ;

  node->j_completion_vector_top           = NULL ;
  node->j_completion_vector_index_top     = NULL ;
  node->j_current_completion_vector_index = NULL ;
  node->j_completion_mode                 = False ;
  return ;
}

/*
 * ѹ()ե饰äؿ
 *----
 * ¹Ԥ뤳Ȥˤꡢȥ֤Ԥʤʤ롣
 */
void j_clear_modified_flag( void )
{
  skkinput_jisyo_dirty          = False ;
  skkinput_autosave_jisyo_dirty = False ;
  return ;
}

/*
 * ϤѴ饤Ȥ֤ؿ
 */
void j_sendback_keypress( Widget gw, XEvent *xevent )
{
  Window to_window, subwindow ;

  /* ࡩ ΤФƤġ*/
  to_window = xevent->xkey.window ;
  subwindow = xevent->xkey.subwindow ;
  /* ٥Ȥ򤯤äĤϤ*/
  XtCallCallbacks( gw, XtNkeybackNotify, xevent ) ;
  /* ᤷƤ롣*/
  xevent->xkey.window    = to_window ;
  xevent->xkey.subwindow = subwindow ;
  return ;
}

void j_mode_off_and_self_insert
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, int chara )
{
  j_mode_off( gw, sbuffer, node, chara ) ;
  j_self_insert( gw, sbuffer, node, chara ) ;
  return ;
}

/*
 * "oh" ΥåԤΤѤؿ
 */
void j_oh_check_with_controlcode
( struct SKKInputNode *node, int keyboard_quit_p )
{
  struct myChar lchara ;

  /* ̾ϤǤʤа̣ʤ*/
  if( !node->j_kana_mode )
    return ;

  if( !IS_ASCII_EQUAL( node->j_prefix[ 0 ], 'o' ) )
    return ;

  /* Ϥ줿Τ "o" äν*/
  if( IS_END_OF_STRING( node->j_prefix[ 1 ] ) ){
    MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
    node->j_kana_mode = False ;
    node->j_kana_start_point = -1 ;
    return ;
  }
  /* oh ϤǤʤطʤΤ̵뤹롣*/
  if( !IS_ASCII_EQUAL( node->j_prefix[ 1 ], 'h' ) ||
      !IS_END_OF_STRING( node->j_prefix[ 2 ] ) ||
      keyboard_quit_p )
    return ;

  /* ץեʸä롣*/
  MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;
  /* ̾γϰ֤ "h" ǤʤФ*/
  if( IS_ASCII_EQUAL
      ( node->textbuffer[ node->j_kana_start_point ], 'h' ) ){
    delete_char( node, node->j_kana_start_point, 1 ) ;
    /* "" 롣*/
    if( node->j_katakana_mode ){
      MYCHAR_SET_JISX0208_1983( lchara, 0x252a /*""*/ ) ;
    } else {
      MYCHAR_SET_JISX0208_1983( lchara, 0x242a /*""*/ ) ;
    }
    j_insert_myChara( node, node->j_kana_start_point, lchara ) ;
  }
  /* "h" ϤǤȤֲ̾⡼ɡפߤ롣*/
  node->j_kana_mode = False ;
  return ;
}

/*
 * ġġġġġĤʤȤɤǤͤ⤤Ȥϡġġġ
 * ٤ʤޤɡǤȤա
 * 
 * http://www2m.meshnet.or.jp/~maina/part3/wakaba/birth0.htm
 * ܺ٤ϡ嵭 url 򻲾ȤΤȡ(^^) äȤɤʤŤ
 * ɡ
 */
