/* # skkinput (Simple Kana-Kanji Input)
 * skkmbuf.c --- mini-buffer
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/ShellP.h>

#include "commondef.h"
#include "buffers.h"
#include "skkbuf.h"
#include "skkel.h"
#include "SeparateWin.h"
#include "OverWin.h"

/* skkmarker.c */
extern void markers_init( struct SKKInputNode *node ) ;
extern int make_marker
( struct SKKInputNode *node, int *marker, int flag ) ;
/* skkel.c */
extern void j_completion_close
( struct SKKInputNode *node ) ;
/* skksvect.c */
extern void free_VectorIndex( VectorIndex **top ) ;
extern void free_SkkinpSearchVector( SkkinpSearchVector **top ) ;

/*
 * skkinput β̾Ѵ˴ؤʬˤĤƤνԤؿ
 *-----
 * ֤νȤ¾
 */
static void skkinput_SkkInputNodeInit( struct SKKInputNode *node )
{
  /* ޡ()롣ޡ emacs-lisp Υޡμ *
   * Ǥ롣˲Ǥ뤬ġ*/
  markers_init( node ) ;

  /* ̾ѴǤΥХѿν*/
  node->cur_pos            = 0 ;
  node->cur_pos2           = 0 ;
  node->cur_pos3           = 0 ;
  node->cur_pos4           = 0 ;
  node->cur_pos_backup     = 0 ;
  node->cur_pos_top        = 0 ;
  make_marker( node, &( node->cur_pos ), 1 ) ;
  make_marker( node, &( node->cur_pos2 ), 1 ) ;
  make_marker( node, &( node->cur_pos3 ), 1 ) ;
  make_marker( node, &( node->cur_pos4 ), 1 ) ;
  make_marker( node, &( node->cur_pos_backup ), 1 ) ;
  node->j_henkan_mode      = False ;
  node->j_henkan_on        = False ;
  node->j_okurigana_mode   = False ;
  node->j_kana_mode        = False ;
  node->j_katakana_mode    = False ;
  node->j_mode             = True ;
  node->j_abbrev           = False ;
  node->j_zenkaku          = False ;
  node->j_henkan_show_candidate_mode = False ;
  node->j_input_by_code_or_menu_mode = False ;
  node->j_minibuff_usage   = J_MINIBUFF_NOT_USING ;

  MYCHAR_SET_END_OF_STRING( node->textbuffer[ 0 ] ) ;
  MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
  MYCHAR_SET_END_OF_STRING( node->j_num_list[ 0 ] ) ;
  MYCHAR_SET_END_OF_STRING( node->j_prefix[ 0 ] ) ;

  node->j_okurigana_start_point = -1 ;
  make_marker( node, &( node->j_okurigana_start_point ), 0 ) ;
  node->j_kana_start_point      = -1 ;
  make_marker( node, &( node->j_kana_start_point ), 0 ) ;
  node->j_henkan_start_point    = -1 ;
  make_marker( node, &( node->j_henkan_start_point ), 0 ) ;
  node->j_henkan_end_point      = -1 ;
  make_marker( node, &( node->j_henkan_end_point ), 0 ) ;
  node->j_input_by_code_or_menu_point = -1 ;
  make_marker( node, &( node->j_input_by_code_or_menu_point ), 0 ) ;

  /* 桼ͳǤޡν*/
  node->mark_pos           = -1 ;
  make_marker( node, &( node->mark_pos ), 0 ) ;

  node->j_henkan_vector_top               = NULL ;
  node->j_henkan_vector_index_top         = NULL ;
  node->j_current_henkan_vector_index     = NULL ;
  node->j_henkan_vector_index_length      = 0 ;

  node->j_completion_vector_top           = NULL ;
  node->j_completion_vector_index_top     = NULL ;
  node->j_current_completion_vector_index = NULL ;
  node->j_completion_mode                 = False ;

  node->prev_cx = node->prev_cy = -1 ;
  node->prev_start_pos     = 0 ;

  return ;
}

/*
 * minibuffer ѤΥΡɤ򿷤ݤؿ
 */
struct SKKInputNode *skkinput_AllocateMinibuffer( void )
{
  struct SKKInputNode *node ;

  node = ( struct SKKInputNode *)malloc( sizeof( struct SKKInputNode ) ) ;
  if( node == NULL ){
    fprintf( stderr, "Fatal error .... Memory exhausted.\n" ) ;
    exit( 1 ) ;
  }
  node->parentbuffer = NULL ;
  node->minibuffer   = NULL ;
  skkinput_SkkInputNodeInit( node ) ;
  return node ;
}

/*
 * mini-buffer ؿ
 */
void free_Minibuffer
( Widget gw, struct skkinputBuffer *buffer, struct SKKInputNode *node )
{
  if( node->parentbuffer != NULL ){
    /* ƤλҶϼʬλҶ*/
    ( node->parentbuffer )->minibuffer = node->minibuffer ;
  } else {
    /* ֺǽ˻ؤ褦ˤʤФʤʤΤǡƬ *
     * 줿齤*/
    buffer->topbuffer = node->minibuffer ;
  }
  /* ꤨʤȻפɡʬ˻Ҷä顢λҶοƤϼʬ *
   * οơ*/
  if( node->minibuffer != NULL ){
    ( node->minibuffer )->parentbuffer = node->parentbuffer ;
    /* ΥΡɤֻҶʤΤ顢w->skkinput.lastbuffer  *
     * ɬפϤʤ*/
  } else {
    /* ֺǸ˻ؤ褦ˤƤ*/
    buffer->lastbuffer = node->parentbuffer ;
  }
  /* ѴλƽФ*/
  free_VectorIndex( &( node->j_henkan_vector_index_top ) ) ;
  free_SkkinpSearchVector( &( node->j_henkan_vector_top ) ) ;
  node->j_current_henkan_vector_index = NULL ;
  /* ץ꡼Ǥäʤ顢Υ롣*/
  j_completion_close( node ) ;
  /* ʬ롣*/
  free( node ) ;
}

/*
 * ߥ˥Хåե̵Ǥβ̾ѴԤνԤؿ
 */
int skkinput_j_henkan_in_minibuff_init
( Widget gw, struct skkinputBuffer *sbuffer, struct SKKInputNode *node )
{
  struct SKKInputNode *mNode ;

#ifdef DEBUG
  /* Ϥ줿Хåե˥뤬̵⤷ϡ˴ѴѤ *
   * ߥ˥ХåեĤΤѤǤ롣äƤϤʤʤ֤Ǥ */
  if( !node->cur_exist || node->minibuffer != NULL ){
    fprintf( stderr, "*** Warning *** : I miss your cursor.\n" ) ;
    return ERR ;
  }
#endif
  /* Хåեݤ롣*/
  mNode = skkinput_AllocateMinibuffer() ;
  mNode->parentbuffer = node ;
  node->minibuffer = sbuffer->lastbuffer = mNode ;

  /* Хåեդʤ褦˥򥳥ԡ롣*/
  if( !IS_END_OF_STRING( node->j_num_list[ 0 ] ) ){
    myCharStrncpy
      ( mNode->textbuffer, node->j_search_key, TEXTMAXLEN - 1 ) ;
  } else {
    myCharStrncpy
      ( mNode->textbuffer, node->j_henkan_key2, TEXTMAXLEN - 1 ) ;
  }
  MYCHAR_SET_END_OF_STRING( mNode->textbuffer[ TEXTMAXLEN - 1 ] ) ;
  myCharCharStrcat( mNode->textbuffer, " " ) ;
  MYCHAR_SET_END_OF_STRING( mNode->textbuffer[ TEXTMAXLEN ] ) ;

  /* ֵڤӥκǾ֤ꡣ*/
  mNode->cur_pos_top = mNode->cur_pos = myCharStrlen( mNode->textbuffer ) ;

  /* Хåե֤ǤΥư*/
  node->cur_exist  = False ;
  mNode->cur_exist = True ;
  /*  j-read-string ȶ̤ΤɬסƤФ action 㤦*/
  mNode->j_minibuff_usage = J_HENKAN_IN_MINIBUFF_MODE ;

  /* ߥ˥Хåե˰ɽƤΤõ롣*/
  XtVaSetValues( gw, XtNclearMinibuffer, True, NULL ) ;
  return 0 ;
}

/*
 * minibuffer ʸϤؿ
 *---------
 * ʸϤλȡδؿ longjmp äƤΤǤλ
 *  True ֤뤫ƽФ¦ʸϤλΤʬ롣
 * Ϥ줿ʸ temporary_buffer ˰Ū¸Τǡ
 * ƤĵŪ®䤫˻ȤäƤޤ̤ΤȤ¸ޤ礦
 */
int j_read_string
( Widget gw, struct skkinputBuffer *sbuffer,
  struct SKKInputNode *node, unsigned char *string, int minibuff_usage )
{
  struct SKKInputNode *mNode ;
  int length = strlen( string ) ;

#ifdef DEBUG
  /* Ϥ줿Хåե˥뤬̵⤷ϡ˴ѴѤ *
   * ߥ˥ХåեĤΤѤǤ롣äƤϤʤʤ֤Ǥ */
  if( !node->cur_exist || node->minibuffer != NULL ){
    fprintf( stderr, "*** Warning *** : I miss your cursor.\n" ) ;
    return ERR ;
  }
#endif
  /* Хåեݤ롣*/
  mNode = skkinput_AllocateMinibuffer() ;
  mNode->parentbuffer = node ;
  node->minibuffer = sbuffer->lastbuffer = mNode ;

  /* Хåեդʤ褦˥򥳥ԡ롣*/
  if( length > TEXTMAXLEN )
    length = TEXTMAXLEN ;
  myCharCharStrncpy( mNode->textbuffer, string, length ) ;
  MYCHAR_SET_END_OF_STRING( mNode->textbuffer[ length ] ) ;

  /* ֵڤӥκǾ֤ꡣ*/
  mNode->cur_pos_top = mNode->cur_pos = myCharStrlen( mNode->textbuffer ) ;

  /* Хåե֤ǤΥư*/
  node->cur_exist  = False ;
  mNode->cur_exist = True ;
  mNode->j_minibuff_usage = minibuff_usage ;

  /* Υ⡼ɤǤϡ̾ϥ⡼ɤϥǥեȤǥա*/
  mNode->j_mode = False ;

  /* ߥ˥Хåե˰ɽƤΤõ롣*/
  XtVaSetValues( gw, XtNclearMinibuffer, True, NULL ) ;
  return 0 ;
}					
