#!/bin/sh
#
# Attatch patch for ptex-src-3.1.10 under TeX Live 2008.
#

echo ${PATCH:=patch} > /dev/null
echo ${CP:=cp -fp}   > /dev/null
echo ${RM:=rm -f}    > /dev/null
echo ${MV:=mv -f}    > /dev/null

## check

if test ! -d kpathsea; then
    cat <<-EOF

	This script should be executed under 'texk'.
	Excute as following.

	  cd /your/path/to/texk
	  ./ptexenc/patches/texlive2007.sh

EOF
    exit 1
fi

if grep "2008 TeX Users Group" ../README > /dev/null; then
    echo "dummy" > /dev/null
else
    echo "This is for TeX Live 2008."
    exit 1
fi

## for ptex

$PATCH -p1 -d web2c/ptexdir < ptexenc/patches/ptex-src-3.1.10-ptexenc.patch || exit

(cd web2c/ptexdir
$RM Makefile.in  ptexextra.c  version.c  mkconf  pconvert
$CP ../lib/openclose.c .
$CP ../lib/printversion.c .
$MV kanji.defines ptex.defines
$MV ptexextra.h ptexextra.in
$MV pltotf.ch ppltotf.ch
$MV tftopl.ch ptftopl.ch
)

$PATCH -p1 -d .. < ptexenc/patches/ptex-src-3.1.10-texlive2008.patch || exit
