#!/bin/sh
#
# ptetex3 -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

echo "------------------------------------------------------------------------"
if env | grep "^TEX" | egrep -v "^(TEXINPUTS=|TEXDOCVIEW)"; then
    echo ""
    echo "Those variables may make unexpected effect. Please unset."
    echo ""
    exit 1
fi

for f in "$HOME/texmf" "$HOME/.texmf-var" "$HOME/.texmf-config"; do
    if test -d "$f"; then
	echo ""
	echo "Personal texmf tree '$f' may make unexpected effect."
	echo "Please rename."
	echo ""
	exit 1
    fi
done

PRINT_MY_OPTION=yes
. ./common.sh
root_check

MKTEMP=`mktemp ptetex-tmp.XXXXXX`
if test $? -ne 0; then
    echo ""
    echo "We need 'mktemp' command when we apply security/tetex-3.0-badscript.patch in 2extract-src.sh."
    echo "Please visit http://www.mktemp.org/mktemp/."
    echo ""
    exit 1
fi
$RM $MKTEMP

uname -a
cat <<EOF

JAPANESE="$JAPANESE"
KANJI_CODE="$KANJI_CODE"
PLATEX209="$PLATEX209"

TMP_PREFIX="$TMP_PREFIX"
PREFIX="$PREFIX"

MAKE="$MAKE"
PATCH="$PATCH"
MD5="$MD5"
NKFJIS="$NKFJIS"

TEXSRC_EXTRACTED="$TEXSRC_EXTRACTED"
TEXMFDIST="$TEXMFDIST"
SYSTEM_FREETYPE2="$SYSTEM_FREETYPE2"
STRIP="$STRIP"

CONF_OPTION="$CONF_OPTION"
MAKE_OPTION="$MAKE_OPTION"

EXTRA_CMAP="$EXTRA_CMAP"
EXTRA_TRUETYPE="$EXTRA_TRUETYPE"
EXTRA_OPENTYPE="$EXTRA_OPENTYPE"

BASH="$BASH"
PATH="$PATH"
EOF

echo "------------------------------------------------------------------------"
test "$MD5" != "none" && necessity_command $MD5 < /dev/null

perl -e 'print "\xa4\xa2\xa5\xa2\xb0\xa1"' > nkfjis-check
nkfjis nkfjis-check
md5check <<EOF || exit 1
68630308fe925f9c84b134c42fb0d080  nkfjis-check
EOF
$RM nkfjis-check

if test "$1" != "notetex"; then
    if test ! -f $SRC_DIR/tetex-src-$TETEX_VER.tar.gz \
	 -o ! -f $SRC_DIR/tetex-texmf-$TEXMF_VER.tar.gz; then
	CTAN=http://www.ring.gr.jp/pub/text/CTAN/systems/unix/teTeX/3.0/distrib
	cat <<-EOF

	Please get "tetex-src-$TETEX_VER.tar.gz" and
	           "tetex-texmf-$TEXMF_VER.tar.gz" by following commands.
	cd $SRC_DIR
	wget $CTAN/tetex-src-$TETEX_VER.tar.gz
	wget $CTAN/tetex-texmf-$TEXMF_VER.tar.gz

	EOF
	exit 1
    fi
    if test -z "$TEXSRC_EXTRACTED"; then md5check <<-EOF || exit
	944a4641e79e61043fdaf8f38ecbb4b3  $SRC_DIR/tetex-src-$TETEX_VER.tar.gz
	EOF
    fi
    if test -z "$TEXMFDIST"; then md5check <<-EOF || exit
	ed9d30d9162d16ac8d5065cde6e0f6fa  $SRC_DIR/tetex-texmf-$TEXMF_VER.tar.gz
	EOF
    fi
fi
md5check <<EOF || exit
92579eca220d2279787ddb98b5b1e439  archive/config.ps
dba57b9893f5632662c7d741874f7159  archive/dvipdfmx-20090506.tar.gz
92f5fcdf523381c6e30288d0e2c487ab  archive/dvipdfmx-contrib-latex.tar.gz
1f659d779459e62873fc0bb149b59b37  archive/dvipsk-5.97-p1.7b.tar.gz
a7aefa88799df081ca981ce6aa32ec90  archive/freetype-2.3.5.tar.gz
7d688306677b99ec34cf68ef93562381  archive/jcode.pl
12fc14c4ed0530eab018c867b383eedb  archive/jis.tar.gz
c82f9dbbe660149fc737e4f8dfb5095a  archive/jmpost-0.04b.tar.gz
8c855399616a49e26e411e6ed5db5092  archive/kpathsea-3.5.6-tetex-3.0.patch.gz
7fd15c90111732cce14c5dbb6228ecb3  archive/makejvf-1.1a.tar.gz
fe07b8b7b83d1cb13f836dc1caf7bad8  archive/mendexk2.6e.tar.gz
10a3a0bb382d9edf834177d0c03101f5  archive/morisawa.tar.gz
e1a6831d17cf0f615029c6717a557081  archive/patch-ebb-artbox.diff
263407fe38f2ab8e0ad83ee343071c46  archive/platex209.tar.gz
9738f48ec9d6b603b4b6550ba480876d  archive/ptex-src-3.1.10.tar.gz
9eb48ecb66cfd626865222564545de1c  archive/ptex-texmf-2.5.tar.gz
8e5495cbc633681ac393ce2cf5a203cc  archive/ptexenc-0.999.tar.gz
0827b7c13924311c029bbf2a1fded7ac  archive/tetex-3.0-dcb314.patch
0a0ae03d463d30c88d42b1e6985de90a  archive/tetex-3.0-dvipdfm.patch
3a68bc5a68db27ff8a66026804855540  archive/tetex-3.0-makej.patch
010ae209d2a5fcac800c99d6f46c9102  archive/tetex-3.0-marvosym-rightarrow.patch
e69659fcf06be4f1f7b2e6c7aa863f94  archive/tetex-src-3.0-omegaware.patch
528896670c493b2948a5ec532507d02a  archive/txpxfonts.zip
18c0886dfdfe4c5ae694db8733bc4c0a  archive/updmap-3.0-4b.diff
2a79fd972752055f6a1e5a4c24db4a5f  archive/updmap-ExtendSlant.patch
ba9f5b90249a5385b8bc334c928f66d1  archive/updmap-cmsuper.patch
aa5acc8f579394fecf68d6ef9d3f556e  archive/updmap-nostop.patch
3a61e3cddcbf838b89461d2fd83ddfc7  archive/xdvik-20080408-tetex-3.0.diff.gz
df3d450473cb0cb4ffcc570cc52d1cac  archive/xdvik-22.84.13-tetex-3.0.diff.gz
c4e4abab05aa1b1873706efd1f6e7f8a  babel/babeltestJIS.tex
efd141cb33626b039f53e921070f9593  babel/japanese.zip
57c1942af01504cff64f7c6b10b4b844  babel/ptetex-babel.tar.gz
344d1f8ff9938282be58e243a5c6700f  cmap/Adobe-Japan1-UCS2
124d33b6c57ffabb96225c410fde70fb  cmap/H
d1f04f6d143075aed5bd05306ff1a14b  cmap/UniCNS-UTF16-H
e1dd9bf28527590647fd02da0a0f6660  cmap/UniCNS-UTF16-V
0fe1be2f34509c7c4fb242cbd2d98d75  cmap/UniGB-UTF16-H
2ea0d12aa562749f4ddab185734b5020  cmap/UniGB-UTF16-V
ff497eadfb17dc27295161e03298f5cc  cmap/UniJIS-UTF16-H
c82b74865f0a6ad98bd47c5d01658ffa  cmap/UniJIS-UTF16-V
57ee11e1f66b80357a6db9e8560cb7a8  cmap/UniKS-UTF16-H
9c7616f643b7f9d5e0fea989d7057865  cmap/UniKS-UTF16-V
c917e6a527ba7704c3e11545dab330ca  cmap/V
55daff53c4e52be78025dcd0785bcfc3  macro/burasage.lzh
40f757c7c16bce50915893170ed9b916  macro/eclepsf.sty
601835d441df357d28f93c4d4534dbe0  macro/epsbox.sty
eab726afd7249145578df56daa3d805f  macro/jsclasses-090222.zip
4c6224bbdc50345999714c32958eb186  macro/otfstable-speedup.patch
0fd496d0e9b365457e161d18da9dfffb  macro/otfstable.zip
50382fd31d95532cbc3d6803bc882578  macro/powerdot.tar.gz
4acbd7a7aea2000b4a5c7048f06041cc  macro/prosper-1.00.4.tar.gz
b5978c8956885bed02211d32f680be2c  macro/tategumi.tar.gz
c9dd89924d2041ff5c64f853736713ef  macro/tateyoko.tar.gz
f8a3ac31b14e6ae9484fe874e2d7c2a6  macro/utfsrc-speedup.patch
3461345204c3762e910d0fb7a8a890dd  macro/utfsrc.zip
beeee2eddd35c5c70a0c60ac4a046a68  macro/xkeyval.tar.gz
525a1a163dab2a135fb38b6bf1510f4d  security/MOAB-06-01-2007.pdf
77a46fb56647732013defe1acc66b3d0  security/libpng-tetex-3.0-1.2.18.patch.gz
a690ce46117257609c2b43485ea4d0d7  security/post-3.5.5-kdegraphics-CVE-2007-0104.diff
caab6b09d2d79aeb3d70383dc6059dcf  security/tetex-2.0.2-dvipdfm-security.patch
aaa40a494cb30778f56f3b5c6590477e  security/tetex-3.0-CVE-2005-3193.patch
43911d0dae2ce667db8307d05e6f2a2d  security/tetex-3.0-CVE-2007-0455.patch
8c2f3c2c87a5ec82869059df57af27c8  security/tetex-3.0-CVE-2007-0650.patch
0d7b48834530a72ed2f287ea0606a415  security/tetex-3.0-CVE-2007-3387.patch
395fa10983cc124d9416410d15deeb4d  security/tetex-3.0-badscript.patch
ac4d63eaf47f1f48fcda5c7d114908b8  security/zlib-tetex-3.0-1.2.3.patch.gz
EOF

#necessity_command which which
necessity_command bash --version
necessity_command ed <<EOF
Q
EOF
necessity_command sed -e s/a/b/g $0
necessity_command egrep '^E?OF$' $0
necessity_command gzip -h
necessity_command unzip -h
necessity_command perl -v
#necessity_command $MAKE -h
#necessity_command $PATCH

echo ""
