#!/bin/sh
#
# ptetex3 -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

. ./common.sh
root_check

if test -z "$TEXSRC_EXTRACTED"; then
    shouldnotexist $SRC
    $MKDIR $SRC || exit
    enoughspace $SRC 450000
fi

PTEXENC=$SRC/texk/ptexenc/patches
GSNOEMBED1="-dNOKANJI"
GSNOEMBED2="-dNOKANJI -c '.setpdfwrite << /NeverEmbed [/Courier /Courier-Bold /Courier-Oblique /Courier-BoldOblique /Helvetica /Helvetica-Bold /Helvetica-Oblique /Helvetica-BoldOblique /Times-Roman /Times-Bold /Times-Italic /Times-BoldItalic /Symbol /ZapfDingbats /Ryumin-Light /GothicBBB-Medium] >> setdistillerparams'"

## start
test -z "$TEXSRC_EXTRACTED" \
    && tarx $SRC_DIR/tetex-src-$TETEX_VER.tar.gz $SRC/..
# update xdvik
zpatch archive/xdvik-22.84.13-tetex-3.0.diff.gz 1 $SRC
# update kpathsea (imported from TeX Live 2007)
#  note: some 'patch' can't handle files containing '\0' (ex. FreeBSD 6.1)
perlprint 's|\000|<<_ZERO_>>|g' $SRC/texk/kpathsea/kpathsea.info
zpatch archive/kpathsea-3.5.6-tetex-3.0.patch.gz 1 $SRC
perlprint 's|<<_ZERO_>>|\000|g' $SRC/texk/kpathsea/kpathsea.info
$RM $SRC/texk/kpathsea/texmf.in-teTeX # useless file

# Fix parallel builds. (imported from FC4)
cpatch archive/tetex-3.0-makej.patch   1 $SRC
# Fix usage of uninitialized variable (imported from FC4)
cpatch archive/tetex-3.0-dcb314.patch  1 $SRC
# Fix dvipdfm buffer overflow (imported from tetex-3.0-20.FC5)
cpatch archive/tetex-3.0-dvipdfm.patch 1 $SRC
# Fix ExtendFont and SlantFont bug
cpatch archive/updmap-ExtendSlant.patch 1 $SRC
# Fix cm-super bug on dvipdfm.map
cpatch archive/updmap-cmsuper.patch     1 $SRC

# Work around of bug of ls (GNU coreutils-6.x (x=0..7))
# http://lists.gnu.org/archive/html/bug-coreutils/2007-01/msg00005.html
$LN md5sum $PTETEX_TMP
ls -LR . | grep "$PTETEX_TMP:" > /dev/null \
    || perlprint 's/LRa/LRat/' $SRC/texk/kpathsea/mktexlsr
rm $PTETEX_TMP

# epstopdf no embed fonts
perlprint "s/OutputFilename -/OutputFilename \\\$GSNOEMBED -/;
	print \"### no embed fonts\nmy \\\$GSNOEMBED=\\\"$GSNOEMBED2\\\";\n\n\"
	if /option BoundingBox types/" \
    $SRC/texk/tetex/epstopdf
# add --nostop option: don't stop even if a map file is not found
cpatch archive/updmap-nostop.patch     0 $SRC/texk/tetex
# ebb patch (+ArtBox)
cpatch archive/patch-ebb-artbox.diff   0 $SRC/texk/dvipdfm

## use TEXMFMAIN for TEXMFDIST etc. instead of absolute path
perlprint 's/\@texmf\@-/\$TEXMFMAIN-/g' \
    $SRC/texk/kpathsea/texmf.in
perlprint 'print "#" if /echo .*TEXMF(LOCAL|DIST|%g)/' \
    $SRC/texk/kpathsea/Makefile.in
## don't rewrite VARTEXFONTS
perlprint 's/TEXMFCNF/\\(TEXMFCNF\\|VARTEXFONTS\\)/g' \
    $SRC/selfautofix

## if TEXMFDIST is specified
if test -n "$TEXMFDIST"; then
    perlprint "s|^(TEXMFDIST) = .*|\1 = $TEXMFDIST|g" \
	$SRC/texk/kpathsea/texmf.in
fi

## also find files which aren't listed in ls-R
## give priority to $TEXMFLOCAL over $TEXMFMAIN (ptetex3's change)
## http://tug.org/pipermail/tex-live/2007-November/015089.html
perlprint  's/^TEXMF = {\$TEXMFCONFIG,\$TEXMFVAR,\$TEXMFHOME,!!\$TEXMFSYSCONFIG,!!\$TEXMFSYSVAR,!!\$TEXMFMAIN,!!\$TEXMFLOCAL,!!\$TEXMFDIST}/TEXMF = {\$TEXMFCONFIG,\$TEXMFVAR,\$TEXMFHOME,\$TEXMFSYSCONFIG,\$TEXMFSYSVAR,\$TEXMFLOCAL,\$TEXMFMAIN,!!\$TEXMFDIST}/g' $SRC/texk/kpathsea/texmf.in

# enlarge buffer size for Babel (imported from Web2C-7.5.5)
# http://oku.edu.mie-u.ac.jp/~okumura/texfaq/qa/37404.html
# http://oku.edu.mie-u.ac.jp/~okumura/texfaq/qa/37707.html
for f in $SRC/texk/web2c/tex.ch \
	 $SRC/texk/web2c/omegadir/com16bit.ch \
	 $SRC/texk/web2c/alephdir/com16bit-rc2.ch
  do perlprint 's/(\@d ssup_trie_size ==) 262143/\1 4194303/g' $f
done


if test "$JAPANESE" != "without"; then
# ptexenc library
tarx archive/ptexenc-*.tar.gz $SRC/texk
mv $SRC/texk/ptexenc-* $SRC/texk/ptexenc
# compile xdvi earlier, compile ptexenc, makejvf, pdvipsk and pxdvik
perlprint "s|^(PKGS=.*)$|\1 ptexenc makejvf mendexk
	web2c/ptex web2c/ptex/jmpost dvipsk pdvipsk xdvik pxdvik|;
	s/tth xdvik\$/tth/g; s/dvipng dvipsk gsftopk/dvipng gsftopk/g" \
    $SRC/texk/configure
## pTeX
tarx archive/ptex-src-3.1.10.tar.gz $SRC/texk/web2c
mv $SRC/texk/web2c/ptex-src-* $SRC/texk/web2c/ptex || exit
cpatch $PTEXENC/ptex-src-3.1.10-ptexenc.patch     1 $SRC/texk/web2c/ptex
# comment out TEXINPUTS.platex (not to be erased by mkconf)
perlprint 's/^(TEXINPUTS.platex)/% \1/g' $SRC/texk/kpathsea/texmf.in
# rewrite 'platex2e_inputs' macro
perlprint 's|/\{ptex/\{platex,generic,\},tex/\{latex,generic,\}\}|/{ptex/platex,{p,}tex/latex,{p,}tex/generic,{p,}tex}|g; s/\| uniq//g' $SRC/texk/web2c/ptex/mkconf
# for Japanese font setting
cpatch archive/updmap-3.0-4b.diff 0 $SRC/texk/tetex
# for UTF/OTF package
cpatch archive/tetex-src-3.0-omegaware.patch 1 $SRC

## for platex209
if test "$PLATEX209" = "yes"; then
    perlnoprint 'print; print "	echo  \"platex209	ptex		language.dat	plplain.ini\" >> \$\@\n" if /Japanese pTeX:/' \
	$SRC/texk/web2c/ptex/Makefile.in
fi

## for mendexk
tarx archive/mendexk2.6e.tar.gz $SRC/texk
mv $SRC/texk/mendexk* $SRC/texk/mendexk || exit
cpatch $PTEXENC/mendexk2.6e-ptexenc.patch 1 $SRC/texk/mendexk

## for jmpost
tarx archive/jmpost-0.04b.tar.gz $SRC/texk/web2c/ptex
mv $SRC/texk/web2c/ptex/jmpost-* $SRC/texk/web2c/ptex/jmpost || exit
cpatch $PTEXENC/jmpost-0.04b-ptexenc.patch 1 $SRC/texk/web2c/ptex/jmpost
perlprint 's/mpost\)/mpost|jmpost\)/g' $SRC/texk/tetex/fmtutil 
perlprint 'print "MPXCOMMAND.jmpost = pmakempx\n" if /MPXCOMMAND/' \
    $SRC/texk/kpathsea/texmf.in

## for makejvf
tarx archive/makejvf-1.1a.tar.gz $SRC/texk
mv $SRC/texk/makejvf* $SRC/texk/makejvf || exit
cpatch $PTEXENC/makejvf-1.1a-ptexenc.patch 1 $SRC/texk/makejvf

## for dvipdfmx
tarx archive/dvipdfmx-20090506.tar.gz $SRC/texk
mv $SRC/texk/dvipdfmx-* $SRC/texk/dvipdfmx || exit
perlprint "s/ cid-x.map\$/ kanjix.map/g;
	s|^(D  \"ps2pdf .*) (%i .*\")|\1 $GSNOEMBED1 \2|" \
    $SRC/texk/dvipdfmx/data/dvipdfmx.cfg
$RM $SRC/texk/dvipdfmx/data/cid-x.map
perlnoprint "print unless /cid-x/" $SRC/texk/dvipdfmx/data/Makefile.in


if test "$JAPANESE" = "international"; then
    $MKDIR $SRC/texk/pdvipsk
    $CP $SRC/texk/dvipsk/* $SRC/texk/pdvipsk/ 2> /dev/null
    tarcp $SRC/texk/xdvik $SRC/texk/pxdvik
    P=p
fi # "$JAPANESE" = "international"
## for dvipsk
#tarx archive/dvipsk-jpatch-p*.tar.gz         $SRC/texk/${P}dvipsk
#cpatch $SRC/texk/${P}dvipsk/dvipsk-*.patch 1 $SRC/texk/${P}dvipsk
tarx archive/dvipsk-*-p*.tar.gz              $SRC/texk/${P}dvipsk
cpatch $SRC/texk/${P}dvipsk/dvipsk-*.diff 1  $SRC/texk/${P}dvipsk
perlprint 's/^kpse_include/ac_include/g'     $SRC/texk/${P}dvipsk/Makefile.in

## for xdvik
zpatch archive/xdvik-200?????-tetex-3.0.diff.gz 3 $SRC/texk/${P}xdvik
# fix for FC5
perlprint 'print "#define NeedWidePrototypes 1\n" if /limits/' \
    $SRC/texk/${P}xdvik/xdvi.h
# pTeX fontmap
perlnoprint "s/^ptexmap .*/ptexmap kanjix.map/; print unless /IPA/" \
    $SRC/texk/${P}xdvik/texmf/xdvi.cfg
# adjust X resource
cat <<EOF >> $SRC/texk/${P}xdvik/texmf/XDvi || exit 1


!!! ------- added by ptetex3 -------

!*.shrinkFactor: 5
!*.geometry: 950x700+0+0
!*.expert: true
!*.smallPanel: false

*.editor: emacsclient --no-wait +%l %f
!*.editor: gnuclient -q +%l %f
!*.editor: gvim --servername xdvi --remote +%l %f
!*.editor: nc -noask +%l %f

*.wwwBrowser: firefox %s
!*.wwwBrowser: mozilla -remote "openURL(%s,new-tab)"
!*.wwwBrowser: mozilla -remote "openURL(%s,new-window)"
!*.wwwBrowser: htmlview %s
!*.wwwBrowser: xterm -e w3m %s
!*.wwwBrowser: xterm -e lynx %s
!*.wwwBrowser: xterm -e wget %s
EOF

if test "$JAPANESE" = "international"; then
    ### pdvipsk
    perlprint  's|program = dvips|program = pdvips|g;
		s|programs = afm2tfm|programs = |g;
		s|dvips.info||g;
		s|.*o\$\(program\).*||g;
		s|install-data: \$\(program\).info|install-data:|g;
		s|install-info.*\$\(program\).info|echo|g;
		s|\$\(INSTALL_DATA\) \$\$i \$\(infodir\)/\$\$i||g;' \
	$SRC/texk/pdvipsk/Makefile.in
    perlnoprint '$a=1 if /^# Info files/; $a=0 if /^# TeX macros/;
	$a=1 if /install-info/;
	print unless $a;
	$a=0 if /else true/;' $SRC/texk/pdvipsk/Makefile.in
    # noomega for pdvips
    perlprint 's|^(Boolean noomega) = 0|\1 = 1|g' $SRC/texk/pdvipsk/dvips.c
    ### pxdvik
    for f in $SRC/texk/pxdvik/configure.in \
	     $SRC/texk/pxdvik/configure; do
      perlprint  's|^(program_transform_name=s,x,)(x,)|\1p\2|;' $f
    done
    perlprint  's|manpage = xdvi|manpage = pxdvi|g;
		s|.*o\$.*||g;
		s|.*o\@.*||g;
		s/\$\(INSTALL_DATA\).*(manext\)|pixmaps)//g;
		s|(xdvi\.cfg)|p\1|g;
		s|(xdvizilla)|p\1|g;'  $SRC/texk/pxdvik/Makefile.in
    perlprint  's|(xdvi\.cfg)|p\1|g'   $SRC/texk/pxdvik/dvi-draw.c
    mv $SRC/texk/pxdvik/texmf/xdvi.cfg $SRC/texk/pxdvik/texmf/pxdvi.cfg
    mv $SRC/texk/pxdvik/xdvizilla      $SRC/texk/pxdvik/pxdvizilla
    perlprint 's|xdvi|pxdvi|g'         $SRC/texk/pxdvik/pxdvizilla
fi # "$JAPANESE" = "international"

## freetype for xdvi-jp
if test "$SYSTEM_FREETYPE2" = "no"; then
    tarx archive/freetype-2.3.5.tar.gz $SRC
    mv $SRC/freetype-* $SRC/freetype || exit
    ## for freetype-2.2.1+
    perlprint 's/# (AUX_MODULES \+= otvalid)/\1/' $SRC/freetype/modules.cfg
fi
fi # "$JAPANESE" != "without"


## security fix
# libpng update
zpatch security/libpng-tetex-3.0-1.2.18.patch.gz   1 $SRC
zpatch security/zlib-tetex-3.0-1.2.3.patch.gz      1 $SRC
# Don't use tmpnam() in dvipdfm. (impoted from tetex-3.0-4.FC4)
cpatch security/tetex-2.0.2-dvipdfm-security.patch 1 $SRC
# Fix xpdf overfows CVE-2005-3193 (impoted from tetex-3.0-20.FC5)
cpatch security/tetex-3.0-CVE-2005-3193.patch      1 $SRC
# http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0104
cpatch security/post-3.5.5-kdegraphics-CVE-2007-0104.diff 1 $SRC/libs
# Fix gd buffer overrun CVE-2007-0455 (imported from tetex-3.0-0vl7.2)
cpatch security/tetex-3.0-CVE-2007-0455.patch      1 $SRC
# Fix overflows in makeindex CVE-2007-0650 (impoted from tetex-3.0-34.fc6)
cpatch security/tetex-3.0-CVE-2007-0650.patch      1 $SRC
# Fix xpdf integer overflow CVE-2007-3387 (impoted from tetex-3.0-35.fc6)
cpatch security/tetex-3.0-CVE-2007-3387.patch      1 $SRC

#exit # uncomment if 'mktemp' command doesn't exist
# Don't use PID for temporary file names in scripts. (impoted from FC4)
cpatch security/tetex-3.0-badscript.patch          1 $SRC
## post
echo ""


## check
cat md5sum/texsrc.$JAPANESE | (cd $SRC; md5check) && exit
cat <<EOF

$0: Some processes were performed improperly.
Check if you have GNU patch.
Some environment variables (TEXMF, LD_LIBRARY_PATH, etc) may make side effect.

EOF
exit 1
