/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.chart.urls.XYURLGenerator;
import com.jrefinery.data.Range;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractXYItemRenderer
extends AbstractRenderer
implements XYItemRenderer {
    private XYPlot plot;
    private XYToolTipGenerator toolTipGenerator;
    private XYURLGenerator urlGenerator;

    protected AbstractXYItemRenderer() {
        this(null, null);
    }

    protected AbstractXYItemRenderer(XYToolTipGenerator xYToolTipGenerator) {
        this(xYToolTipGenerator, null);
    }

    protected AbstractXYItemRenderer(XYURLGenerator xYURLGenerator) {
        this(null, xYURLGenerator);
    }

    protected AbstractXYItemRenderer(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.toolTipGenerator = xYToolTipGenerator;
        this.urlGenerator = xYURLGenerator;
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public void setPlot(XYPlot xYPlot) {
        this.plot = xYPlot;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        this.setInfo(chartRenderingInfo);
    }

    public XYToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        XYToolTipGenerator xYToolTipGenerator2 = this.toolTipGenerator;
        this.toolTipGenerator = xYToolTipGenerator;
        this.firePropertyChanged("renderer.ToolTipGenerator", xYToolTipGenerator2, xYToolTipGenerator);
    }

    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        XYURLGenerator xYURLGenerator2 = this.urlGenerator;
        this.urlGenerator = xYURLGenerator;
        this.firePropertyChanged("renderer.URLGenerator", xYURLGenerator2, xYURLGenerator);
    }

    public LegendItem getLegendItem(int n) {
        String string;
        if (this.plot == null) {
            return null;
        }
        XYDataset xYDataset = this.plot.getXYDataset();
        String string2 = string = xYDataset.getSeriesName(n);
        Shape shape = null;
        Paint paint = this.plot.getSeriesPaint(n);
        Paint paint2 = this.plot.getSeriesOutlinePaint(n);
        Stroke stroke = this.plot.getSeriesStroke(n);
        Stroke stroke2 = this.plot.getSeriesOutlineStroke(n);
        return new LegendItem(string, string2, shape, paint, paint2, stroke, stroke2);
    }

    public void drawDomainMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke == null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public abstract void drawItem(Graphics2D var1, Rectangle2D var2, ChartRenderingInfo var3, XYPlot var4, ValueAxis var5, ValueAxis var6, XYDataset var7, int var8, int var9, CrosshairInfo var10);
}

