/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.data.SignalsDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class SignalRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    private double markOffset = 5.0;
    private double shapeWidth = 15.0;
    private double shapeHeight = 25.0;

    public double getMarkOffset() {
        return this.markOffset;
    }

    public void setMarkOffset(double d) {
        this.markOffset = d;
    }

    public double getShapeWidth() {
        return this.shapeWidth;
    }

    public void setShapeWidth(double d) {
        this.shapeWidth = d;
    }

    public double getShapeHeight() {
        return this.shapeHeight;
    }

    public void setShapeHeight(double d) {
        this.shapeHeight = d;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo) {
        Object object;
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        SignalsDataset signalsDataset = (SignalsDataset)xYDataset;
        Number number = signalsDataset.getXValue(n, n2);
        Number number2 = signalsDataset.getYValue(n, n2);
        int n3 = signalsDataset.getType(n, n2);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        Paint paint = xYPlot.getSeriesPaint(n);
        Stroke stroke = xYPlot.getSeriesStroke(n);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        int n4 = 1;
        if (n3 == 1 || n3 == -2) {
            d2 += this.markOffset;
            n4 = -1;
        } else {
            d2 -= this.markOffset;
        }
        GeneralPath generalPath = new GeneralPath();
        if (n3 == 1 || n3 == -1) {
            generalPath.moveTo((float)d, (float)d2);
            generalPath.lineTo((float)(d + this.shapeWidth / 2.0), (float)(d2 - (double)n4 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)(d + this.shapeWidth / 6.0), (float)(d2 - (double)n4 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)(d + this.shapeWidth / 6.0), (float)(d2 - (double)n4 * this.shapeHeight));
            generalPath.lineTo((float)(d - this.shapeWidth / 6.0), (float)(d2 - (double)n4 * this.shapeHeight));
            generalPath.lineTo((float)(d - this.shapeWidth / 6.0), (float)(d2 - (double)n4 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)(d - this.shapeWidth / 2.0), (float)(d2 - (double)n4 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)d, (float)d2);
        } else {
            generalPath.moveTo((float)d, (float)d2);
            generalPath.lineTo((float)d, (float)(d2 - (double)n4 * this.shapeHeight));
            object = new Ellipse2D.Double(d - this.shapeWidth / 2.0, d2 + (n4 == 1 ? -this.shapeHeight : this.shapeHeight - this.shapeWidth), this.shapeWidth, this.shapeWidth);
            generalPath.append((Shape)object, false);
        }
        graphics2D.fill(generalPath);
        graphics2D.setPaint(Color.black);
        graphics2D.draw(generalPath);
        if (entityCollection != null) {
            object = "";
            if (this.getToolTipGenerator() != null) {
                object = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string = null;
            if (this.getURLGenerator() != null) {
                string = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(generalPath, (String)object, string, n, n2);
            entityCollection.addEntity(xYItemEntity);
        }
    }
}

