/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class VerticalNumberAxis3D
extends VerticalNumberAxis {
    public static final double DEFAULT_EFFECT_3D = 10.0;
    private double effect3d = 10.0;

    public VerticalNumberAxis3D() {
        this(null);
    }

    public VerticalNumberAxis3D(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 0.0, 1.0);
        this.setAutoRangeAttribute(true);
    }

    public VerticalNumberAxis3D(String string, Font font, double d, double d2) {
        this(string, font, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, AxisConstants.DEFAULT_TICK_PAINT, false, ValueAxis.DEFAULT_AUTO_RANGE_MINIMUM_SIZE, true, true, d, d2, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, 0.0, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT, 10.0);
    }

    public VerticalNumberAxis3D(String string, Font font, Paint paint, Insets insets, boolean bl, boolean bl2, Font font2, Paint paint2, Insets insets2, boolean bl3, Stroke stroke, Paint paint3, boolean bl4, Number number, boolean bl5, boolean bl6, double d, double d2, boolean bl7, boolean bl8, NumberTickUnit numberTickUnit, boolean bl9, Stroke stroke2, Paint paint4, double d3, boolean bl10, double d4, Stroke stroke3, Paint paint5, double d5) {
        super(string, font, paint, insets, bl, bl2, font2, paint2, insets2, bl3, stroke, paint3, bl4, number, bl5, bl6, d, d2, bl7, bl8, numberTickUnit, bl9, stroke2, paint4, d3, bl10, d4, stroke3, paint5);
        this.effect3d = d5;
    }

    public double getEffect3d() {
        return this.effect3d;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (!this.visible) {
            return;
        }
        if (this.label == null ? false : !this.label.equals("")) {
            double d;
            double d2;
            graphics2D.setFont(this.labelFont);
            graphics2D.setPaint(this.labelPaint);
            Rectangle2D rectangle2D3 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            if (this.isVerticalLabel()) {
                d2 = rectangle2D.getX() + (double)this.labelInsets.left + rectangle2D3.getHeight();
                d = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0 + rectangle2D3.getWidth() / 2.0;
                RefineryUtilities.drawRotatedString((String)this.label, (Graphics2D)graphics2D, (float)((float)d2), (float)((float)d), (double)-1.5707963267948966);
            } else {
                d2 = rectangle2D.getX() + (double)this.labelInsets.left;
                d = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - rectangle2D3.getHeight() / 2.0;
                graphics2D.drawString(this.label, (float)d2, (float)d);
            }
        }
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
        double d = rectangle2D2.getX();
        graphics2D.setFont(this.tickLabelFont);
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Line2D.Double double_;
            Tick tick = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2);
            if (this.tickLabelsVisible) {
                graphics2D.setPaint(this.tickLabelPaint);
                graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
            }
            if (this.tickMarksVisible) {
                graphics2D.setStroke(this.getTickMarkStroke());
                graphics2D.setPaint(this.getTickMarkPaint());
                double_ = new Line2D.Double(rectangle2D2.getX() - 2.0, f, rectangle2D2.getX(), f);
                graphics2D.draw(double_);
            }
            if (!this.isGridLinesVisible()) continue;
            graphics2D.setStroke(this.getGridStroke());
            graphics2D.setPaint(this.getGridPaint());
            double_ = new Line2D.Double(d + this.effect3d, (double)f - this.effect3d, rectangle2D2.getMaxX() + this.effect3d, (double)f - this.effect3d);
            graphics2D.draw(double_);
            Line2D.Double double_2 = new Line2D.Double(d, f, d + this.effect3d, (double)f - this.effect3d);
            graphics2D.draw(double_2);
        }
    }
}

