/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.CompassPlot;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.data.DefaultMeterDataset;
import com.jrefinery.ui.Spinner;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class CompassDemo
extends JPanel {
    public static final String[] NEEDLE_TYPES = new String[]{"Pointer", "Line", "Long", "Pin", "Plum", "Pointer", "Ship", "Wind", "Arrow"};
    private DefaultMeterDataset compassData = new DefaultMeterDataset();
    private DefaultMeterDataset shipData = new DefaultMeterDataset();
    private CompassPlot compassPlot = new CompassPlot(this.compassData);
    private JFreeChart compassChart = new JFreeChart("Compass Test", JFreeChartConstants.DEFAULT_TITLE_FONT, this.compassPlot, false);
    private ChartPanel panelCompass = new ChartPanel(this.compassChart);
    private GridLayout gridLayout1 = new GridLayout();
    private JPanel panelCompassHolder = new JPanel();
    private BorderLayout borderLayout = new BorderLayout();
    private JPanel jPanel12 = new JPanel();
    private JCheckBox checkWindNull = new JCheckBox();
    private JCheckBox checkShipNull = new JCheckBox();
    private Spinner spinWind = new Spinner(270);
    private Spinner spinShip = new Spinner(45);
    private JPanel jPanel1 = new JPanel();
    private JComboBox pick1Pointer = new JComboBox<String>(NEEDLE_TYPES);
    private JPanel jPanel2 = new JPanel();
    private JComboBox pick2Pointer = new JComboBox<String>(NEEDLE_TYPES);
    private TitledBorder titledBorder1;
    private TitledBorder titledBorder2;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private TitledBorder titledBorder3;
    private GridLayout gridLayout2 = new GridLayout();

    public CompassDemo() {
        try {
            this.compassData.setRange(new Double(0.0), new Double(360.0));
            this.shipData.setRange(new Double(0.0), new Double(360.0));
            this.compassPlot.addData(this.shipData);
            this.compassPlot.setSeriesNeedle(0, 7);
            this.compassPlot.setSeriesNeedle(1, 5);
            this.compassPlot.setSeriesPaint(0, Color.blue);
            this.compassPlot.setSeriesOutlinePaint(0, Color.blue);
            this.compassPlot.setSeriesPaint(1, Color.red);
            this.compassPlot.setSeriesOutlineStroke(new Stroke[]{new BasicStroke(3.0f)});
            this.pick1Pointer.setSelectedIndex(7);
            this.pick2Pointer.setSelectedIndex(5);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder("");
        this.titledBorder3 = new TitledBorder("");
        this.setLayout(this.gridLayout1);
        this.panelCompassHolder.setLayout(this.borderLayout);
        this.checkWindNull.setHorizontalTextPosition(10);
        this.checkWindNull.setText("Null");
        this.checkWindNull.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompassDemo.this.checkWindNullActionPerformed(actionEvent);
            }
        });
        this.checkShipNull.setHorizontalTextPosition(2);
        this.checkShipNull.setText("Null");
        this.checkShipNull.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompassDemo.this.checkShipNullActionPerformed(actionEvent);
            }
        });
        this.spinShip.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Spinner spinner = (Spinner)propertyChangeEvent.getSource();
                CompassDemo.this.shipData.setValue(spinner.getValue());
            }
        });
        this.spinWind.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Spinner spinner = (Spinner)propertyChangeEvent.getSource();
                CompassDemo.this.compassData.setValue(spinner.getValue());
            }
        });
        this.jPanel12.setLayout(this.gridLayout2);
        this.jPanel2.setBorder(this.titledBorder1);
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.jPanel1.setBorder(this.titledBorder2);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.titledBorder1.setTitle("Second Pointer");
        this.titledBorder2.setTitle("First Pointer");
        this.titledBorder3.setTitle("Plot Options");
        this.pick2Pointer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompassDemo.this.pick2PointerActionPerformed(actionEvent);
            }
        });
        this.pick1Pointer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompassDemo.this.pick1PointerActionPerformed(actionEvent);
            }
        });
        this.add((Component)this.panelCompassHolder, null);
        this.panelCompassHolder.add((Component)this.jPanel12, "South");
        this.jPanel12.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.pick1Pointer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.checkWindNull, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.spinWind, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel12.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.pick2Pointer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.checkShipNull, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.spinShip, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelCompassHolder.add((Component)this.panelCompass, "Center");
    }

    public static void main(String[] stringArray) {
        CompassDemo compassDemo = new CompassDemo();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new BorderLayout(5, 5));
        jFrame.setDefaultCloseOperation(3);
        jFrame.setTitle("Compass Demo");
        jFrame.getContentPane().add((Component)compassDemo, "Center");
        jFrame.setSize(700, 400);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation((dimension.width - jFrame.getSize().width) / 2, (dimension.height - jFrame.getSize().height) / 2);
        jFrame.setVisible(true);
    }

    public void adjustData(double d) {
        Number number = this.compassData.getValue();
        double d2 = d;
        if (number != null) {
            d2 += number.doubleValue();
        }
        if (d2 > 360.0) {
            d2 = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 360.0;
        }
        this.compassData.setValue(new Double(d2));
    }

    void checkWindNullActionPerformed(ActionEvent actionEvent) {
        if (this.checkWindNull.isSelected()) {
            this.compassData.setValue(null);
            this.spinWind.setEnabled(false);
        } else {
            this.compassData.setValue(this.spinWind.getValue());
            this.spinWind.setEnabled(true);
        }
    }

    void checkShipNullActionPerformed(ActionEvent actionEvent) {
        if (this.checkShipNull.isSelected()) {
            this.shipData.setValue(null);
            this.spinShip.setEnabled(false);
        } else {
            this.shipData.setValue(this.spinShip.getValue());
            this.spinShip.setEnabled(true);
        }
    }

    void pick2PointerActionPerformed(ActionEvent actionEvent) {
        this.compassPlot.setSeriesNeedle(1, this.pick2Pointer.getSelectedIndex());
        this.compassPlot.setSeriesPaint(1, Color.red);
    }

    void pick1PointerActionPerformed(ActionEvent actionEvent) {
        this.compassPlot.setSeriesNeedle(0, this.pick1Pointer.getSelectedIndex());
        this.compassPlot.setSeriesPaint(0, Color.blue);
        this.compassPlot.setSeriesOutlinePaint(0, Color.blue);
    }
}

