/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.HorizontalLogarithmicAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.VerticalLogarithmicAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.DefaultXYDataset;
import com.jrefinery.ui.ApplicationFrame;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;

public class XYLogAxesDemo
extends ApplicationFrame {
    public XYLogAxesDemo(String string) {
        super(string);
        Object[][][] objectArray = new Object[3][50][2];
        int n = 1;
        while (n <= 50) {
            objectArray[0][n - 1][0] = new Double(n);
            objectArray[0][n - 1][1] = new Double(1000.0 * Math.pow(n, -2.0));
            objectArray[1][n - 1][0] = new Double(n);
            objectArray[1][n - 1][1] = new Double(1000.0 * Math.pow(n, -3.0));
            objectArray[2][n - 1][0] = new Double(n);
            objectArray[2][n - 1][1] = new Double(1000.0 * Math.pow(n, -4.0));
            System.out.println(objectArray[0][n - 1][0] + ";" + objectArray[0][n - 1][1] + ";" + objectArray[1][n - 1][0] + ";" + objectArray[1][n - 1][1] + ";" + objectArray[2][n - 1][0] + ";" + objectArray[2][n - 1][1]);
            ++n;
        }
        DefaultXYDataset defaultXYDataset = new DefaultXYDataset(objectArray);
        JFreeChart jFreeChart = ChartFactory.createLineXYChart("Log Axis Demo", "Category", "Value", defaultXYDataset, true);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        VerticalLogarithmicAxis verticalLogarithmicAxis = new VerticalLogarithmicAxis("Log(y)");
        HorizontalLogarithmicAxis horizontalLogarithmicAxis = new HorizontalLogarithmicAxis("Log(x)");
        xYPlot.setRangeAxis(verticalLogarithmicAxis);
        xYPlot.setDomainAxis(horizontalLogarithmicAxis);
        jFreeChart.setBackgroundPaint(Color.white);
        xYPlot.setSeriesPaint(new Paint[]{Color.green, Color.orange, Color.red});
        xYPlot.setOutlinePaint(Color.blue);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        XYLogAxesDemo xYLogAxesDemo = new XYLogAxesDemo("XY Log Axes Demo");
        xYLogAxesDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)xYLogAxesDemo));
        xYLogAxesDemo.setVisible(true);
    }
}

